// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MEMORY_BREAKDOWN_ENTRY_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MEMORY_BREAKDOWN_ENTRY_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/collection_support/heap_vector.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class MemoryAttribution;

class CORE_EXPORT MemoryBreakdownEntry : public bindings::DictionaryBase {
  
  public:
static MemoryBreakdownEntry* Create() {
  return MakeGarbageCollected<MemoryBreakdownEntry>();
}
static MemoryBreakdownEntry* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<MemoryBreakdownEntry>(isolate);
}
static MemoryBreakdownEntry* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  MemoryBreakdownEntry();
explicit  MemoryBreakdownEntry(v8::Isolate* isolate);

bool hasAttribution() const {
  return true;
}
const HeapVector<Member<MemoryAttribution>>& attribution() const {
  return member_attribution_;
}
void setAttribution(const HeapVector<Member<MemoryAttribution>>& value);
void setAttribution(HeapVector<Member<MemoryAttribution>>&& value);

bool hasBytes() const {
  return true;
}
uint64_t bytes() const {
  return member_bytes_;
}
void setBytes(uint64_t value) {
  member_bytes_ = value;
}

bool hasTypes() const {
  return true;
}
const Vector<String>& types() const {
  return member_types_;
}
void setTypes(const Vector<String>& value);
void setTypes(Vector<String>&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



HeapVector<Member<MemoryAttribution>> member_attribution_;
uint64_t member_bytes_;
Vector<String> member_types_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_MEMORY_BREAKDOWN_ENTRY_H_
