// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_internal_dictionary_derived.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"derivedStringMember",
"derivedStringMemberWithDefault",
"requiredBooleanMember",
};


}  // namespace 

InternalDictionaryDerived* InternalDictionaryDerived::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  InternalDictionaryDerived* dictionary = MakeGarbageCollected<InternalDictionaryDerived>(isolate);
if (!v8_value->IsObject()) {
  const char* const class_like_name = "InternalDictionaryDerived";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 InternalDictionaryDerived::InternalDictionaryDerived(v8::Isolate* isolate) : InternalDictionary(isolate) {
  
}



String InternalDictionaryDerived::getDerivedStringMemberOr(const String& fallback_value) const {
  if (!hasDerivedStringMember()) {
  return fallback_value;
}
return member_derived_string_member_;
}

String InternalDictionaryDerived::getDerivedStringMemberOr(String&& fallback_value) const {
  if (!hasDerivedStringMember()) {
  return std::move(fallback_value);
}
return member_derived_string_member_;
}

void InternalDictionaryDerived::setDerivedStringMember(const String& value) {
  member_derived_string_member_ = value;
has_derived_string_member_ = true;
}

void InternalDictionaryDerived::setDerivedStringMember(String&& value) {
  member_derived_string_member_ = std::move(value);
has_derived_string_member_ = true;
}




void InternalDictionaryDerived::setDerivedStringMemberWithDefault(const String& value) {
  member_derived_string_member_with_default_ = value;
}

void InternalDictionaryDerived::setDerivedStringMemberWithDefault(String&& value) {
  member_derived_string_member_with_default_ = std::move(value);
}








void InternalDictionaryDerived::Trace(Visitor* visitor) const {
  InternalDictionary::Trace(visitor);
}

void InternalDictionaryDerived::FillTemplateProperties(Vector<std::string_view>& properties) const {
  InternalDictionary::FillTemplateProperties(properties);
DCHECK_EQ(properties.size(), kBasePropertyCount);

static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void InternalDictionaryDerived::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  InternalDictionary::FillValuesImpl(script_state, values.first(kBasePropertyCount));
values = values.subspan(kBasePropertyCount);

CHECK_EQ(kOwnPropertyCount, values.size());
if (hasDerivedStringMember()) {
  values[0] = ToV8Traits<IDLString>::ToV8(script_state, member_derived_string_member_);
DCHECK(!values[0].IsEmpty());
}
if (hasDerivedStringMemberWithDefault()) {
  values[1] = ToV8Traits<IDLString>::ToV8(script_state, member_derived_string_member_with_default_);
DCHECK(!values[1].IsEmpty());
}
if (hasRequiredBooleanMember()) {
  values[2] = ToV8Traits<IDLBoolean>::ToV8(script_state, member_required_boolean_member_);
DCHECK(!values[2].IsEmpty());
}
}

const void* InternalDictionaryDerived::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> InternalDictionaryDerived::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void InternalDictionaryDerived::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
InternalDictionary::FillMembersFromV8Object(isolate, v8_dictionary, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

const char* const class_like_name = "InternalDictionaryDerived";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("derivedStringMember");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_derived_string_member_, member_derived_string_member_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("derivedStringMemberWithDefault");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), fallback_presence_var, member_derived_string_member_with_default_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("requiredBooleanMember");
constexpr bool is_required = true;
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_required>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), fallback_presence_var, member_required_boolean_member_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> InternalDictionaryDerived::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
