// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_FILE_PROPERTY_BAG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_FILE_PROPERTY_BAG_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_blob_property_bag.h"
#include "third_party/blink/renderer/core/core_export.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT FilePropertyBag : public BlobPropertyBag {
  
  public:
static FilePropertyBag* Create() {
  return MakeGarbageCollected<FilePropertyBag>();
}
static FilePropertyBag* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<FilePropertyBag>(isolate);
}
static FilePropertyBag* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  FilePropertyBag();
explicit  FilePropertyBag(v8::Isolate* isolate);

bool hasLastModified() const {
  return has_last_modified_;
}
int64_t lastModified() const {
  DCHECK(hasLastModified());
return member_last_modified_;
}
int64_t getLastModifiedOr(int64_t fallback_value) const {
  if (!hasLastModified()) {
  return fallback_value;
}
return member_last_modified_;
}
void setLastModified(int64_t value) {
  member_last_modified_ = value;
has_last_modified_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = BlobPropertyBag::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 1;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_last_modified_ = false;

int64_t member_last_modified_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_FILE_PROPERTY_BAG_H_
