// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_event_listener.h"

#include <tuple>

#include "third_party/blink/renderer/bindings/core/v8/callback_invoke_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/core/dom/events/event.h"

namespace blink {





const char* V8EventListener::GetHumanReadableName() const {
  return "V8EventListener";
}

v8::Maybe<void> V8EventListener::handleEvent(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, Event* arg1_event) {
  const char* const class_like_name = "EventListener";
const char* const property_name = "handleEvent";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<void>();
}

if (!IsCallbackFunctionRunnable(callback_relevant_script_state, IncumbentScriptState())) {
  v8::Isolate* isolate = GetIsolate();
v8::HandleScope handle_scope(isolate);
v8::Context::Scope context_scope(callback_relevant_script_state->GetContext());
V8ThrowException::ThrowError(isolate,"The provided callback is no longer runnable.");
return v8::Nothing<void>();
}

bindings::CallbackInvokeHelper<CallbackInterfaceBase> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(arg0_receiver)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<void>();
}
return v8::JustVoid();
}
v8::Local<v8::Value> argv_arr[1];
base::span<v8::Local<v8::Value>> argv(argv_arr);
v8::Local<v8::Value> v8_arg1_event;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_event = ToV8Traits<Event>::ToV8(script_state, arg1_event);
argv[0] = v8_arg1_event;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<void>();
}
return v8::JustVoid();
}

void V8EventListener::InvokeAndReportException(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, Event* arg1_event) {
  v8::Isolate* isolate = GetIsolate();
v8::TryCatch try_catch(isolate);
try_catch.SetVerbose(true);

std::ignore = handleEvent(arg0_receiver, arg1_event);
}

bool V8EventListener::IsRunnableOrThrowException(IgnorePause ignore_pause) {
  ScriptState* callback_relevant_script_state = CallbackRelevantScriptState();

const bool is_runnable =
    ignore_pause == IgnorePause::kIgnore
    ? IsCallbackFunctionRunnableIgnoringPause(
          callback_relevant_script_state, IncumbentScriptState())
    : IsCallbackFunctionRunnable(
          callback_relevant_script_state, IncumbentScriptState());
if (is_runnable)
  return true;

ScriptState::Scope scope(callback_relevant_script_state);
v8::Isolate* isolate = GetIsolate();
V8ThrowException::ThrowError(
    isolate, "The provided callback is no longer runnable.");
return false;
}

v8::Maybe<void> V8EventListener::InvokeWithoutRunnabilityCheck(bindings::V8ValueOrScriptWrappableAdapter arg0_receiver, Event* arg1_event) {
  const char* const class_like_name = "EventListener";
const char* const property_name = "handleEvent";
ScriptState* callback_relevant_script_state =
    CallbackRelevantScriptStateOrThrowException(
        class_like_name, property_name);
if (!callback_relevant_script_state) {
  return v8::Nothing<void>();
}

bindings::CallbackInvokeHelper<CallbackInterfaceBase> helper(
    this, class_like_name, property_name);
if (!helper.PrepareForCall(arg0_receiver)) [[unlikely]] {
  if (helper.V8Result().IsEmpty()) {
  return v8::Nothing<void>();
}
return v8::JustVoid();
}
v8::Local<v8::Value> argv_arr[1];
base::span<v8::Local<v8::Value>> argv(argv_arr);
v8::Local<v8::Value> v8_arg1_event;
ScriptState* script_state = CallbackRelevantScriptState();
v8_arg1_event = ToV8Traits<Event>::ToV8(script_state, arg1_event);
argv[0] = v8_arg1_event;
if (!helper.Call(static_cast<int>(argv.size()), argv.data())) {
  return v8::Nothing<void>();
}
return v8::JustVoid();
}


}  // namespace blink
