// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CSS_STYLE_SHEET_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CSS_STYLE_SHEET_INIT_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;
class MediaList;
class V8UnionMediaListOrString;

class CORE_EXPORT CSSStyleSheetInit : public bindings::InputDictionaryBase {
  
  public:
static CSSStyleSheetInit* Create() {
  return MakeGarbageCollected<CSSStyleSheetInit>();
}
static CSSStyleSheetInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<CSSStyleSheetInit>(isolate);
}
static CSSStyleSheetInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  CSSStyleSheetInit();
explicit  CSSStyleSheetInit(v8::Isolate* isolate);

bool hasAlternate() const {
  return true;
}
bool alternate() const {
  return member_alternate_;
}
void setAlternate(bool value) {
  member_alternate_ = value;
}

bool hasDisabled() const {
  return true;
}
bool disabled() const {
  return member_disabled_;
}
void setDisabled(bool value) {
  member_disabled_ = value;
}

bool hasMedia() const {
  return true;
}
V8UnionMediaListOrString* media() const {
  return member_media_.Get();
}
void setMedia(V8UnionMediaListOrString* value) {
  member_media_ = value;
DCHECK(member_media_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



bool member_alternate_{false};
bool member_disabled_{false};
Member<V8UnionMediaListOrString> member_media_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_CSS_STYLE_SHEET_INIT_H_
