// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/core/v8/v8_css_numeric_type.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"angle",
"flex",
"frequency",
"length",
"percent",
"percentHint",
"resolution",
"time",
};


}  // namespace 

CSSNumericType* CSSNumericType::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  CSSNumericType* dictionary = MakeGarbageCollected<CSSNumericType>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "CSSNumericType";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 CSSNumericType::CSSNumericType() {
  
}

 CSSNumericType::CSSNumericType(v8::Isolate* isolate) {
  
}


























































void CSSNumericType::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void CSSNumericType::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void CSSNumericType::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasAngle()) {
  values[0] = ToV8Traits<IDLLong>::ToV8(script_state, member_angle_);
DCHECK(!values[0].IsEmpty());
}
if (hasFlex()) {
  values[1] = ToV8Traits<IDLLong>::ToV8(script_state, member_flex_);
DCHECK(!values[1].IsEmpty());
}
if (hasFrequency()) {
  values[2] = ToV8Traits<IDLLong>::ToV8(script_state, member_frequency_);
DCHECK(!values[2].IsEmpty());
}
if (hasLength()) {
  values[3] = ToV8Traits<IDLLong>::ToV8(script_state, member_length_);
DCHECK(!values[3].IsEmpty());
}
if (hasPercent()) {
  values[4] = ToV8Traits<IDLLong>::ToV8(script_state, member_percent_);
DCHECK(!values[4].IsEmpty());
}
if (hasPercentHint()) {
  values[5] = ToV8Traits<V8CSSNumericBaseType>::ToV8(script_state, member_percent_hint_);
DCHECK(!values[5].IsEmpty());
}
if (hasResolution()) {
  values[6] = ToV8Traits<IDLLong>::ToV8(script_state, member_resolution_);
DCHECK(!values[6].IsEmpty());
}
if (hasTime()) {
  values[7] = ToV8Traits<IDLLong>::ToV8(script_state, member_time_);
DCHECK(!values[7].IsEmpty());
}
}

const void* CSSNumericType::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> CSSNumericType::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void CSSNumericType::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "CSSNumericType";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("angle");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_angle_, member_angle_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("flex");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_flex_, member_flex_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("frequency");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_frequency_, member_frequency_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("length");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_length_, member_length_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("percent");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_percent_, member_percent_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("percentHint");
if (!bindings::GetDictionaryMemberFromV8Object<V8CSSNumericBaseType, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_percent_hint_, member_percent_hint_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("resolution");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_resolution_, member_resolution_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("time");
if (!bindings::GetDictionaryMemberFromV8Object<IDLLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[7].Get(isolate), has_time_, member_time_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> CSSNumericType::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
