// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_BLOB_PROPERTY_BAG_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_BLOB_PROPERTY_BAG_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_ending_type.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class ExceptionState;

class CORE_EXPORT BlobPropertyBag : public bindings::InputDictionaryBase {
  
  public:
static BlobPropertyBag* Create() {
  return MakeGarbageCollected<BlobPropertyBag>();
}
static BlobPropertyBag* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<BlobPropertyBag>(isolate);
}
static BlobPropertyBag* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  BlobPropertyBag();
explicit  BlobPropertyBag(v8::Isolate* isolate);

bool hasEndings() const {
  return true;
}
V8EndingType endings() const {
  return member_endings_;
}
void setEndings(V8EndingType value) {
  member_endings_ = value;
}
void setEndings(V8EndingType::Enum value) {
  member_endings_ = V8EndingType(value);
}

bool hasType() const {
  return true;
}
const String& type() const {
  return member_type_;
}
void setType(const String& value);
void setType(String&& value);


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 2;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



V8EndingType member_endings_{V8EndingType::Enum::kTransparent};
String member_type_{""};


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_CORE_V8_V8_BLOB_PROPERTY_BAG_H_
