// third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom-params-data.h"
#include "third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom-import-headers.h"
#include "third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom-test-utils.h"


namespace blink::mojom {
WorkletGlobalScopeCreationParams::WorkletGlobalScopeCreationParams()
    : script_url(),
      starter_origin(),
      origin_trial_features(),
      devtools_token(),
      devtools_host(),
      code_cache_host(),
      browser_interface_broker(),
      wait_for_debugger() {}

WorkletGlobalScopeCreationParams::WorkletGlobalScopeCreationParams(
    const ::GURL& script_url_in,
    const ::url::Origin& starter_origin_in,
    std::vector<::blink::mojom::OriginTrialFeature> origin_trial_features_in,
    const ::base::UnguessableToken& devtools_token_in,
    ::mojo::PendingRemote<WorkletDevToolsHost> devtools_host_in,
    ::mojo::PendingRemote<::blink::mojom::CodeCacheHost> code_cache_host_in,
    ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker> browser_interface_broker_in,
    bool wait_for_debugger_in)
    : script_url(std::move(script_url_in)),
      starter_origin(std::move(starter_origin_in)),
      origin_trial_features(std::move(origin_trial_features_in)),
      devtools_token(std::move(devtools_token_in)),
      devtools_host(std::move(devtools_host_in)),
      code_cache_host(std::move(code_cache_host_in)),
      browser_interface_broker(std::move(browser_interface_broker_in)),
      wait_for_debugger(std::move(wait_for_debugger_in)) {}

WorkletGlobalScopeCreationParams::~WorkletGlobalScopeCreationParams() = default;

void WorkletGlobalScopeCreationParams::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "script_url"), this->script_url,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::GURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "starter_origin"), this->starter_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::url::Origin&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "origin_trial_features"), this->origin_trial_features,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::blink::mojom::OriginTrialFeature>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_token"), this->devtools_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::base::UnguessableToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "devtools_host"), this->devtools_host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<WorkletDevToolsHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "code_cache_host"), this->code_cache_host,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::CodeCacheHost>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browser_interface_broker"), this->browser_interface_broker,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::BrowserInterfaceBroker>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wait_for_debugger"), this->wait_for_debugger,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool WorkletGlobalScopeCreationParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

WorkletDevToolsHost::IPCStableHashFunction WorkletDevToolsHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WorkletDevToolsHost>(message.name())) {
    case messages::WorkletDevToolsHost::kOnReadyForInspection: {
      return &WorkletDevToolsHost::OnReadyForInspection_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WorkletDevToolsHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WorkletDevToolsHost>(message.name())) {
      case messages::WorkletDevToolsHost::kOnReadyForInspection:
            return "Receive blink::mojom::WorkletDevToolsHost::OnReadyForInspection";
    }
  } else {
    switch (static_cast<messages::WorkletDevToolsHost>(message.name())) {
      case messages::WorkletDevToolsHost::kOnReadyForInspection:
            return "Receive reply blink::mojom::WorkletDevToolsHost::OnReadyForInspection";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WorkletDevToolsHost::OnReadyForInspection_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1c829b35;  // IPCStableHash for blink::mojom::WorkletDevToolsHost::OnReadyForInspection
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WorkletDevToolsHostProxy::WorkletDevToolsHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WorkletDevToolsHostProxy::OnReadyForInspection(
    ::mojo::PendingRemote<::blink::mojom::DevToolsAgent> in_agent, ::mojo::PendingReceiver<::blink::mojom::DevToolsAgentHost> in_agent_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WorkletDevToolsHost::OnReadyForInspection", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent"), in_agent,
                        "<value of type ::mojo::PendingRemote<::blink::mojom::DevToolsAgent>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("agent_host"), in_agent_host,
                        "<value of type ::mojo::PendingReceiver<::blink::mojom::DevToolsAgentHost>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WorkletDevToolsHost::kOnReadyForInspection), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WorkletDevToolsHost_OnReadyForInspection_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::DevToolsAgentInterfaceBase>>(
    in_agent,
    &params->agent,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->agent)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid agent in WorkletDevToolsHost.OnReadyForInspection request");

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::DevToolsAgentHostInterfaceBase>>(
    in_agent_host,
    &params->agent_host,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->agent_host)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid agent_host in WorkletDevToolsHost.OnReadyForInspection request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WorkletDevToolsHost::Name_);
  message.set_method_name("OnReadyForInspection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WorkletDevToolsHostStubDispatch::Accept(
    WorkletDevToolsHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WorkletDevToolsHost>(message->header()->name)) {
    case messages::WorkletDevToolsHost::kOnReadyForInspection: {
      DCHECK(message->is_serialized());
      internal::WorkletDevToolsHost_OnReadyForInspection_Params_Data* params =
          reinterpret_cast<internal::WorkletDevToolsHost_OnReadyForInspection_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WorkletDevToolsHost.0
      bool success = true;
      ::mojo::PendingRemote<::blink::mojom::DevToolsAgent> p_agent{};
      ::mojo::PendingReceiver<::blink::mojom::DevToolsAgentHost> p_agent_host{};
      WorkletDevToolsHost_OnReadyForInspection_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_agent =
            input_data_view.TakeAgent<decltype(p_agent)>();
      }
      if (success) {
        p_agent_host =
            input_data_view.TakeAgentHost<decltype(p_agent_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WorkletDevToolsHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnReadyForInspection(        
        std::move(p_agent), 
        std::move(p_agent_host));
      return true;
    }
  }
  return false;
}

// static
bool WorkletDevToolsHostStubDispatch::AcceptWithResponder(
    WorkletDevToolsHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WorkletDevToolsHost>(message->header()->name)) {
    case messages::WorkletDevToolsHost::kOnReadyForInspection: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWorkletDevToolsHostValidationInfo[] = {
    { &internal::WorkletDevToolsHost_OnReadyForInspection_Params_Data::Validate,
     nullptr /* no response */},
};

bool WorkletDevToolsHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::WorkletDevToolsHost::Name_,
    kWorkletDevToolsHostValidationInfo);
}



}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::WorkletGlobalScopeCreationParams::DataView, ::blink::mojom::WorkletGlobalScopeCreationParamsPtr>::Read(
    ::blink::mojom::WorkletGlobalScopeCreationParams::DataView input,
    ::blink::mojom::WorkletGlobalScopeCreationParamsPtr* output) {
  bool success = true;
  ::blink::mojom::WorkletGlobalScopeCreationParamsPtr result(::blink::mojom::WorkletGlobalScopeCreationParams::New());
  
      if (success && !input.ReadScriptUrl(&result->script_url))
        success = false;
      if (success && !input.ReadStarterOrigin(&result->starter_origin))
        success = false;
      if (success && !input.ReadOriginTrialFeatures(&result->origin_trial_features))
        success = false;
      if (success && !input.ReadDevtoolsToken(&result->devtools_token))
        success = false;
      if (success) {
        result->devtools_host =
            input.TakeDevtoolsHost<decltype(result->devtools_host)>();
      }
      if (success) {
        result->code_cache_host =
            input.TakeCodeCacheHost<decltype(result->code_cache_host)>();
      }
      if (success) {
        result->browser_interface_broker =
            input.TakeBrowserInterfaceBroker<decltype(result->browser_interface_broker)>();
      }
      if (success)
        result->wait_for_debugger = input.wait_for_debugger();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void WorkletDevToolsHostInterceptorForTesting::OnReadyForInspection(::mojo::PendingRemote<::blink::mojom::DevToolsAgent> agent, ::mojo::PendingReceiver<::blink::mojom::DevToolsAgentHost> agent_host) {
  GetForwardingInterface()->OnReadyForInspection(
    std::move(agent)
    , 
    std::move(agent_host)
    );
}
WorkletDevToolsHostAsyncWaiter::WorkletDevToolsHostAsyncWaiter(
    WorkletDevToolsHost* proxy) : proxy_(proxy) {}

WorkletDevToolsHostAsyncWaiter::~WorkletDevToolsHostAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif