// third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_WORKLET_GLOBAL_SCOPE_CREATION_PARAMS_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_WORKLET_GLOBAL_SCOPE_CREATION_PARAMS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-shared.h"
#include "third_party/blink/public/mojom/loader/code_cache.mojom-shared.h"
#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/public/mojom/browser_interface_broker.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"
#include "mojo/public/cpp/system/data_pipe.h"



#include "third_party/blink/public/mojom/worker/worklet_global_scope_creation_params.mojom-data-view.h"
#include "base/component_export.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::WorkletGlobalScopeCreationParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WorkletGlobalScopeCreationParamsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WorkletGlobalScopeCreationParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::script_url(input)) in_script_url = Traits::script_url(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->script_url)::BaseType> script_url_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_script_url,
      script_url_fragment);

    fragment->script_url.Set(
        script_url_fragment.is_null() ? nullptr : script_url_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->script_url.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null script_url in WorkletGlobalScopeCreationParams struct");

    decltype(Traits::starter_origin(input)) in_starter_origin = Traits::starter_origin(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->starter_origin)::BaseType> starter_origin_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_starter_origin,
      starter_origin_fragment);

    fragment->starter_origin.Set(
        starter_origin_fragment.is_null() ? nullptr : starter_origin_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->starter_origin.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null starter_origin in WorkletGlobalScopeCreationParams struct");

    decltype(Traits::origin_trial_features(input)) in_origin_trial_features = Traits::origin_trial_features(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->origin_trial_features)::BaseType>
        origin_trial_features_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& origin_trial_features_validate_params =
        mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::OriginTrialFeature_Data::Validate>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::OriginTrialFeature>>(
      in_origin_trial_features,
      origin_trial_features_fragment,
      &origin_trial_features_validate_params);

    fragment->origin_trial_features.Set(
        origin_trial_features_fragment.is_null() ? nullptr : origin_trial_features_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->origin_trial_features.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin_trial_features in WorkletGlobalScopeCreationParams struct");

    decltype(Traits::devtools_token(input)) in_devtools_token = Traits::devtools_token(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->devtools_token)::BaseType> devtools_token_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_devtools_token,
      devtools_token_fragment);

    fragment->devtools_token.Set(
        devtools_token_fragment.is_null() ? nullptr : devtools_token_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->devtools_token.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null devtools_token in WorkletGlobalScopeCreationParams struct");

    decltype(Traits::devtools_host(input)) in_devtools_host = Traits::devtools_host(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::WorkletDevToolsHostInterfaceBase>>(
      in_devtools_host,
      &fragment->devtools_host,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->devtools_host)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid devtools_host in WorkletGlobalScopeCreationParams struct");

    decltype(Traits::code_cache_host(input)) in_code_cache_host = Traits::code_cache_host(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::CodeCacheHostInterfaceBase>>(
      in_code_cache_host,
      &fragment->code_cache_host,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->code_cache_host)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid code_cache_host in WorkletGlobalScopeCreationParams struct");

    decltype(Traits::browser_interface_broker(input)) in_browser_interface_broker = Traits::browser_interface_broker(input);

    
    mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::BrowserInterfaceBrokerInterfaceBase>>(
      in_browser_interface_broker,
      &fragment->browser_interface_broker,
      &fragment.message());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(!mojo::internal::IsHandleOrInterfaceValid(fragment->browser_interface_broker)),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid browser_interface_broker in WorkletGlobalScopeCreationParams struct");

    fragment->wait_for_debugger = Traits::wait_for_debugger(input);
  }

  static bool Deserialize(::blink::mojom::internal::WorkletGlobalScopeCreationParams_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::WorkletGlobalScopeCreationParamsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink::mojom {

inline void WorkletGlobalScopeCreationParamsDataView::GetScriptUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->script_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void WorkletGlobalScopeCreationParamsDataView::GetStarterOriginDataView(
    ::url::mojom::OriginDataView* output) {
  auto pointer = data_->starter_origin.Get();
  *output = ::url::mojom::OriginDataView(pointer, message_);
}
inline void WorkletGlobalScopeCreationParamsDataView::GetOriginTrialFeaturesDataView(
    mojo::ArrayDataView<::blink::mojom::OriginTrialFeature>* output) {
  auto pointer = data_->origin_trial_features.Get();
  *output = mojo::ArrayDataView<::blink::mojom::OriginTrialFeature>(pointer, message_);
}
inline void WorkletGlobalScopeCreationParamsDataView::GetDevtoolsTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  auto pointer = data_->devtools_token.Get();
  *output = ::mojo_base::mojom::UnguessableTokenDataView(pointer, message_);
}



}  // blink::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WORKER_WORKLET_GLOBAL_SCOPE_CREATION_PARAMS_MOJOM_SHARED_H_