// third_party/blink/public/mojom/worker/shared_worker_exception_details.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/worker/shared_worker_exception_details.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var source_location$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/source_location.mojom', '../../../../../services/network/public/mojom/source_location.mojom.js');
  }


  var SharedWorkerErrorType = {};
  SharedWorkerErrorType.kParseError = 0;
  SharedWorkerErrorType.kRuntimeError = 1;
  SharedWorkerErrorType.MIN_VALUE = 0;
  SharedWorkerErrorType.MAX_VALUE = 1;

  SharedWorkerErrorType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  SharedWorkerErrorType.toKnownEnumValue = function(value) {
    return value;
  };

  SharedWorkerErrorType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function SharedWorkerExceptionDetails(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedWorkerExceptionDetails.prototype.initDefaults_ = function() {
    this.errorMessage = null;
    this.sourceLocation = null;
    this.errorType = 0;
  };
  SharedWorkerExceptionDetails.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedWorkerExceptionDetails.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerExceptionDetails.errorMessage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerExceptionDetails.sourceLocation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, source_location$.SourceLocation, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerExceptionDetails.errorType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, SharedWorkerErrorType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedWorkerExceptionDetails.encodedSize = codec.kStructHeaderSize + 24;

  SharedWorkerExceptionDetails.decode = function(decoder) {
    var packed;
    var val = new SharedWorkerExceptionDetails();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errorMessage =
        decoder.decodeStruct(codec.String);
    val.sourceLocation =
        decoder.decodeStructPointer(source_location$.SourceLocation);
    val.errorType =
        decoder.decodeStruct(new codec.Enum(SharedWorkerErrorType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SharedWorkerExceptionDetails.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedWorkerExceptionDetails.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.errorMessage);
    encoder.encodeStructPointer(source_location$.SourceLocation, val.sourceLocation);
    encoder.encodeStruct(codec.Int32, val.errorType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.SharedWorkerErrorType = SharedWorkerErrorType;
  exports.SharedWorkerExceptionDetails = SharedWorkerExceptionDetails;
})();