// third_party/blink/public/mojom/widget/platform_widget.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  RenderFrameMetadataObserverRemote as cc_mojom_RenderFrameMetadataObserverRemote,
  RenderFrameMetadataObserverPendingReceiver as cc_mojom_RenderFrameMetadataObserverPendingReceiver,
  RenderFrameMetadataObserverClientRemote as cc_mojom_RenderFrameMetadataObserverClientRemote,
  RenderFrameMetadataObserverClientPendingReceiver as cc_mojom_RenderFrameMetadataObserverClientPendingReceiver
} from '../../../../../cc/mojom/render_frame_metadata.mojom.m.js';

import {
  String16 as mojoBase_mojom_String16,
  String16Spec as mojoBase_mojom_String16Spec
} from '../../../../../mojo/public/mojom/base/string16.mojom.m.js';

import {
  TextDirection as mojoBase_mojom_TextDirection,
  TextDirectionSpec as mojoBase_mojom_TextDirectionSpec
} from '../../../../../mojo/public/mojom/base/text_direction.mojom.m.js';

import {
  CompositorFrameSinkRemote as viz_mojom_CompositorFrameSinkRemote,
  CompositorFrameSinkPendingReceiver as viz_mojom_CompositorFrameSinkPendingReceiver,
  CompositorFrameSinkClientRemote as viz_mojom_CompositorFrameSinkClientRemote,
  CompositorFrameSinkClientPendingReceiver as viz_mojom_CompositorFrameSinkClientPendingReceiver
} from '../../../../../services/viz/public/mojom/compositing/compositor_frame_sink.mojom.m.js';

import {
  InputTargetClientRemote as viz_mojom_InputTargetClientRemote,
  InputTargetClientPendingReceiver as viz_mojom_InputTargetClientPendingReceiver
} from '../../../../../services/viz/public/mojom/hit_test/input_target_client.mojom.m.js';

import {
  Cursor as ui_mojom_Cursor,
  CursorSpec as ui_mojom_CursorSpec
} from '../../../../../ui/base/cursor/mojom/cursor.mojom.m.js';

import {
  TextInputState as ui_mojom_TextInputState,
  TextInputStateSpec as ui_mojom_TextInputStateSpec
} from '../../../../../ui/base/ime/mojom/text_input_state.mojom.m.js';

import {
  MenuSourceType as ui_mojom_MenuSourceType,
  MenuSourceTypeSpec as ui_mojom_MenuSourceTypeSpec
} from '../../../../../ui/base/mojom/menu_source_type.mojom.m.js';

import {
  Point as gfx_mojom_Point,
  PointSpec as gfx_mojom_PointSpec,
  Rect as gfx_mojom_Rect,
  RectSpec as gfx_mojom_RectSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';

import {
  WidgetInputHandlerRemote as blink_mojom_WidgetInputHandlerRemote,
  WidgetInputHandlerPendingReceiver as blink_mojom_WidgetInputHandlerPendingReceiver,
  WidgetInputHandlerHostRemote as blink_mojom_WidgetInputHandlerHostRemote,
  WidgetInputHandlerHostPendingReceiver as blink_mojom_WidgetInputHandlerHostPendingReceiver
} from '../input/input_handler.mojom.m.js';

import {
  RecordContentToVisibleTimeRequest as blink_mojom_RecordContentToVisibleTimeRequest,
  RecordContentToVisibleTimeRequestSpec as blink_mojom_RecordContentToVisibleTimeRequestSpec
} from './record_content_to_visible_time_request.mojom.m.js';

import {
  VisualProperties as blink_mojom_VisualProperties,
  VisualPropertiesSpec as blink_mojom_VisualPropertiesSpec
} from './visual_properties.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WidgetCompositorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.WidgetCompositor', scope);
  }
}

/** @interface */
export class WidgetCompositorInterface {
  
  /**
   * @return {!Promise}
   */

  visualStateRequest() {}
}

/**
 * @implements { WidgetCompositorInterface }
 */
export class WidgetCompositorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WidgetCompositorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WidgetCompositorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WidgetCompositorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise}
   */

  visualStateRequest() {
    return this.proxy.sendMessage(
        0,
        WidgetCompositor_VisualStateRequest_ParamsSpec.$,
        WidgetCompositor_VisualStateRequest_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WidgetCompositor
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WidgetCompositorReceiver {
  /**
   * @param {!WidgetCompositorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WidgetCompositorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WidgetCompositorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WidgetCompositorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WidgetCompositor_VisualStateRequest_ParamsSpec.$,
        WidgetCompositor_VisualStateRequest_ResponseParamsSpec.$,
        impl.visualStateRequest.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WidgetCompositor {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WidgetCompositor";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WidgetCompositorRemote}
   */
  static getRemote() {
    let remote = new WidgetCompositorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WidgetCompositor
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WidgetCompositorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WidgetCompositorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WidgetCompositorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.visualStateRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WidgetCompositor_VisualStateRequest_ParamsSpec.$,
        WidgetCompositor_VisualStateRequest_ResponseParamsSpec.$,
        this.visualStateRequest.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WidgetHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.WidgetHost', scope);
  }
}

/** @interface */
export class WidgetHostInterface {
  
  /**
   * @param { !ui_mojom_Cursor } cursor
   */

  setCursor(cursor) {}
  
  /**
   * @param { !mojoBase_mojom_String16 } tooltipText
   * @param { !mojoBase_mojom_TextDirection } textDirectionHint
   */

  updateTooltipUnderCursor(tooltipText, textDirectionHint) {}
  
  /**
   * @param { !mojoBase_mojom_String16 } tooltipText
   * @param { !mojoBase_mojom_TextDirection } textDirectionHint
   * @param { !gfx_mojom_Rect } bounds
   */

  updateTooltipFromKeyboard(tooltipText, textDirectionHint, bounds) {}
  
  /**
   */

  clearKeyboardTriggeredTooltip() {}
  
  /**
   * @param { !ui_mojom_TextInputState } state
   */

  textInputStateChanged(state) {}
  
  /**
   * @param { !gfx_mojom_Rect } anchorRect
   * @param { !mojoBase_mojom_TextDirection } anchorDir
   * @param { !gfx_mojom_Rect } focusRect
   * @param { !mojoBase_mojom_TextDirection } focusDir
   * @param { !gfx_mojom_Rect } boundingBoxRect
   * @param { !boolean } isAnchorFirst
   */

  selectionBoundsChanged(anchorRect, anchorDir, focusRect, focusDir, boundingBoxRect, isAnchorFirst) {}
  
  /**
   * @param { !viz_mojom_CompositorFrameSinkPendingReceiver } compositorFrameSinkReceiver
   * @param { !viz_mojom_CompositorFrameSinkClientRemote } compositorFrameSinkClient
   * @param { !RenderInputRouterClientRemote } renderInputRouterClient
   */

  createFrameSink(compositorFrameSinkReceiver, compositorFrameSinkClient, renderInputRouterClient) {}
  
  /**
   * @param { !cc_mojom_RenderFrameMetadataObserverClientPendingReceiver } renderFrameMetadataObserverClientReceiver
   * @param { !cc_mojom_RenderFrameMetadataObserverRemote } renderFrameMetadataObserver
   */

  registerRenderFrameMetadataObserver(renderFrameMetadataObserverClientReceiver, renderFrameMetadataObserver) {}
}

/**
 * @implements { WidgetHostInterface }
 */
export class WidgetHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WidgetHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WidgetHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WidgetHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ui_mojom_Cursor } cursor
   */

  setCursor(
      cursor) {
    this.proxy.sendMessage(
        0,
        WidgetHost_SetCursor_ParamsSpec.$,
        null,
        [
          cursor
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_String16 } tooltipText
   * @param { !mojoBase_mojom_TextDirection } textDirectionHint
   */

  updateTooltipUnderCursor(
      tooltipText,
      textDirectionHint) {
    this.proxy.sendMessage(
        1,
        WidgetHost_UpdateTooltipUnderCursor_ParamsSpec.$,
        null,
        [
          tooltipText,
          textDirectionHint
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_String16 } tooltipText
   * @param { !mojoBase_mojom_TextDirection } textDirectionHint
   * @param { !gfx_mojom_Rect } bounds
   */

  updateTooltipFromKeyboard(
      tooltipText,
      textDirectionHint,
      bounds) {
    this.proxy.sendMessage(
        2,
        WidgetHost_UpdateTooltipFromKeyboard_ParamsSpec.$,
        null,
        [
          tooltipText,
          textDirectionHint,
          bounds
        ],
        false);
  }

  
  /**
   */

  clearKeyboardTriggeredTooltip() {
    this.proxy.sendMessage(
        3,
        WidgetHost_ClearKeyboardTriggeredTooltip_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !ui_mojom_TextInputState } state
   */

  textInputStateChanged(
      state) {
    this.proxy.sendMessage(
        4,
        WidgetHost_TextInputStateChanged_ParamsSpec.$,
        null,
        [
          state
        ],
        false);
  }

  
  /**
   * @param { !gfx_mojom_Rect } anchorRect
   * @param { !mojoBase_mojom_TextDirection } anchorDir
   * @param { !gfx_mojom_Rect } focusRect
   * @param { !mojoBase_mojom_TextDirection } focusDir
   * @param { !gfx_mojom_Rect } boundingBoxRect
   * @param { !boolean } isAnchorFirst
   */

  selectionBoundsChanged(
      anchorRect,
      anchorDir,
      focusRect,
      focusDir,
      boundingBoxRect,
      isAnchorFirst) {
    this.proxy.sendMessage(
        5,
        WidgetHost_SelectionBoundsChanged_ParamsSpec.$,
        null,
        [
          anchorRect,
          anchorDir,
          focusRect,
          focusDir,
          boundingBoxRect,
          isAnchorFirst
        ],
        false);
  }

  
  /**
   * @param { !viz_mojom_CompositorFrameSinkPendingReceiver } compositorFrameSinkReceiver
   * @param { !viz_mojom_CompositorFrameSinkClientRemote } compositorFrameSinkClient
   * @param { !RenderInputRouterClientRemote } renderInputRouterClient
   */

  createFrameSink(
      compositorFrameSinkReceiver,
      compositorFrameSinkClient,
      renderInputRouterClient) {
    this.proxy.sendMessage(
        6,
        WidgetHost_CreateFrameSink_ParamsSpec.$,
        null,
        [
          compositorFrameSinkReceiver,
          compositorFrameSinkClient,
          renderInputRouterClient
        ],
        false);
  }

  
  /**
   * @param { !cc_mojom_RenderFrameMetadataObserverClientPendingReceiver } renderFrameMetadataObserverClientReceiver
   * @param { !cc_mojom_RenderFrameMetadataObserverRemote } renderFrameMetadataObserver
   */

  registerRenderFrameMetadataObserver(
      renderFrameMetadataObserverClientReceiver,
      renderFrameMetadataObserver) {
    this.proxy.sendMessage(
        7,
        WidgetHost_RegisterRenderFrameMetadataObserver_ParamsSpec.$,
        null,
        [
          renderFrameMetadataObserverClientReceiver,
          renderFrameMetadataObserver
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WidgetHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WidgetHostReceiver {
  /**
   * @param {!WidgetHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WidgetHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WidgetHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WidgetHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WidgetHost_SetCursor_ParamsSpec.$,
        null,
        impl.setCursor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        WidgetHost_UpdateTooltipUnderCursor_ParamsSpec.$,
        null,
        impl.updateTooltipUnderCursor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        WidgetHost_UpdateTooltipFromKeyboard_ParamsSpec.$,
        null,
        impl.updateTooltipFromKeyboard.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        WidgetHost_ClearKeyboardTriggeredTooltip_ParamsSpec.$,
        null,
        impl.clearKeyboardTriggeredTooltip.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        WidgetHost_TextInputStateChanged_ParamsSpec.$,
        null,
        impl.textInputStateChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        WidgetHost_SelectionBoundsChanged_ParamsSpec.$,
        null,
        impl.selectionBoundsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        WidgetHost_CreateFrameSink_ParamsSpec.$,
        null,
        impl.createFrameSink.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        WidgetHost_RegisterRenderFrameMetadataObserver_ParamsSpec.$,
        null,
        impl.registerRenderFrameMetadataObserver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WidgetHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WidgetHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WidgetHostRemote}
   */
  static getRemote() {
    let remote = new WidgetHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WidgetHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WidgetHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WidgetHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WidgetHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCursor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WidgetHost_SetCursor_ParamsSpec.$,
        null,
        this.setCursor.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateTooltipUnderCursor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        WidgetHost_UpdateTooltipUnderCursor_ParamsSpec.$,
        null,
        this.updateTooltipUnderCursor.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateTooltipFromKeyboard =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        WidgetHost_UpdateTooltipFromKeyboard_ParamsSpec.$,
        null,
        this.updateTooltipFromKeyboard.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearKeyboardTriggeredTooltip =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        WidgetHost_ClearKeyboardTriggeredTooltip_ParamsSpec.$,
        null,
        this.clearKeyboardTriggeredTooltip.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.textInputStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        WidgetHost_TextInputStateChanged_ParamsSpec.$,
        null,
        this.textInputStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.selectionBoundsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        WidgetHost_SelectionBoundsChanged_ParamsSpec.$,
        null,
        this.selectionBoundsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createFrameSink =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        WidgetHost_CreateFrameSink_ParamsSpec.$,
        null,
        this.createFrameSink.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.registerRenderFrameMetadataObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        WidgetHost_RegisterRenderFrameMetadataObserver_ParamsSpec.$,
        null,
        this.registerRenderFrameMetadataObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WidgetPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.Widget', scope);
  }
}

/** @interface */
export class WidgetInterface {
  
  /**
   * @return {!Promise}
   */

  forceRedraw() {}
  
  /**
   * @param { !blink_mojom_VisualProperties } visualProperties
   */

  updateVisualProperties(visualProperties) {}
  
  /**
   * @param { !gfx_mojom_Rect } widgetScreenRect
   * @param { !gfx_mojom_Rect } windowScreenRect
   * @return {!Promise}
   */

  updateScreenRects(widgetScreenRect, windowScreenRect) {}
  
  /**
   */

  wasHidden() {}
  
  /**
   * @param { !boolean } wasEvicted
   * @param { ?blink_mojom_RecordContentToVisibleTimeRequest } recordTabSwitchTimeRequest
   */

  wasShown(wasEvicted, recordTabSwitchTimeRequest) {}
  
  /**
   * @param { !blink_mojom_RecordContentToVisibleTimeRequest } visibleTimeRequest
   */

  requestSuccessfulPresentationTimeForNextFrame(visibleTimeRequest) {}
  
  /**
   */

  cancelSuccessfulPresentationTimeRequest() {}
  
  /**
   * @param { !RenderInputRouterClientPendingReceiver } browserClient
   */

  setupBrowserRenderInputRouterConnections(browserClient) {}
}

/**
 * @implements { WidgetInterface }
 */
export class WidgetRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WidgetPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WidgetPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WidgetPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise}
   */

  forceRedraw() {
    return this.proxy.sendMessage(
        0,
        Widget_ForceRedraw_ParamsSpec.$,
        Widget_ForceRedraw_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_VisualProperties } visualProperties
   */

  updateVisualProperties(
      visualProperties) {
    this.proxy.sendMessage(
        1,
        Widget_UpdateVisualProperties_ParamsSpec.$,
        null,
        [
          visualProperties
        ],
        false);
  }

  
  /**
   * @param { !gfx_mojom_Rect } widgetScreenRect
   * @param { !gfx_mojom_Rect } windowScreenRect
   * @return {!Promise}
   */

  updateScreenRects(
      widgetScreenRect,
      windowScreenRect) {
    return this.proxy.sendMessage(
        2,
        Widget_UpdateScreenRects_ParamsSpec.$,
        Widget_UpdateScreenRects_ResponseParamsSpec.$,
        [
          widgetScreenRect,
          windowScreenRect
        ],
        false);
  }

  
  /**
   */

  wasHidden() {
    this.proxy.sendMessage(
        3,
        Widget_WasHidden_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !boolean } wasEvicted
   * @param { ?blink_mojom_RecordContentToVisibleTimeRequest } recordTabSwitchTimeRequest
   */

  wasShown(
      wasEvicted,
      recordTabSwitchTimeRequest) {
    this.proxy.sendMessage(
        4,
        Widget_WasShown_ParamsSpec.$,
        null,
        [
          wasEvicted,
          recordTabSwitchTimeRequest
        ],
        false);
  }

  
  /**
   * @param { !blink_mojom_RecordContentToVisibleTimeRequest } visibleTimeRequest
   */

  requestSuccessfulPresentationTimeForNextFrame(
      visibleTimeRequest) {
    this.proxy.sendMessage(
        5,
        Widget_RequestSuccessfulPresentationTimeForNextFrame_ParamsSpec.$,
        null,
        [
          visibleTimeRequest
        ],
        false);
  }

  
  /**
   */

  cancelSuccessfulPresentationTimeRequest() {
    this.proxy.sendMessage(
        6,
        Widget_CancelSuccessfulPresentationTimeRequest_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !RenderInputRouterClientPendingReceiver } browserClient
   */

  setupBrowserRenderInputRouterConnections(
      browserClient) {
    this.proxy.sendMessage(
        7,
        Widget_SetupBrowserRenderInputRouterConnections_ParamsSpec.$,
        null,
        [
          browserClient
        ],
        false);
  }
}

/**
 * An object which receives request messages for the Widget
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WidgetReceiver {
  /**
   * @param {!WidgetInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WidgetRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WidgetRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WidgetRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Widget_ForceRedraw_ParamsSpec.$,
        Widget_ForceRedraw_ResponseParamsSpec.$,
        impl.forceRedraw.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Widget_UpdateVisualProperties_ParamsSpec.$,
        null,
        impl.updateVisualProperties.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Widget_UpdateScreenRects_ParamsSpec.$,
        Widget_UpdateScreenRects_ResponseParamsSpec.$,
        impl.updateScreenRects.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Widget_WasHidden_ParamsSpec.$,
        null,
        impl.wasHidden.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Widget_WasShown_ParamsSpec.$,
        null,
        impl.wasShown.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        Widget_RequestSuccessfulPresentationTimeForNextFrame_ParamsSpec.$,
        null,
        impl.requestSuccessfulPresentationTimeForNextFrame.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        Widget_CancelSuccessfulPresentationTimeRequest_ParamsSpec.$,
        null,
        impl.cancelSuccessfulPresentationTimeRequest.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        Widget_SetupBrowserRenderInputRouterConnections_ParamsSpec.$,
        null,
        impl.setupBrowserRenderInputRouterConnections.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Widget {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.Widget";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WidgetRemote}
   */
  static getRemote() {
    let remote = new WidgetRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the Widget
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WidgetCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WidgetRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WidgetRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forceRedraw =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Widget_ForceRedraw_ParamsSpec.$,
        Widget_ForceRedraw_ResponseParamsSpec.$,
        this.forceRedraw.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateVisualProperties =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Widget_UpdateVisualProperties_ParamsSpec.$,
        null,
        this.updateVisualProperties.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateScreenRects =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Widget_UpdateScreenRects_ParamsSpec.$,
        Widget_UpdateScreenRects_ResponseParamsSpec.$,
        this.updateScreenRects.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.wasHidden =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Widget_WasHidden_ParamsSpec.$,
        null,
        this.wasHidden.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.wasShown =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Widget_WasShown_ParamsSpec.$,
        null,
        this.wasShown.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestSuccessfulPresentationTimeForNextFrame =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        Widget_RequestSuccessfulPresentationTimeForNextFrame_ParamsSpec.$,
        null,
        this.requestSuccessfulPresentationTimeForNextFrame.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelSuccessfulPresentationTimeRequest =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        Widget_CancelSuccessfulPresentationTimeRequest_ParamsSpec.$,
        null,
        this.cancelSuccessfulPresentationTimeRequest.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setupBrowserRenderInputRouterConnections =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        Widget_SetupBrowserRenderInputRouterConnections_ParamsSpec.$,
        null,
        this.setupBrowserRenderInputRouterConnections.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class RenderInputRouterClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.RenderInputRouterClient', scope);
  }
}

/** @interface */
export class RenderInputRouterClientInterface {
  
  /**
   * @param { !blink_mojom_WidgetInputHandlerPendingReceiver } request
   * @param { !blink_mojom_WidgetInputHandlerHostRemote } host
   * @param { !boolean } fromViz
   */

  getWidgetInputHandler(request, host, fromViz) {}
  
  /**
   * @param { !ui_mojom_MenuSourceType } sourceType
   * @param { !gfx_mojom_Point } location
   */

  showContextMenu(sourceType, location) {}
  
  /**
   * @param { !viz_mojom_InputTargetClientPendingReceiver } host
   */

  bindInputTargetClient(host) {}
}

/**
 * @implements { RenderInputRouterClientInterface }
 */
export class RenderInputRouterClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!RenderInputRouterClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          RenderInputRouterClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!RenderInputRouterClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_WidgetInputHandlerPendingReceiver } request
   * @param { !blink_mojom_WidgetInputHandlerHostRemote } host
   * @param { !boolean } fromViz
   */

  getWidgetInputHandler(
      request,
      host,
      fromViz) {
    this.proxy.sendMessage(
        0,
        RenderInputRouterClient_GetWidgetInputHandler_ParamsSpec.$,
        null,
        [
          request,
          host,
          fromViz
        ],
        false);
  }

  
  /**
   * @param { !ui_mojom_MenuSourceType } sourceType
   * @param { !gfx_mojom_Point } location
   */

  showContextMenu(
      sourceType,
      location) {
    this.proxy.sendMessage(
        1,
        RenderInputRouterClient_ShowContextMenu_ParamsSpec.$,
        null,
        [
          sourceType,
          location
        ],
        false);
  }

  
  /**
   * @param { !viz_mojom_InputTargetClientPendingReceiver } host
   */

  bindInputTargetClient(
      host) {
    this.proxy.sendMessage(
        2,
        RenderInputRouterClient_BindInputTargetClient_ParamsSpec.$,
        null,
        [
          host
        ],
        false);
  }
}

/**
 * An object which receives request messages for the RenderInputRouterClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class RenderInputRouterClientReceiver {
  /**
   * @param {!RenderInputRouterClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!RenderInputRouterClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        RenderInputRouterClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RenderInputRouterClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        RenderInputRouterClient_GetWidgetInputHandler_ParamsSpec.$,
        null,
        impl.getWidgetInputHandler.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        RenderInputRouterClient_ShowContextMenu_ParamsSpec.$,
        null,
        impl.showContextMenu.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        RenderInputRouterClient_BindInputTargetClient_ParamsSpec.$,
        null,
        impl.bindInputTargetClient.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class RenderInputRouterClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.RenderInputRouterClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!RenderInputRouterClientRemote}
   */
  static getRemote() {
    let remote = new RenderInputRouterClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the RenderInputRouterClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class RenderInputRouterClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      RenderInputRouterClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!RenderInputRouterClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getWidgetInputHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        RenderInputRouterClient_GetWidgetInputHandler_ParamsSpec.$,
        null,
        this.getWidgetInputHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.showContextMenu =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        RenderInputRouterClient_ShowContextMenu_ParamsSpec.$,
        null,
        this.showContextMenu.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindInputTargetClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        RenderInputRouterClient_BindInputTargetClient_ParamsSpec.$,
        null,
        this.bindInputTargetClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetCompositor_VisualStateRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetCompositor_VisualStateRequest_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetHost_SetCursor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetHost_UpdateTooltipUnderCursor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetHost_UpdateTooltipFromKeyboard_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetHost_ClearKeyboardTriggeredTooltip_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetHost_TextInputStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetHost_SelectionBoundsChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetHost_CreateFrameSink_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WidgetHost_RegisterRenderFrameMetadataObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Widget_ForceRedraw_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Widget_ForceRedraw_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Widget_UpdateVisualProperties_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Widget_UpdateScreenRects_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Widget_UpdateScreenRects_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Widget_WasHidden_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Widget_WasShown_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Widget_RequestSuccessfulPresentationTimeForNextFrame_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Widget_CancelSuccessfulPresentationTimeRequest_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Widget_SetupBrowserRenderInputRouterConnections_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RenderInputRouterClient_GetWidgetInputHandler_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RenderInputRouterClient_ShowContextMenu_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const RenderInputRouterClient_BindInputTargetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    WidgetCompositor_VisualStateRequest_ParamsSpec.$,
    'WidgetCompositor_VisualStateRequest_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WidgetCompositor_VisualStateRequest_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WidgetCompositor_VisualStateRequest_ResponseParamsSpec.$,
    'WidgetCompositor_VisualStateRequest_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WidgetCompositor_VisualStateRequest_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    WidgetHost_SetCursor_ParamsSpec.$,
    'WidgetHost_SetCursor_Params',
    [
      mojo.internal.StructField(
        'cursor', 0,
        0,
        ui_mojom_CursorSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WidgetHost_SetCursor_Params {
  constructor() {
    /** @type { !ui_mojom_Cursor } */
    this.cursor;
  }
}



mojo.internal.Struct(
    WidgetHost_UpdateTooltipUnderCursor_ParamsSpec.$,
    'WidgetHost_UpdateTooltipUnderCursor_Params',
    [
      mojo.internal.StructField(
        'tooltipText', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'textDirectionHint', 8,
        0,
        mojoBase_mojom_TextDirectionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WidgetHost_UpdateTooltipUnderCursor_Params {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.tooltipText;
    /** @type { !mojoBase_mojom_TextDirection } */
    this.textDirectionHint;
  }
}



mojo.internal.Struct(
    WidgetHost_UpdateTooltipFromKeyboard_ParamsSpec.$,
    'WidgetHost_UpdateTooltipFromKeyboard_Params',
    [
      mojo.internal.StructField(
        'tooltipText', 0,
        0,
        mojoBase_mojom_String16Spec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'textDirectionHint', 8,
        0,
        mojoBase_mojom_TextDirectionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'bounds', 16,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class WidgetHost_UpdateTooltipFromKeyboard_Params {
  constructor() {
    /** @type { !mojoBase_mojom_String16 } */
    this.tooltipText;
    /** @type { !mojoBase_mojom_TextDirection } */
    this.textDirectionHint;
    /** @type { !gfx_mojom_Rect } */
    this.bounds;
  }
}



mojo.internal.Struct(
    WidgetHost_ClearKeyboardTriggeredTooltip_ParamsSpec.$,
    'WidgetHost_ClearKeyboardTriggeredTooltip_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class WidgetHost_ClearKeyboardTriggeredTooltip_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    WidgetHost_TextInputStateChanged_ParamsSpec.$,
    'WidgetHost_TextInputStateChanged_Params',
    [
      mojo.internal.StructField(
        'state', 0,
        0,
        ui_mojom_TextInputStateSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class WidgetHost_TextInputStateChanged_Params {
  constructor() {
    /** @type { !ui_mojom_TextInputState } */
    this.state;
  }
}



mojo.internal.Struct(
    WidgetHost_SelectionBoundsChanged_ParamsSpec.$,
    'WidgetHost_SelectionBoundsChanged_Params',
    [
      mojo.internal.StructField(
        'anchorRect', 0,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'anchorDir', 8,
        0,
        mojoBase_mojom_TextDirectionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'focusRect', 16,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'focusDir', 12,
        0,
        mojoBase_mojom_TextDirectionSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'boundingBoxRect', 24,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isAnchorFirst', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class WidgetHost_SelectionBoundsChanged_Params {
  constructor() {
    /** @type { !gfx_mojom_Rect } */
    this.anchorRect;
    /** @type { !mojoBase_mojom_TextDirection } */
    this.anchorDir;
    /** @type { !gfx_mojom_Rect } */
    this.focusRect;
    /** @type { !mojoBase_mojom_TextDirection } */
    this.focusDir;
    /** @type { !gfx_mojom_Rect } */
    this.boundingBoxRect;
    /** @type { !boolean } */
    this.isAnchorFirst;
  }
}



mojo.internal.Struct(
    WidgetHost_CreateFrameSink_ParamsSpec.$,
    'WidgetHost_CreateFrameSink_Params',
    [
      mojo.internal.StructField(
        'compositorFrameSinkReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(viz_mojom_CompositorFrameSinkPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'compositorFrameSinkClient', 4,
        0,
        mojo.internal.InterfaceProxy(viz_mojom_CompositorFrameSinkClientRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'renderInputRouterClient', 12,
        0,
        mojo.internal.InterfaceProxy(RenderInputRouterClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class WidgetHost_CreateFrameSink_Params {
  constructor() {
    /** @type { !viz_mojom_CompositorFrameSinkPendingReceiver } */
    this.compositorFrameSinkReceiver;
    /** @type { !viz_mojom_CompositorFrameSinkClientRemote } */
    this.compositorFrameSinkClient;
    /** @type { !RenderInputRouterClientRemote } */
    this.renderInputRouterClient;
  }
}



mojo.internal.Struct(
    WidgetHost_RegisterRenderFrameMetadataObserver_ParamsSpec.$,
    'WidgetHost_RegisterRenderFrameMetadataObserver_Params',
    [
      mojo.internal.StructField(
        'renderFrameMetadataObserverClientReceiver', 0,
        0,
        mojo.internal.InterfaceRequest(cc_mojom_RenderFrameMetadataObserverClientPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'renderFrameMetadataObserver', 4,
        0,
        mojo.internal.InterfaceProxy(cc_mojom_RenderFrameMetadataObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class WidgetHost_RegisterRenderFrameMetadataObserver_Params {
  constructor() {
    /** @type { !cc_mojom_RenderFrameMetadataObserverClientPendingReceiver } */
    this.renderFrameMetadataObserverClientReceiver;
    /** @type { !cc_mojom_RenderFrameMetadataObserverRemote } */
    this.renderFrameMetadataObserver;
  }
}



mojo.internal.Struct(
    Widget_ForceRedraw_ParamsSpec.$,
    'Widget_ForceRedraw_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Widget_ForceRedraw_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Widget_ForceRedraw_ResponseParamsSpec.$,
    'Widget_ForceRedraw_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Widget_ForceRedraw_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    Widget_UpdateVisualProperties_ParamsSpec.$,
    'Widget_UpdateVisualProperties_Params',
    [
      mojo.internal.StructField(
        'visualProperties', 0,
        0,
        blink_mojom_VisualPropertiesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Widget_UpdateVisualProperties_Params {
  constructor() {
    /** @type { !blink_mojom_VisualProperties } */
    this.visualProperties;
  }
}



mojo.internal.Struct(
    Widget_UpdateScreenRects_ParamsSpec.$,
    'Widget_UpdateScreenRects_Params',
    [
      mojo.internal.StructField(
        'widgetScreenRect', 0,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'windowScreenRect', 8,
        0,
        gfx_mojom_RectSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Widget_UpdateScreenRects_Params {
  constructor() {
    /** @type { !gfx_mojom_Rect } */
    this.widgetScreenRect;
    /** @type { !gfx_mojom_Rect } */
    this.windowScreenRect;
  }
}



mojo.internal.Struct(
    Widget_UpdateScreenRects_ResponseParamsSpec.$,
    'Widget_UpdateScreenRects_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Widget_UpdateScreenRects_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    Widget_WasHidden_ParamsSpec.$,
    'Widget_WasHidden_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Widget_WasHidden_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Widget_WasShown_ParamsSpec.$,
    'Widget_WasShown_Params',
    [
      mojo.internal.StructField(
        'wasEvicted', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'recordTabSwitchTimeRequest', 8,
        0,
        blink_mojom_RecordContentToVisibleTimeRequestSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Widget_WasShown_Params {
  constructor() {
    /** @type { !boolean } */
    this.wasEvicted;
    /** @type { (blink_mojom_RecordContentToVisibleTimeRequest|undefined) } */
    this.recordTabSwitchTimeRequest;
  }
}



mojo.internal.Struct(
    Widget_RequestSuccessfulPresentationTimeForNextFrame_ParamsSpec.$,
    'Widget_RequestSuccessfulPresentationTimeForNextFrame_Params',
    [
      mojo.internal.StructField(
        'visibleTimeRequest', 0,
        0,
        blink_mojom_RecordContentToVisibleTimeRequestSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Widget_RequestSuccessfulPresentationTimeForNextFrame_Params {
  constructor() {
    /** @type { !blink_mojom_RecordContentToVisibleTimeRequest } */
    this.visibleTimeRequest;
  }
}



mojo.internal.Struct(
    Widget_CancelSuccessfulPresentationTimeRequest_ParamsSpec.$,
    'Widget_CancelSuccessfulPresentationTimeRequest_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Widget_CancelSuccessfulPresentationTimeRequest_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Widget_SetupBrowserRenderInputRouterConnections_ParamsSpec.$,
    'Widget_SetupBrowserRenderInputRouterConnections_Params',
    [
      mojo.internal.StructField(
        'browserClient', 0,
        0,
        mojo.internal.InterfaceRequest(RenderInputRouterClientPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Widget_SetupBrowserRenderInputRouterConnections_Params {
  constructor() {
    /** @type { !RenderInputRouterClientPendingReceiver } */
    this.browserClient;
  }
}



mojo.internal.Struct(
    RenderInputRouterClient_GetWidgetInputHandler_ParamsSpec.$,
    'RenderInputRouterClient_GetWidgetInputHandler_Params',
    [
      mojo.internal.StructField(
        'request', 0,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_WidgetInputHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'host', 4,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_WidgetInputHandlerHostRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fromViz', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RenderInputRouterClient_GetWidgetInputHandler_Params {
  constructor() {
    /** @type { !blink_mojom_WidgetInputHandlerPendingReceiver } */
    this.request;
    /** @type { !blink_mojom_WidgetInputHandlerHostRemote } */
    this.host;
    /** @type { !boolean } */
    this.fromViz;
  }
}



mojo.internal.Struct(
    RenderInputRouterClient_ShowContextMenu_ParamsSpec.$,
    'RenderInputRouterClient_ShowContextMenu_Params',
    [
      mojo.internal.StructField(
        'sourceType', 0,
        0,
        ui_mojom_MenuSourceTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'location', 8,
        0,
        gfx_mojom_PointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class RenderInputRouterClient_ShowContextMenu_Params {
  constructor() {
    /** @type { !ui_mojom_MenuSourceType } */
    this.sourceType;
    /** @type { !gfx_mojom_Point } */
    this.location;
  }
}



mojo.internal.Struct(
    RenderInputRouterClient_BindInputTargetClient_ParamsSpec.$,
    'RenderInputRouterClient_BindInputTargetClient_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        mojo.internal.InterfaceRequest(viz_mojom_InputTargetClientPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class RenderInputRouterClient_BindInputTargetClient_Params {
  constructor() {
    /** @type { !viz_mojom_InputTargetClientPendingReceiver } */
    this.host;
  }
}

