// third_party/blink/public/mojom/webtransport/web_transport_connector.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  WebTransportHandshakeClientRemote as network_mojom_WebTransportHandshakeClientRemote,
  WebTransportHandshakeClientPendingReceiver as network_mojom_WebTransportHandshakeClientPendingReceiver,
  WebTransportCertificateFingerprint as network_mojom_WebTransportCertificateFingerprint,
  WebTransportCertificateFingerprintSpec as network_mojom_WebTransportCertificateFingerprintSpec
} from '../../../../../services/network/public/mojom/web_transport.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../../url/mojom/url.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class WebTransportConnectorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.WebTransportConnector', scope);
  }
}

/** @interface */
export class WebTransportConnectorInterface {
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !Array<!network_mojom_WebTransportCertificateFingerprint> } fingerprints
   * @param { !Array<!string> } applicationProtocols
   * @param { !network_mojom_WebTransportHandshakeClientRemote } client
   */

  connect(url, fingerprints, applicationProtocols, client) {}
}

/**
 * @implements { WebTransportConnectorInterface }
 */
export class WebTransportConnectorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!WebTransportConnectorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          WebTransportConnectorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!WebTransportConnectorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !Array<!network_mojom_WebTransportCertificateFingerprint> } fingerprints
   * @param { !Array<!string> } applicationProtocols
   * @param { !network_mojom_WebTransportHandshakeClientRemote } client
   */

  connect(
      url,
      fingerprints,
      applicationProtocols,
      client) {
    this.proxy.sendMessage(
        0,
        WebTransportConnector_Connect_ParamsSpec.$,
        null,
        [
          url,
          fingerprints,
          applicationProtocols,
          client
        ],
        false);
  }
}

/**
 * An object which receives request messages for the WebTransportConnector
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class WebTransportConnectorReceiver {
  /**
   * @param {!WebTransportConnectorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!WebTransportConnectorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        WebTransportConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebTransportConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        WebTransportConnector_Connect_ParamsSpec.$,
        null,
        impl.connect.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class WebTransportConnector {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.WebTransportConnector";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!WebTransportConnectorRemote}
   */
  static getRemote() {
    let remote = new WebTransportConnectorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the WebTransportConnector
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class WebTransportConnectorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      WebTransportConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!WebTransportConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        WebTransportConnector_Connect_ParamsSpec.$,
        null,
        this.connect.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const WebTransportConnector_Connect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    WebTransportConnector_Connect_ParamsSpec.$,
    'WebTransportConnector_Connect_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fingerprints', 8,
        0,
        mojo.internal.Array(network_mojom_WebTransportCertificateFingerprintSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'applicationProtocols', 16,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'client', 24,
        0,
        mojo.internal.InterfaceProxy(network_mojom_WebTransportHandshakeClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class WebTransportConnector_Connect_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !Array<!network_mojom_WebTransportCertificateFingerprint> } */
    this.fingerprints;
    /** @type { !Array<!string> } */
    this.applicationProtocols;
    /** @type { !network_mojom_WebTransportHandshakeClientRemote } */
    this.client;
  }
}

