// third_party/blink/public/mojom/websockets/websocket_connector.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/websockets/websocket_connector.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/websockets/websocket_connector.mojom-params-data.h"
#include "third_party/blink/public/mojom/websockets/websocket_connector.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/websockets/websocket_connector.mojom-import-headers.h"
#include "third_party/blink/public/mojom/websockets/websocket_connector.mojom-test-utils.h"


namespace blink::mojom {
// The declaration includes the definition on other builds.

WebSocketConnector::IPCStableHashFunction WebSocketConnector::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebSocketConnector>(message.name())) {
    case messages::WebSocketConnector::kConnect: {
      return &WebSocketConnector::Connect_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebSocketConnector::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebSocketConnector>(message.name())) {
      case messages::WebSocketConnector::kConnect:
            return "Receive blink::mojom::WebSocketConnector::Connect";
    }
  } else {
    switch (static_cast<messages::WebSocketConnector>(message.name())) {
      case messages::WebSocketConnector::kConnect:
            return "Receive reply blink::mojom::WebSocketConnector::Connect";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebSocketConnector::Connect_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4664720f;  // IPCStableHash for blink::mojom::WebSocketConnector::Connect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

WebSocketConnectorProxy::WebSocketConnectorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebSocketConnectorProxy::Connect(
    const ::GURL& in_url, const std::vector<std::string>& in_requested_protocols, const ::net::SiteForCookies& in_site_for_cookies, const std::optional<std::string>& in_user_agent, ::net::StorageAccessApiStatus in_storage_access_api_status, ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient> in_handshake_client, const std::optional<::base::UnguessableToken>& in_throttling_profile_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebSocketConnector::Connect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("url"), in_url,
                        "<value of type const ::GURL&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("requested_protocols"), in_requested_protocols,
                        "<value of type const std::vector<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("site_for_cookies"), in_site_for_cookies,
                        "<value of type const ::net::SiteForCookies&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_agent"), in_user_agent,
                        "<value of type const std::optional<std::string>&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("storage_access_api_status"), in_storage_access_api_status,
                        "<value of type ::net::StorageAccessApiStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handshake_client"), in_handshake_client,
                        "<value of type ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("throttling_profile_id"), in_throttling_profile_id,
                        "<value of type const std::optional<::base::UnguessableToken>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebSocketConnector::kConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebSocketConnector_Connect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->url)::BaseType> url_fragment(
          params.message());
  
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
    in_url,
    url_fragment);

  params->url.Set(
      url_fragment.is_null() ? nullptr : url_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->url.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null url in WebSocketConnector.Connect request");
  mojo::internal::MessageFragment<
      typename decltype(params->requested_protocols)::BaseType>
      requested_protocols_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& requested_protocols_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_requested_protocols,
    requested_protocols_fragment,
    &requested_protocols_validate_params);

  params->requested_protocols.Set(
      requested_protocols_fragment.is_null() ? nullptr : requested_protocols_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->requested_protocols.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null requested_protocols in WebSocketConnector.Connect request");
  mojo::internal::MessageFragment<
      typename decltype(params->site_for_cookies)::BaseType> site_for_cookies_fragment(
          params.message());
  
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
    in_site_for_cookies,
    site_for_cookies_fragment);

  params->site_for_cookies.Set(
      site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->site_for_cookies.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null site_for_cookies in WebSocketConnector.Connect request");
  mojo::internal::MessageFragment<
      typename decltype(params->user_agent)::BaseType> user_agent_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_user_agent,
    user_agent_fragment);

  params->user_agent.Set(
      user_agent_fragment.is_null() ? nullptr : user_agent_fragment.data());

  
  mojo::internal::Serialize<::network::mojom::StorageAccessApiStatus>(
    in_storage_access_api_status,
    &params->storage_access_api_status);

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::WebSocketHandshakeClientInterfaceBase>>(
    in_handshake_client,
    &params->handshake_client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handshake_client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handshake_client in WebSocketConnector.Connect request");
  mojo::internal::MessageFragment<
      typename decltype(params->throttling_profile_id)::BaseType> throttling_profile_id_fragment(
          params.message());
  
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
    in_throttling_profile_id,
    throttling_profile_id_fragment);

  params->throttling_profile_id.Set(
      throttling_profile_id_fragment.is_null() ? nullptr : throttling_profile_id_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSocketConnector::Name_);
  message.set_method_name("Connect");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool WebSocketConnectorStubDispatch::Accept(
    WebSocketConnector* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebSocketConnector>(message->header()->name)) {
    case messages::WebSocketConnector::kConnect: {
      DCHECK(message->is_serialized());
      internal::WebSocketConnector_Connect_Params_Data* params =
          reinterpret_cast<internal::WebSocketConnector_Connect_Params_Data*>(
              message->mutable_payload());
      

      // Validation for WebSocketConnector.0
      bool success = true;
      ::GURL p_url{};
      std::vector<std::string> p_requested_protocols{};
      ::net::SiteForCookies p_site_for_cookies{};
      std::optional<std::string> p_user_agent{};
      ::net::StorageAccessApiStatus p_storage_access_api_status{};
      ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient> p_handshake_client{};
      std::optional<::base::UnguessableToken> p_throttling_profile_id{};
      WebSocketConnector_Connect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadRequestedProtocols(&p_requested_protocols))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadUserAgent(&p_user_agent))
        success = false;
      if (success && !input_data_view.ReadStorageAccessApiStatus(&p_storage_access_api_status))
        success = false;
      if (success) {
        p_handshake_client =
            input_data_view.TakeHandshakeClient<decltype(p_handshake_client)>();
      }
      if (success && !input_data_view.ReadThrottlingProfileId(&p_throttling_profile_id))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSocketConnector::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Connect(        
        std::move(p_url), 
        std::move(p_requested_protocols), 
        std::move(p_site_for_cookies), 
        std::move(p_user_agent), 
        std::move(p_storage_access_api_status), 
        std::move(p_handshake_client), 
        std::move(p_throttling_profile_id));
      return true;
    }
  }
  return false;
}

// static
bool WebSocketConnectorStubDispatch::AcceptWithResponder(
    WebSocketConnector* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebSocketConnector>(message->header()->name)) {
    case messages::WebSocketConnector::kConnect: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebSocketConnectorValidationInfo[] = {
    { &internal::WebSocketConnector_Connect_Params_Data::Validate,
     nullptr /* no response */},
};

bool WebSocketConnectorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::WebSocketConnector::Name_,
    kWebSocketConnectorValidationInfo);
}



}  // blink::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void WebSocketConnectorInterceptorForTesting::Connect(const ::GURL& url, const std::vector<std::string>& requested_protocols, const ::net::SiteForCookies& site_for_cookies, const std::optional<std::string>& user_agent, ::net::StorageAccessApiStatus storage_access_api_status, ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient> handshake_client, const std::optional<::base::UnguessableToken>& throttling_profile_id) {
  GetForwardingInterface()->Connect(
    std::move(url)
    , 
    std::move(requested_protocols)
    , 
    std::move(site_for_cookies)
    , 
    std::move(user_agent)
    , 
    std::move(storage_access_api_status)
    , 
    std::move(handshake_client)
    , 
    std::move(throttling_profile_id)
    );
}
WebSocketConnectorAsyncWaiter::WebSocketConnectorAsyncWaiter(
    WebSocketConnector* proxy) : proxy_(proxy) {}

WebSocketConnectorAsyncWaiter::~WebSocketConnectorAsyncWaiter() = default;







}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif