// third_party/blink/public/mojom/webpreferences/web_preferences.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBPREFERENCES_WEB_PREFERENCES_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBPREFERENCES_WEB_PREFERENCES_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "third_party/blink/public/mojom/css/preferred_color_scheme.mojom-shared.h"
#include "third_party/blink/public/mojom/css/preferred_contrast.mojom-shared.h"
#include "third_party/blink/public/mojom/v8_cache_options.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::PointerType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::HoverType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::OutputDeviceUpdateAbilityType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::EditingBehavior, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::ImageAnimationPolicy, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::ViewportStyle, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::AutoplayPolicy, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::EffectiveConnectionType, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::WebPreferencesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::WebPreferencesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::WebPreferences_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::standard_font_family_map(input)) in_standard_font_family_map = Traits::standard_font_family_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->standard_font_family_map)::BaseType>
          standard_font_family_map_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& standard_font_family_map_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>, send_validation>(
        in_standard_font_family_map,
        standard_font_family_map_fragment,
        &standard_font_family_map_validate_params);

      fragment->standard_font_family_map.Set(
          standard_font_family_map_fragment.is_null() ? nullptr : standard_font_family_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->standard_font_family_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null standard_font_family_map in WebPreferences struct");

      decltype(Traits::fixed_font_family_map(input)) in_fixed_font_family_map = Traits::fixed_font_family_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->fixed_font_family_map)::BaseType>
          fixed_font_family_map_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& fixed_font_family_map_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>, send_validation>(
        in_fixed_font_family_map,
        fixed_font_family_map_fragment,
        &fixed_font_family_map_validate_params);

      fragment->fixed_font_family_map.Set(
          fixed_font_family_map_fragment.is_null() ? nullptr : fixed_font_family_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->fixed_font_family_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fixed_font_family_map in WebPreferences struct");

      decltype(Traits::serif_font_family_map(input)) in_serif_font_family_map = Traits::serif_font_family_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->serif_font_family_map)::BaseType>
          serif_font_family_map_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& serif_font_family_map_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>, send_validation>(
        in_serif_font_family_map,
        serif_font_family_map_fragment,
        &serif_font_family_map_validate_params);

      fragment->serif_font_family_map.Set(
          serif_font_family_map_fragment.is_null() ? nullptr : serif_font_family_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->serif_font_family_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null serif_font_family_map in WebPreferences struct");

      decltype(Traits::sans_serif_font_family_map(input)) in_sans_serif_font_family_map = Traits::sans_serif_font_family_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->sans_serif_font_family_map)::BaseType>
          sans_serif_font_family_map_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& sans_serif_font_family_map_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>, send_validation>(
        in_sans_serif_font_family_map,
        sans_serif_font_family_map_fragment,
        &sans_serif_font_family_map_validate_params);

      fragment->sans_serif_font_family_map.Set(
          sans_serif_font_family_map_fragment.is_null() ? nullptr : sans_serif_font_family_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->sans_serif_font_family_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null sans_serif_font_family_map in WebPreferences struct");

      decltype(Traits::cursive_font_family_map(input)) in_cursive_font_family_map = Traits::cursive_font_family_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->cursive_font_family_map)::BaseType>
          cursive_font_family_map_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& cursive_font_family_map_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>, send_validation>(
        in_cursive_font_family_map,
        cursive_font_family_map_fragment,
        &cursive_font_family_map_validate_params);

      fragment->cursive_font_family_map.Set(
          cursive_font_family_map_fragment.is_null() ? nullptr : cursive_font_family_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->cursive_font_family_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null cursive_font_family_map in WebPreferences struct");

      decltype(Traits::fantasy_font_family_map(input)) in_fantasy_font_family_map = Traits::fantasy_font_family_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->fantasy_font_family_map)::BaseType>
          fantasy_font_family_map_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& fantasy_font_family_map_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>, send_validation>(
        in_fantasy_font_family_map,
        fantasy_font_family_map_fragment,
        &fantasy_font_family_map_validate_params);

      fragment->fantasy_font_family_map.Set(
          fantasy_font_family_map_fragment.is_null() ? nullptr : fantasy_font_family_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->fantasy_font_family_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fantasy_font_family_map in WebPreferences struct");

      decltype(Traits::math_font_family_map(input)) in_math_font_family_map = Traits::math_font_family_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->math_font_family_map)::BaseType>
          math_font_family_map_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& math_font_family_map_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, ::mojo_base::mojom::String16DataView>, send_validation>(
        in_math_font_family_map,
        math_font_family_map_fragment,
        &math_font_family_map_validate_params);

      fragment->math_font_family_map.Set(
          math_font_family_map_fragment.is_null() ? nullptr : math_font_family_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->math_font_family_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null math_font_family_map in WebPreferences struct");

      fragment->default_font_size = Traits::default_font_size(input);

      fragment->default_fixed_font_size = Traits::default_fixed_font_size(input);

      fragment->minimum_font_size = Traits::minimum_font_size(input);

      fragment->minimum_logical_font_size = Traits::minimum_logical_font_size(input);

      decltype(Traits::default_encoding(input)) in_default_encoding = Traits::default_encoding(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->default_encoding)::BaseType> default_encoding_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_default_encoding,
        default_encoding_fragment);

      fragment->default_encoding.Set(
          default_encoding_fragment.is_null() ? nullptr : default_encoding_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->default_encoding.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null default_encoding in WebPreferences struct");

      fragment->always_show_context_menu_on_touch = Traits::always_show_context_menu_on_touch(input);

      fragment->context_menu_on_mouse_up = Traits::context_menu_on_mouse_up(input);

      fragment->javascript_enabled = Traits::javascript_enabled(input);

      fragment->web_security_enabled = Traits::web_security_enabled(input);

      fragment->loads_images_automatically = Traits::loads_images_automatically(input);

      fragment->images_enabled = Traits::images_enabled(input);

      fragment->plugins_enabled = Traits::plugins_enabled(input);

      fragment->dom_paste_enabled = Traits::dom_paste_enabled(input);

      fragment->shrinks_standalone_images_to_fit = Traits::shrinks_standalone_images_to_fit(input);

      fragment->text_areas_are_resizable = Traits::text_areas_are_resizable(input);

      fragment->allow_scripts_to_close_windows = Traits::allow_scripts_to_close_windows(input);

      fragment->remote_fonts_enabled = Traits::remote_fonts_enabled(input);

      fragment->javascript_can_access_clipboard = Traits::javascript_can_access_clipboard(input);

      fragment->dns_prefetching_enabled = Traits::dns_prefetching_enabled(input);

      fragment->data_saver_enabled = Traits::data_saver_enabled(input);

      fragment->local_storage_enabled = Traits::local_storage_enabled(input);

      fragment->tabs_to_links = Traits::tabs_to_links(input);

      fragment->disable_ipc_flooding_protection = Traits::disable_ipc_flooding_protection(input);

      fragment->hyperlink_auditing_enabled = Traits::hyperlink_auditing_enabled(input);

      fragment->allow_universal_access_from_file_urls = Traits::allow_universal_access_from_file_urls(input);

      fragment->allow_file_access_from_file_urls = Traits::allow_file_access_from_file_urls(input);

      fragment->webgl1_enabled = Traits::webgl1_enabled(input);

      fragment->webgl2_enabled = Traits::webgl2_enabled(input);

      fragment->privileged_webgl_extensions_enabled = Traits::privileged_webgl_extensions_enabled(input);

      fragment->webgl_errors_to_console_enabled = Traits::webgl_errors_to_console_enabled(input);

      fragment->hide_scrollbars = Traits::hide_scrollbars(input);

      fragment->prefers_default_scrollbar_styles = Traits::prefers_default_scrollbar_styles(input);

      fragment->accelerated_2d_canvas_enabled = Traits::accelerated_2d_canvas_enabled(input);

      fragment->canvas_2d_layers_enabled = Traits::canvas_2d_layers_enabled(input);

      fragment->antialiased_2d_canvas_disabled = Traits::antialiased_2d_canvas_disabled(input);

      fragment->antialiased_clips_2d_canvas_enabled = Traits::antialiased_clips_2d_canvas_enabled(input);

      fragment->accelerated_filters_enabled = Traits::accelerated_filters_enabled(input);

      fragment->deferred_filters_enabled = Traits::deferred_filters_enabled(input);

      fragment->container_culling_enabled = Traits::container_culling_enabled(input);

      fragment->allow_running_insecure_content = Traits::allow_running_insecure_content(input);

      fragment->disable_reading_from_canvas = Traits::disable_reading_from_canvas(input);

      fragment->strict_mixed_content_checking = Traits::strict_mixed_content_checking(input);

      fragment->strict_powerful_feature_restrictions = Traits::strict_powerful_feature_restrictions(input);

      fragment->allow_geolocation_on_insecure_origins = Traits::allow_geolocation_on_insecure_origins(input);

      fragment->strictly_block_blockable_mixed_content = Traits::strictly_block_blockable_mixed_content(input);

      fragment->block_mixed_plugin_content = Traits::block_mixed_plugin_content(input);

      fragment->password_echo_enabled = Traits::password_echo_enabled(input);

      fragment->should_clear_document_background = Traits::should_clear_document_background(input);

      fragment->enable_scroll_animator = Traits::enable_scroll_animator(input);

      fragment->prefers_reduced_motion = Traits::prefers_reduced_motion(input);

      fragment->prefers_reduced_transparency = Traits::prefers_reduced_transparency(input);

      fragment->inverted_colors = Traits::inverted_colors(input);

      fragment->touch_event_feature_detection_enabled = Traits::touch_event_feature_detection_enabled(input);

      fragment->pointer_events_max_touch_points = Traits::pointer_events_max_touch_points(input);

      fragment->available_pointer_types = Traits::available_pointer_types(input);

      
      mojo::internal::Serialize<::blink::mojom::PointerType>(
        Traits::primary_pointer_type(input),
        &fragment->primary_pointer_type);

      
      mojo::internal::Serialize<::blink::mojom::OutputDeviceUpdateAbilityType>(
        Traits::output_device_update_ability_type(input),
        &fragment->output_device_update_ability_type);

      fragment->available_hover_types = Traits::available_hover_types(input);

      
      mojo::internal::Serialize<::blink::mojom::HoverType>(
        Traits::primary_hover_type(input),
        &fragment->primary_hover_type);

      fragment->dont_send_key_events_to_javascript = Traits::dont_send_key_events_to_javascript(input);

      fragment->barrel_button_for_drag_enabled = Traits::barrel_button_for_drag_enabled(input);

      fragment->sync_xhr_in_documents_enabled = Traits::sync_xhr_in_documents_enabled(input);

      fragment->target_blank_implies_no_opener_enabled_will_be_removed = Traits::target_blank_implies_no_opener_enabled_will_be_removed(input);

      fragment->ignore_permission_for_device_changed_event = Traits::ignore_permission_for_device_changed_event(input);

      fragment->number_of_cpu_cores = Traits::number_of_cpu_cores(input);

      
      mojo::internal::Serialize<::blink::mojom::EditingBehavior>(
        Traits::editing_behavior(input),
        &fragment->editing_behavior);

      fragment->supports_multiple_windows = Traits::supports_multiple_windows(input);

      fragment->viewport_enabled = Traits::viewport_enabled(input);

      fragment->viewport_meta_enabled = Traits::viewport_meta_enabled(input);

      fragment->auto_zoom_focused_editable_to_legible_scale = Traits::auto_zoom_focused_editable_to_legible_scale(input);

      fragment->shrinks_viewport_contents_to_fit = Traits::shrinks_viewport_contents_to_fit(input);

      
      mojo::internal::Serialize<::blink::mojom::ViewportStyle>(
        Traits::viewport_style(input),
        &fragment->viewport_style);

      fragment->smooth_scroll_for_find_enabled = Traits::smooth_scroll_for_find_enabled(input);

      fragment->main_frame_resizes_are_orientation_changes = Traits::main_frame_resizes_are_orientation_changes(input);

      fragment->initialize_at_minimum_page_scale = Traits::initialize_at_minimum_page_scale(input);

      fragment->smart_insert_delete_enabled = Traits::smart_insert_delete_enabled(input);

      fragment->spatial_navigation_enabled = Traits::spatial_navigation_enabled(input);

      
      mojo::internal::Serialize<::blink::mojom::V8CacheOptions>(
        Traits::v8_cache_options(input),
        &fragment->v8_cache_options);

      fragment->record_whole_document = Traits::record_whole_document(input);

      fragment->stylus_handwriting_enabled = Traits::stylus_handwriting_enabled(input);

      fragment->cookie_enabled = Traits::cookie_enabled(input);

      fragment->accelerated_video_decode_enabled = Traits::accelerated_video_decode_enabled(input);

      
      mojo::internal::Serialize<::blink::mojom::ImageAnimationPolicy>(
        Traits::animation_policy(input),
        &fragment->animation_policy);

      fragment->user_gesture_required_for_presentation = Traits::user_gesture_required_for_presentation(input);

      fragment->text_tracks_enabled = Traits::text_tracks_enabled(input);

      decltype(Traits::text_track_background_color(input)) in_text_track_background_color = Traits::text_track_background_color(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text_track_background_color)::BaseType> text_track_background_color_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text_track_background_color,
        text_track_background_color_fragment);

      fragment->text_track_background_color.Set(
          text_track_background_color_fragment.is_null() ? nullptr : text_track_background_color_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text_track_background_color.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_background_color in WebPreferences struct");

      decltype(Traits::text_track_text_color(input)) in_text_track_text_color = Traits::text_track_text_color(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text_track_text_color)::BaseType> text_track_text_color_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text_track_text_color,
        text_track_text_color_fragment);

      fragment->text_track_text_color.Set(
          text_track_text_color_fragment.is_null() ? nullptr : text_track_text_color_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text_track_text_color.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_text_color in WebPreferences struct");

      decltype(Traits::text_track_text_size(input)) in_text_track_text_size = Traits::text_track_text_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text_track_text_size)::BaseType> text_track_text_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text_track_text_size,
        text_track_text_size_fragment);

      fragment->text_track_text_size.Set(
          text_track_text_size_fragment.is_null() ? nullptr : text_track_text_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text_track_text_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_text_size in WebPreferences struct");

      decltype(Traits::text_track_text_shadow(input)) in_text_track_text_shadow = Traits::text_track_text_shadow(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text_track_text_shadow)::BaseType> text_track_text_shadow_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text_track_text_shadow,
        text_track_text_shadow_fragment);

      fragment->text_track_text_shadow.Set(
          text_track_text_shadow_fragment.is_null() ? nullptr : text_track_text_shadow_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text_track_text_shadow.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_text_shadow in WebPreferences struct");

      decltype(Traits::text_track_font_family(input)) in_text_track_font_family = Traits::text_track_font_family(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text_track_font_family)::BaseType> text_track_font_family_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text_track_font_family,
        text_track_font_family_fragment);

      fragment->text_track_font_family.Set(
          text_track_font_family_fragment.is_null() ? nullptr : text_track_font_family_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text_track_font_family.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_font_family in WebPreferences struct");

      decltype(Traits::text_track_font_style(input)) in_text_track_font_style = Traits::text_track_font_style(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text_track_font_style)::BaseType> text_track_font_style_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text_track_font_style,
        text_track_font_style_fragment);

      fragment->text_track_font_style.Set(
          text_track_font_style_fragment.is_null() ? nullptr : text_track_font_style_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text_track_font_style.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_font_style in WebPreferences struct");

      decltype(Traits::text_track_font_variant(input)) in_text_track_font_variant = Traits::text_track_font_variant(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text_track_font_variant)::BaseType> text_track_font_variant_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text_track_font_variant,
        text_track_font_variant_fragment);

      fragment->text_track_font_variant.Set(
          text_track_font_variant_fragment.is_null() ? nullptr : text_track_font_variant_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text_track_font_variant.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_font_variant in WebPreferences struct");

      decltype(Traits::text_track_window_color(input)) in_text_track_window_color = Traits::text_track_window_color(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text_track_window_color)::BaseType> text_track_window_color_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text_track_window_color,
        text_track_window_color_fragment);

      fragment->text_track_window_color.Set(
          text_track_window_color_fragment.is_null() ? nullptr : text_track_window_color_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text_track_window_color.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_window_color in WebPreferences struct");

      decltype(Traits::text_track_window_radius(input)) in_text_track_window_radius = Traits::text_track_window_radius(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->text_track_window_radius)::BaseType> text_track_window_radius_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_text_track_window_radius,
        text_track_window_radius_fragment);

      fragment->text_track_window_radius.Set(
          text_track_window_radius_fragment.is_null() ? nullptr : text_track_window_radius_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->text_track_window_radius.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null text_track_window_radius in WebPreferences struct");

      fragment->text_track_margin_percentage = Traits::text_track_margin_percentage(input);

      fragment->immersive_mode_enabled = Traits::immersive_mode_enabled(input);

      fragment->double_tap_to_zoom_enabled = Traits::double_tap_to_zoom_enabled(input);

      fragment->fullscreen_supported = Traits::fullscreen_supported(input);

      fragment->text_autosizing_enabled = Traits::text_autosizing_enabled(input);

      decltype(Traits::web_app_scope(input)) in_web_app_scope = Traits::web_app_scope(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->web_app_scope)::BaseType> web_app_scope_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_web_app_scope,
        web_app_scope_fragment);

      fragment->web_app_scope.Set(
          web_app_scope_fragment.is_null() ? nullptr : web_app_scope_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->web_app_scope.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null web_app_scope in WebPreferences struct");

      fragment->force_dark_mode_enabled = Traits::force_dark_mode_enabled(input);

      fragment->default_minimum_page_scale_factor = Traits::default_minimum_page_scale_factor(input);

      fragment->default_maximum_page_scale_factor = Traits::default_maximum_page_scale_factor(input);

      fragment->hide_download_ui = Traits::hide_download_ui(input);

      fragment->presentation_receiver = Traits::presentation_receiver(input);

      fragment->media_controls_enabled = Traits::media_controls_enabled(input);

      fragment->do_not_update_selection_on_mutating_selection_range = Traits::do_not_update_selection_on_mutating_selection_range(input);

      
      mojo::internal::Serialize<::blink::mojom::AutoplayPolicy>(
        Traits::autoplay_policy(input),
        &fragment->autoplay_policy);

      fragment->require_transient_activation_for_get_display_media = Traits::require_transient_activation_for_get_display_media(input);

      fragment->require_transient_activation_for_show_file_or_directory_picker = Traits::require_transient_activation_for_show_file_or_directory_picker(input);

      fragment->require_transient_activation_and_user_confirmation_for_subapps_api = Traits::require_transient_activation_and_user_confirmation_for_subapps_api(input);

      fragment->in_forced_colors = Traits::in_forced_colors(input);

      fragment->is_forced_colors_disabled = Traits::is_forced_colors_disabled(input);

      decltype(Traits::root_scrollbar_theme_color(input)) in_root_scrollbar_theme_color = Traits::root_scrollbar_theme_color(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->root_scrollbar_theme_color)::BaseType> root_scrollbar_theme_color_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::SkColorDataView, send_validation>(
        in_root_scrollbar_theme_color,
        root_scrollbar_theme_color_fragment);

      fragment->root_scrollbar_theme_color.Set(
          root_scrollbar_theme_color_fragment.is_null() ? nullptr : root_scrollbar_theme_color_fragment.data());

      
      mojo::internal::Serialize<::blink::mojom::PreferredColorScheme>(
        Traits::preferred_root_scrollbar_color_scheme(input),
        &fragment->preferred_root_scrollbar_color_scheme);

      
      mojo::internal::Serialize<::blink::mojom::PreferredColorScheme>(
        Traits::preferred_color_scheme(input),
        &fragment->preferred_color_scheme);

      
      mojo::internal::Serialize<::blink::mojom::PreferredContrast>(
        Traits::preferred_contrast(input),
        &fragment->preferred_contrast);

      
      mojo::internal::Serialize<::blink::mojom::EffectiveConnectionType>(
        Traits::low_priority_iframes_threshold(input),
        &fragment->low_priority_iframes_threshold);

      fragment->picture_in_picture_enabled = Traits::picture_in_picture_enabled(input);

      fragment->translate_service_available = Traits::translate_service_available(input);

      
      mojo::internal::Serialize<::blink::mojom::EffectiveConnectionType>(
        Traits::network_quality_estimator_web_holdback(input),
        &fragment->network_quality_estimator_web_holdback);

      fragment->lazy_load_enabled = Traits::lazy_load_enabled(input);

      fragment->allow_mixed_content_upgrades = Traits::allow_mixed_content_upgrades(input);

      fragment->always_show_focus = Traits::always_show_focus(input);

      fragment->touch_drag_drop_enabled = Traits::touch_drag_drop_enabled(input);

      fragment->touch_dragend_context_menu = Traits::touch_dragend_context_menu(input);

      fragment->webxr_immersive_ar_allowed = Traits::webxr_immersive_ar_allowed(input);

      fragment->renderer_wide_named_frame_lookup = Traits::renderer_wide_named_frame_lookup(input);

      fragment->strict_mime_type_check_for_worker_scripts_enabled = Traits::strict_mime_type_check_for_worker_scripts_enabled(input);

      fragment->modal_context_menu = Traits::modal_context_menu(input);

      fragment->payment_request_enabled = Traits::payment_request_enabled(input);

      fragment->content_based_fingerprinting_protection_enabled = Traits::content_based_fingerprinting_protection_enabled(input);

      fragment->ai_prompt_api_enabled = Traits::ai_prompt_api_enabled(input);

      fragment->should_disable_external_popups = Traits::should_disable_external_popups(input);
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBPREFERENCES_WEB_PREFERENCES_MOJOM_SEND_VALIDATION_H_