// third_party/blink/public/mojom/webid/federated_auth_request.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/webid/federated_auth_request.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/values.mojom-blink.h"
#include "third_party/blink/public/mojom/credentialmanagement/credential_manager.mojom-blink-forward.h"
#include "url/mojom/origin.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class FederatedAuthRequestProxy;

template <typename ImplRefTraits>
class FederatedAuthRequestStub;

class FederatedAuthRequestRequestValidator;
class FederatedAuthRequestResponseValidator;


class PLATFORM_EXPORT FederatedAuthRequest
    : public FederatedAuthRequestInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.FederatedAuthRequest";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FederatedAuthRequestInterfaceBase;
  using Proxy_ = FederatedAuthRequestProxy;

  template <typename ImplRefTraits>
  using Stub_ = FederatedAuthRequestStub<ImplRefTraits>;

  using RequestValidator_ = FederatedAuthRequestRequestValidator;
  using ResponseValidator_ = FederatedAuthRequestResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestTokenMinVersion = 0,
    kRequestUserInfoMinVersion = 0,
    kCancelTokenRequestMinVersion = 0,
    kResolveTokenRequestMinVersion = 0,
    kSetIdpSigninStatusMinVersion = 0,
    kRegisterIdPMinVersion = 0,
    kUnregisterIdPMinVersion = 0,
    kCloseModalDialogViewMinVersion = 0,
    kPreventSilentAccessMinVersion = 0,
    kDisconnectMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestToken_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RequestUserInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CancelTokenRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ResolveTokenRequest_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIdpSigninStatus_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RegisterIdP_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UnregisterIdP_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CloseModalDialogView_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PreventSilentAccess_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Disconnect_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FederatedAuthRequest() = default;

  using RequestTokenCallback = base::OnceCallback<void(RequestTokenStatus, const std::optional<::blink::KURL>&, std::optional<::base::Value>, TokenErrorPtr, bool)>;
  using RequestTokenMojoCallback = base::OnceCallback<void(RequestTokenStatus, const std::optional<::blink::KURL>&, std::optional<::base::Value>, TokenErrorPtr, bool)>;

  virtual void RequestToken(::blink::Vector<IdentityProviderGetParametersPtr> idp_get_params, ::blink::mojom::blink::CredentialMediationRequirement requirement, RequestTokenCallback callback) = 0;

  using RequestUserInfoCallback = base::OnceCallback<void(RequestUserInfoStatus, std::optional<::blink::Vector<IdentityUserInfoPtr>>)>;
  using RequestUserInfoMojoCallback = base::OnceCallback<void(RequestUserInfoStatus, std::optional<::blink::Vector<IdentityUserInfoPtr>>)>;

  virtual void RequestUserInfo(IdentityProviderConfigPtr provider, RequestUserInfoCallback callback) = 0;

  virtual void CancelTokenRequest() = 0;

  using ResolveTokenRequestCallback = base::OnceCallback<void(bool)>;
  using ResolveTokenRequestMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ResolveTokenRequest(const ::blink::String& account_id, ::base::Value token, ResolveTokenRequestCallback callback) = 0;

  using SetIdpSigninStatusCallback = base::OnceCallback<void()>;
  using SetIdpSigninStatusMojoCallback = base::OnceCallback<void()>;

  virtual void SetIdpSigninStatus(const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, IdpSigninStatus status, LoginStatusOptionsPtr options, SetIdpSigninStatusCallback callback) = 0;

  using RegisterIdPCallback = base::OnceCallback<void(RegisterIdpStatus)>;
  using RegisterIdPMojoCallback = base::OnceCallback<void(RegisterIdpStatus)>;

  virtual void RegisterIdP(const ::blink::KURL& url, RegisterIdPCallback callback) = 0;

  using UnregisterIdPCallback = base::OnceCallback<void(bool)>;
  using UnregisterIdPMojoCallback = base::OnceCallback<void(bool)>;

  virtual void UnregisterIdP(const ::blink::KURL& url, UnregisterIdPCallback callback) = 0;

  virtual void CloseModalDialogView() = 0;

  using PreventSilentAccessCallback = base::OnceCallback<void()>;
  using PreventSilentAccessMojoCallback = base::OnceCallback<void()>;

  virtual void PreventSilentAccess(PreventSilentAccessCallback callback) = 0;

  using DisconnectCallback = base::OnceCallback<void(DisconnectStatus)>;
  using DisconnectMojoCallback = base::OnceCallback<void(DisconnectStatus)>;

  virtual void Disconnect(IdentityCredentialDisconnectOptionsPtr options, DisconnectCallback callback) = 0;
};



class PLATFORM_EXPORT FederatedAuthRequestProxy
    : public FederatedAuthRequest {
 public:
  using InterfaceType = FederatedAuthRequest;

  explicit FederatedAuthRequestProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestToken(::blink::Vector<IdentityProviderGetParametersPtr> idp_get_params, ::blink::mojom::blink::CredentialMediationRequirement requirement, RequestTokenCallback callback) final;
  
  void RequestUserInfo(IdentityProviderConfigPtr provider, RequestUserInfoCallback callback) final;
  
  void CancelTokenRequest() final;
  
  void ResolveTokenRequest(const ::blink::String& account_id, ::base::Value token, ResolveTokenRequestCallback callback) final;
  
  void SetIdpSigninStatus(const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, IdpSigninStatus status, LoginStatusOptionsPtr options, SetIdpSigninStatusCallback callback) final;
  
  void RegisterIdP(const ::blink::KURL& url, RegisterIdPCallback callback) final;
  
  void UnregisterIdP(const ::blink::KURL& url, UnregisterIdPCallback callback) final;
  
  void CloseModalDialogView() final;
  
  void PreventSilentAccess(PreventSilentAccessCallback callback) final;
  
  void Disconnect(IdentityCredentialDisconnectOptionsPtr options, DisconnectCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT FederatedAuthRequestStubDispatch {
 public:
  static bool Accept(FederatedAuthRequest* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FederatedAuthRequest* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FederatedAuthRequest>>
class FederatedAuthRequestStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FederatedAuthRequestStub() = default;
  ~FederatedAuthRequestStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FederatedAuthRequestStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FederatedAuthRequestStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT FederatedAuthRequestRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class PLATFORM_EXPORT FederatedAuthRequestResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class PLATFORM_EXPORT IdentityUserInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IdentityUserInfo, T>::value>;
  using DataView = IdentityUserInfoDataView;
  using Data_ = internal::IdentityUserInfo_Data;

  template <typename... Args>
  static IdentityUserInfoPtr New(Args&&... args) {
    return IdentityUserInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IdentityUserInfoPtr From(const U& u) {
    return mojo::TypeConverter<IdentityUserInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IdentityUserInfo>::Convert(*this);
  }


  IdentityUserInfo();

  IdentityUserInfo(
      const ::blink::String& email,
      const ::blink::String& given_name,
      const ::blink::String& name,
      const ::blink::String& picture);


  ~IdentityUserInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IdentityUserInfoPtr>
  IdentityUserInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IdentityUserInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IdentityUserInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IdentityUserInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdentityUserInfo::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdentityUserInfo::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IdentityUserInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IdentityUserInfo_UnserializedMessageContext<
            UserType, IdentityUserInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IdentityUserInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IdentityUserInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IdentityUserInfo_UnserializedMessageContext<
            UserType, IdentityUserInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IdentityUserInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String email;
  
  ::blink::String given_name;
  
  ::blink::String name;
  
  ::blink::String picture;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IdentityUserInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IdentityUserInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IdentityUserInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IdentityUserInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class PLATFORM_EXPORT TokenError {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TokenError, T>::value>;
  using DataView = TokenErrorDataView;
  using Data_ = internal::TokenError_Data;

  template <typename... Args>
  static TokenErrorPtr New(Args&&... args) {
    return TokenErrorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TokenErrorPtr From(const U& u) {
    return mojo::TypeConverter<TokenErrorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TokenError>::Convert(*this);
  }


  TokenError();

  TokenError(
      const ::blink::String& code,
      const ::blink::String& url);


  ~TokenError();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TokenErrorPtr>
  TokenErrorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TokenError::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, TokenError::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, TokenError::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TokenError::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TokenError::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TokenError::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TokenError_UnserializedMessageContext<
            UserType, TokenError::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<TokenError::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return TokenError::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TokenError_UnserializedMessageContext<
            UserType, TokenError::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TokenError::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String code;
  
  ::blink::String url;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TokenError::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TokenError::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TokenError::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TokenError::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class PLATFORM_EXPORT IdentityProviderConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IdentityProviderConfig, T>::value>;
  using DataView = IdentityProviderConfigDataView;
  using Data_ = internal::IdentityProviderConfig_Data;

  template <typename... Args>
  static IdentityProviderConfigPtr New(Args&&... args) {
    return IdentityProviderConfigPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IdentityProviderConfigPtr From(const U& u) {
    return mojo::TypeConverter<IdentityProviderConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IdentityProviderConfig>::Convert(*this);
  }


  IdentityProviderConfig();

  IdentityProviderConfig(
      const ::blink::KURL& config_url,
      bool from_idp_registration_api,
      const ::blink::String& type,
      const ::blink::String& client_id);


  ~IdentityProviderConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IdentityProviderConfigPtr>
  IdentityProviderConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IdentityProviderConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IdentityProviderConfig::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IdentityProviderConfig::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdentityProviderConfig::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdentityProviderConfig::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IdentityProviderConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IdentityProviderConfig_UnserializedMessageContext<
            UserType, IdentityProviderConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IdentityProviderConfig::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IdentityProviderConfig::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IdentityProviderConfig_UnserializedMessageContext<
            UserType, IdentityProviderConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IdentityProviderConfig::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL config_url;
  
  bool from_idp_registration_api;
  
  ::blink::String type;
  
  ::blink::String client_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IdentityProviderConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IdentityProviderConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IdentityProviderConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IdentityProviderConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT IdentityProviderRequestOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IdentityProviderRequestOptions, T>::value>;
  using DataView = IdentityProviderRequestOptionsDataView;
  using Data_ = internal::IdentityProviderRequestOptions_Data;

  template <typename... Args>
  static IdentityProviderRequestOptionsPtr New(Args&&... args) {
    return IdentityProviderRequestOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IdentityProviderRequestOptionsPtr From(const U& u) {
    return mojo::TypeConverter<IdentityProviderRequestOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IdentityProviderRequestOptions>::Convert(*this);
  }


  IdentityProviderRequestOptions();

  IdentityProviderRequestOptions(
      IdentityProviderConfigPtr config,
      const ::blink::String& nonce,
      const ::blink::String& login_hint,
      const ::blink::String& domain_hint,
      std::optional<::blink::Vector<::blink::String>> fields,
      const ::blink::String& params_json,
      std::optional<Format> format);

IdentityProviderRequestOptions(const IdentityProviderRequestOptions&) = delete;
IdentityProviderRequestOptions& operator=(const IdentityProviderRequestOptions&) = delete;

  ~IdentityProviderRequestOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IdentityProviderRequestOptionsPtr>
  IdentityProviderRequestOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IdentityProviderRequestOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IdentityProviderRequestOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IdentityProviderRequestOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdentityProviderRequestOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdentityProviderRequestOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IdentityProviderRequestOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IdentityProviderRequestOptions_UnserializedMessageContext<
            UserType, IdentityProviderRequestOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IdentityProviderRequestOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IdentityProviderRequestOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IdentityProviderRequestOptions_UnserializedMessageContext<
            UserType, IdentityProviderRequestOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IdentityProviderRequestOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  IdentityProviderConfigPtr config;
  
  ::blink::String nonce;
  
  ::blink::String login_hint;
  
  ::blink::String domain_hint;
  
  std::optional<::blink::Vector<::blink::String>> fields;
  
  ::blink::String params_json;
  
  std::optional<Format> format;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IdentityProviderRequestOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IdentityProviderRequestOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IdentityProviderRequestOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IdentityProviderRequestOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT IdentityCredentialDisconnectOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IdentityCredentialDisconnectOptions, T>::value>;
  using DataView = IdentityCredentialDisconnectOptionsDataView;
  using Data_ = internal::IdentityCredentialDisconnectOptions_Data;

  template <typename... Args>
  static IdentityCredentialDisconnectOptionsPtr New(Args&&... args) {
    return IdentityCredentialDisconnectOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IdentityCredentialDisconnectOptionsPtr From(const U& u) {
    return mojo::TypeConverter<IdentityCredentialDisconnectOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IdentityCredentialDisconnectOptions>::Convert(*this);
  }


  IdentityCredentialDisconnectOptions();

  IdentityCredentialDisconnectOptions(
      IdentityProviderConfigPtr config,
      const ::blink::String& account_hint);

IdentityCredentialDisconnectOptions(const IdentityCredentialDisconnectOptions&) = delete;
IdentityCredentialDisconnectOptions& operator=(const IdentityCredentialDisconnectOptions&) = delete;

  ~IdentityCredentialDisconnectOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IdentityCredentialDisconnectOptionsPtr>
  IdentityCredentialDisconnectOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IdentityCredentialDisconnectOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IdentityCredentialDisconnectOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IdentityCredentialDisconnectOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdentityCredentialDisconnectOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdentityCredentialDisconnectOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IdentityCredentialDisconnectOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IdentityCredentialDisconnectOptions_UnserializedMessageContext<
            UserType, IdentityCredentialDisconnectOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IdentityCredentialDisconnectOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IdentityCredentialDisconnectOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IdentityCredentialDisconnectOptions_UnserializedMessageContext<
            UserType, IdentityCredentialDisconnectOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IdentityCredentialDisconnectOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  IdentityProviderConfigPtr config;
  
  ::blink::String account_hint;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IdentityCredentialDisconnectOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IdentityCredentialDisconnectOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IdentityCredentialDisconnectOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IdentityCredentialDisconnectOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class PLATFORM_EXPORT LoginStatusAccount {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LoginStatusAccount, T>::value>;
  using DataView = LoginStatusAccountDataView;
  using Data_ = internal::LoginStatusAccount_Data;

  template <typename... Args>
  static LoginStatusAccountPtr New(Args&&... args) {
    return LoginStatusAccountPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LoginStatusAccountPtr From(const U& u) {
    return mojo::TypeConverter<LoginStatusAccountPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LoginStatusAccount>::Convert(*this);
  }


  LoginStatusAccount();

  LoginStatusAccount(
      const ::blink::String& id,
      const ::blink::String& email,
      const ::blink::String& name,
      const ::blink::String& given_name,
      const std::optional<::blink::KURL>& picture);


  ~LoginStatusAccount();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LoginStatusAccountPtr>
  LoginStatusAccountPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LoginStatusAccount::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LoginStatusAccount::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LoginStatusAccount::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoginStatusAccount::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoginStatusAccount::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LoginStatusAccount::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LoginStatusAccount_UnserializedMessageContext<
            UserType, LoginStatusAccount::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LoginStatusAccount::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LoginStatusAccount::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LoginStatusAccount_UnserializedMessageContext<
            UserType, LoginStatusAccount::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LoginStatusAccount::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String id;
  
  ::blink::String email;
  
  ::blink::String name;
  
  ::blink::String given_name;
  
  std::optional<::blink::KURL> picture;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LoginStatusAccount::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LoginStatusAccount::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LoginStatusAccount::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LoginStatusAccount::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT LoginStatusOptions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LoginStatusOptions, T>::value>;
  using DataView = LoginStatusOptionsDataView;
  using Data_ = internal::LoginStatusOptions_Data;

  template <typename... Args>
  static LoginStatusOptionsPtr New(Args&&... args) {
    return LoginStatusOptionsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LoginStatusOptionsPtr From(const U& u) {
    return mojo::TypeConverter<LoginStatusOptionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LoginStatusOptions>::Convert(*this);
  }


  LoginStatusOptions();

  LoginStatusOptions(
      ::blink::Vector<LoginStatusAccountPtr> accounts,
      std::optional<::base::TimeDelta> expiration);

LoginStatusOptions(const LoginStatusOptions&) = delete;
LoginStatusOptions& operator=(const LoginStatusOptions&) = delete;

  ~LoginStatusOptions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LoginStatusOptionsPtr>
  LoginStatusOptionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LoginStatusOptions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, LoginStatusOptions::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, LoginStatusOptions::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoginStatusOptions::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LoginStatusOptions::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LoginStatusOptions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LoginStatusOptions_UnserializedMessageContext<
            UserType, LoginStatusOptions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<LoginStatusOptions::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return LoginStatusOptions::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LoginStatusOptions_UnserializedMessageContext<
            UserType, LoginStatusOptions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LoginStatusOptions::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<LoginStatusAccountPtr> accounts;
  
  std::optional<::base::TimeDelta> expiration;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LoginStatusOptions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LoginStatusOptions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LoginStatusOptions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LoginStatusOptions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT IdentityProviderGetParameters {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IdentityProviderGetParameters, T>::value>;
  using DataView = IdentityProviderGetParametersDataView;
  using Data_ = internal::IdentityProviderGetParameters_Data;

  template <typename... Args>
  static IdentityProviderGetParametersPtr New(Args&&... args) {
    return IdentityProviderGetParametersPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IdentityProviderGetParametersPtr From(const U& u) {
    return mojo::TypeConverter<IdentityProviderGetParametersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IdentityProviderGetParameters>::Convert(*this);
  }


  IdentityProviderGetParameters();

  IdentityProviderGetParameters(
      ::blink::Vector<IdentityProviderRequestOptionsPtr> providers,
      RpContext context,
      RpMode mode);

IdentityProviderGetParameters(const IdentityProviderGetParameters&) = delete;
IdentityProviderGetParameters& operator=(const IdentityProviderGetParameters&) = delete;

  ~IdentityProviderGetParameters();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IdentityProviderGetParametersPtr>
  IdentityProviderGetParametersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IdentityProviderGetParameters::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IdentityProviderGetParameters::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IdentityProviderGetParameters::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdentityProviderGetParameters::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IdentityProviderGetParameters::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IdentityProviderGetParameters::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IdentityProviderGetParameters_UnserializedMessageContext<
            UserType, IdentityProviderGetParameters::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IdentityProviderGetParameters::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IdentityProviderGetParameters::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IdentityProviderGetParameters_UnserializedMessageContext<
            UserType, IdentityProviderGetParameters::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IdentityProviderGetParameters::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<IdentityProviderRequestOptionsPtr> providers;
  
  RpContext context;
  
  RpMode mode;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IdentityProviderGetParameters::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IdentityProviderGetParameters::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IdentityProviderGetParameters::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IdentityProviderGetParameters::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
IdentityProviderConfigPtr IdentityProviderConfig::Clone() const {
  return New(
      mojo::Clone(config_url),
      mojo::Clone(from_idp_registration_api),
      mojo::Clone(type),
      mojo::Clone(client_id)
  );
}

template <typename T, IdentityProviderConfig::EnableIfSame<T>*>
bool IdentityProviderConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->config_url, other_struct.config_url))
    return false;
  if (!mojo::Equals(this->from_idp_registration_api, other_struct.from_idp_registration_api))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->client_id, other_struct.client_id))
    return false;
  return true;
}

template <typename T, IdentityProviderConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.config_url < rhs.config_url)
    return true;
  if (rhs.config_url < lhs.config_url)
    return false;
  if (lhs.from_idp_registration_api < rhs.from_idp_registration_api)
    return true;
  if (rhs.from_idp_registration_api < lhs.from_idp_registration_api)
    return false;
  if (lhs.type < rhs.type)
    return true;
  if (rhs.type < lhs.type)
    return false;
  if (lhs.client_id < rhs.client_id)
    return true;
  if (rhs.client_id < lhs.client_id)
    return false;
  return false;
}
template <typename StructPtrType>
IdentityProviderRequestOptionsPtr IdentityProviderRequestOptions::Clone() const {
  return New(
      mojo::Clone(config),
      mojo::Clone(nonce),
      mojo::Clone(login_hint),
      mojo::Clone(domain_hint),
      mojo::Clone(fields),
      mojo::Clone(params_json),
      mojo::Clone(format)
  );
}

template <typename T, IdentityProviderRequestOptions::EnableIfSame<T>*>
bool IdentityProviderRequestOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->config, other_struct.config))
    return false;
  if (!mojo::Equals(this->nonce, other_struct.nonce))
    return false;
  if (!mojo::Equals(this->login_hint, other_struct.login_hint))
    return false;
  if (!mojo::Equals(this->domain_hint, other_struct.domain_hint))
    return false;
  if (!mojo::Equals(this->fields, other_struct.fields))
    return false;
  if (!mojo::Equals(this->params_json, other_struct.params_json))
    return false;
  if (!mojo::Equals(this->format, other_struct.format))
    return false;
  return true;
}

template <typename T, IdentityProviderRequestOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.config < rhs.config)
    return true;
  if (rhs.config < lhs.config)
    return false;
  if (lhs.nonce < rhs.nonce)
    return true;
  if (rhs.nonce < lhs.nonce)
    return false;
  if (lhs.login_hint < rhs.login_hint)
    return true;
  if (rhs.login_hint < lhs.login_hint)
    return false;
  if (lhs.domain_hint < rhs.domain_hint)
    return true;
  if (rhs.domain_hint < lhs.domain_hint)
    return false;
  if (lhs.fields < rhs.fields)
    return true;
  if (rhs.fields < lhs.fields)
    return false;
  if (lhs.params_json < rhs.params_json)
    return true;
  if (rhs.params_json < lhs.params_json)
    return false;
  if (lhs.format < rhs.format)
    return true;
  if (rhs.format < lhs.format)
    return false;
  return false;
}
template <typename StructPtrType>
IdentityCredentialDisconnectOptionsPtr IdentityCredentialDisconnectOptions::Clone() const {
  return New(
      mojo::Clone(config),
      mojo::Clone(account_hint)
  );
}

template <typename T, IdentityCredentialDisconnectOptions::EnableIfSame<T>*>
bool IdentityCredentialDisconnectOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->config, other_struct.config))
    return false;
  if (!mojo::Equals(this->account_hint, other_struct.account_hint))
    return false;
  return true;
}

template <typename T, IdentityCredentialDisconnectOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.config < rhs.config)
    return true;
  if (rhs.config < lhs.config)
    return false;
  if (lhs.account_hint < rhs.account_hint)
    return true;
  if (rhs.account_hint < lhs.account_hint)
    return false;
  return false;
}
template <typename StructPtrType>
IdentityUserInfoPtr IdentityUserInfo::Clone() const {
  return New(
      mojo::Clone(email),
      mojo::Clone(given_name),
      mojo::Clone(name),
      mojo::Clone(picture)
  );
}

template <typename T, IdentityUserInfo::EnableIfSame<T>*>
bool IdentityUserInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->email, other_struct.email))
    return false;
  if (!mojo::Equals(this->given_name, other_struct.given_name))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->picture, other_struct.picture))
    return false;
  return true;
}

template <typename T, IdentityUserInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.email < rhs.email)
    return true;
  if (rhs.email < lhs.email)
    return false;
  if (lhs.given_name < rhs.given_name)
    return true;
  if (rhs.given_name < lhs.given_name)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.picture < rhs.picture)
    return true;
  if (rhs.picture < lhs.picture)
    return false;
  return false;
}
template <typename StructPtrType>
LoginStatusAccountPtr LoginStatusAccount::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(email),
      mojo::Clone(name),
      mojo::Clone(given_name),
      mojo::Clone(picture)
  );
}

template <typename T, LoginStatusAccount::EnableIfSame<T>*>
bool LoginStatusAccount::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->email, other_struct.email))
    return false;
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->given_name, other_struct.given_name))
    return false;
  if (!mojo::Equals(this->picture, other_struct.picture))
    return false;
  return true;
}

template <typename T, LoginStatusAccount::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.email < rhs.email)
    return true;
  if (rhs.email < lhs.email)
    return false;
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.given_name < rhs.given_name)
    return true;
  if (rhs.given_name < lhs.given_name)
    return false;
  if (lhs.picture < rhs.picture)
    return true;
  if (rhs.picture < lhs.picture)
    return false;
  return false;
}
template <typename StructPtrType>
LoginStatusOptionsPtr LoginStatusOptions::Clone() const {
  return New(
      mojo::Clone(accounts),
      mojo::Clone(expiration)
  );
}

template <typename T, LoginStatusOptions::EnableIfSame<T>*>
bool LoginStatusOptions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->accounts, other_struct.accounts))
    return false;
  if (!mojo::Equals(this->expiration, other_struct.expiration))
    return false;
  return true;
}

template <typename T, LoginStatusOptions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.accounts < rhs.accounts)
    return true;
  if (rhs.accounts < lhs.accounts)
    return false;
  if (lhs.expiration < rhs.expiration)
    return true;
  if (rhs.expiration < lhs.expiration)
    return false;
  return false;
}
template <typename StructPtrType>
IdentityProviderGetParametersPtr IdentityProviderGetParameters::Clone() const {
  return New(
      mojo::Clone(providers),
      mojo::Clone(context),
      mojo::Clone(mode)
  );
}

template <typename T, IdentityProviderGetParameters::EnableIfSame<T>*>
bool IdentityProviderGetParameters::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->providers, other_struct.providers))
    return false;
  if (!mojo::Equals(this->context, other_struct.context))
    return false;
  if (!mojo::Equals(this->mode, other_struct.mode))
    return false;
  return true;
}

template <typename T, IdentityProviderGetParameters::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.providers < rhs.providers)
    return true;
  if (rhs.providers < lhs.providers)
    return false;
  if (lhs.context < rhs.context)
    return true;
  if (rhs.context < lhs.context)
    return false;
  if (lhs.mode < rhs.mode)
    return true;
  if (rhs.mode < lhs.mode)
    return false;
  return false;
}
template <typename StructPtrType>
TokenErrorPtr TokenError::Clone() const {
  return New(
      mojo::Clone(code),
      mojo::Clone(url)
  );
}

template <typename T, TokenError::EnableIfSame<T>*>
bool TokenError::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->code, other_struct.code))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  return true;
}

template <typename T, TokenError::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.code < rhs.code)
    return true;
  if (rhs.code < lhs.code)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::IdentityProviderConfig::DataView,
                                         ::blink::mojom::blink::IdentityProviderConfigPtr> {
  static bool IsNull(const ::blink::mojom::blink::IdentityProviderConfigPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::IdentityProviderConfigPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::IdentityProviderConfig::config_url)& config_url(
      const ::blink::mojom::blink::IdentityProviderConfigPtr& input) {
    return input->config_url;
  }

  static decltype(::blink::mojom::blink::IdentityProviderConfig::from_idp_registration_api) from_idp_registration_api(
      const ::blink::mojom::blink::IdentityProviderConfigPtr& input) {
    return input->from_idp_registration_api;
  }

  static const decltype(::blink::mojom::blink::IdentityProviderConfig::type)& type(
      const ::blink::mojom::blink::IdentityProviderConfigPtr& input) {
    return input->type;
  }

  static const decltype(::blink::mojom::blink::IdentityProviderConfig::client_id)& client_id(
      const ::blink::mojom::blink::IdentityProviderConfigPtr& input) {
    return input->client_id;
  }

  static bool Read(::blink::mojom::blink::IdentityProviderConfig::DataView input, ::blink::mojom::blink::IdentityProviderConfigPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::IdentityProviderRequestOptions::DataView,
                                         ::blink::mojom::blink::IdentityProviderRequestOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::IdentityProviderRequestOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::IdentityProviderRequestOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::IdentityProviderRequestOptions::config)& config(
      const ::blink::mojom::blink::IdentityProviderRequestOptionsPtr& input) {
    return input->config;
  }

  static const decltype(::blink::mojom::blink::IdentityProviderRequestOptions::nonce)& nonce(
      const ::blink::mojom::blink::IdentityProviderRequestOptionsPtr& input) {
    return input->nonce;
  }

  static const decltype(::blink::mojom::blink::IdentityProviderRequestOptions::login_hint)& login_hint(
      const ::blink::mojom::blink::IdentityProviderRequestOptionsPtr& input) {
    return input->login_hint;
  }

  static const decltype(::blink::mojom::blink::IdentityProviderRequestOptions::domain_hint)& domain_hint(
      const ::blink::mojom::blink::IdentityProviderRequestOptionsPtr& input) {
    return input->domain_hint;
  }

  static const decltype(::blink::mojom::blink::IdentityProviderRequestOptions::fields)& fields(
      const ::blink::mojom::blink::IdentityProviderRequestOptionsPtr& input) {
    return input->fields;
  }

  static const decltype(::blink::mojom::blink::IdentityProviderRequestOptions::params_json)& params_json(
      const ::blink::mojom::blink::IdentityProviderRequestOptionsPtr& input) {
    return input->params_json;
  }

  static decltype(::blink::mojom::blink::IdentityProviderRequestOptions::format) format(
      const ::blink::mojom::blink::IdentityProviderRequestOptionsPtr& input) {
    return input->format;
  }

  static bool Read(::blink::mojom::blink::IdentityProviderRequestOptions::DataView input, ::blink::mojom::blink::IdentityProviderRequestOptionsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::IdentityCredentialDisconnectOptions::DataView,
                                         ::blink::mojom::blink::IdentityCredentialDisconnectOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::IdentityCredentialDisconnectOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::IdentityCredentialDisconnectOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::IdentityCredentialDisconnectOptions::config)& config(
      const ::blink::mojom::blink::IdentityCredentialDisconnectOptionsPtr& input) {
    return input->config;
  }

  static const decltype(::blink::mojom::blink::IdentityCredentialDisconnectOptions::account_hint)& account_hint(
      const ::blink::mojom::blink::IdentityCredentialDisconnectOptionsPtr& input) {
    return input->account_hint;
  }

  static bool Read(::blink::mojom::blink::IdentityCredentialDisconnectOptions::DataView input, ::blink::mojom::blink::IdentityCredentialDisconnectOptionsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::IdentityUserInfo::DataView,
                                         ::blink::mojom::blink::IdentityUserInfoPtr> {
  static bool IsNull(const ::blink::mojom::blink::IdentityUserInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::IdentityUserInfoPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::IdentityUserInfo::email)& email(
      const ::blink::mojom::blink::IdentityUserInfoPtr& input) {
    return input->email;
  }

  static const decltype(::blink::mojom::blink::IdentityUserInfo::given_name)& given_name(
      const ::blink::mojom::blink::IdentityUserInfoPtr& input) {
    return input->given_name;
  }

  static const decltype(::blink::mojom::blink::IdentityUserInfo::name)& name(
      const ::blink::mojom::blink::IdentityUserInfoPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::IdentityUserInfo::picture)& picture(
      const ::blink::mojom::blink::IdentityUserInfoPtr& input) {
    return input->picture;
  }

  static bool Read(::blink::mojom::blink::IdentityUserInfo::DataView input, ::blink::mojom::blink::IdentityUserInfoPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::LoginStatusAccount::DataView,
                                         ::blink::mojom::blink::LoginStatusAccountPtr> {
  static bool IsNull(const ::blink::mojom::blink::LoginStatusAccountPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::LoginStatusAccountPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::LoginStatusAccount::id)& id(
      const ::blink::mojom::blink::LoginStatusAccountPtr& input) {
    return input->id;
  }

  static const decltype(::blink::mojom::blink::LoginStatusAccount::email)& email(
      const ::blink::mojom::blink::LoginStatusAccountPtr& input) {
    return input->email;
  }

  static const decltype(::blink::mojom::blink::LoginStatusAccount::name)& name(
      const ::blink::mojom::blink::LoginStatusAccountPtr& input) {
    return input->name;
  }

  static const decltype(::blink::mojom::blink::LoginStatusAccount::given_name)& given_name(
      const ::blink::mojom::blink::LoginStatusAccountPtr& input) {
    return input->given_name;
  }

  static const decltype(::blink::mojom::blink::LoginStatusAccount::picture)& picture(
      const ::blink::mojom::blink::LoginStatusAccountPtr& input) {
    return input->picture;
  }

  static bool Read(::blink::mojom::blink::LoginStatusAccount::DataView input, ::blink::mojom::blink::LoginStatusAccountPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::LoginStatusOptions::DataView,
                                         ::blink::mojom::blink::LoginStatusOptionsPtr> {
  static bool IsNull(const ::blink::mojom::blink::LoginStatusOptionsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::LoginStatusOptionsPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::LoginStatusOptions::accounts)& accounts(
      const ::blink::mojom::blink::LoginStatusOptionsPtr& input) {
    return input->accounts;
  }

  static const decltype(::blink::mojom::blink::LoginStatusOptions::expiration)& expiration(
      const ::blink::mojom::blink::LoginStatusOptionsPtr& input) {
    return input->expiration;
  }

  static bool Read(::blink::mojom::blink::LoginStatusOptions::DataView input, ::blink::mojom::blink::LoginStatusOptionsPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::IdentityProviderGetParameters::DataView,
                                         ::blink::mojom::blink::IdentityProviderGetParametersPtr> {
  static bool IsNull(const ::blink::mojom::blink::IdentityProviderGetParametersPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::IdentityProviderGetParametersPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::IdentityProviderGetParameters::providers)& providers(
      const ::blink::mojom::blink::IdentityProviderGetParametersPtr& input) {
    return input->providers;
  }

  static decltype(::blink::mojom::blink::IdentityProviderGetParameters::context) context(
      const ::blink::mojom::blink::IdentityProviderGetParametersPtr& input) {
    return input->context;
  }

  static decltype(::blink::mojom::blink::IdentityProviderGetParameters::mode) mode(
      const ::blink::mojom::blink::IdentityProviderGetParametersPtr& input) {
    return input->mode;
  }

  static bool Read(::blink::mojom::blink::IdentityProviderGetParameters::DataView input, ::blink::mojom::blink::IdentityProviderGetParametersPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::TokenError::DataView,
                                         ::blink::mojom::blink::TokenErrorPtr> {
  static bool IsNull(const ::blink::mojom::blink::TokenErrorPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::TokenErrorPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::TokenError::code)& code(
      const ::blink::mojom::blink::TokenErrorPtr& input) {
    return input->code;
  }

  static const decltype(::blink::mojom::blink::TokenError::url)& url(
      const ::blink::mojom::blink::TokenErrorPtr& input) {
    return input->url;
  }

  static bool Read(::blink::mojom::blink::TokenError::DataView input, ::blink::mojom::blink::TokenErrorPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEBID_FEDERATED_AUTH_REQUEST_MOJOM_BLINK_H_