// third_party/blink/public/mojom/web_launch/web_launch.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/web_launch/web_launch.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var file_system_access_directory_handle$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom', '../file_system_access/file_system_access_directory_handle.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }



  function WebLaunchService_SetLaunchFiles_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebLaunchService_SetLaunchFiles_Params.prototype.initDefaults_ = function() {
    this.files = null;
  };
  WebLaunchService_SetLaunchFiles_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebLaunchService_SetLaunchFiles_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebLaunchService_SetLaunchFiles_Params.files
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(file_system_access_directory_handle$.FileSystemAccessEntry), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebLaunchService_SetLaunchFiles_Params.encodedSize = codec.kStructHeaderSize + 8;

  WebLaunchService_SetLaunchFiles_Params.decode = function(decoder) {
    var packed;
    var val = new WebLaunchService_SetLaunchFiles_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.files =
        decoder.decodeArrayPointer(new codec.PointerTo(file_system_access_directory_handle$.FileSystemAccessEntry));
    return val;
  };

  WebLaunchService_SetLaunchFiles_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebLaunchService_SetLaunchFiles_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(file_system_access_directory_handle$.FileSystemAccessEntry), val.files);
  };
  function WebLaunchService_EnqueueLaunchParams_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebLaunchService_EnqueueLaunchParams_Params.prototype.initDefaults_ = function() {
    this.launchUrl = null;
    this.timeNavigationStartedInBrowser = null;
    this.navigationStarted = false;
  };
  WebLaunchService_EnqueueLaunchParams_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebLaunchService_EnqueueLaunchParams_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebLaunchService_EnqueueLaunchParams_Params.launchUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebLaunchService_EnqueueLaunchParams_Params.timeNavigationStartedInBrowser
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  WebLaunchService_EnqueueLaunchParams_Params.encodedSize = codec.kStructHeaderSize + 24;

  WebLaunchService_EnqueueLaunchParams_Params.decode = function(decoder) {
    var packed;
    var val = new WebLaunchService_EnqueueLaunchParams_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.launchUrl =
        decoder.decodeStructPointer(url$.Url);
    val.timeNavigationStartedInBrowser =
        decoder.decodeStructPointer(time$.TimeTicks);
    packed = decoder.readUint8();
    val.navigationStarted = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  WebLaunchService_EnqueueLaunchParams_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebLaunchService_EnqueueLaunchParams_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.launchUrl);
    encoder.encodeStructPointer(time$.TimeTicks, val.timeNavigationStartedInBrowser);
    packed = 0;
    packed |= (val.navigationStarted & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kWebLaunchService_SetLaunchFiles_Name = 0;
  var kWebLaunchService_EnqueueLaunchParams_Name = 1;

  function WebLaunchServicePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(WebLaunchService,
                                                   handleOrPtrInfo);
  }

  function WebLaunchServiceAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        WebLaunchService, associatedInterfacePtrInfo);
  }

  WebLaunchServiceAssociatedPtr.prototype =
      Object.create(WebLaunchServicePtr.prototype);
  WebLaunchServiceAssociatedPtr.prototype.constructor =
      WebLaunchServiceAssociatedPtr;

  function WebLaunchServiceProxy(receiver) {
    this.receiver_ = receiver;
  }
  WebLaunchServicePtr.prototype.setLaunchFiles = function() {
    return WebLaunchServiceProxy.prototype.setLaunchFiles
        .apply(this.ptr.getProxy(), arguments);
  };

  WebLaunchServiceProxy.prototype.setLaunchFiles = function(files) {
    var params_ = new WebLaunchService_SetLaunchFiles_Params();
    params_.files = files;
    var builder = new codec.MessageV0Builder(
        kWebLaunchService_SetLaunchFiles_Name,
        codec.align(WebLaunchService_SetLaunchFiles_Params.encodedSize));
    builder.encodeStruct(WebLaunchService_SetLaunchFiles_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  WebLaunchServicePtr.prototype.enqueueLaunchParams = function() {
    return WebLaunchServiceProxy.prototype.enqueueLaunchParams
        .apply(this.ptr.getProxy(), arguments);
  };

  WebLaunchServiceProxy.prototype.enqueueLaunchParams = function(launchUrl, timeNavigationStartedInBrowser, navigationStarted) {
    var params_ = new WebLaunchService_EnqueueLaunchParams_Params();
    params_.launchUrl = launchUrl;
    params_.timeNavigationStartedInBrowser = timeNavigationStartedInBrowser;
    params_.navigationStarted = navigationStarted;
    var builder = new codec.MessageV0Builder(
        kWebLaunchService_EnqueueLaunchParams_Name,
        codec.align(WebLaunchService_EnqueueLaunchParams_Params.encodedSize));
    builder.encodeStruct(WebLaunchService_EnqueueLaunchParams_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function WebLaunchServiceStub(delegate) {
    this.delegate_ = delegate;
  }
  WebLaunchServiceStub.prototype.setLaunchFiles = function(files) {
    return this.delegate_ && this.delegate_.setLaunchFiles && this.delegate_.setLaunchFiles(files);
  }
  WebLaunchServiceStub.prototype.enqueueLaunchParams = function(launchUrl, timeNavigationStartedInBrowser, navigationStarted) {
    return this.delegate_ && this.delegate_.enqueueLaunchParams && this.delegate_.enqueueLaunchParams(launchUrl, timeNavigationStartedInBrowser, navigationStarted);
  }

  WebLaunchServiceStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kWebLaunchService_SetLaunchFiles_Name:
      var params = reader.decodeStruct(WebLaunchService_SetLaunchFiles_Params);
      this.setLaunchFiles(params.files);
      return true;
    case kWebLaunchService_EnqueueLaunchParams_Name:
      var params = reader.decodeStruct(WebLaunchService_EnqueueLaunchParams_Params);
      this.enqueueLaunchParams(params.launchUrl, params.timeNavigationStartedInBrowser, params.navigationStarted);
      return true;
    default:
      return false;
    }
  };

  WebLaunchServiceStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateWebLaunchServiceRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kWebLaunchService_SetLaunchFiles_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebLaunchService_SetLaunchFiles_Params;
      break;
      case kWebLaunchService_EnqueueLaunchParams_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = WebLaunchService_EnqueueLaunchParams_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateWebLaunchServiceResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var WebLaunchService = {
    name: 'blink.mojom.WebLaunchService',
    kVersion: 0,
    ptrClass: WebLaunchServicePtr,
    proxyClass: WebLaunchServiceProxy,
    stubClass: WebLaunchServiceStub,
    validateRequest: validateWebLaunchServiceRequest,
    validateResponse: null,
  };
  WebLaunchServiceStub.prototype.validator = validateWebLaunchServiceRequest;
  WebLaunchServiceProxy.prototype.validator = null;
  exports.WebLaunchService = WebLaunchService;
  exports.WebLaunchServicePtr = WebLaunchServicePtr;
  exports.WebLaunchServiceAssociatedPtr = WebLaunchServiceAssociatedPtr;
})();