// third_party/blink/public/mojom/web_launch/web_launch.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEB_LAUNCH_WEB_LAUNCH_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEB_LAUNCH_WEB_LAUNCH_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/web_launch/web_launch.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/web_launch/web_launch.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/web_launch/web_launch.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "third_party/blink/public/mojom/file_system_access/file_system_access_directory_handle.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class WebLaunchServiceProxy;

template <typename ImplRefTraits>
class WebLaunchServiceStub;

class WebLaunchServiceRequestValidator;


class BLINK_COMMON_EXPORT WebLaunchService
    : public WebLaunchServiceInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.WebLaunchService";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = WebLaunchServiceInterfaceBase;
  using Proxy_ = WebLaunchServiceProxy;

  template <typename ImplRefTraits>
  using Stub_ = WebLaunchServiceStub<ImplRefTraits>;

  using RequestValidator_ = WebLaunchServiceRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetLaunchFilesMinVersion = 0,
    kEnqueueLaunchParamsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetLaunchFiles_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnqueueLaunchParams_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~WebLaunchService() = default;

  virtual void SetLaunchFiles(std::vector<::blink::mojom::FileSystemAccessEntryPtr> files) = 0;

  virtual void EnqueueLaunchParams(const ::GURL& launch_url, ::base::TimeTicks time_navigation_started_in_browser, bool navigation_started) = 0;
};



class BLINK_COMMON_EXPORT WebLaunchServiceProxy
    : public WebLaunchService {
 public:
  using InterfaceType = WebLaunchService;

  explicit WebLaunchServiceProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetLaunchFiles(std::vector<::blink::mojom::FileSystemAccessEntryPtr> files) final;
  
  void EnqueueLaunchParams(const ::GURL& launch_url, ::base::TimeTicks time_navigation_started_in_browser, bool navigation_started) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT WebLaunchServiceStubDispatch {
 public:
  static bool Accept(WebLaunchService* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      WebLaunchService* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<WebLaunchService>>
class WebLaunchServiceStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  WebLaunchServiceStub() = default;
  ~WebLaunchServiceStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebLaunchServiceStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return WebLaunchServiceStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT WebLaunchServiceRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // blink::mojom

namespace mojo {

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_WEB_LAUNCH_WEB_LAUNCH_MOJOM_H_