// third_party/blink/public/mojom/tokens/tokens.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/tokens/tokens.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }



  function DocumentToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DocumentToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  DocumentToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DocumentToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DocumentToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DocumentToken.encodedSize = codec.kStructHeaderSize + 8;

  DocumentToken.decode = function(decoder) {
    var packed;
    var val = new DocumentToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  DocumentToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DocumentToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };
  function LocalFrameToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LocalFrameToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  LocalFrameToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LocalFrameToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LocalFrameToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LocalFrameToken.encodedSize = codec.kStructHeaderSize + 8;

  LocalFrameToken.decode = function(decoder) {
    var packed;
    var val = new LocalFrameToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  LocalFrameToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LocalFrameToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };
  function RemoteFrameToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  RemoteFrameToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  RemoteFrameToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  RemoteFrameToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate RemoteFrameToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  RemoteFrameToken.encodedSize = codec.kStructHeaderSize + 8;

  RemoteFrameToken.decode = function(decoder) {
    var packed;
    var val = new RemoteFrameToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  RemoteFrameToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(RemoteFrameToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };
  function DedicatedWorkerToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DedicatedWorkerToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  DedicatedWorkerToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DedicatedWorkerToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DedicatedWorkerToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DedicatedWorkerToken.encodedSize = codec.kStructHeaderSize + 8;

  DedicatedWorkerToken.decode = function(decoder) {
    var packed;
    var val = new DedicatedWorkerToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  DedicatedWorkerToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DedicatedWorkerToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };
  function ServiceWorkerToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ServiceWorkerToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  ServiceWorkerToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ServiceWorkerToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ServiceWorkerToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ServiceWorkerToken.encodedSize = codec.kStructHeaderSize + 8;

  ServiceWorkerToken.decode = function(decoder) {
    var packed;
    var val = new ServiceWorkerToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  ServiceWorkerToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ServiceWorkerToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };
  function SharedWorkerToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedWorkerToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  SharedWorkerToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedWorkerToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedWorkerToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedWorkerToken.encodedSize = codec.kStructHeaderSize + 8;

  SharedWorkerToken.decode = function(decoder) {
    var packed;
    var val = new SharedWorkerToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  SharedWorkerToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedWorkerToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };
  function AnimationWorkletToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AnimationWorkletToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  AnimationWorkletToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AnimationWorkletToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AnimationWorkletToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AnimationWorkletToken.encodedSize = codec.kStructHeaderSize + 8;

  AnimationWorkletToken.decode = function(decoder) {
    var packed;
    var val = new AnimationWorkletToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  AnimationWorkletToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AnimationWorkletToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };
  function AudioWorkletToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioWorkletToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  AudioWorkletToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioWorkletToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioWorkletToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioWorkletToken.encodedSize = codec.kStructHeaderSize + 8;

  AudioWorkletToken.decode = function(decoder) {
    var packed;
    var val = new AudioWorkletToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  AudioWorkletToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioWorkletToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };
  function LayoutWorkletToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LayoutWorkletToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  LayoutWorkletToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LayoutWorkletToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LayoutWorkletToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LayoutWorkletToken.encodedSize = codec.kStructHeaderSize + 8;

  LayoutWorkletToken.decode = function(decoder) {
    var packed;
    var val = new LayoutWorkletToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  LayoutWorkletToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LayoutWorkletToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };
  function PaintWorkletToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PaintWorkletToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  PaintWorkletToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PaintWorkletToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PaintWorkletToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PaintWorkletToken.encodedSize = codec.kStructHeaderSize + 8;

  PaintWorkletToken.decode = function(decoder) {
    var packed;
    var val = new PaintWorkletToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  PaintWorkletToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PaintWorkletToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };
  function SharedStorageWorkletToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SharedStorageWorkletToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  SharedStorageWorkletToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SharedStorageWorkletToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SharedStorageWorkletToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SharedStorageWorkletToken.encodedSize = codec.kStructHeaderSize + 8;

  SharedStorageWorkletToken.decode = function(decoder) {
    var packed;
    var val = new SharedStorageWorkletToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  SharedStorageWorkletToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SharedStorageWorkletToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };
  function ShadowRealmToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ShadowRealmToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  ShadowRealmToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ShadowRealmToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ShadowRealmToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ShadowRealmToken.encodedSize = codec.kStructHeaderSize + 8;

  ShadowRealmToken.decode = function(decoder) {
    var packed;
    var val = new ShadowRealmToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  ShadowRealmToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ShadowRealmToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };
  function AttributionSrcToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AttributionSrcToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  AttributionSrcToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AttributionSrcToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AttributionSrcToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AttributionSrcToken.encodedSize = codec.kStructHeaderSize + 8;

  AttributionSrcToken.decode = function(decoder) {
    var packed;
    var val = new AttributionSrcToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  AttributionSrcToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AttributionSrcToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };
  function SameDocNavigationScreenshotDestinationToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SameDocNavigationScreenshotDestinationToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  SameDocNavigationScreenshotDestinationToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SameDocNavigationScreenshotDestinationToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SameDocNavigationScreenshotDestinationToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SameDocNavigationScreenshotDestinationToken.encodedSize = codec.kStructHeaderSize + 8;

  SameDocNavigationScreenshotDestinationToken.decode = function(decoder) {
    var packed;
    var val = new SameDocNavigationScreenshotDestinationToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  SameDocNavigationScreenshotDestinationToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SameDocNavigationScreenshotDestinationToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };
  function V8ContextToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  V8ContextToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  V8ContextToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  V8ContextToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate V8ContextToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  V8ContextToken.encodedSize = codec.kStructHeaderSize + 8;

  V8ContextToken.decode = function(decoder) {
    var packed;
    var val = new V8ContextToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  V8ContextToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(V8ContextToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };
  function ViewTransitionToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ViewTransitionToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  ViewTransitionToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ViewTransitionToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ViewTransitionToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ViewTransitionToken.encodedSize = codec.kStructHeaderSize + 8;

  ViewTransitionToken.decode = function(decoder) {
    var packed;
    var val = new ViewTransitionToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  ViewTransitionToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ViewTransitionToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };
  function WebNNContextToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebNNContextToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  WebNNContextToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebNNContextToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebNNContextToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebNNContextToken.encodedSize = codec.kStructHeaderSize + 8;

  WebNNContextToken.decode = function(decoder) {
    var packed;
    var val = new WebNNContextToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  WebNNContextToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebNNContextToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };
  function WebNNPendingConstantToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebNNPendingConstantToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  WebNNPendingConstantToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebNNPendingConstantToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebNNPendingConstantToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebNNPendingConstantToken.encodedSize = codec.kStructHeaderSize + 8;

  WebNNPendingConstantToken.decode = function(decoder) {
    var packed;
    var val = new WebNNPendingConstantToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  WebNNPendingConstantToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebNNPendingConstantToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };
  function WebNNTensorToken(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  WebNNTensorToken.prototype.initDefaults_ = function() {
    this.value = null;
  };
  WebNNTensorToken.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  WebNNTensorToken.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate WebNNTensorToken.value
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  WebNNTensorToken.encodedSize = codec.kStructHeaderSize + 8;

  WebNNTensorToken.decode = function(decoder) {
    var packed;
    var val = new WebNNTensorToken();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.value =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  WebNNTensorToken.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(WebNNTensorToken.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.value);
  };

  function FrameToken(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  FrameToken.Tags = {
    localFrameToken: 0,
    remoteFrameToken: 1,
  };

  FrameToken.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  FrameToken.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "localFrameToken",
        "remoteFrameToken",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a FrameToken member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(FrameToken.prototype, "localFrameToken", {
    get: function() {
      if (this.$tag != FrameToken.Tags.localFrameToken) {
        throw new ReferenceError(
            "FrameToken.localFrameToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = FrameToken.Tags.localFrameToken;
      this.$data = value;
    }
  });
  Object.defineProperty(FrameToken.prototype, "remoteFrameToken", {
    get: function() {
      if (this.$tag != FrameToken.Tags.remoteFrameToken) {
        throw new ReferenceError(
            "FrameToken.remoteFrameToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = FrameToken.Tags.remoteFrameToken;
      this.$data = value;
    }
  });


    FrameToken.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case FrameToken.Tags.localFrameToken:
          encoder.encodeStructPointer(LocalFrameToken, val.localFrameToken);
          break;
        case FrameToken.Tags.remoteFrameToken:
          encoder.encodeStructPointer(RemoteFrameToken, val.remoteFrameToken);
          break;
      }
      encoder.align();
    };


    FrameToken.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new FrameToken();
      var tag = decoder.readUint32();
      switch (tag) {
        case FrameToken.Tags.localFrameToken:
          result.localFrameToken = decoder.decodeStructPointer(LocalFrameToken);
          break;
        case FrameToken.Tags.remoteFrameToken:
          result.remoteFrameToken = decoder.decodeStructPointer(RemoteFrameToken);
          break;
      }
      decoder.align();

      return result;
    };


    FrameToken.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case FrameToken.Tags.localFrameToken:
          

    // validate FrameToken.localFrameToken
    err = messageValidator.validateStructPointer(data_offset, LocalFrameToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case FrameToken.Tags.remoteFrameToken:
          

    // validate FrameToken.remoteFrameToken
    err = messageValidator.validateStructPointer(data_offset, RemoteFrameToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  FrameToken.encodedSize = 16;

  function WorkerToken(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  WorkerToken.Tags = {
    dedicatedWorkerToken: 0,
    serviceWorkerToken: 1,
    sharedWorkerToken: 2,
  };

  WorkerToken.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  WorkerToken.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "dedicatedWorkerToken",
        "serviceWorkerToken",
        "sharedWorkerToken",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a WorkerToken member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(WorkerToken.prototype, "dedicatedWorkerToken", {
    get: function() {
      if (this.$tag != WorkerToken.Tags.dedicatedWorkerToken) {
        throw new ReferenceError(
            "WorkerToken.dedicatedWorkerToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WorkerToken.Tags.dedicatedWorkerToken;
      this.$data = value;
    }
  });
  Object.defineProperty(WorkerToken.prototype, "serviceWorkerToken", {
    get: function() {
      if (this.$tag != WorkerToken.Tags.serviceWorkerToken) {
        throw new ReferenceError(
            "WorkerToken.serviceWorkerToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WorkerToken.Tags.serviceWorkerToken;
      this.$data = value;
    }
  });
  Object.defineProperty(WorkerToken.prototype, "sharedWorkerToken", {
    get: function() {
      if (this.$tag != WorkerToken.Tags.sharedWorkerToken) {
        throw new ReferenceError(
            "WorkerToken.sharedWorkerToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WorkerToken.Tags.sharedWorkerToken;
      this.$data = value;
    }
  });


    WorkerToken.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case WorkerToken.Tags.dedicatedWorkerToken:
          encoder.encodeStructPointer(DedicatedWorkerToken, val.dedicatedWorkerToken);
          break;
        case WorkerToken.Tags.serviceWorkerToken:
          encoder.encodeStructPointer(ServiceWorkerToken, val.serviceWorkerToken);
          break;
        case WorkerToken.Tags.sharedWorkerToken:
          encoder.encodeStructPointer(SharedWorkerToken, val.sharedWorkerToken);
          break;
      }
      encoder.align();
    };


    WorkerToken.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new WorkerToken();
      var tag = decoder.readUint32();
      switch (tag) {
        case WorkerToken.Tags.dedicatedWorkerToken:
          result.dedicatedWorkerToken = decoder.decodeStructPointer(DedicatedWorkerToken);
          break;
        case WorkerToken.Tags.serviceWorkerToken:
          result.serviceWorkerToken = decoder.decodeStructPointer(ServiceWorkerToken);
          break;
        case WorkerToken.Tags.sharedWorkerToken:
          result.sharedWorkerToken = decoder.decodeStructPointer(SharedWorkerToken);
          break;
      }
      decoder.align();

      return result;
    };


    WorkerToken.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case WorkerToken.Tags.dedicatedWorkerToken:
          

    // validate WorkerToken.dedicatedWorkerToken
    err = messageValidator.validateStructPointer(data_offset, DedicatedWorkerToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case WorkerToken.Tags.serviceWorkerToken:
          

    // validate WorkerToken.serviceWorkerToken
    err = messageValidator.validateStructPointer(data_offset, ServiceWorkerToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case WorkerToken.Tags.sharedWorkerToken:
          

    // validate WorkerToken.sharedWorkerToken
    err = messageValidator.validateStructPointer(data_offset, SharedWorkerToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  WorkerToken.encodedSize = 16;

  function WorkletToken(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  WorkletToken.Tags = {
    animationWorkletToken: 0,
    audioWorkletToken: 1,
    layoutWorkletToken: 2,
    paintWorkletToken: 3,
    sharedStorageWorkletToken: 4,
  };

  WorkletToken.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  WorkletToken.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "animationWorkletToken",
        "audioWorkletToken",
        "layoutWorkletToken",
        "paintWorkletToken",
        "sharedStorageWorkletToken",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a WorkletToken member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(WorkletToken.prototype, "animationWorkletToken", {
    get: function() {
      if (this.$tag != WorkletToken.Tags.animationWorkletToken) {
        throw new ReferenceError(
            "WorkletToken.animationWorkletToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WorkletToken.Tags.animationWorkletToken;
      this.$data = value;
    }
  });
  Object.defineProperty(WorkletToken.prototype, "audioWorkletToken", {
    get: function() {
      if (this.$tag != WorkletToken.Tags.audioWorkletToken) {
        throw new ReferenceError(
            "WorkletToken.audioWorkletToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WorkletToken.Tags.audioWorkletToken;
      this.$data = value;
    }
  });
  Object.defineProperty(WorkletToken.prototype, "layoutWorkletToken", {
    get: function() {
      if (this.$tag != WorkletToken.Tags.layoutWorkletToken) {
        throw new ReferenceError(
            "WorkletToken.layoutWorkletToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WorkletToken.Tags.layoutWorkletToken;
      this.$data = value;
    }
  });
  Object.defineProperty(WorkletToken.prototype, "paintWorkletToken", {
    get: function() {
      if (this.$tag != WorkletToken.Tags.paintWorkletToken) {
        throw new ReferenceError(
            "WorkletToken.paintWorkletToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WorkletToken.Tags.paintWorkletToken;
      this.$data = value;
    }
  });
  Object.defineProperty(WorkletToken.prototype, "sharedStorageWorkletToken", {
    get: function() {
      if (this.$tag != WorkletToken.Tags.sharedStorageWorkletToken) {
        throw new ReferenceError(
            "WorkletToken.sharedStorageWorkletToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WorkletToken.Tags.sharedStorageWorkletToken;
      this.$data = value;
    }
  });


    WorkletToken.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case WorkletToken.Tags.animationWorkletToken:
          encoder.encodeStructPointer(AnimationWorkletToken, val.animationWorkletToken);
          break;
        case WorkletToken.Tags.audioWorkletToken:
          encoder.encodeStructPointer(AudioWorkletToken, val.audioWorkletToken);
          break;
        case WorkletToken.Tags.layoutWorkletToken:
          encoder.encodeStructPointer(LayoutWorkletToken, val.layoutWorkletToken);
          break;
        case WorkletToken.Tags.paintWorkletToken:
          encoder.encodeStructPointer(PaintWorkletToken, val.paintWorkletToken);
          break;
        case WorkletToken.Tags.sharedStorageWorkletToken:
          encoder.encodeStructPointer(SharedStorageWorkletToken, val.sharedStorageWorkletToken);
          break;
      }
      encoder.align();
    };


    WorkletToken.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new WorkletToken();
      var tag = decoder.readUint32();
      switch (tag) {
        case WorkletToken.Tags.animationWorkletToken:
          result.animationWorkletToken = decoder.decodeStructPointer(AnimationWorkletToken);
          break;
        case WorkletToken.Tags.audioWorkletToken:
          result.audioWorkletToken = decoder.decodeStructPointer(AudioWorkletToken);
          break;
        case WorkletToken.Tags.layoutWorkletToken:
          result.layoutWorkletToken = decoder.decodeStructPointer(LayoutWorkletToken);
          break;
        case WorkletToken.Tags.paintWorkletToken:
          result.paintWorkletToken = decoder.decodeStructPointer(PaintWorkletToken);
          break;
        case WorkletToken.Tags.sharedStorageWorkletToken:
          result.sharedStorageWorkletToken = decoder.decodeStructPointer(SharedStorageWorkletToken);
          break;
      }
      decoder.align();

      return result;
    };


    WorkletToken.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case WorkletToken.Tags.animationWorkletToken:
          

    // validate WorkletToken.animationWorkletToken
    err = messageValidator.validateStructPointer(data_offset, AnimationWorkletToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case WorkletToken.Tags.audioWorkletToken:
          

    // validate WorkletToken.audioWorkletToken
    err = messageValidator.validateStructPointer(data_offset, AudioWorkletToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case WorkletToken.Tags.layoutWorkletToken:
          

    // validate WorkletToken.layoutWorkletToken
    err = messageValidator.validateStructPointer(data_offset, LayoutWorkletToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case WorkletToken.Tags.paintWorkletToken:
          

    // validate WorkletToken.paintWorkletToken
    err = messageValidator.validateStructPointer(data_offset, PaintWorkletToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case WorkletToken.Tags.sharedStorageWorkletToken:
          

    // validate WorkletToken.sharedStorageWorkletToken
    err = messageValidator.validateStructPointer(data_offset, SharedStorageWorkletToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  WorkletToken.encodedSize = 16;

  function ExecutionContextToken(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  ExecutionContextToken.Tags = {
    localFrameToken: 0,
    dedicatedWorkerToken: 1,
    serviceWorkerToken: 2,
    sharedWorkerToken: 3,
    animationWorkletToken: 4,
    audioWorkletToken: 5,
    layoutWorkletToken: 6,
    paintWorkletToken: 7,
    sharedStorageWorkletToken: 8,
    shadowRealmToken: 9,
  };

  ExecutionContextToken.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  ExecutionContextToken.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "localFrameToken",
        "dedicatedWorkerToken",
        "serviceWorkerToken",
        "sharedWorkerToken",
        "animationWorkletToken",
        "audioWorkletToken",
        "layoutWorkletToken",
        "paintWorkletToken",
        "sharedStorageWorkletToken",
        "shadowRealmToken",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a ExecutionContextToken member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(ExecutionContextToken.prototype, "localFrameToken", {
    get: function() {
      if (this.$tag != ExecutionContextToken.Tags.localFrameToken) {
        throw new ReferenceError(
            "ExecutionContextToken.localFrameToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ExecutionContextToken.Tags.localFrameToken;
      this.$data = value;
    }
  });
  Object.defineProperty(ExecutionContextToken.prototype, "dedicatedWorkerToken", {
    get: function() {
      if (this.$tag != ExecutionContextToken.Tags.dedicatedWorkerToken) {
        throw new ReferenceError(
            "ExecutionContextToken.dedicatedWorkerToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ExecutionContextToken.Tags.dedicatedWorkerToken;
      this.$data = value;
    }
  });
  Object.defineProperty(ExecutionContextToken.prototype, "serviceWorkerToken", {
    get: function() {
      if (this.$tag != ExecutionContextToken.Tags.serviceWorkerToken) {
        throw new ReferenceError(
            "ExecutionContextToken.serviceWorkerToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ExecutionContextToken.Tags.serviceWorkerToken;
      this.$data = value;
    }
  });
  Object.defineProperty(ExecutionContextToken.prototype, "sharedWorkerToken", {
    get: function() {
      if (this.$tag != ExecutionContextToken.Tags.sharedWorkerToken) {
        throw new ReferenceError(
            "ExecutionContextToken.sharedWorkerToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ExecutionContextToken.Tags.sharedWorkerToken;
      this.$data = value;
    }
  });
  Object.defineProperty(ExecutionContextToken.prototype, "animationWorkletToken", {
    get: function() {
      if (this.$tag != ExecutionContextToken.Tags.animationWorkletToken) {
        throw new ReferenceError(
            "ExecutionContextToken.animationWorkletToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ExecutionContextToken.Tags.animationWorkletToken;
      this.$data = value;
    }
  });
  Object.defineProperty(ExecutionContextToken.prototype, "audioWorkletToken", {
    get: function() {
      if (this.$tag != ExecutionContextToken.Tags.audioWorkletToken) {
        throw new ReferenceError(
            "ExecutionContextToken.audioWorkletToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ExecutionContextToken.Tags.audioWorkletToken;
      this.$data = value;
    }
  });
  Object.defineProperty(ExecutionContextToken.prototype, "layoutWorkletToken", {
    get: function() {
      if (this.$tag != ExecutionContextToken.Tags.layoutWorkletToken) {
        throw new ReferenceError(
            "ExecutionContextToken.layoutWorkletToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ExecutionContextToken.Tags.layoutWorkletToken;
      this.$data = value;
    }
  });
  Object.defineProperty(ExecutionContextToken.prototype, "paintWorkletToken", {
    get: function() {
      if (this.$tag != ExecutionContextToken.Tags.paintWorkletToken) {
        throw new ReferenceError(
            "ExecutionContextToken.paintWorkletToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ExecutionContextToken.Tags.paintWorkletToken;
      this.$data = value;
    }
  });
  Object.defineProperty(ExecutionContextToken.prototype, "sharedStorageWorkletToken", {
    get: function() {
      if (this.$tag != ExecutionContextToken.Tags.sharedStorageWorkletToken) {
        throw new ReferenceError(
            "ExecutionContextToken.sharedStorageWorkletToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ExecutionContextToken.Tags.sharedStorageWorkletToken;
      this.$data = value;
    }
  });
  Object.defineProperty(ExecutionContextToken.prototype, "shadowRealmToken", {
    get: function() {
      if (this.$tag != ExecutionContextToken.Tags.shadowRealmToken) {
        throw new ReferenceError(
            "ExecutionContextToken.shadowRealmToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = ExecutionContextToken.Tags.shadowRealmToken;
      this.$data = value;
    }
  });


    ExecutionContextToken.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case ExecutionContextToken.Tags.localFrameToken:
          encoder.encodeStructPointer(LocalFrameToken, val.localFrameToken);
          break;
        case ExecutionContextToken.Tags.dedicatedWorkerToken:
          encoder.encodeStructPointer(DedicatedWorkerToken, val.dedicatedWorkerToken);
          break;
        case ExecutionContextToken.Tags.serviceWorkerToken:
          encoder.encodeStructPointer(ServiceWorkerToken, val.serviceWorkerToken);
          break;
        case ExecutionContextToken.Tags.sharedWorkerToken:
          encoder.encodeStructPointer(SharedWorkerToken, val.sharedWorkerToken);
          break;
        case ExecutionContextToken.Tags.animationWorkletToken:
          encoder.encodeStructPointer(AnimationWorkletToken, val.animationWorkletToken);
          break;
        case ExecutionContextToken.Tags.audioWorkletToken:
          encoder.encodeStructPointer(AudioWorkletToken, val.audioWorkletToken);
          break;
        case ExecutionContextToken.Tags.layoutWorkletToken:
          encoder.encodeStructPointer(LayoutWorkletToken, val.layoutWorkletToken);
          break;
        case ExecutionContextToken.Tags.paintWorkletToken:
          encoder.encodeStructPointer(PaintWorkletToken, val.paintWorkletToken);
          break;
        case ExecutionContextToken.Tags.sharedStorageWorkletToken:
          encoder.encodeStructPointer(SharedStorageWorkletToken, val.sharedStorageWorkletToken);
          break;
        case ExecutionContextToken.Tags.shadowRealmToken:
          encoder.encodeStructPointer(ShadowRealmToken, val.shadowRealmToken);
          break;
      }
      encoder.align();
    };


    ExecutionContextToken.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new ExecutionContextToken();
      var tag = decoder.readUint32();
      switch (tag) {
        case ExecutionContextToken.Tags.localFrameToken:
          result.localFrameToken = decoder.decodeStructPointer(LocalFrameToken);
          break;
        case ExecutionContextToken.Tags.dedicatedWorkerToken:
          result.dedicatedWorkerToken = decoder.decodeStructPointer(DedicatedWorkerToken);
          break;
        case ExecutionContextToken.Tags.serviceWorkerToken:
          result.serviceWorkerToken = decoder.decodeStructPointer(ServiceWorkerToken);
          break;
        case ExecutionContextToken.Tags.sharedWorkerToken:
          result.sharedWorkerToken = decoder.decodeStructPointer(SharedWorkerToken);
          break;
        case ExecutionContextToken.Tags.animationWorkletToken:
          result.animationWorkletToken = decoder.decodeStructPointer(AnimationWorkletToken);
          break;
        case ExecutionContextToken.Tags.audioWorkletToken:
          result.audioWorkletToken = decoder.decodeStructPointer(AudioWorkletToken);
          break;
        case ExecutionContextToken.Tags.layoutWorkletToken:
          result.layoutWorkletToken = decoder.decodeStructPointer(LayoutWorkletToken);
          break;
        case ExecutionContextToken.Tags.paintWorkletToken:
          result.paintWorkletToken = decoder.decodeStructPointer(PaintWorkletToken);
          break;
        case ExecutionContextToken.Tags.sharedStorageWorkletToken:
          result.sharedStorageWorkletToken = decoder.decodeStructPointer(SharedStorageWorkletToken);
          break;
        case ExecutionContextToken.Tags.shadowRealmToken:
          result.shadowRealmToken = decoder.decodeStructPointer(ShadowRealmToken);
          break;
      }
      decoder.align();

      return result;
    };


    ExecutionContextToken.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case ExecutionContextToken.Tags.localFrameToken:
          

    // validate ExecutionContextToken.localFrameToken
    err = messageValidator.validateStructPointer(data_offset, LocalFrameToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ExecutionContextToken.Tags.dedicatedWorkerToken:
          

    // validate ExecutionContextToken.dedicatedWorkerToken
    err = messageValidator.validateStructPointer(data_offset, DedicatedWorkerToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ExecutionContextToken.Tags.serviceWorkerToken:
          

    // validate ExecutionContextToken.serviceWorkerToken
    err = messageValidator.validateStructPointer(data_offset, ServiceWorkerToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ExecutionContextToken.Tags.sharedWorkerToken:
          

    // validate ExecutionContextToken.sharedWorkerToken
    err = messageValidator.validateStructPointer(data_offset, SharedWorkerToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ExecutionContextToken.Tags.animationWorkletToken:
          

    // validate ExecutionContextToken.animationWorkletToken
    err = messageValidator.validateStructPointer(data_offset, AnimationWorkletToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ExecutionContextToken.Tags.audioWorkletToken:
          

    // validate ExecutionContextToken.audioWorkletToken
    err = messageValidator.validateStructPointer(data_offset, AudioWorkletToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ExecutionContextToken.Tags.layoutWorkletToken:
          

    // validate ExecutionContextToken.layoutWorkletToken
    err = messageValidator.validateStructPointer(data_offset, LayoutWorkletToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ExecutionContextToken.Tags.paintWorkletToken:
          

    // validate ExecutionContextToken.paintWorkletToken
    err = messageValidator.validateStructPointer(data_offset, PaintWorkletToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ExecutionContextToken.Tags.sharedStorageWorkletToken:
          

    // validate ExecutionContextToken.sharedStorageWorkletToken
    err = messageValidator.validateStructPointer(data_offset, SharedStorageWorkletToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case ExecutionContextToken.Tags.shadowRealmToken:
          

    // validate ExecutionContextToken.shadowRealmToken
    err = messageValidator.validateStructPointer(data_offset, ShadowRealmToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  ExecutionContextToken.encodedSize = 16;

  function WebGPUExecutionContextToken(value) {
    this.initDefault_();
    this.initValue_(value);
  }


  WebGPUExecutionContextToken.Tags = {
    documentToken: 0,
    dedicatedWorkerToken: 1,
    sharedWorkerToken: 2,
    serviceWorkerToken: 3,
  };

  WebGPUExecutionContextToken.prototype.initDefault_ = function() {
    this.$data = null;
    this.$tag = undefined;
  }

  WebGPUExecutionContextToken.prototype.initValue_ = function(value) {
    if (value == undefined) {
      return;
    }

    var keys = Object.keys(value);
    if (keys.length == 0) {
      return;
    }

    if (keys.length > 1) {
      throw new TypeError("You may set only one member on a union.");
    }

    var fields = [
        "documentToken",
        "dedicatedWorkerToken",
        "sharedWorkerToken",
        "serviceWorkerToken",
    ];

    if (fields.indexOf(keys[0]) < 0) {
      throw new ReferenceError(keys[0] + " is not a WebGPUExecutionContextToken member.");

    }

    this[keys[0]] = value[keys[0]];
  }
  Object.defineProperty(WebGPUExecutionContextToken.prototype, "documentToken", {
    get: function() {
      if (this.$tag != WebGPUExecutionContextToken.Tags.documentToken) {
        throw new ReferenceError(
            "WebGPUExecutionContextToken.documentToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WebGPUExecutionContextToken.Tags.documentToken;
      this.$data = value;
    }
  });
  Object.defineProperty(WebGPUExecutionContextToken.prototype, "dedicatedWorkerToken", {
    get: function() {
      if (this.$tag != WebGPUExecutionContextToken.Tags.dedicatedWorkerToken) {
        throw new ReferenceError(
            "WebGPUExecutionContextToken.dedicatedWorkerToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WebGPUExecutionContextToken.Tags.dedicatedWorkerToken;
      this.$data = value;
    }
  });
  Object.defineProperty(WebGPUExecutionContextToken.prototype, "sharedWorkerToken", {
    get: function() {
      if (this.$tag != WebGPUExecutionContextToken.Tags.sharedWorkerToken) {
        throw new ReferenceError(
            "WebGPUExecutionContextToken.sharedWorkerToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WebGPUExecutionContextToken.Tags.sharedWorkerToken;
      this.$data = value;
    }
  });
  Object.defineProperty(WebGPUExecutionContextToken.prototype, "serviceWorkerToken", {
    get: function() {
      if (this.$tag != WebGPUExecutionContextToken.Tags.serviceWorkerToken) {
        throw new ReferenceError(
            "WebGPUExecutionContextToken.serviceWorkerToken is not currently set.");
      }
      return this.$data;
    },

    set: function(value) {
      this.$tag = WebGPUExecutionContextToken.Tags.serviceWorkerToken;
      this.$data = value;
    }
  });


    WebGPUExecutionContextToken.encode = function(encoder, val) {
      if (val == null) {
        encoder.writeUint64(0);
        encoder.writeUint64(0);
        return;
      }
      if (val.$tag == undefined) {
        throw new TypeError("Cannot encode unions with an unknown member set.");
      }

      encoder.writeUint32(16);
      encoder.writeUint32(val.$tag);
      switch (val.$tag) {
        case WebGPUExecutionContextToken.Tags.documentToken:
          encoder.encodeStructPointer(DocumentToken, val.documentToken);
          break;
        case WebGPUExecutionContextToken.Tags.dedicatedWorkerToken:
          encoder.encodeStructPointer(DedicatedWorkerToken, val.dedicatedWorkerToken);
          break;
        case WebGPUExecutionContextToken.Tags.sharedWorkerToken:
          encoder.encodeStructPointer(SharedWorkerToken, val.sharedWorkerToken);
          break;
        case WebGPUExecutionContextToken.Tags.serviceWorkerToken:
          encoder.encodeStructPointer(ServiceWorkerToken, val.serviceWorkerToken);
          break;
      }
      encoder.align();
    };


    WebGPUExecutionContextToken.decode = function(decoder) {
      var size = decoder.readUint32();
      if (size == 0) {
        decoder.readUint32();
        decoder.readUint64();
        return null;
      }

      var result = new WebGPUExecutionContextToken();
      var tag = decoder.readUint32();
      switch (tag) {
        case WebGPUExecutionContextToken.Tags.documentToken:
          result.documentToken = decoder.decodeStructPointer(DocumentToken);
          break;
        case WebGPUExecutionContextToken.Tags.dedicatedWorkerToken:
          result.dedicatedWorkerToken = decoder.decodeStructPointer(DedicatedWorkerToken);
          break;
        case WebGPUExecutionContextToken.Tags.sharedWorkerToken:
          result.sharedWorkerToken = decoder.decodeStructPointer(SharedWorkerToken);
          break;
        case WebGPUExecutionContextToken.Tags.serviceWorkerToken:
          result.serviceWorkerToken = decoder.decodeStructPointer(ServiceWorkerToken);
          break;
      }
      decoder.align();

      return result;
    };


    WebGPUExecutionContextToken.validate = function(messageValidator, offset) {
      var size = messageValidator.decodeUnionSize(offset);
      if (size != 16) {
        return validator.validationError.INVALID_UNION_SIZE;
      }

      var tag = messageValidator.decodeUnionTag(offset);
      var data_offset = offset + 8;
      var err;
      switch (tag) {
        case WebGPUExecutionContextToken.Tags.documentToken:
          

    // validate WebGPUExecutionContextToken.documentToken
    err = messageValidator.validateStructPointer(data_offset, DocumentToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case WebGPUExecutionContextToken.Tags.dedicatedWorkerToken:
          

    // validate WebGPUExecutionContextToken.dedicatedWorkerToken
    err = messageValidator.validateStructPointer(data_offset, DedicatedWorkerToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case WebGPUExecutionContextToken.Tags.sharedWorkerToken:
          

    // validate WebGPUExecutionContextToken.sharedWorkerToken
    err = messageValidator.validateStructPointer(data_offset, SharedWorkerToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
        case WebGPUExecutionContextToken.Tags.serviceWorkerToken:
          

    // validate WebGPUExecutionContextToken.serviceWorkerToken
    err = messageValidator.validateStructPointer(data_offset, ServiceWorkerToken, false);
    if (err !== validator.validationError.NONE)
        return err;
          break;
      }

      return validator.validationError.NONE;
    };

  WebGPUExecutionContextToken.encodedSize = 16;
  exports.DocumentToken = DocumentToken;
  exports.LocalFrameToken = LocalFrameToken;
  exports.RemoteFrameToken = RemoteFrameToken;
  exports.DedicatedWorkerToken = DedicatedWorkerToken;
  exports.ServiceWorkerToken = ServiceWorkerToken;
  exports.SharedWorkerToken = SharedWorkerToken;
  exports.AnimationWorkletToken = AnimationWorkletToken;
  exports.AudioWorkletToken = AudioWorkletToken;
  exports.LayoutWorkletToken = LayoutWorkletToken;
  exports.PaintWorkletToken = PaintWorkletToken;
  exports.SharedStorageWorkletToken = SharedStorageWorkletToken;
  exports.ShadowRealmToken = ShadowRealmToken;
  exports.AttributionSrcToken = AttributionSrcToken;
  exports.SameDocNavigationScreenshotDestinationToken = SameDocNavigationScreenshotDestinationToken;
  exports.V8ContextToken = V8ContextToken;
  exports.ViewTransitionToken = ViewTransitionToken;
  exports.WebNNContextToken = WebNNContextToken;
  exports.WebNNPendingConstantToken = WebNNPendingConstantToken;
  exports.WebNNTensorToken = WebNNTensorToken;
  exports.FrameToken = FrameToken;
  exports.WorkerToken = WorkerToken;
  exports.WorkletToken = WorkletToken;
  exports.ExecutionContextToken = ExecutionContextToken;
  exports.WebGPUExecutionContextToken = WebGPUExecutionContextToken;
})();