// third_party/blink/public/mojom/timing/resource_timing.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_RESOURCE_TIMING_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_RESOURCE_TIMING_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/timing/resource_timing.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/fetch_api.mojom-shared.h"
#include "services/network/public/mojom/load_timing_info.mojom-shared.h"
#include "services/network/public/mojom/service_worker_router_info.mojom-shared.h"
#include "third_party/blink/public/mojom/fetch/fetch_api_request.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "third_party/blink/public/mojom/timing/resource_timing.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::CacheState, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ServerTimingInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ServerTimingInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ServerTimingInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in ServerTimingInfo struct");

      fragment->duration = Traits::duration(input);

      decltype(Traits::description(input)) in_description = Traits::description(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->description)::BaseType> description_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_description,
        description_fragment);

      fragment->description.Set(
          description_fragment.is_null() ? nullptr : description_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->description.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null description in ServerTimingInfo struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ResourceTimingInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ResourceTimingInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ResourceTimingInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::name(input)) in_name = Traits::name(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->name)::BaseType> name_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_name,
        name_fragment);

      fragment->name.Set(
          name_fragment.is_null() ? nullptr : name_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->name.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null name in ResourceTimingInfo struct");

      decltype(Traits::start_time(input)) in_start_time = Traits::start_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->start_time)::BaseType> start_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_start_time,
        start_time_fragment);

      fragment->start_time.Set(
          start_time_fragment.is_null() ? nullptr : start_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->start_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null start_time in ResourceTimingInfo struct");

      decltype(Traits::alpn_negotiated_protocol(input)) in_alpn_negotiated_protocol = Traits::alpn_negotiated_protocol(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->alpn_negotiated_protocol)::BaseType> alpn_negotiated_protocol_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_alpn_negotiated_protocol,
        alpn_negotiated_protocol_fragment);

      fragment->alpn_negotiated_protocol.Set(
          alpn_negotiated_protocol_fragment.is_null() ? nullptr : alpn_negotiated_protocol_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->alpn_negotiated_protocol.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null alpn_negotiated_protocol in ResourceTimingInfo struct");

      decltype(Traits::connection_info(input)) in_connection_info = Traits::connection_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->connection_info)::BaseType> connection_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_connection_info,
        connection_info_fragment);

      fragment->connection_info.Set(
          connection_info_fragment.is_null() ? nullptr : connection_info_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->connection_info.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null connection_info in ResourceTimingInfo struct");

      decltype(Traits::timing(input)) in_timing = Traits::timing(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->timing)::BaseType> timing_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::LoadTimingInfoDataView, send_validation>(
        in_timing,
        timing_fragment);

      fragment->timing.Set(
          timing_fragment.is_null() ? nullptr : timing_fragment.data());

      decltype(Traits::last_redirect_end_time(input)) in_last_redirect_end_time = Traits::last_redirect_end_time(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->last_redirect_end_time)::BaseType> last_redirect_end_time_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_last_redirect_end_time,
        last_redirect_end_time_fragment);

      fragment->last_redirect_end_time.Set(
          last_redirect_end_time_fragment.is_null() ? nullptr : last_redirect_end_time_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->last_redirect_end_time.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null last_redirect_end_time in ResourceTimingInfo struct");

      decltype(Traits::response_end(input)) in_response_end = Traits::response_end(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->response_end)::BaseType> response_end_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_response_end,
        response_end_fragment);

      fragment->response_end.Set(
          response_end_fragment.is_null() ? nullptr : response_end_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->response_end.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null response_end in ResourceTimingInfo struct");

      
      mojo::internal::Serialize<::blink::mojom::CacheState>(
        Traits::cache_state(input),
        &fragment->cache_state);

      fragment->encoded_body_size = Traits::encoded_body_size(input);

      fragment->decoded_body_size = Traits::decoded_body_size(input);

      fragment->did_reuse_connection = Traits::did_reuse_connection(input);

      fragment->is_secure_transport = Traits::is_secure_transport(input);

      fragment->allow_timing_details = Traits::allow_timing_details(input);

      fragment->allow_negative_values = Traits::allow_negative_values(input);

      decltype(Traits::server_timing(input)) in_server_timing = Traits::server_timing(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->server_timing)::BaseType>
          server_timing_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& server_timing_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::ServerTimingInfoDataView>, send_validation>(
        in_server_timing,
        server_timing_fragment,
        &server_timing_validate_params);

      fragment->server_timing.Set(
          server_timing_fragment.is_null() ? nullptr : server_timing_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->server_timing.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null server_timing in ResourceTimingInfo struct");

      fragment->render_blocking_status = Traits::render_blocking_status(input);

      fragment->response_status = Traits::response_status(input);

      decltype(Traits::content_type(input)) in_content_type = Traits::content_type(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content_type)::BaseType> content_type_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_content_type,
        content_type_fragment);

      fragment->content_type.Set(
          content_type_fragment.is_null() ? nullptr : content_type_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->content_type.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_type in ResourceTimingInfo struct");

      decltype(Traits::content_encoding(input)) in_content_encoding = Traits::content_encoding(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->content_encoding)::BaseType> content_encoding_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_content_encoding,
        content_encoding_fragment);

      fragment->content_encoding.Set(
          content_encoding_fragment.is_null() ? nullptr : content_encoding_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->content_encoding.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content_encoding in ResourceTimingInfo struct");

      decltype(Traits::initiator_url(input)) in_initiator_url = Traits::initiator_url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->initiator_url)::BaseType> initiator_url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_initiator_url,
        initiator_url_fragment);

      fragment->initiator_url.Set(
          initiator_url_fragment.is_null() ? nullptr : initiator_url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->initiator_url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null initiator_url in ResourceTimingInfo struct");

      decltype(Traits::service_worker_router_info(input)) in_service_worker_router_info = Traits::service_worker_router_info(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->service_worker_router_info)::BaseType> service_worker_router_info_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::ServiceWorkerRouterInfoDataView, send_validation>(
        in_service_worker_router_info,
        service_worker_router_info_fragment);

      fragment->service_worker_router_info.Set(
          service_worker_router_info_fragment.is_null() ? nullptr : service_worker_router_info_fragment.data());

      
      mojo::internal::Serialize<::network::mojom::FetchResponseSource>(
        Traits::service_worker_response_source(input),
        &fragment->service_worker_response_source);
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_TIMING_RESOURCE_TIMING_MOJOM_SEND_VALIDATION_H_