// third_party/blink/public/mojom/subapps/sub_apps_service.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/subapps/sub_apps_service.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/subapps/sub_apps_service.mojom-params-data.h"
#include "third_party/blink/public/mojom/subapps/sub_apps_service.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/subapps/sub_apps_service.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/subapps/sub_apps_service.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
SubAppsServiceAddParameters::SubAppsServiceAddParameters()
    : manifest_id_path(),
      install_url_path() {}

SubAppsServiceAddParameters::SubAppsServiceAddParameters(
    const ::blink::String& manifest_id_path_in,
    const ::blink::String& install_url_path_in)
    : manifest_id_path(std::move(manifest_id_path_in)),
      install_url_path(std::move(install_url_path_in)) {}

SubAppsServiceAddParameters::~SubAppsServiceAddParameters() = default;
size_t SubAppsServiceAddParameters::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->manifest_id_path);
  seed = mojo::internal::WTFHash(seed, this->install_url_path);
  return seed;
}

void SubAppsServiceAddParameters::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manifest_id_path"), this->manifest_id_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "install_url_path"), this->install_url_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SubAppsServiceAddParameters::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SubAppsServiceAddResult::SubAppsServiceAddResult()
    : manifest_id_path(),
      result_code() {}

SubAppsServiceAddResult::SubAppsServiceAddResult(
    const ::blink::String& manifest_id_path_in,
    SubAppsServiceResultCode result_code_in)
    : manifest_id_path(std::move(manifest_id_path_in)),
      result_code(std::move(result_code_in)) {}

SubAppsServiceAddResult::~SubAppsServiceAddResult() = default;
size_t SubAppsServiceAddResult::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->manifest_id_path);
  seed = mojo::internal::WTFHash(seed, this->result_code);
  return seed;
}

void SubAppsServiceAddResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manifest_id_path"), this->manifest_id_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "result_code"), this->result_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SubAppsServiceResultCode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SubAppsServiceAddResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SubAppsServiceListResult::SubAppsServiceListResult()
    : result_code(),
      sub_apps_list() {}

SubAppsServiceListResult::SubAppsServiceListResult(
    SubAppsServiceResultCode result_code_in,
    ::blink::Vector<SubAppsServiceListResultEntryPtr> sub_apps_list_in)
    : result_code(std::move(result_code_in)),
      sub_apps_list(std::move(sub_apps_list_in)) {}

SubAppsServiceListResult::~SubAppsServiceListResult() = default;

void SubAppsServiceListResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "result_code"), this->result_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SubAppsServiceResultCode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "sub_apps_list"), this->sub_apps_list,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<SubAppsServiceListResultEntryPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SubAppsServiceListResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SubAppsServiceListResultEntry::SubAppsServiceListResultEntry()
    : manifest_id_path(),
      app_name() {}

SubAppsServiceListResultEntry::SubAppsServiceListResultEntry(
    const ::blink::String& manifest_id_path_in,
    const ::blink::String& app_name_in)
    : manifest_id_path(std::move(manifest_id_path_in)),
      app_name(std::move(app_name_in)) {}

SubAppsServiceListResultEntry::~SubAppsServiceListResultEntry() = default;
size_t SubAppsServiceListResultEntry::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->manifest_id_path);
  seed = mojo::internal::WTFHash(seed, this->app_name);
  return seed;
}

void SubAppsServiceListResultEntry::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manifest_id_path"), this->manifest_id_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "app_name"), this->app_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SubAppsServiceListResultEntry::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SubAppsServiceRemoveResult::SubAppsServiceRemoveResult()
    : manifest_id_path(),
      result_code() {}

SubAppsServiceRemoveResult::SubAppsServiceRemoveResult(
    const ::blink::String& manifest_id_path_in,
    SubAppsServiceResultCode result_code_in)
    : manifest_id_path(std::move(manifest_id_path_in)),
      result_code(std::move(result_code_in)) {}

SubAppsServiceRemoveResult::~SubAppsServiceRemoveResult() = default;
size_t SubAppsServiceRemoveResult::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->manifest_id_path);
  seed = mojo::internal::WTFHash(seed, this->result_code);
  return seed;
}

void SubAppsServiceRemoveResult::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "manifest_id_path"), this->manifest_id_path,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "result_code"), this->result_code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type SubAppsServiceResultCode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool SubAppsServiceRemoveResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

SubAppsService::IPCStableHashFunction SubAppsService::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::SubAppsService>(message.name())) {
    case messages::SubAppsService::kAdd: {
      return &SubAppsService::Add_Sym::IPCStableHash;
    }
    case messages::SubAppsService::kList: {
      return &SubAppsService::List_Sym::IPCStableHash;
    }
    case messages::SubAppsService::kRemove: {
      return &SubAppsService::Remove_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* SubAppsService::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::SubAppsService>(message.name())) {
      case messages::SubAppsService::kAdd:
            return "Receive blink::mojom::SubAppsService::Add";
      case messages::SubAppsService::kList:
            return "Receive blink::mojom::SubAppsService::List";
      case messages::SubAppsService::kRemove:
            return "Receive blink::mojom::SubAppsService::Remove";
    }
  } else {
    switch (static_cast<messages::SubAppsService>(message.name())) {
      case messages::SubAppsService::kAdd:
            return "Receive reply blink::mojom::SubAppsService::Add";
      case messages::SubAppsService::kList:
            return "Receive reply blink::mojom::SubAppsService::List";
      case messages::SubAppsService::kRemove:
            return "Receive reply blink::mojom::SubAppsService::Remove";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t SubAppsService::Add_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6fd53f66;  // IPCStableHash for blink::mojom::SubAppsService::Add
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SubAppsService::List_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcbe2096b;  // IPCStableHash for blink::mojom::SubAppsService::List
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t SubAppsService::Remove_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x96e5d829;  // IPCStableHash for blink::mojom::SubAppsService::Remove
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class SubAppsService_Add_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SubAppsService_Add_ForwardToCallback(
      SubAppsService::AddCallback callback
      ) : callback_(std::move(callback)) {
  }

  SubAppsService_Add_ForwardToCallback(const SubAppsService_Add_ForwardToCallback&) = delete;
  SubAppsService_Add_ForwardToCallback& operator=(const SubAppsService_Add_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SubAppsService::AddCallback callback_;
};

class SubAppsService_List_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SubAppsService_List_ForwardToCallback(
      SubAppsService::ListCallback callback
      ) : callback_(std::move(callback)) {
  }

  SubAppsService_List_ForwardToCallback(const SubAppsService_List_ForwardToCallback&) = delete;
  SubAppsService_List_ForwardToCallback& operator=(const SubAppsService_List_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SubAppsService::ListCallback callback_;
};

class SubAppsService_Remove_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SubAppsService_Remove_ForwardToCallback(
      SubAppsService::RemoveCallback callback
      ) : callback_(std::move(callback)) {
  }

  SubAppsService_Remove_ForwardToCallback(const SubAppsService_Remove_ForwardToCallback&) = delete;
  SubAppsService_Remove_ForwardToCallback& operator=(const SubAppsService_Remove_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  SubAppsService::RemoveCallback callback_;
};

SubAppsServiceProxy::SubAppsServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SubAppsServiceProxy::Add(
    ::blink::Vector<SubAppsServiceAddParametersPtr> in_sub_apps_to_add, AddCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SubAppsService::Add", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("sub_apps_to_add"), in_sub_apps_to_add,
                        "<value of type ::blink::Vector<SubAppsServiceAddParametersPtr>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SubAppsService::kAdd), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SubAppsService_Add_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->sub_apps_to_add)::BaseType>
      sub_apps_to_add_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& sub_apps_to_add_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SubAppsServiceAddParametersDataView>>(
    in_sub_apps_to_add,
    sub_apps_to_add_fragment,
    &sub_apps_to_add_validate_params);

  params->sub_apps_to_add.Set(
      sub_apps_to_add_fragment.is_null() ? nullptr : sub_apps_to_add_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->sub_apps_to_add.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null sub_apps_to_add in SubAppsService.Add request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SubAppsService::Name_);
  message.set_method_name("Add");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SubAppsService_Add_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SubAppsServiceProxy::List(
    ListCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::SubAppsService::List");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SubAppsService::kList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SubAppsService_List_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SubAppsService::Name_);
  message.set_method_name("List");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SubAppsService_List_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void SubAppsServiceProxy::Remove(
    const ::blink::Vector<::blink::String>& in_manifest_id_paths, RemoveCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::SubAppsService::Remove", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("manifest_id_paths"), in_manifest_id_paths,
                        "<value of type const ::blink::Vector<::blink::String>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SubAppsService::kRemove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SubAppsService_Remove_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->manifest_id_paths)::BaseType>
      manifest_id_paths_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& manifest_id_paths_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
    in_manifest_id_paths,
    manifest_id_paths_fragment,
    &manifest_id_paths_validate_params);

  params->manifest_id_paths.Set(
      manifest_id_paths_fragment.is_null() ? nullptr : manifest_id_paths_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->manifest_id_paths.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null manifest_id_paths in SubAppsService.Remove request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SubAppsService::Name_);
  message.set_method_name("Remove");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SubAppsService_Remove_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class SubAppsService_Add_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SubAppsService::AddCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SubAppsService_Add_ProxyToResponder> proxy(
        new SubAppsService_Add_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SubAppsService_Add_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SubAppsService_Add_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SubAppsService_Add_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SubAppsService::AddCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<SubAppsServiceAddResultPtr> in_result);
};

bool SubAppsService_Add_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SubAppsService_Add_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SubAppsService_Add_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SubAppsService.0
  bool success = true;
  ::blink::Vector<SubAppsServiceAddResultPtr> p_result{};
  SubAppsService_Add_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SubAppsService::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void SubAppsService_Add_ProxyToResponder::Run(
    ::blink::Vector<SubAppsServiceAddResultPtr> in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SubAppsService::Add", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::Vector<SubAppsServiceAddResultPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SubAppsService::kAdd), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SubAppsService_Add_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType>
      result_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SubAppsServiceAddResultDataView>>(
    in_result,
    result_fragment,
    &result_validate_params);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SubAppsService::Name_);
  message.set_method_name("Add");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SubAppsService_List_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SubAppsService::ListCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SubAppsService_List_ProxyToResponder> proxy(
        new SubAppsService_List_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SubAppsService_List_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SubAppsService_List_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SubAppsService_List_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SubAppsService::ListCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      SubAppsServiceListResultPtr in_result);
};

bool SubAppsService_List_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SubAppsService_List_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SubAppsService_List_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SubAppsService.1
  bool success = true;
  SubAppsServiceListResultPtr p_result{};
  SubAppsService_List_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SubAppsService::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void SubAppsService_List_ProxyToResponder::Run(
    SubAppsServiceListResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SubAppsService::List", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type SubAppsServiceListResultPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SubAppsService::kList), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SubAppsService_List_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType> result_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::SubAppsServiceListResultDataView>(
    in_result,
    result_fragment);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SubAppsService::Name_);
  message.set_method_name("List");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class SubAppsService_Remove_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static SubAppsService::RemoveCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<SubAppsService_Remove_ProxyToResponder> proxy(
        new SubAppsService_Remove_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&SubAppsService_Remove_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SubAppsService_Remove_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  SubAppsService_Remove_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "SubAppsService::RemoveCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<SubAppsServiceRemoveResultPtr> in_result);
};

bool SubAppsService_Remove_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::SubAppsService_Remove_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SubAppsService_Remove_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for SubAppsService.2
  bool success = true;
  ::blink::Vector<SubAppsServiceRemoveResultPtr> p_result{};
  SubAppsService_Remove_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SubAppsService::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void SubAppsService_Remove_ProxyToResponder::Run(
    ::blink::Vector<SubAppsServiceRemoveResultPtr> in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::SubAppsService::Remove", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::blink::Vector<SubAppsServiceRemoveResultPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::SubAppsService::kRemove), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::SubAppsService_Remove_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->result)::BaseType>
      result_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::SubAppsServiceRemoveResultDataView>>(
    in_result,
    result_fragment,
    &result_validate_params);

  params->result.Set(
      result_fragment.is_null() ? nullptr : result_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SubAppsService::Name_);
  message.set_method_name("Remove");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SubAppsServiceStubDispatch::Accept(
    SubAppsService* impl,
    mojo::Message* message) {
  switch (static_cast<messages::SubAppsService>(message->header()->name)) {
    case messages::SubAppsService::kAdd: {
      break;
    }
    case messages::SubAppsService::kList: {
      break;
    }
    case messages::SubAppsService::kRemove: {
      break;
    }
  }
  return false;
}

// static
bool SubAppsServiceStubDispatch::AcceptWithResponder(
    SubAppsService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::SubAppsService>(message->header()->name)) {
    case messages::SubAppsService::kAdd: {
      internal::SubAppsService_Add_Params_Data* params =
          reinterpret_cast<
              internal::SubAppsService_Add_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SubAppsService.0
      bool success = true;
      ::blink::Vector<SubAppsServiceAddParametersPtr> p_sub_apps_to_add{};
      SubAppsService_Add_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSubAppsToAdd(&p_sub_apps_to_add))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SubAppsService::Name_, 0, false);
        return false;
      }
      auto callback =
          SubAppsService_Add_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Add(        
        std::move(p_sub_apps_to_add), std::move(callback));
      return true;
    }
    case messages::SubAppsService::kList: {
      internal::SubAppsService_List_Params_Data* params =
          reinterpret_cast<
              internal::SubAppsService_List_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SubAppsService.1
      bool success = true;
      SubAppsService_List_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SubAppsService::Name_, 1, false);
        return false;
      }
      auto callback =
          SubAppsService_List_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->List(std::move(callback));
      return true;
    }
    case messages::SubAppsService::kRemove: {
      internal::SubAppsService_Remove_Params_Data* params =
          reinterpret_cast<
              internal::SubAppsService_Remove_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for SubAppsService.2
      bool success = true;
      ::blink::Vector<::blink::String> p_manifest_id_paths{};
      SubAppsService_Remove_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadManifestIdPaths(&p_manifest_id_paths))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SubAppsService::Name_, 2, false);
        return false;
      }
      auto callback =
          SubAppsService_Remove_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Remove(        
        std::move(p_manifest_id_paths), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kSubAppsServiceValidationInfo[] = {
    { &internal::SubAppsService_Add_Params_Data::Validate,
     &internal::SubAppsService_Add_ResponseParams_Data::Validate},
    { &internal::SubAppsService_List_Params_Data::Validate,
     &internal::SubAppsService_List_ResponseParams_Data::Validate},
    { &internal::SubAppsService_Remove_Params_Data::Validate,
     &internal::SubAppsService_Remove_ResponseParams_Data::Validate},
};

bool SubAppsServiceRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::SubAppsService::Name_,
    kSubAppsServiceValidationInfo);
}

bool SubAppsServiceResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::SubAppsService::Name_,
    kSubAppsServiceValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::SubAppsServiceAddParameters::DataView, ::blink::mojom::blink::SubAppsServiceAddParametersPtr>::Read(
    ::blink::mojom::blink::SubAppsServiceAddParameters::DataView input,
    ::blink::mojom::blink::SubAppsServiceAddParametersPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SubAppsServiceAddParametersPtr result(::blink::mojom::blink::SubAppsServiceAddParameters::New());
  
      if (success && !input.ReadManifestIdPath(&result->manifest_id_path))
        success = false;
      if (success && !input.ReadInstallUrlPath(&result->install_url_path))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::SubAppsServiceAddResult::DataView, ::blink::mojom::blink::SubAppsServiceAddResultPtr>::Read(
    ::blink::mojom::blink::SubAppsServiceAddResult::DataView input,
    ::blink::mojom::blink::SubAppsServiceAddResultPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SubAppsServiceAddResultPtr result(::blink::mojom::blink::SubAppsServiceAddResult::New());
  
      if (success && !input.ReadManifestIdPath(&result->manifest_id_path))
        success = false;
      if (success && !input.ReadResultCode(&result->result_code))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::SubAppsServiceListResult::DataView, ::blink::mojom::blink::SubAppsServiceListResultPtr>::Read(
    ::blink::mojom::blink::SubAppsServiceListResult::DataView input,
    ::blink::mojom::blink::SubAppsServiceListResultPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SubAppsServiceListResultPtr result(::blink::mojom::blink::SubAppsServiceListResult::New());
  
      if (success && !input.ReadResultCode(&result->result_code))
        success = false;
      if (success && !input.ReadSubAppsList(&result->sub_apps_list))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::SubAppsServiceListResultEntry::DataView, ::blink::mojom::blink::SubAppsServiceListResultEntryPtr>::Read(
    ::blink::mojom::blink::SubAppsServiceListResultEntry::DataView input,
    ::blink::mojom::blink::SubAppsServiceListResultEntryPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SubAppsServiceListResultEntryPtr result(::blink::mojom::blink::SubAppsServiceListResultEntry::New());
  
      if (success && !input.ReadManifestIdPath(&result->manifest_id_path))
        success = false;
      if (success && !input.ReadAppName(&result->app_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::SubAppsServiceRemoveResult::DataView, ::blink::mojom::blink::SubAppsServiceRemoveResultPtr>::Read(
    ::blink::mojom::blink::SubAppsServiceRemoveResult::DataView input,
    ::blink::mojom::blink::SubAppsServiceRemoveResultPtr* output) {
  bool success = true;
  ::blink::mojom::blink::SubAppsServiceRemoveResultPtr result(::blink::mojom::blink::SubAppsServiceRemoveResult::New());
  
      if (success && !input.ReadManifestIdPath(&result->manifest_id_path))
        success = false;
      if (success && !input.ReadResultCode(&result->result_code))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void SubAppsServiceInterceptorForTesting::Add(::blink::Vector<SubAppsServiceAddParametersPtr> sub_apps_to_add, AddCallback callback) {
  GetForwardingInterface()->Add(
    std::move(sub_apps_to_add)
    , std::move(callback));
}
void SubAppsServiceInterceptorForTesting::List(ListCallback callback) {
  GetForwardingInterface()->List(std::move(callback));
}
void SubAppsServiceInterceptorForTesting::Remove(const ::blink::Vector<::blink::String>& manifest_id_paths, RemoveCallback callback) {
  GetForwardingInterface()->Remove(
    std::move(manifest_id_paths)
    , std::move(callback));
}
SubAppsServiceAsyncWaiter::SubAppsServiceAsyncWaiter(
    SubAppsService* proxy) : proxy_(proxy) {}

SubAppsServiceAsyncWaiter::~SubAppsServiceAsyncWaiter() = default;


void SubAppsServiceAsyncWaiter::Add(
    ::blink::Vector<SubAppsServiceAddParametersPtr> sub_apps_to_add, ::blink::Vector<SubAppsServiceAddResultPtr>* out_result) {
  base::RunLoop loop;
  proxy_->Add(
      std::move(sub_apps_to_add),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<SubAppsServiceAddResultPtr>* out_result
,
             ::blink::Vector<SubAppsServiceAddResultPtr> result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::Vector<SubAppsServiceAddResultPtr> SubAppsServiceAsyncWaiter::Add(
    ::blink::Vector<SubAppsServiceAddParametersPtr> sub_apps_to_add) {
  ::blink::Vector<SubAppsServiceAddResultPtr> async_wait_result;
  Add(std::move(sub_apps_to_add),&async_wait_result);
  return async_wait_result;
}

void SubAppsServiceAsyncWaiter::List(
    SubAppsServiceListResultPtr* out_result) {
  base::RunLoop loop;
  proxy_->List(
      base::BindOnce(
          [](base::RunLoop* loop,
             SubAppsServiceListResultPtr* out_result
,
             SubAppsServiceListResultPtr result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

SubAppsServiceListResultPtr SubAppsServiceAsyncWaiter::List(
    ) {
  SubAppsServiceListResultPtr async_wait_result;
  List(&async_wait_result);
  return async_wait_result;
}

void SubAppsServiceAsyncWaiter::Remove(
    const ::blink::Vector<::blink::String>& manifest_id_paths, ::blink::Vector<SubAppsServiceRemoveResultPtr>* out_result) {
  base::RunLoop loop;
  proxy_->Remove(
      std::move(manifest_id_paths),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<SubAppsServiceRemoveResultPtr>* out_result
,
             ::blink::Vector<SubAppsServiceRemoveResultPtr> result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

::blink::Vector<SubAppsServiceRemoveResultPtr> SubAppsServiceAsyncWaiter::Remove(
    const ::blink::Vector<::blink::String>& manifest_id_paths) {
  ::blink::Vector<SubAppsServiceRemoveResultPtr> async_wait_result;
  Remove(std::move(manifest_id_paths),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif