// third_party/blink/public/mojom/speech/speech_synthesis.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/speech/speech_synthesis.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');


  var SPEECH_SYNTHESIS_DEFAULT_RATE = 1.0;
  var SPEECH_SYNTHESIS_DEFAULT_PITCH = 1.0;
  var SPEECH_SYNTHESIS_DEFAULT_VOLUME = 1.0;
  var SPEECH_SYNTHESIS_DOUBLE_PREF_NOT_SET = -1.0;
  var SpeechSynthesisErrorCode = {};
  SpeechSynthesisErrorCode.kCancelled = 0;
  SpeechSynthesisErrorCode.kInterrupted = 1;
  SpeechSynthesisErrorCode.kErrorOccurred = 2;
  SpeechSynthesisErrorCode.kNoError = 3;
  SpeechSynthesisErrorCode.MIN_VALUE = 0;
  SpeechSynthesisErrorCode.MAX_VALUE = 3;

  SpeechSynthesisErrorCode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  SpeechSynthesisErrorCode.toKnownEnumValue = function(value) {
    return value;
  };

  SpeechSynthesisErrorCode.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function SpeechSynthesisUtterance(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechSynthesisUtterance.prototype.initDefaults_ = function() {
    this.text = null;
    this.lang = null;
    this.voice = null;
    this.volume = 0;
    this.rate = 0;
    this.pitch = 0;
  };
  SpeechSynthesisUtterance.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechSynthesisUtterance.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechSynthesisUtterance.text
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechSynthesisUtterance.lang
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechSynthesisUtterance.voice
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  SpeechSynthesisUtterance.encodedSize = codec.kStructHeaderSize + 48;

  SpeechSynthesisUtterance.decode = function(decoder) {
    var packed;
    var val = new SpeechSynthesisUtterance();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.text =
        decoder.decodeStruct(codec.String);
    val.lang =
        decoder.decodeStruct(codec.String);
    val.voice =
        decoder.decodeStruct(codec.String);
    val.volume =
        decoder.decodeStruct(codec.Double);
    val.rate =
        decoder.decodeStruct(codec.Double);
    val.pitch =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  SpeechSynthesisUtterance.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechSynthesisUtterance.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.text);
    encoder.encodeStruct(codec.String, val.lang);
    encoder.encodeStruct(codec.String, val.voice);
    encoder.encodeStruct(codec.Double, val.volume);
    encoder.encodeStruct(codec.Double, val.rate);
    encoder.encodeStruct(codec.Double, val.pitch);
  };
  function SpeechSynthesisVoice(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechSynthesisVoice.prototype.initDefaults_ = function() {
    this.voiceUri = null;
    this.name = null;
    this.lang = null;
    this.isLocalService = false;
    this.isDefault = false;
  };
  SpeechSynthesisVoice.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechSynthesisVoice.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechSynthesisVoice.voiceUri
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechSynthesisVoice.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechSynthesisVoice.lang
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  SpeechSynthesisVoice.encodedSize = codec.kStructHeaderSize + 32;

  SpeechSynthesisVoice.decode = function(decoder) {
    var packed;
    var val = new SpeechSynthesisVoice();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.voiceUri =
        decoder.decodeStruct(codec.String);
    val.name =
        decoder.decodeStruct(codec.String);
    val.lang =
        decoder.decodeStruct(codec.String);
    packed = decoder.readUint8();
    val.isLocalService = (packed >> 0) & 1 ? true : false;
    val.isDefault = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SpeechSynthesisVoice.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechSynthesisVoice.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.voiceUri);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.lang);
    packed = 0;
    packed |= (val.isLocalService & 1) << 0
    packed |= (val.isDefault & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params.prototype.initDefaults_ = function() {
    this.voiceList = null;
  };
  SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params.voiceList
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(SpeechSynthesisVoice), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.voiceList =
        decoder.decodeArrayPointer(new codec.PointerTo(SpeechSynthesisVoice));
    return val;
  };

  SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(SpeechSynthesisVoice), val.voiceList);
  };
  function SpeechSynthesisClient_OnStartedSpeaking_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechSynthesisClient_OnStartedSpeaking_Params.prototype.initDefaults_ = function() {
  };
  SpeechSynthesisClient_OnStartedSpeaking_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechSynthesisClient_OnStartedSpeaking_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechSynthesisClient_OnStartedSpeaking_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechSynthesisClient_OnStartedSpeaking_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechSynthesisClient_OnStartedSpeaking_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechSynthesisClient_OnStartedSpeaking_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechSynthesisClient_OnStartedSpeaking_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechSynthesisClient_OnFinishedSpeaking_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechSynthesisClient_OnFinishedSpeaking_Params.prototype.initDefaults_ = function() {
    this.errorCode = 0;
  };
  SpeechSynthesisClient_OnFinishedSpeaking_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechSynthesisClient_OnFinishedSpeaking_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechSynthesisClient_OnFinishedSpeaking_Params.errorCode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, SpeechSynthesisErrorCode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechSynthesisClient_OnFinishedSpeaking_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechSynthesisClient_OnFinishedSpeaking_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechSynthesisClient_OnFinishedSpeaking_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.errorCode =
        decoder.decodeStruct(new codec.Enum(SpeechSynthesisErrorCode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  SpeechSynthesisClient_OnFinishedSpeaking_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechSynthesisClient_OnFinishedSpeaking_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.errorCode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function SpeechSynthesisClient_OnPausedSpeaking_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechSynthesisClient_OnPausedSpeaking_Params.prototype.initDefaults_ = function() {
  };
  SpeechSynthesisClient_OnPausedSpeaking_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechSynthesisClient_OnPausedSpeaking_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechSynthesisClient_OnPausedSpeaking_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechSynthesisClient_OnPausedSpeaking_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechSynthesisClient_OnPausedSpeaking_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechSynthesisClient_OnPausedSpeaking_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechSynthesisClient_OnPausedSpeaking_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechSynthesisClient_OnResumedSpeaking_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechSynthesisClient_OnResumedSpeaking_Params.prototype.initDefaults_ = function() {
  };
  SpeechSynthesisClient_OnResumedSpeaking_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechSynthesisClient_OnResumedSpeaking_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechSynthesisClient_OnResumedSpeaking_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechSynthesisClient_OnResumedSpeaking_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechSynthesisClient_OnResumedSpeaking_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechSynthesisClient_OnResumedSpeaking_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechSynthesisClient_OnResumedSpeaking_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechSynthesisClient_OnEncounteredWordBoundary_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechSynthesisClient_OnEncounteredWordBoundary_Params.prototype.initDefaults_ = function() {
    this.charIndex = 0;
    this.charLength = 0;
  };
  SpeechSynthesisClient_OnEncounteredWordBoundary_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechSynthesisClient_OnEncounteredWordBoundary_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  SpeechSynthesisClient_OnEncounteredWordBoundary_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechSynthesisClient_OnEncounteredWordBoundary_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechSynthesisClient_OnEncounteredWordBoundary_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.charIndex =
        decoder.decodeStruct(codec.Uint32);
    val.charLength =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  SpeechSynthesisClient_OnEncounteredWordBoundary_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechSynthesisClient_OnEncounteredWordBoundary_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.charIndex);
    encoder.encodeStruct(codec.Uint32, val.charLength);
  };
  function SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params.prototype.initDefaults_ = function() {
    this.charIndex = 0;
    this.charLength = 0;
  };
  SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.charIndex =
        decoder.decodeStruct(codec.Uint32);
    val.charLength =
        decoder.decodeStruct(codec.Uint32);
    return val;
  };

  SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Uint32, val.charIndex);
    encoder.encodeStruct(codec.Uint32, val.charLength);
  };
  function SpeechSynthesisClient_OnEncounteredSpeakingError_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechSynthesisClient_OnEncounteredSpeakingError_Params.prototype.initDefaults_ = function() {
  };
  SpeechSynthesisClient_OnEncounteredSpeakingError_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechSynthesisClient_OnEncounteredSpeakingError_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechSynthesisClient_OnEncounteredSpeakingError_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechSynthesisClient_OnEncounteredSpeakingError_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechSynthesisClient_OnEncounteredSpeakingError_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechSynthesisClient_OnEncounteredSpeakingError_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechSynthesisClient_OnEncounteredSpeakingError_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechSynthesis_AddVoiceListObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechSynthesis_AddVoiceListObserver_Params.prototype.initDefaults_ = function() {
    this.observer = new SpeechSynthesisVoiceListObserverPtr();
  };
  SpeechSynthesis_AddVoiceListObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechSynthesis_AddVoiceListObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechSynthesis_AddVoiceListObserver_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechSynthesis_AddVoiceListObserver_Params.encodedSize = codec.kStructHeaderSize + 8;

  SpeechSynthesis_AddVoiceListObserver_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechSynthesis_AddVoiceListObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observer =
        decoder.decodeStruct(new codec.Interface(SpeechSynthesisVoiceListObserverPtr));
    return val;
  };

  SpeechSynthesis_AddVoiceListObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechSynthesis_AddVoiceListObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(SpeechSynthesisVoiceListObserverPtr), val.observer);
  };
  function SpeechSynthesis_Speak_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechSynthesis_Speak_Params.prototype.initDefaults_ = function() {
    this.utterance = null;
    this.client = new SpeechSynthesisClientPtr();
  };
  SpeechSynthesis_Speak_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechSynthesis_Speak_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechSynthesis_Speak_Params.utterance
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, SpeechSynthesisUtterance, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate SpeechSynthesis_Speak_Params.client
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechSynthesis_Speak_Params.encodedSize = codec.kStructHeaderSize + 16;

  SpeechSynthesis_Speak_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechSynthesis_Speak_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.utterance =
        decoder.decodeStructPointer(SpeechSynthesisUtterance);
    val.client =
        decoder.decodeStruct(new codec.Interface(SpeechSynthesisClientPtr));
    return val;
  };

  SpeechSynthesis_Speak_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechSynthesis_Speak_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(SpeechSynthesisUtterance, val.utterance);
    encoder.encodeStruct(new codec.Interface(SpeechSynthesisClientPtr), val.client);
  };
  function SpeechSynthesis_Pause_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechSynthesis_Pause_Params.prototype.initDefaults_ = function() {
  };
  SpeechSynthesis_Pause_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechSynthesis_Pause_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechSynthesis_Pause_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechSynthesis_Pause_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechSynthesis_Pause_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechSynthesis_Pause_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechSynthesis_Pause_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechSynthesis_Resume_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechSynthesis_Resume_Params.prototype.initDefaults_ = function() {
  };
  SpeechSynthesis_Resume_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechSynthesis_Resume_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechSynthesis_Resume_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechSynthesis_Resume_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechSynthesis_Resume_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechSynthesis_Resume_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechSynthesis_Resume_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function SpeechSynthesis_Cancel_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  SpeechSynthesis_Cancel_Params.prototype.initDefaults_ = function() {
  };
  SpeechSynthesis_Cancel_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  SpeechSynthesis_Cancel_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  SpeechSynthesis_Cancel_Params.encodedSize = codec.kStructHeaderSize + 0;

  SpeechSynthesis_Cancel_Params.decode = function(decoder) {
    var packed;
    var val = new SpeechSynthesis_Cancel_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  SpeechSynthesis_Cancel_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(SpeechSynthesis_Cancel_Params.encodedSize);
    encoder.writeUint32(0);
  };
  var kSpeechSynthesisVoiceListObserver_OnSetVoiceList_Name = 0;

  function SpeechSynthesisVoiceListObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SpeechSynthesisVoiceListObserver,
                                                   handleOrPtrInfo);
  }

  function SpeechSynthesisVoiceListObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SpeechSynthesisVoiceListObserver, associatedInterfacePtrInfo);
  }

  SpeechSynthesisVoiceListObserverAssociatedPtr.prototype =
      Object.create(SpeechSynthesisVoiceListObserverPtr.prototype);
  SpeechSynthesisVoiceListObserverAssociatedPtr.prototype.constructor =
      SpeechSynthesisVoiceListObserverAssociatedPtr;

  function SpeechSynthesisVoiceListObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  SpeechSynthesisVoiceListObserverPtr.prototype.onSetVoiceList = function() {
    return SpeechSynthesisVoiceListObserverProxy.prototype.onSetVoiceList
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechSynthesisVoiceListObserverProxy.prototype.onSetVoiceList = function(voiceList) {
    var params_ = new SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params();
    params_.voiceList = voiceList;
    var builder = new codec.MessageV0Builder(
        kSpeechSynthesisVoiceListObserver_OnSetVoiceList_Name,
        codec.align(SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params.encodedSize));
    builder.encodeStruct(SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SpeechSynthesisVoiceListObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  SpeechSynthesisVoiceListObserverStub.prototype.onSetVoiceList = function(voiceList) {
    return this.delegate_ && this.delegate_.onSetVoiceList && this.delegate_.onSetVoiceList(voiceList);
  }

  SpeechSynthesisVoiceListObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSpeechSynthesisVoiceListObserver_OnSetVoiceList_Name:
      var params = reader.decodeStruct(SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params);
      this.onSetVoiceList(params.voiceList);
      return true;
    default:
      return false;
    }
  };

  SpeechSynthesisVoiceListObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSpeechSynthesisVoiceListObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSpeechSynthesisVoiceListObserver_OnSetVoiceList_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechSynthesisVoiceListObserver_OnSetVoiceList_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSpeechSynthesisVoiceListObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SpeechSynthesisVoiceListObserver = {
    name: 'blink.mojom.SpeechSynthesisVoiceListObserver',
    kVersion: 0,
    ptrClass: SpeechSynthesisVoiceListObserverPtr,
    proxyClass: SpeechSynthesisVoiceListObserverProxy,
    stubClass: SpeechSynthesisVoiceListObserverStub,
    validateRequest: validateSpeechSynthesisVoiceListObserverRequest,
    validateResponse: null,
  };
  SpeechSynthesisVoiceListObserverStub.prototype.validator = validateSpeechSynthesisVoiceListObserverRequest;
  SpeechSynthesisVoiceListObserverProxy.prototype.validator = null;
  var kSpeechSynthesisClient_OnStartedSpeaking_Name = 0;
  var kSpeechSynthesisClient_OnFinishedSpeaking_Name = 1;
  var kSpeechSynthesisClient_OnPausedSpeaking_Name = 2;
  var kSpeechSynthesisClient_OnResumedSpeaking_Name = 3;
  var kSpeechSynthesisClient_OnEncounteredWordBoundary_Name = 4;
  var kSpeechSynthesisClient_OnEncounteredSentenceBoundary_Name = 5;
  var kSpeechSynthesisClient_OnEncounteredSpeakingError_Name = 6;

  function SpeechSynthesisClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SpeechSynthesisClient,
                                                   handleOrPtrInfo);
  }

  function SpeechSynthesisClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SpeechSynthesisClient, associatedInterfacePtrInfo);
  }

  SpeechSynthesisClientAssociatedPtr.prototype =
      Object.create(SpeechSynthesisClientPtr.prototype);
  SpeechSynthesisClientAssociatedPtr.prototype.constructor =
      SpeechSynthesisClientAssociatedPtr;

  function SpeechSynthesisClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  SpeechSynthesisClientPtr.prototype.onStartedSpeaking = function() {
    return SpeechSynthesisClientProxy.prototype.onStartedSpeaking
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechSynthesisClientProxy.prototype.onStartedSpeaking = function() {
    var params_ = new SpeechSynthesisClient_OnStartedSpeaking_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechSynthesisClient_OnStartedSpeaking_Name,
        codec.align(SpeechSynthesisClient_OnStartedSpeaking_Params.encodedSize));
    builder.encodeStruct(SpeechSynthesisClient_OnStartedSpeaking_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechSynthesisClientPtr.prototype.onFinishedSpeaking = function() {
    return SpeechSynthesisClientProxy.prototype.onFinishedSpeaking
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechSynthesisClientProxy.prototype.onFinishedSpeaking = function(errorCode) {
    var params_ = new SpeechSynthesisClient_OnFinishedSpeaking_Params();
    params_.errorCode = errorCode;
    var builder = new codec.MessageV0Builder(
        kSpeechSynthesisClient_OnFinishedSpeaking_Name,
        codec.align(SpeechSynthesisClient_OnFinishedSpeaking_Params.encodedSize));
    builder.encodeStruct(SpeechSynthesisClient_OnFinishedSpeaking_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechSynthesisClientPtr.prototype.onPausedSpeaking = function() {
    return SpeechSynthesisClientProxy.prototype.onPausedSpeaking
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechSynthesisClientProxy.prototype.onPausedSpeaking = function() {
    var params_ = new SpeechSynthesisClient_OnPausedSpeaking_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechSynthesisClient_OnPausedSpeaking_Name,
        codec.align(SpeechSynthesisClient_OnPausedSpeaking_Params.encodedSize));
    builder.encodeStruct(SpeechSynthesisClient_OnPausedSpeaking_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechSynthesisClientPtr.prototype.onResumedSpeaking = function() {
    return SpeechSynthesisClientProxy.prototype.onResumedSpeaking
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechSynthesisClientProxy.prototype.onResumedSpeaking = function() {
    var params_ = new SpeechSynthesisClient_OnResumedSpeaking_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechSynthesisClient_OnResumedSpeaking_Name,
        codec.align(SpeechSynthesisClient_OnResumedSpeaking_Params.encodedSize));
    builder.encodeStruct(SpeechSynthesisClient_OnResumedSpeaking_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechSynthesisClientPtr.prototype.onEncounteredWordBoundary = function() {
    return SpeechSynthesisClientProxy.prototype.onEncounteredWordBoundary
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechSynthesisClientProxy.prototype.onEncounteredWordBoundary = function(charIndex, charLength) {
    var params_ = new SpeechSynthesisClient_OnEncounteredWordBoundary_Params();
    params_.charIndex = charIndex;
    params_.charLength = charLength;
    var builder = new codec.MessageV0Builder(
        kSpeechSynthesisClient_OnEncounteredWordBoundary_Name,
        codec.align(SpeechSynthesisClient_OnEncounteredWordBoundary_Params.encodedSize));
    builder.encodeStruct(SpeechSynthesisClient_OnEncounteredWordBoundary_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechSynthesisClientPtr.prototype.onEncounteredSentenceBoundary = function() {
    return SpeechSynthesisClientProxy.prototype.onEncounteredSentenceBoundary
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechSynthesisClientProxy.prototype.onEncounteredSentenceBoundary = function(charIndex, charLength) {
    var params_ = new SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params();
    params_.charIndex = charIndex;
    params_.charLength = charLength;
    var builder = new codec.MessageV0Builder(
        kSpeechSynthesisClient_OnEncounteredSentenceBoundary_Name,
        codec.align(SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params.encodedSize));
    builder.encodeStruct(SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechSynthesisClientPtr.prototype.onEncounteredSpeakingError = function() {
    return SpeechSynthesisClientProxy.prototype.onEncounteredSpeakingError
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechSynthesisClientProxy.prototype.onEncounteredSpeakingError = function() {
    var params_ = new SpeechSynthesisClient_OnEncounteredSpeakingError_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechSynthesisClient_OnEncounteredSpeakingError_Name,
        codec.align(SpeechSynthesisClient_OnEncounteredSpeakingError_Params.encodedSize));
    builder.encodeStruct(SpeechSynthesisClient_OnEncounteredSpeakingError_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SpeechSynthesisClientStub(delegate) {
    this.delegate_ = delegate;
  }
  SpeechSynthesisClientStub.prototype.onStartedSpeaking = function() {
    return this.delegate_ && this.delegate_.onStartedSpeaking && this.delegate_.onStartedSpeaking();
  }
  SpeechSynthesisClientStub.prototype.onFinishedSpeaking = function(errorCode) {
    return this.delegate_ && this.delegate_.onFinishedSpeaking && this.delegate_.onFinishedSpeaking(errorCode);
  }
  SpeechSynthesisClientStub.prototype.onPausedSpeaking = function() {
    return this.delegate_ && this.delegate_.onPausedSpeaking && this.delegate_.onPausedSpeaking();
  }
  SpeechSynthesisClientStub.prototype.onResumedSpeaking = function() {
    return this.delegate_ && this.delegate_.onResumedSpeaking && this.delegate_.onResumedSpeaking();
  }
  SpeechSynthesisClientStub.prototype.onEncounteredWordBoundary = function(charIndex, charLength) {
    return this.delegate_ && this.delegate_.onEncounteredWordBoundary && this.delegate_.onEncounteredWordBoundary(charIndex, charLength);
  }
  SpeechSynthesisClientStub.prototype.onEncounteredSentenceBoundary = function(charIndex, charLength) {
    return this.delegate_ && this.delegate_.onEncounteredSentenceBoundary && this.delegate_.onEncounteredSentenceBoundary(charIndex, charLength);
  }
  SpeechSynthesisClientStub.prototype.onEncounteredSpeakingError = function() {
    return this.delegate_ && this.delegate_.onEncounteredSpeakingError && this.delegate_.onEncounteredSpeakingError();
  }

  SpeechSynthesisClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSpeechSynthesisClient_OnStartedSpeaking_Name:
      var params = reader.decodeStruct(SpeechSynthesisClient_OnStartedSpeaking_Params);
      this.onStartedSpeaking();
      return true;
    case kSpeechSynthesisClient_OnFinishedSpeaking_Name:
      var params = reader.decodeStruct(SpeechSynthesisClient_OnFinishedSpeaking_Params);
      this.onFinishedSpeaking(params.errorCode);
      return true;
    case kSpeechSynthesisClient_OnPausedSpeaking_Name:
      var params = reader.decodeStruct(SpeechSynthesisClient_OnPausedSpeaking_Params);
      this.onPausedSpeaking();
      return true;
    case kSpeechSynthesisClient_OnResumedSpeaking_Name:
      var params = reader.decodeStruct(SpeechSynthesisClient_OnResumedSpeaking_Params);
      this.onResumedSpeaking();
      return true;
    case kSpeechSynthesisClient_OnEncounteredWordBoundary_Name:
      var params = reader.decodeStruct(SpeechSynthesisClient_OnEncounteredWordBoundary_Params);
      this.onEncounteredWordBoundary(params.charIndex, params.charLength);
      return true;
    case kSpeechSynthesisClient_OnEncounteredSentenceBoundary_Name:
      var params = reader.decodeStruct(SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params);
      this.onEncounteredSentenceBoundary(params.charIndex, params.charLength);
      return true;
    case kSpeechSynthesisClient_OnEncounteredSpeakingError_Name:
      var params = reader.decodeStruct(SpeechSynthesisClient_OnEncounteredSpeakingError_Params);
      this.onEncounteredSpeakingError();
      return true;
    default:
      return false;
    }
  };

  SpeechSynthesisClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSpeechSynthesisClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSpeechSynthesisClient_OnStartedSpeaking_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechSynthesisClient_OnStartedSpeaking_Params;
      break;
      case kSpeechSynthesisClient_OnFinishedSpeaking_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechSynthesisClient_OnFinishedSpeaking_Params;
      break;
      case kSpeechSynthesisClient_OnPausedSpeaking_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechSynthesisClient_OnPausedSpeaking_Params;
      break;
      case kSpeechSynthesisClient_OnResumedSpeaking_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechSynthesisClient_OnResumedSpeaking_Params;
      break;
      case kSpeechSynthesisClient_OnEncounteredWordBoundary_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechSynthesisClient_OnEncounteredWordBoundary_Params;
      break;
      case kSpeechSynthesisClient_OnEncounteredSentenceBoundary_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechSynthesisClient_OnEncounteredSentenceBoundary_Params;
      break;
      case kSpeechSynthesisClient_OnEncounteredSpeakingError_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechSynthesisClient_OnEncounteredSpeakingError_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSpeechSynthesisClientResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SpeechSynthesisClient = {
    name: 'blink.mojom.SpeechSynthesisClient',
    kVersion: 0,
    ptrClass: SpeechSynthesisClientPtr,
    proxyClass: SpeechSynthesisClientProxy,
    stubClass: SpeechSynthesisClientStub,
    validateRequest: validateSpeechSynthesisClientRequest,
    validateResponse: null,
  };
  SpeechSynthesisClientStub.prototype.validator = validateSpeechSynthesisClientRequest;
  SpeechSynthesisClientProxy.prototype.validator = null;
  var kSpeechSynthesis_AddVoiceListObserver_Name = 0;
  var kSpeechSynthesis_Speak_Name = 1;
  var kSpeechSynthesis_Pause_Name = 2;
  var kSpeechSynthesis_Resume_Name = 3;
  var kSpeechSynthesis_Cancel_Name = 4;

  function SpeechSynthesisPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(SpeechSynthesis,
                                                   handleOrPtrInfo);
  }

  function SpeechSynthesisAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        SpeechSynthesis, associatedInterfacePtrInfo);
  }

  SpeechSynthesisAssociatedPtr.prototype =
      Object.create(SpeechSynthesisPtr.prototype);
  SpeechSynthesisAssociatedPtr.prototype.constructor =
      SpeechSynthesisAssociatedPtr;

  function SpeechSynthesisProxy(receiver) {
    this.receiver_ = receiver;
  }
  SpeechSynthesisPtr.prototype.addVoiceListObserver = function() {
    return SpeechSynthesisProxy.prototype.addVoiceListObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechSynthesisProxy.prototype.addVoiceListObserver = function(observer) {
    var params_ = new SpeechSynthesis_AddVoiceListObserver_Params();
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kSpeechSynthesis_AddVoiceListObserver_Name,
        codec.align(SpeechSynthesis_AddVoiceListObserver_Params.encodedSize));
    builder.encodeStruct(SpeechSynthesis_AddVoiceListObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechSynthesisPtr.prototype.speak = function() {
    return SpeechSynthesisProxy.prototype.speak
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechSynthesisProxy.prototype.speak = function(utterance, client) {
    var params_ = new SpeechSynthesis_Speak_Params();
    params_.utterance = utterance;
    params_.client = client;
    var builder = new codec.MessageV0Builder(
        kSpeechSynthesis_Speak_Name,
        codec.align(SpeechSynthesis_Speak_Params.encodedSize));
    builder.encodeStruct(SpeechSynthesis_Speak_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechSynthesisPtr.prototype.pause = function() {
    return SpeechSynthesisProxy.prototype.pause
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechSynthesisProxy.prototype.pause = function() {
    var params_ = new SpeechSynthesis_Pause_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechSynthesis_Pause_Name,
        codec.align(SpeechSynthesis_Pause_Params.encodedSize));
    builder.encodeStruct(SpeechSynthesis_Pause_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechSynthesisPtr.prototype.resume = function() {
    return SpeechSynthesisProxy.prototype.resume
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechSynthesisProxy.prototype.resume = function() {
    var params_ = new SpeechSynthesis_Resume_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechSynthesis_Resume_Name,
        codec.align(SpeechSynthesis_Resume_Params.encodedSize));
    builder.encodeStruct(SpeechSynthesis_Resume_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  SpeechSynthesisPtr.prototype.cancel = function() {
    return SpeechSynthesisProxy.prototype.cancel
        .apply(this.ptr.getProxy(), arguments);
  };

  SpeechSynthesisProxy.prototype.cancel = function() {
    var params_ = new SpeechSynthesis_Cancel_Params();
    var builder = new codec.MessageV0Builder(
        kSpeechSynthesis_Cancel_Name,
        codec.align(SpeechSynthesis_Cancel_Params.encodedSize));
    builder.encodeStruct(SpeechSynthesis_Cancel_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function SpeechSynthesisStub(delegate) {
    this.delegate_ = delegate;
  }
  SpeechSynthesisStub.prototype.addVoiceListObserver = function(observer) {
    return this.delegate_ && this.delegate_.addVoiceListObserver && this.delegate_.addVoiceListObserver(observer);
  }
  SpeechSynthesisStub.prototype.speak = function(utterance, client) {
    return this.delegate_ && this.delegate_.speak && this.delegate_.speak(utterance, client);
  }
  SpeechSynthesisStub.prototype.pause = function() {
    return this.delegate_ && this.delegate_.pause && this.delegate_.pause();
  }
  SpeechSynthesisStub.prototype.resume = function() {
    return this.delegate_ && this.delegate_.resume && this.delegate_.resume();
  }
  SpeechSynthesisStub.prototype.cancel = function() {
    return this.delegate_ && this.delegate_.cancel && this.delegate_.cancel();
  }

  SpeechSynthesisStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kSpeechSynthesis_AddVoiceListObserver_Name:
      var params = reader.decodeStruct(SpeechSynthesis_AddVoiceListObserver_Params);
      this.addVoiceListObserver(params.observer);
      return true;
    case kSpeechSynthesis_Speak_Name:
      var params = reader.decodeStruct(SpeechSynthesis_Speak_Params);
      this.speak(params.utterance, params.client);
      return true;
    case kSpeechSynthesis_Pause_Name:
      var params = reader.decodeStruct(SpeechSynthesis_Pause_Params);
      this.pause();
      return true;
    case kSpeechSynthesis_Resume_Name:
      var params = reader.decodeStruct(SpeechSynthesis_Resume_Params);
      this.resume();
      return true;
    case kSpeechSynthesis_Cancel_Name:
      var params = reader.decodeStruct(SpeechSynthesis_Cancel_Params);
      this.cancel();
      return true;
    default:
      return false;
    }
  };

  SpeechSynthesisStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateSpeechSynthesisRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kSpeechSynthesis_AddVoiceListObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechSynthesis_AddVoiceListObserver_Params;
      break;
      case kSpeechSynthesis_Speak_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechSynthesis_Speak_Params;
      break;
      case kSpeechSynthesis_Pause_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechSynthesis_Pause_Params;
      break;
      case kSpeechSynthesis_Resume_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechSynthesis_Resume_Params;
      break;
      case kSpeechSynthesis_Cancel_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = SpeechSynthesis_Cancel_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateSpeechSynthesisResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var SpeechSynthesis = {
    name: 'blink.mojom.SpeechSynthesis',
    kVersion: 0,
    ptrClass: SpeechSynthesisPtr,
    proxyClass: SpeechSynthesisProxy,
    stubClass: SpeechSynthesisStub,
    validateRequest: validateSpeechSynthesisRequest,
    validateResponse: null,
  };
  SpeechSynthesisStub.prototype.validator = validateSpeechSynthesisRequest;
  SpeechSynthesisProxy.prototype.validator = null;
  exports.SPEECH_SYNTHESIS_DEFAULT_RATE = SPEECH_SYNTHESIS_DEFAULT_RATE;
  exports.SPEECH_SYNTHESIS_DEFAULT_PITCH = SPEECH_SYNTHESIS_DEFAULT_PITCH;
  exports.SPEECH_SYNTHESIS_DEFAULT_VOLUME = SPEECH_SYNTHESIS_DEFAULT_VOLUME;
  exports.SPEECH_SYNTHESIS_DOUBLE_PREF_NOT_SET = SPEECH_SYNTHESIS_DOUBLE_PREF_NOT_SET;
  exports.SpeechSynthesisErrorCode = SpeechSynthesisErrorCode;
  exports.SpeechSynthesisUtterance = SpeechSynthesisUtterance;
  exports.SpeechSynthesisVoice = SpeechSynthesisVoice;
  exports.SpeechSynthesisVoiceListObserver = SpeechSynthesisVoiceListObserver;
  exports.SpeechSynthesisVoiceListObserverPtr = SpeechSynthesisVoiceListObserverPtr;
  exports.SpeechSynthesisVoiceListObserverAssociatedPtr = SpeechSynthesisVoiceListObserverAssociatedPtr;
  exports.SpeechSynthesisClient = SpeechSynthesisClient;
  exports.SpeechSynthesisClientPtr = SpeechSynthesisClientPtr;
  exports.SpeechSynthesisClientAssociatedPtr = SpeechSynthesisClientAssociatedPtr;
  exports.SpeechSynthesis = SpeechSynthesis;
  exports.SpeechSynthesisPtr = SpeechSynthesisPtr;
  exports.SpeechSynthesisAssociatedPtr = SpeechSynthesisAssociatedPtr;
})();