// third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* SpeculationActionToStringHelper(SpeculationAction value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SpeculationAction::kPrefetch:
      return "kPrefetch";
    case SpeculationAction::kPrefetchWithSubresources:
      return "kPrefetchWithSubresources";
    case SpeculationAction::kPrerender:
      return "kPrerender";
    case SpeculationAction::kPrerenderUntilScript:
      return "kPrerenderUntilScript";
    default:
      return nullptr;
  }
}

std::string SpeculationActionToString(SpeculationAction value) {
  const char *str = SpeculationActionToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SpeculationAction value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SpeculationAction value) {
  return os << SpeculationActionToString(value);
}

NOINLINE static const char* SpeculationTargetHintToStringHelper(SpeculationTargetHint value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SpeculationTargetHint::kNoHint:
      return "kNoHint";
    case SpeculationTargetHint::kBlank:
      return "kBlank";
    case SpeculationTargetHint::kSelf:
      return "kSelf";
    default:
      return nullptr;
  }
}

std::string SpeculationTargetHintToString(SpeculationTargetHint value) {
  const char *str = SpeculationTargetHintToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SpeculationTargetHint value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SpeculationTargetHint value) {
  return os << SpeculationTargetHintToString(value);
}

NOINLINE static const char* SpeculationEagernessToStringHelper(SpeculationEagerness value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SpeculationEagerness::kConservative:
      return "kConservative";
    case SpeculationEagerness::kModerate:
      return "kModerate";
    case SpeculationEagerness::kImmediate:
      return "kImmediate";
    case SpeculationEagerness::kEager:
      return "kEager";
    default:
      return nullptr;
  }
}

std::string SpeculationEagernessToString(SpeculationEagerness value) {
  const char *str = SpeculationEagernessToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SpeculationEagerness value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SpeculationEagerness value) {
  return os << SpeculationEagernessToString(value);
}

NOINLINE static const char* SpeculationInjectionTypeToStringHelper(SpeculationInjectionType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case SpeculationInjectionType::kNone:
      return "kNone";
    case SpeculationInjectionType::kMainWorldScript:
      return "kMainWorldScript";
    case SpeculationInjectionType::kIsolatedWorldScript:
      return "kIsolatedWorldScript";
    case SpeculationInjectionType::kAutoSpeculationRules:
      return "kAutoSpeculationRules";
    default:
      return nullptr;
  }
}

std::string SpeculationInjectionTypeToString(SpeculationInjectionType value) {
  const char *str = SpeculationInjectionTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown SpeculationInjectionType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, SpeculationInjectionType value) {
  return os << SpeculationInjectionTypeToString(value);
}

namespace internal {


// static
bool SpeculationCandidate_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeculationCandidate_Data* object =
      static_cast<const SpeculationCandidate_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::blink::mojom::internal::SpeculationAction_Data
        ::Validate(object->action, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referrer, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;


  if (!::blink::mojom::internal::SpeculationTargetHint_Data
        ::Validate(object->target_browsing_context_name_hint, validation_context))
    return false;


  if (!::blink::mojom::internal::SpeculationEagerness_Data
        ::Validate(object->eagerness, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->no_vary_search_hint, validation_context))
    return false;


  if (!::blink::mojom::internal::SpeculationInjectionType_Data
        ::Validate(object->injection_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->tags, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& tags_validate_params =
      mojo::internal::GetArrayValidator<0, true, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->tags, validation_context,
                                         &tags_validate_params)) {
    return false;
  }

  return true;
}

SpeculationCandidate_Data::SpeculationCandidate_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeculationHost_UpdateSpeculationCandidates_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeculationHost_UpdateSpeculationCandidates_Params_Data* object =
      static_cast<const SpeculationHost_UpdateSpeculationCandidates_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->candidates, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& candidates_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->candidates, validation_context,
                                         &candidates_validate_params)) {
    return false;
  }

  return true;
}

SpeculationHost_UpdateSpeculationCandidates_Params_Data::SpeculationHost_UpdateSpeculationCandidates_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeculationHost_OnLCPPredicted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeculationHost_OnLCPPredicted_Params_Data* object =
      static_cast<const SpeculationHost_OnLCPPredicted_Params_Data*>(data);

  return true;
}

SpeculationHost_OnLCPPredicted_Params_Data::SpeculationHost_OnLCPPredicted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SpeculationHost_InitiatePreview_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SpeculationHost_InitiatePreview_Params_Data* object =
      static_cast<const SpeculationHost_InitiatePreview_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

SpeculationHost_InitiatePreview_Params_Data::SpeculationHost_InitiatePreview_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::SpeculationAction>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::SpeculationAction value) {
  return std::move(context).WriteString(::blink::mojom::SpeculationActionToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::SpeculationTargetHint>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::SpeculationTargetHint value) {
  return std::move(context).WriteString(::blink::mojom::SpeculationTargetHintToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::SpeculationEagerness>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::SpeculationEagerness value) {
  return std::move(context).WriteString(::blink::mojom::SpeculationEagernessToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::SpeculationInjectionType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::SpeculationInjectionType value) {
  return std::move(context).WriteString(::blink::mojom::SpeculationInjectionTypeToString(value));
}

} // namespace perfetto