// third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPECULATION_RULES_SPECULATION_RULES_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPECULATION_RULES_SPECULATION_RULES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/speculation_rules/speculation_rules.mojom-blink-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/no_vary_search.mojom-blink.h"
#include "third_party/blink/public/mojom/loader/referrer.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class SpeculationHostProxy;

template <typename ImplRefTraits>
class SpeculationHostStub;

class SpeculationHostRequestValidator;


class PLATFORM_EXPORT SpeculationHost
    : public SpeculationHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.SpeculationHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = SpeculationHostInterfaceBase;
  using Proxy_ = SpeculationHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = SpeculationHostStub<ImplRefTraits>;

  using RequestValidator_ = SpeculationHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kUpdateSpeculationCandidatesMinVersion = 0,
    kOnLCPPredictedMinVersion = 0,
    kInitiatePreviewMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct UpdateSpeculationCandidates_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnLCPPredicted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct InitiatePreview_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~SpeculationHost() = default;

  virtual void UpdateSpeculationCandidates(::blink::Vector<SpeculationCandidatePtr> candidates, bool enable_cross_origin_prerender_iframes) = 0;

  virtual void OnLCPPredicted() = 0;

  virtual void InitiatePreview(const ::blink::KURL& url) = 0;
};



class PLATFORM_EXPORT SpeculationHostProxy
    : public SpeculationHost {
 public:
  using InterfaceType = SpeculationHost;

  explicit SpeculationHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void UpdateSpeculationCandidates(::blink::Vector<SpeculationCandidatePtr> candidates, bool enable_cross_origin_prerender_iframes) final;
  
  void OnLCPPredicted() final;
  
  void InitiatePreview(const ::blink::KURL& url) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT SpeculationHostStubDispatch {
 public:
  static bool Accept(SpeculationHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SpeculationHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SpeculationHost>>
class SpeculationHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SpeculationHostStub() = default;
  ~SpeculationHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeculationHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SpeculationHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT SpeculationHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class PLATFORM_EXPORT SpeculationCandidate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SpeculationCandidate, T>::value>;
  using DataView = SpeculationCandidateDataView;
  using Data_ = internal::SpeculationCandidate_Data;

  template <typename... Args>
  static SpeculationCandidatePtr New(Args&&... args) {
    return SpeculationCandidatePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SpeculationCandidatePtr From(const U& u) {
    return mojo::TypeConverter<SpeculationCandidatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SpeculationCandidate>::Convert(*this);
  }


  SpeculationCandidate();

  SpeculationCandidate(
      const ::blink::KURL& url,
      SpeculationAction action,
      ::blink::mojom::blink::ReferrerPtr referrer,
      bool requires_anonymous_client_ip_when_cross_origin,
      SpeculationTargetHint target_browsing_context_name_hint,
      SpeculationEagerness eagerness,
      ::network::mojom::blink::NoVarySearchPtr no_vary_search_hint,
      SpeculationInjectionType injection_type,
      ::blink::Vector<::blink::String> tags);

SpeculationCandidate(const SpeculationCandidate&) = delete;
SpeculationCandidate& operator=(const SpeculationCandidate&) = delete;

  ~SpeculationCandidate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SpeculationCandidatePtr>
  SpeculationCandidatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SpeculationCandidate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SpeculationCandidate::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SpeculationCandidate::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeculationCandidate::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SpeculationCandidate::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SpeculationCandidate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SpeculationCandidate_UnserializedMessageContext<
            UserType, SpeculationCandidate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SpeculationCandidate::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SpeculationCandidate::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SpeculationCandidate_UnserializedMessageContext<
            UserType, SpeculationCandidate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SpeculationCandidate::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::KURL url;
  
  SpeculationAction action;
  
  ::blink::mojom::blink::ReferrerPtr referrer;
  
  bool requires_anonymous_client_ip_when_cross_origin;
  
  SpeculationTargetHint target_browsing_context_name_hint;
  
  SpeculationEagerness eagerness;
  
  ::network::mojom::blink::NoVarySearchPtr no_vary_search_hint;
  
  SpeculationInjectionType injection_type;
  
  ::blink::Vector<::blink::String> tags;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SpeculationCandidate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SpeculationCandidate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SpeculationCandidate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SpeculationCandidate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SpeculationCandidatePtr SpeculationCandidate::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(action),
      mojo::Clone(referrer),
      mojo::Clone(requires_anonymous_client_ip_when_cross_origin),
      mojo::Clone(target_browsing_context_name_hint),
      mojo::Clone(eagerness),
      mojo::Clone(no_vary_search_hint),
      mojo::Clone(injection_type),
      mojo::Clone(tags)
  );
}

template <typename T, SpeculationCandidate::EnableIfSame<T>*>
bool SpeculationCandidate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->action, other_struct.action))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->requires_anonymous_client_ip_when_cross_origin, other_struct.requires_anonymous_client_ip_when_cross_origin))
    return false;
  if (!mojo::Equals(this->target_browsing_context_name_hint, other_struct.target_browsing_context_name_hint))
    return false;
  if (!mojo::Equals(this->eagerness, other_struct.eagerness))
    return false;
  if (!mojo::Equals(this->no_vary_search_hint, other_struct.no_vary_search_hint))
    return false;
  if (!mojo::Equals(this->injection_type, other_struct.injection_type))
    return false;
  if (!mojo::Equals(this->tags, other_struct.tags))
    return false;
  return true;
}

template <typename T, SpeculationCandidate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.action < rhs.action)
    return true;
  if (rhs.action < lhs.action)
    return false;
  if (lhs.referrer < rhs.referrer)
    return true;
  if (rhs.referrer < lhs.referrer)
    return false;
  if (lhs.requires_anonymous_client_ip_when_cross_origin < rhs.requires_anonymous_client_ip_when_cross_origin)
    return true;
  if (rhs.requires_anonymous_client_ip_when_cross_origin < lhs.requires_anonymous_client_ip_when_cross_origin)
    return false;
  if (lhs.target_browsing_context_name_hint < rhs.target_browsing_context_name_hint)
    return true;
  if (rhs.target_browsing_context_name_hint < lhs.target_browsing_context_name_hint)
    return false;
  if (lhs.eagerness < rhs.eagerness)
    return true;
  if (rhs.eagerness < lhs.eagerness)
    return false;
  if (lhs.no_vary_search_hint < rhs.no_vary_search_hint)
    return true;
  if (rhs.no_vary_search_hint < lhs.no_vary_search_hint)
    return false;
  if (lhs.injection_type < rhs.injection_type)
    return true;
  if (rhs.injection_type < lhs.injection_type)
    return false;
  if (lhs.tags < rhs.tags)
    return true;
  if (rhs.tags < lhs.tags)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::SpeculationCandidate::DataView,
                                         ::blink::mojom::blink::SpeculationCandidatePtr> {
  static bool IsNull(const ::blink::mojom::blink::SpeculationCandidatePtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::SpeculationCandidatePtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::SpeculationCandidate::url)& url(
      const ::blink::mojom::blink::SpeculationCandidatePtr& input) {
    return input->url;
  }

  static decltype(::blink::mojom::blink::SpeculationCandidate::action) action(
      const ::blink::mojom::blink::SpeculationCandidatePtr& input) {
    return input->action;
  }

  static const decltype(::blink::mojom::blink::SpeculationCandidate::referrer)& referrer(
      const ::blink::mojom::blink::SpeculationCandidatePtr& input) {
    return input->referrer;
  }

  static decltype(::blink::mojom::blink::SpeculationCandidate::requires_anonymous_client_ip_when_cross_origin) requires_anonymous_client_ip_when_cross_origin(
      const ::blink::mojom::blink::SpeculationCandidatePtr& input) {
    return input->requires_anonymous_client_ip_when_cross_origin;
  }

  static decltype(::blink::mojom::blink::SpeculationCandidate::target_browsing_context_name_hint) target_browsing_context_name_hint(
      const ::blink::mojom::blink::SpeculationCandidatePtr& input) {
    return input->target_browsing_context_name_hint;
  }

  static decltype(::blink::mojom::blink::SpeculationCandidate::eagerness) eagerness(
      const ::blink::mojom::blink::SpeculationCandidatePtr& input) {
    return input->eagerness;
  }

  static const decltype(::blink::mojom::blink::SpeculationCandidate::no_vary_search_hint)& no_vary_search_hint(
      const ::blink::mojom::blink::SpeculationCandidatePtr& input) {
    return input->no_vary_search_hint;
  }

  static decltype(::blink::mojom::blink::SpeculationCandidate::injection_type) injection_type(
      const ::blink::mojom::blink::SpeculationCandidatePtr& input) {
    return input->injection_type;
  }

  static const decltype(::blink::mojom::blink::SpeculationCandidate::tags)& tags(
      const ::blink::mojom::blink::SpeculationCandidatePtr& input) {
    return input->tags;
  }

  static bool Read(::blink::mojom::blink::SpeculationCandidate::DataView input, ::blink::mojom::blink::SpeculationCandidatePtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SPECULATION_RULES_SPECULATION_RULES_MOJOM_BLINK_H_