// third_party/blink/public/mojom/service_worker/service_worker_stream_handle.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/service_worker/service_worker_stream_handle.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_stream_handle.mojom-params-data.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_stream_handle.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_stream_handle.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_stream_handle.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
ServiceWorkerStreamHandle::ServiceWorkerStreamHandle()
    : stream(),
      callback_receiver() {}

ServiceWorkerStreamHandle::ServiceWorkerStreamHandle(
    ::mojo::ScopedDataPipeConsumerHandle stream_in,
    ::mojo::PendingReceiver<ServiceWorkerStreamCallback> callback_receiver_in)
    : stream(std::move(stream_in)),
      callback_receiver(std::move(callback_receiver_in)) {}

ServiceWorkerStreamHandle::~ServiceWorkerStreamHandle() = default;

void ServiceWorkerStreamHandle::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stream"), this->stream,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::ScopedDataPipeConsumerHandle>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "callback_receiver"), this->callback_receiver,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingReceiver<ServiceWorkerStreamCallback>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ServiceWorkerStreamHandle::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ServiceWorkerStreamCallback::IPCStableHashFunction ServiceWorkerStreamCallback::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ServiceWorkerStreamCallback>(message.name())) {
    case messages::ServiceWorkerStreamCallback::kOnCompleted: {
      return &ServiceWorkerStreamCallback::OnCompleted_Sym::IPCStableHash;
    }
    case messages::ServiceWorkerStreamCallback::kOnAborted: {
      return &ServiceWorkerStreamCallback::OnAborted_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ServiceWorkerStreamCallback::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ServiceWorkerStreamCallback>(message.name())) {
      case messages::ServiceWorkerStreamCallback::kOnCompleted:
            return "Receive blink::mojom::ServiceWorkerStreamCallback::OnCompleted";
      case messages::ServiceWorkerStreamCallback::kOnAborted:
            return "Receive blink::mojom::ServiceWorkerStreamCallback::OnAborted";
    }
  } else {
    switch (static_cast<messages::ServiceWorkerStreamCallback>(message.name())) {
      case messages::ServiceWorkerStreamCallback::kOnCompleted:
            return "Receive reply blink::mojom::ServiceWorkerStreamCallback::OnCompleted";
      case messages::ServiceWorkerStreamCallback::kOnAborted:
            return "Receive reply blink::mojom::ServiceWorkerStreamCallback::OnAborted";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ServiceWorkerStreamCallback::OnCompleted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x119ce27d;  // IPCStableHash for blink::mojom::ServiceWorkerStreamCallback::OnCompleted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ServiceWorkerStreamCallback::OnAborted_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xed52f365;  // IPCStableHash for blink::mojom::ServiceWorkerStreamCallback::OnAborted
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ServiceWorkerStreamCallbackProxy::ServiceWorkerStreamCallbackProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ServiceWorkerStreamCallbackProxy::OnCompleted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ServiceWorkerStreamCallback::OnCompleted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStreamCallback::kOnCompleted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerStreamCallback_OnCompleted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStreamCallback::Name_);
  message.set_method_name("OnCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ServiceWorkerStreamCallbackProxy::OnAborted(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::ServiceWorkerStreamCallback::OnAborted");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ServiceWorkerStreamCallback::kOnAborted), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::ServiceWorkerStreamCallback_OnAborted_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ServiceWorkerStreamCallback::Name_);
  message.set_method_name("OnAborted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ServiceWorkerStreamCallbackStubDispatch::Accept(
    ServiceWorkerStreamCallback* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ServiceWorkerStreamCallback>(message->header()->name)) {
    case messages::ServiceWorkerStreamCallback::kOnCompleted: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerStreamCallback_OnCompleted_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerStreamCallback_OnCompleted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerStreamCallback.0
      bool success = true;
      ServiceWorkerStreamCallback_OnCompleted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStreamCallback::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCompleted(        );
      return true;
    }
    case messages::ServiceWorkerStreamCallback::kOnAborted: {
      DCHECK(message->is_serialized());
      internal::ServiceWorkerStreamCallback_OnAborted_Params_Data* params =
          reinterpret_cast<internal::ServiceWorkerStreamCallback_OnAborted_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ServiceWorkerStreamCallback.1
      bool success = true;
      ServiceWorkerStreamCallback_OnAborted_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ServiceWorkerStreamCallback::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAborted(        );
      return true;
    }
  }
  return false;
}

// static
bool ServiceWorkerStreamCallbackStubDispatch::AcceptWithResponder(
    ServiceWorkerStreamCallback* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ServiceWorkerStreamCallback>(message->header()->name)) {
    case messages::ServiceWorkerStreamCallback::kOnCompleted: {
      break;
    }
    case messages::ServiceWorkerStreamCallback::kOnAborted: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kServiceWorkerStreamCallbackValidationInfo[] = {
    { &internal::ServiceWorkerStreamCallback_OnCompleted_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ServiceWorkerStreamCallback_OnAborted_Params_Data::Validate,
     nullptr /* no response */},
};

bool ServiceWorkerStreamCallbackRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::ServiceWorkerStreamCallback::Name_,
    kServiceWorkerStreamCallbackValidationInfo);
}



}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::ServiceWorkerStreamHandle::DataView, ::blink::mojom::blink::ServiceWorkerStreamHandlePtr>::Read(
    ::blink::mojom::blink::ServiceWorkerStreamHandle::DataView input,
    ::blink::mojom::blink::ServiceWorkerStreamHandlePtr* output) {
  bool success = true;
  ::blink::mojom::blink::ServiceWorkerStreamHandlePtr result(::blink::mojom::blink::ServiceWorkerStreamHandle::New());
  
      if (success)
        result->stream = input.TakeStream();
      if (success) {
        result->callback_receiver =
            input.TakeCallbackReceiver<decltype(result->callback_receiver)>();
      }
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void ServiceWorkerStreamCallbackInterceptorForTesting::OnCompleted() {
  GetForwardingInterface()->OnCompleted();
}
void ServiceWorkerStreamCallbackInterceptorForTesting::OnAborted() {
  GetForwardingInterface()->OnAborted();
}
ServiceWorkerStreamCallbackAsyncWaiter::ServiceWorkerStreamCallbackAsyncWaiter(
    ServiceWorkerStreamCallback* proxy) : proxy_(proxy) {}

ServiceWorkerStreamCallbackAsyncWaiter::~ServiceWorkerStreamCallbackAsyncWaiter() = default;







}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif