// third_party/blink/public/mojom/service_worker/service_worker_registration.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_REGISTRATION_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_REGISTRATION_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-forward.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/navigation_preload_state.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_database.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_error_type.mojom-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_object.mojom.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration_options.mojom-forward.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class ServiceWorkerRegistrationObjectHostProxy;

template <typename ImplRefTraits>
class ServiceWorkerRegistrationObjectHostStub;

class ServiceWorkerRegistrationObjectHostRequestValidator;
class ServiceWorkerRegistrationObjectHostResponseValidator;


class BLINK_COMMON_EXPORT ServiceWorkerRegistrationObjectHost
    : public ServiceWorkerRegistrationObjectHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ServiceWorkerRegistrationObjectHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServiceWorkerRegistrationObjectHostInterfaceBase;
  using Proxy_ = ServiceWorkerRegistrationObjectHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerRegistrationObjectHostStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerRegistrationObjectHostRequestValidator;
  using ResponseValidator_ = ServiceWorkerRegistrationObjectHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kUpdateMinVersion = 0,
    kUnregisterMinVersion = 0,
    kEnableNavigationPreloadMinVersion = 0,
    kGetNavigationPreloadStateMinVersion = 0,
    kSetNavigationPreloadHeaderMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Update_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Unregister_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableNavigationPreload_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetNavigationPreloadState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetNavigationPreloadHeader_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ServiceWorkerRegistrationObjectHost() = default;

  using UpdateCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerErrorType, const std::optional<std::string>&)>;
  using UpdateMojoCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerErrorType, const std::optional<std::string>&)>;

  virtual void Update(::blink::mojom::FetchClientSettingsObjectPtr outside_fetch_client_settings_object, UpdateCallback callback) = 0;

  using UnregisterCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerErrorType, const std::optional<std::string>&)>;
  using UnregisterMojoCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerErrorType, const std::optional<std::string>&)>;

  virtual void Unregister(UnregisterCallback callback) = 0;

  using EnableNavigationPreloadCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerErrorType, const std::optional<std::string>&)>;
  using EnableNavigationPreloadMojoCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerErrorType, const std::optional<std::string>&)>;

  virtual void EnableNavigationPreload(bool enable, EnableNavigationPreloadCallback callback) = 0;

  using GetNavigationPreloadStateCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerErrorType, const std::optional<std::string>&, ::blink::mojom::NavigationPreloadStatePtr)>;
  using GetNavigationPreloadStateMojoCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerErrorType, const std::optional<std::string>&, ::blink::mojom::NavigationPreloadStatePtr)>;

  virtual void GetNavigationPreloadState(GetNavigationPreloadStateCallback callback) = 0;

  using SetNavigationPreloadHeaderCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerErrorType, const std::optional<std::string>&)>;
  using SetNavigationPreloadHeaderMojoCallback = base::OnceCallback<void(::blink::mojom::ServiceWorkerErrorType, const std::optional<std::string>&)>;

  virtual void SetNavigationPreloadHeader(const std::string& value, SetNavigationPreloadHeaderCallback callback) = 0;
};

class ServiceWorkerRegistrationObjectProxy;

template <typename ImplRefTraits>
class ServiceWorkerRegistrationObjectStub;

class ServiceWorkerRegistrationObjectRequestValidator;


class BLINK_COMMON_EXPORT ServiceWorkerRegistrationObject
    : public ServiceWorkerRegistrationObjectInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.ServiceWorkerRegistrationObject";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ServiceWorkerRegistrationObjectInterfaceBase;
  using Proxy_ = ServiceWorkerRegistrationObjectProxy;

  template <typename ImplRefTraits>
  using Stub_ = ServiceWorkerRegistrationObjectStub<ImplRefTraits>;

  using RequestValidator_ = ServiceWorkerRegistrationObjectRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetServiceWorkerObjectsMinVersion = 0,
    kSetUpdateViaCacheMinVersion = 0,
    kUpdateFoundMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetServiceWorkerObjects_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUpdateViaCache_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateFound_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ServiceWorkerRegistrationObject() = default;

  virtual void SetServiceWorkerObjects(ChangedServiceWorkerObjectsMaskPtr changed_mask, ::blink::mojom::ServiceWorkerObjectInfoPtr installing, ::blink::mojom::ServiceWorkerObjectInfoPtr waiting, ::blink::mojom::ServiceWorkerObjectInfoPtr active) = 0;

  virtual void SetUpdateViaCache(::blink::mojom::ServiceWorkerUpdateViaCache update_via_cache) = 0;

  virtual void UpdateFound() = 0;
};



class BLINK_COMMON_EXPORT ServiceWorkerRegistrationObjectHostProxy
    : public ServiceWorkerRegistrationObjectHost {
 public:
  using InterfaceType = ServiceWorkerRegistrationObjectHost;

  explicit ServiceWorkerRegistrationObjectHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Update(::blink::mojom::FetchClientSettingsObjectPtr outside_fetch_client_settings_object, UpdateCallback callback) final;
  
  void Unregister(UnregisterCallback callback) final;
  
  void EnableNavigationPreload(bool enable, EnableNavigationPreloadCallback callback) final;
  
  void GetNavigationPreloadState(GetNavigationPreloadStateCallback callback) final;
  
  void SetNavigationPreloadHeader(const std::string& value, SetNavigationPreloadHeaderCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT ServiceWorkerRegistrationObjectProxy
    : public ServiceWorkerRegistrationObject {
 public:
  using InterfaceType = ServiceWorkerRegistrationObject;

  explicit ServiceWorkerRegistrationObjectProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetServiceWorkerObjects(ChangedServiceWorkerObjectsMaskPtr changed_mask, ::blink::mojom::ServiceWorkerObjectInfoPtr installing, ::blink::mojom::ServiceWorkerObjectInfoPtr waiting, ::blink::mojom::ServiceWorkerObjectInfoPtr active) final;
  
  void SetUpdateViaCache(::blink::mojom::ServiceWorkerUpdateViaCache update_via_cache) final;
  
  void UpdateFound() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT ServiceWorkerRegistrationObjectHostStubDispatch {
 public:
  static bool Accept(ServiceWorkerRegistrationObjectHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerRegistrationObjectHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerRegistrationObjectHost>>
class ServiceWorkerRegistrationObjectHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerRegistrationObjectHostStub() = default;
  ~ServiceWorkerRegistrationObjectHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerRegistrationObjectHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerRegistrationObjectHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ServiceWorkerRegistrationObjectStubDispatch {
 public:
  static bool Accept(ServiceWorkerRegistrationObject* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ServiceWorkerRegistrationObject* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ServiceWorkerRegistrationObject>>
class ServiceWorkerRegistrationObjectStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ServiceWorkerRegistrationObjectStub() = default;
  ~ServiceWorkerRegistrationObjectStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerRegistrationObjectStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ServiceWorkerRegistrationObjectStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT ServiceWorkerRegistrationObjectHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT ServiceWorkerRegistrationObjectRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT ServiceWorkerRegistrationObjectHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_COMMON_EXPORT ChangedServiceWorkerObjectsMask {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ChangedServiceWorkerObjectsMask, T>::value>;
  using DataView = ChangedServiceWorkerObjectsMaskDataView;
  using Data_ = internal::ChangedServiceWorkerObjectsMask_Data;

  template <typename... Args>
  static ChangedServiceWorkerObjectsMaskPtr New(Args&&... args) {
    return ChangedServiceWorkerObjectsMaskPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ChangedServiceWorkerObjectsMaskPtr From(const U& u) {
    return mojo::TypeConverter<ChangedServiceWorkerObjectsMaskPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ChangedServiceWorkerObjectsMask>::Convert(*this);
  }


  ChangedServiceWorkerObjectsMask();

  ChangedServiceWorkerObjectsMask(
      bool installing,
      bool waiting,
      bool active);


  ~ChangedServiceWorkerObjectsMask();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ChangedServiceWorkerObjectsMaskPtr>
  ChangedServiceWorkerObjectsMaskPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ChangedServiceWorkerObjectsMask::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ChangedServiceWorkerObjectsMask::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ChangedServiceWorkerObjectsMask::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChangedServiceWorkerObjectsMask::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChangedServiceWorkerObjectsMask::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ChangedServiceWorkerObjectsMask::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ChangedServiceWorkerObjectsMask_UnserializedMessageContext<
            UserType, ChangedServiceWorkerObjectsMask::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ChangedServiceWorkerObjectsMask::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ChangedServiceWorkerObjectsMask::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ChangedServiceWorkerObjectsMask_UnserializedMessageContext<
            UserType, ChangedServiceWorkerObjectsMask::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ChangedServiceWorkerObjectsMask::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool installing;
  
  bool waiting;
  
  bool active;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ChangedServiceWorkerObjectsMask::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ChangedServiceWorkerObjectsMask::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ChangedServiceWorkerObjectsMask::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ChangedServiceWorkerObjectsMask::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class BLINK_COMMON_EXPORT ServiceWorkerRegistrationObjectInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ServiceWorkerRegistrationObjectInfo, T>::value>;
  using DataView = ServiceWorkerRegistrationObjectInfoDataView;
  using Data_ = internal::ServiceWorkerRegistrationObjectInfo_Data;

  template <typename... Args>
  static ServiceWorkerRegistrationObjectInfoPtr New(Args&&... args) {
    return ServiceWorkerRegistrationObjectInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ServiceWorkerRegistrationObjectInfoPtr From(const U& u) {
    return mojo::TypeConverter<ServiceWorkerRegistrationObjectInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ServiceWorkerRegistrationObjectInfo>::Convert(*this);
  }


  ServiceWorkerRegistrationObjectInfo();

  ServiceWorkerRegistrationObjectInfo(
      int64_t registration_id,
      const ::GURL& scope,
      ::blink::mojom::ServiceWorkerUpdateViaCache update_via_cache,
      ::mojo::PendingAssociatedRemote<ServiceWorkerRegistrationObjectHost> host_remote,
      ::mojo::PendingAssociatedReceiver<ServiceWorkerRegistrationObject> receiver,
      ::blink::mojom::ServiceWorkerObjectInfoPtr installing,
      ::blink::mojom::ServiceWorkerObjectInfoPtr waiting,
      ::blink::mojom::ServiceWorkerObjectInfoPtr active);

ServiceWorkerRegistrationObjectInfo(const ServiceWorkerRegistrationObjectInfo&) = delete;
ServiceWorkerRegistrationObjectInfo& operator=(const ServiceWorkerRegistrationObjectInfo&) = delete;

  ~ServiceWorkerRegistrationObjectInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ServiceWorkerRegistrationObjectInfoPtr>
  ServiceWorkerRegistrationObjectInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ServiceWorkerRegistrationObjectInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ServiceWorkerRegistrationObjectInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ServiceWorkerRegistrationObjectInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ServiceWorkerRegistrationObjectInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ServiceWorkerRegistrationObjectInfo_UnserializedMessageContext<
            UserType, ServiceWorkerRegistrationObjectInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ServiceWorkerRegistrationObjectInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ServiceWorkerRegistrationObjectInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ServiceWorkerRegistrationObjectInfo_UnserializedMessageContext<
            UserType, ServiceWorkerRegistrationObjectInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ServiceWorkerRegistrationObjectInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t registration_id;
  
  ::GURL scope;
  
  ::blink::mojom::ServiceWorkerUpdateViaCache update_via_cache;
  
  ::mojo::PendingAssociatedRemote<ServiceWorkerRegistrationObjectHost> host_remote;
  
  ::mojo::PendingAssociatedReceiver<ServiceWorkerRegistrationObject> receiver;
  
  ::blink::mojom::ServiceWorkerObjectInfoPtr installing;
  
  ::blink::mojom::ServiceWorkerObjectInfoPtr waiting;
  
  ::blink::mojom::ServiceWorkerObjectInfoPtr active;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ServiceWorkerRegistrationObjectInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ServiceWorkerRegistrationObjectInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ServiceWorkerRegistrationObjectInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ServiceWorkerRegistrationObjectInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ChangedServiceWorkerObjectsMaskPtr ChangedServiceWorkerObjectsMask::Clone() const {
  return New(
      mojo::Clone(installing),
      mojo::Clone(waiting),
      mojo::Clone(active)
  );
}

template <typename T, ChangedServiceWorkerObjectsMask::EnableIfSame<T>*>
bool ChangedServiceWorkerObjectsMask::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->installing, other_struct.installing))
    return false;
  if (!mojo::Equals(this->waiting, other_struct.waiting))
    return false;
  if (!mojo::Equals(this->active, other_struct.active))
    return false;
  return true;
}

template <typename T, ChangedServiceWorkerObjectsMask::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.installing < rhs.installing)
    return true;
  if (rhs.installing < lhs.installing)
    return false;
  if (lhs.waiting < rhs.waiting)
    return true;
  if (rhs.waiting < lhs.waiting)
    return false;
  if (lhs.active < rhs.active)
    return true;
  if (rhs.active < lhs.active)
    return false;
  return false;
}
template <typename StructPtrType>
ServiceWorkerRegistrationObjectInfoPtr ServiceWorkerRegistrationObjectInfo::Clone() const {
  return New(
      mojo::Clone(registration_id),
      mojo::Clone(scope),
      mojo::Clone(update_via_cache),
      mojo::Clone(host_remote),
      mojo::Clone(receiver),
      mojo::Clone(installing),
      mojo::Clone(waiting),
      mojo::Clone(active)
  );
}

template <typename T, ServiceWorkerRegistrationObjectInfo::EnableIfSame<T>*>
bool ServiceWorkerRegistrationObjectInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->registration_id, other_struct.registration_id))
    return false;
  if (!mojo::Equals(this->scope, other_struct.scope))
    return false;
  if (!mojo::Equals(this->update_via_cache, other_struct.update_via_cache))
    return false;
  if (!mojo::Equals(this->host_remote, other_struct.host_remote))
    return false;
  if (!mojo::Equals(this->receiver, other_struct.receiver))
    return false;
  if (!mojo::Equals(this->installing, other_struct.installing))
    return false;
  if (!mojo::Equals(this->waiting, other_struct.waiting))
    return false;
  if (!mojo::Equals(this->active, other_struct.active))
    return false;
  return true;
}

template <typename T, ServiceWorkerRegistrationObjectInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.registration_id < rhs.registration_id)
    return true;
  if (rhs.registration_id < lhs.registration_id)
    return false;
  if (lhs.scope < rhs.scope)
    return true;
  if (rhs.scope < lhs.scope)
    return false;
  if (lhs.update_via_cache < rhs.update_via_cache)
    return true;
  if (rhs.update_via_cache < lhs.update_via_cache)
    return false;
  if (lhs.host_remote < rhs.host_remote)
    return true;
  if (rhs.host_remote < lhs.host_remote)
    return false;
  if (lhs.receiver < rhs.receiver)
    return true;
  if (rhs.receiver < lhs.receiver)
    return false;
  if (lhs.installing < rhs.installing)
    return true;
  if (rhs.installing < lhs.installing)
    return false;
  if (lhs.waiting < rhs.waiting)
    return true;
  if (rhs.waiting < lhs.waiting)
    return false;
  if (lhs.active < rhs.active)
    return true;
  if (rhs.active < lhs.active)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ChangedServiceWorkerObjectsMask::DataView,
                                         ::blink::mojom::ChangedServiceWorkerObjectsMaskPtr> {
  static bool IsNull(const ::blink::mojom::ChangedServiceWorkerObjectsMaskPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ChangedServiceWorkerObjectsMaskPtr* output) { output->reset(); }

  static decltype(::blink::mojom::ChangedServiceWorkerObjectsMask::installing) installing(
      const ::blink::mojom::ChangedServiceWorkerObjectsMaskPtr& input) {
    return input->installing;
  }

  static decltype(::blink::mojom::ChangedServiceWorkerObjectsMask::waiting) waiting(
      const ::blink::mojom::ChangedServiceWorkerObjectsMaskPtr& input) {
    return input->waiting;
  }

  static decltype(::blink::mojom::ChangedServiceWorkerObjectsMask::active) active(
      const ::blink::mojom::ChangedServiceWorkerObjectsMaskPtr& input) {
    return input->active;
  }

  static bool Read(::blink::mojom::ChangedServiceWorkerObjectsMask::DataView input, ::blink::mojom::ChangedServiceWorkerObjectsMaskPtr* output);
};


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::ServiceWorkerRegistrationObjectInfo::DataView,
                                         ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr> {
  static bool IsNull(const ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr* output) { output->reset(); }

  static decltype(::blink::mojom::ServiceWorkerRegistrationObjectInfo::registration_id) registration_id(
      const ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr& input) {
    return input->registration_id;
  }

  static const decltype(::blink::mojom::ServiceWorkerRegistrationObjectInfo::scope)& scope(
      const ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr& input) {
    return input->scope;
  }

  static decltype(::blink::mojom::ServiceWorkerRegistrationObjectInfo::update_via_cache) update_via_cache(
      const ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr& input) {
    return input->update_via_cache;
  }

  static  decltype(::blink::mojom::ServiceWorkerRegistrationObjectInfo::host_remote)& host_remote(
       ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr& input) {
    return input->host_remote;
  }

  static  decltype(::blink::mojom::ServiceWorkerRegistrationObjectInfo::receiver)& receiver(
       ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr& input) {
    return input->receiver;
  }

  static  decltype(::blink::mojom::ServiceWorkerRegistrationObjectInfo::installing)& installing(
       ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr& input) {
    return input->installing;
  }

  static  decltype(::blink::mojom::ServiceWorkerRegistrationObjectInfo::waiting)& waiting(
       ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr& input) {
    return input->waiting;
  }

  static  decltype(::blink::mojom::ServiceWorkerRegistrationObjectInfo::active)& active(
       ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr& input) {
    return input->active;
  }

  static bool Read(::blink::mojom::ServiceWorkerRegistrationObjectInfo::DataView input, ::blink::mojom::ServiceWorkerRegistrationObjectInfoPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_SERVICE_WORKER_REGISTRATION_MOJOM_H_