// third_party/blink/public/mojom/service_worker/embedded_worker.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_EMBEDDED_WORKER_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_EMBEDDED_WORKER_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/service_worker/embedded_worker.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/embedded_worker.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/service_worker/embedded_worker.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink.h"
#include "services/network/public/mojom/url_loader_factory.mojom-blink-forward.h"
#include "services/service_manager/public/mojom/interface_provider.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/devtools/console_message.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/devtools/devtools_agent.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/frame/policy_container.mojom-blink.h"
#include "third_party/blink/public/mojom/frame/reporting_observer.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/fingerprinting_protection/noise_token.mojom-blink.h"
#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-blink.h"
#include "third_party/blink/public/mojom/loader/url_loader_factory_bundle.mojom-blink.h"
#include "third_party/blink/public/mojom/renderer_preference_watcher.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom-blink.h"
#include "third_party/blink/public/mojom/script/script_type.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/fingerprinting_protection/canvas_interventions.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/controller_service_worker.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_event_status.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_fetch_handler_type.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_installed_scripts_manager.mojom-blink.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_provider.mojom-blink.h"
#include "third_party/blink/public/mojom/service_worker/service_worker_registration.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-blink.h"
#include "third_party/blink/public/mojom/use_counter/metrics/web_feature.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom-blink.h"
#include "third_party/blink/public/mojom/worker/subresource_loader_updater.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/worker/worker_content_settings_proxy.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/worker/worker_main_script_load_params.mojom-blink.h"
#include "third_party/blink/public/mojom/storage_key/storage_key.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "mojo/public/cpp/bindings/lib/native_enum_serialization.h"
#include "mojo/public/cpp/bindings/lib/native_struct_serialization.h"
#include "third_party/blink/renderer/core/core_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class EmbeddedWorkerInstanceClientProxy;

template <typename ImplRefTraits>
class EmbeddedWorkerInstanceClientStub;

class EmbeddedWorkerInstanceClientRequestValidator;


class CORE_EXPORT EmbeddedWorkerInstanceClient
    : public EmbeddedWorkerInstanceClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.EmbeddedWorkerInstanceClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = true;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = EmbeddedWorkerInstanceClientInterfaceBase;
  using Proxy_ = EmbeddedWorkerInstanceClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = EmbeddedWorkerInstanceClientStub<ImplRefTraits>;

  using RequestValidator_ = EmbeddedWorkerInstanceClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kStartWorkerMinVersion = 0,
    kStopWorkerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct StartWorker_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StopWorker_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~EmbeddedWorkerInstanceClient() = default;

  virtual void StartWorker(EmbeddedWorkerStartParamsPtr params) = 0;

  virtual void StopWorker() = 0;
};

class EmbeddedWorkerInstanceHostProxy;

template <typename ImplRefTraits>
class EmbeddedWorkerInstanceHostStub;

class EmbeddedWorkerInstanceHostRequestValidator;
class EmbeddedWorkerInstanceHostResponseValidator;


class CORE_EXPORT EmbeddedWorkerInstanceHost
    : public EmbeddedWorkerInstanceHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.EmbeddedWorkerInstanceHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = EmbeddedWorkerInstanceHostInterfaceBase;
  using Proxy_ = EmbeddedWorkerInstanceHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = EmbeddedWorkerInstanceHostStub<ImplRefTraits>;

  using RequestValidator_ = EmbeddedWorkerInstanceHostRequestValidator;
  using ResponseValidator_ = EmbeddedWorkerInstanceHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestTerminationMinVersion = 0,
    kCountFeatureMinVersion = 0,
    kOnReadyForInspectionMinVersion = 0,
    kOnScriptLoadedMinVersion = 0,
    kOnScriptEvaluationStartMinVersion = 0,
    kOnStartedMinVersion = 0,
    kOnReportExceptionMinVersion = 0,
    kOnReportConsoleMessageMinVersion = 0,
    kOnStoppedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestTermination_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CountFeature_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnReadyForInspection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnScriptLoaded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnScriptEvaluationStart_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnStarted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnReportException_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnReportConsoleMessage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnStopped_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~EmbeddedWorkerInstanceHost() = default;

  using RequestTerminationCallback = base::OnceCallback<void(bool)>;
  using RequestTerminationMojoCallback = base::OnceCallback<void(bool)>;

  virtual void RequestTermination(RequestTerminationCallback callback) = 0;

  virtual void CountFeature(::blink::mojom::blink::WebFeature feature) = 0;

  virtual void OnReadyForInspection(::mojo::PendingRemote<::blink::mojom::blink::DevToolsAgent> agent, ::mojo::PendingReceiver<::blink::mojom::blink::DevToolsAgentHost> agent_host) = 0;

  virtual void OnScriptLoaded() = 0;

  virtual void OnScriptEvaluationStart() = 0;

  virtual void OnStarted(::blink::mojom::blink::ServiceWorkerStartStatus status, ::blink::mojom::blink::ServiceWorkerFetchHandlerType fetch_handler_type, bool has_hid_event_handlers, bool has_usb_event_handlers, int32_t thread_id, EmbeddedWorkerStartTimingPtr start_timing) = 0;

  virtual void OnReportException(const ::blink::String& error_message, int32_t line_number, int32_t column_number, const ::blink::KURL& source_url) = 0;

  virtual void OnReportConsoleMessage(::blink::mojom::blink::ConsoleMessageSource source, ::blink::mojom::blink::ConsoleMessageLevel message_level, const ::blink::String& message, int32_t line_number, const ::blink::KURL& source_url) = 0;

  virtual void OnStopped() = 0;
};



class CORE_EXPORT EmbeddedWorkerInstanceClientProxy
    : public EmbeddedWorkerInstanceClient {
 public:
  using InterfaceType = EmbeddedWorkerInstanceClient;

  explicit EmbeddedWorkerInstanceClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void StartWorker(EmbeddedWorkerStartParamsPtr params) final;
  
  void StopWorker() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CORE_EXPORT EmbeddedWorkerInstanceHostProxy
    : public EmbeddedWorkerInstanceHost {
 public:
  using InterfaceType = EmbeddedWorkerInstanceHost;

  explicit EmbeddedWorkerInstanceHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestTermination(RequestTerminationCallback callback) final;
  
  void CountFeature(::blink::mojom::blink::WebFeature feature) final;
  
  void OnReadyForInspection(::mojo::PendingRemote<::blink::mojom::blink::DevToolsAgent> agent, ::mojo::PendingReceiver<::blink::mojom::blink::DevToolsAgentHost> agent_host) final;
  
  void OnScriptLoaded() final;
  
  void OnScriptEvaluationStart() final;
  
  void OnStarted(::blink::mojom::blink::ServiceWorkerStartStatus status, ::blink::mojom::blink::ServiceWorkerFetchHandlerType fetch_handler_type, bool has_hid_event_handlers, bool has_usb_event_handlers, int32_t thread_id, EmbeddedWorkerStartTimingPtr start_timing) final;
  
  void OnReportException(const ::blink::String& error_message, int32_t line_number, int32_t column_number, const ::blink::KURL& source_url) final;
  
  void OnReportConsoleMessage(::blink::mojom::blink::ConsoleMessageSource source, ::blink::mojom::blink::ConsoleMessageLevel message_level, const ::blink::String& message, int32_t line_number, const ::blink::KURL& source_url) final;
  
  void OnStopped() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CORE_EXPORT EmbeddedWorkerInstanceClientStubDispatch {
 public:
  static bool Accept(EmbeddedWorkerInstanceClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      EmbeddedWorkerInstanceClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<EmbeddedWorkerInstanceClient>>
class EmbeddedWorkerInstanceClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  EmbeddedWorkerInstanceClientStub() = default;
  ~EmbeddedWorkerInstanceClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedWorkerInstanceClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedWorkerInstanceClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT EmbeddedWorkerInstanceHostStubDispatch {
 public:
  static bool Accept(EmbeddedWorkerInstanceHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      EmbeddedWorkerInstanceHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<EmbeddedWorkerInstanceHost>>
class EmbeddedWorkerInstanceHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  EmbeddedWorkerInstanceHostStub() = default;
  ~EmbeddedWorkerInstanceHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedWorkerInstanceHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return EmbeddedWorkerInstanceHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CORE_EXPORT EmbeddedWorkerInstanceClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT EmbeddedWorkerInstanceHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CORE_EXPORT EmbeddedWorkerInstanceHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class CORE_EXPORT EmbeddedWorkerStartParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EmbeddedWorkerStartParams, T>::value>;
  using DataView = EmbeddedWorkerStartParamsDataView;
  using Data_ = internal::EmbeddedWorkerStartParams_Data;

  template <typename... Args>
  static EmbeddedWorkerStartParamsPtr New(Args&&... args) {
    return EmbeddedWorkerStartParamsPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EmbeddedWorkerStartParamsPtr From(const U& u) {
    return mojo::TypeConverter<EmbeddedWorkerStartParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EmbeddedWorkerStartParams>::Convert(*this);
  }


  EmbeddedWorkerStartParams();

  EmbeddedWorkerStartParams(
      int64_t service_worker_version_id,
      const ::blink::KURL& scope,
      const ::blink::KURL& script_url,
      ::blink::mojom::blink::ScriptType script_type,
      ::blink::mojom::blink::FetchClientSettingsObjectPtr outside_fetch_client_settings_object,
      const ::blink::String& user_agent,
      ::blink::mojom::blink::UserAgentMetadataPtr ua_metadata,
      int32_t service_worker_route_id,
      const ::base::UnguessableToken& devtools_worker_token,
      const ::blink::KURL& script_url_to_skip_throttling,
      bool wait_for_debugger,
      bool is_installed,
      const ::blink::RendererPreferences& renderer_preferences,
      ::blink::Vector<::blink::String> forced_enabled_runtime_features,
      ::mojo::PendingReceiver<::blink::mojom::blink::ServiceWorker> service_worker_receiver,
      ::mojo::PendingReceiver<::service_manager::mojom::blink::InterfaceProvider> interface_provider,
      ::mojo::PendingReceiver<::blink::mojom::blink::ControllerServiceWorker> controller_receiver,
      ::blink::mojom::blink::ServiceWorkerInstalledScriptsInfoPtr installed_scripts_info,
      ::mojo::PendingAssociatedRemote<EmbeddedWorkerInstanceHost> instance_host,
      ::blink::mojom::blink::ServiceWorkerProviderInfoForStartWorkerPtr provider_info,
      ::mojo::PendingRemote<::blink::mojom::blink::WorkerContentSettingsProxy> content_settings_proxy,
      ::mojo::PendingReceiver<::blink::mojom::blink::RendererPreferenceWatcher> preference_watcher_receiver,
      ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories,
      ::mojo::PendingReceiver<::blink::mojom::blink::SubresourceLoaderUpdater> subresource_loader_updater,
      const ::blink::ServiceWorkerToken& service_worker_token,
      int64_t ukm_source_id,
      ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr main_script_load_params,
      ::blink::mojom::blink::PolicyContainerPtr policy_container,
      const ::blink::BlinkStorageKey& storage_key,
      ::blink::Vector<::blink::String> cors_exempt_header_list,
      ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> coep_reporting_observer,
      ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> dip_reporting_observer,
      std::optional<::blink::NoiseToken> canvas_noise_token,
      ::mojo::PendingReceiver<::blink::mojom::blink::CanvasNoiseTokenUpdater> canvas_noise_token_observer);

EmbeddedWorkerStartParams(const EmbeddedWorkerStartParams&) = delete;
EmbeddedWorkerStartParams& operator=(const EmbeddedWorkerStartParams&) = delete;

  ~EmbeddedWorkerStartParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EmbeddedWorkerStartParamsPtr>
  EmbeddedWorkerStartParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EmbeddedWorkerStartParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EmbeddedWorkerStartParams::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EmbeddedWorkerStartParams::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EmbeddedWorkerStartParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EmbeddedWorkerStartParams_UnserializedMessageContext<
            UserType, EmbeddedWorkerStartParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EmbeddedWorkerStartParams::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EmbeddedWorkerStartParams::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EmbeddedWorkerStartParams_UnserializedMessageContext<
            UserType, EmbeddedWorkerStartParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EmbeddedWorkerStartParams::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int64_t service_worker_version_id;
  
  ::blink::KURL scope;
  
  ::blink::KURL script_url;
  
  ::blink::mojom::blink::ScriptType script_type;
  
  ::blink::mojom::blink::FetchClientSettingsObjectPtr outside_fetch_client_settings_object;
  
  ::blink::String user_agent;
  
  ::blink::mojom::blink::UserAgentMetadataPtr ua_metadata;
  
  int32_t service_worker_route_id;
  
  ::base::UnguessableToken devtools_worker_token;
  
  ::blink::KURL script_url_to_skip_throttling;
  
  bool wait_for_debugger;
  
  bool is_installed;
  
  ::blink::RendererPreferences renderer_preferences;
  
  ::blink::Vector<::blink::String> forced_enabled_runtime_features;
  
  ::mojo::PendingReceiver<::blink::mojom::blink::ServiceWorker> service_worker_receiver;
  
  ::mojo::PendingReceiver<::service_manager::mojom::blink::InterfaceProvider> interface_provider;
  
  ::mojo::PendingReceiver<::blink::mojom::blink::ControllerServiceWorker> controller_receiver;
  
  ::blink::mojom::blink::ServiceWorkerInstalledScriptsInfoPtr installed_scripts_info;
  
  ::mojo::PendingAssociatedRemote<EmbeddedWorkerInstanceHost> instance_host;
  
  ::blink::mojom::blink::ServiceWorkerProviderInfoForStartWorkerPtr provider_info;
  
  ::mojo::PendingRemote<::blink::mojom::blink::WorkerContentSettingsProxy> content_settings_proxy;
  
  ::mojo::PendingReceiver<::blink::mojom::blink::RendererPreferenceWatcher> preference_watcher_receiver;
  
  ::std::unique_ptr<::blink::PendingURLLoaderFactoryBundle> subresource_loader_factories;
  
  ::mojo::PendingReceiver<::blink::mojom::blink::SubresourceLoaderUpdater> subresource_loader_updater;
  
  ::blink::ServiceWorkerToken service_worker_token;
  
  int64_t ukm_source_id;
  
  ::blink::mojom::blink::WorkerMainScriptLoadParamsPtr main_script_load_params;
  
  ::blink::mojom::blink::PolicyContainerPtr policy_container;
  
  ::blink::BlinkStorageKey storage_key;
  
  ::blink::Vector<::blink::String> cors_exempt_header_list;
  
  ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> coep_reporting_observer;
  
  ::mojo::PendingReceiver<::blink::mojom::blink::ReportingObserver> dip_reporting_observer;
  
  std::optional<::blink::NoiseToken> canvas_noise_token;
  
  ::mojo::PendingReceiver<::blink::mojom::blink::CanvasNoiseTokenUpdater> canvas_noise_token_observer;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EmbeddedWorkerStartParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EmbeddedWorkerStartParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EmbeddedWorkerStartParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EmbeddedWorkerStartParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CORE_EXPORT EmbeddedWorkerStartTiming {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<EmbeddedWorkerStartTiming, T>::value>;
  using DataView = EmbeddedWorkerStartTimingDataView;
  using Data_ = internal::EmbeddedWorkerStartTiming_Data;

  template <typename... Args>
  static EmbeddedWorkerStartTimingPtr New(Args&&... args) {
    return EmbeddedWorkerStartTimingPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static EmbeddedWorkerStartTimingPtr From(const U& u) {
    return mojo::TypeConverter<EmbeddedWorkerStartTimingPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, EmbeddedWorkerStartTiming>::Convert(*this);
  }


  EmbeddedWorkerStartTiming();

  EmbeddedWorkerStartTiming(
      ::base::TimeTicks start_worker_received_time,
      ::base::TimeTicks script_evaluation_start_time,
      ::base::TimeTicks script_evaluation_end_time);


  ~EmbeddedWorkerStartTiming();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = EmbeddedWorkerStartTimingPtr>
  EmbeddedWorkerStartTimingPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, EmbeddedWorkerStartTiming::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, EmbeddedWorkerStartTiming::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, EmbeddedWorkerStartTiming::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EmbeddedWorkerStartTiming::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        EmbeddedWorkerStartTiming::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        EmbeddedWorkerStartTiming::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::EmbeddedWorkerStartTiming_UnserializedMessageContext<
            UserType, EmbeddedWorkerStartTiming::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<EmbeddedWorkerStartTiming::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return EmbeddedWorkerStartTiming::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::EmbeddedWorkerStartTiming_UnserializedMessageContext<
            UserType, EmbeddedWorkerStartTiming::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<EmbeddedWorkerStartTiming::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::base::TimeTicks start_worker_received_time;
  
  ::base::TimeTicks script_evaluation_start_time;
  
  ::base::TimeTicks script_evaluation_end_time;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, EmbeddedWorkerStartTiming::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, EmbeddedWorkerStartTiming::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, EmbeddedWorkerStartTiming::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, EmbeddedWorkerStartTiming::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
EmbeddedWorkerStartParamsPtr EmbeddedWorkerStartParams::Clone() const {
  return New(
      mojo::Clone(service_worker_version_id),
      mojo::Clone(scope),
      mojo::Clone(script_url),
      mojo::Clone(script_type),
      mojo::Clone(outside_fetch_client_settings_object),
      mojo::Clone(user_agent),
      mojo::Clone(ua_metadata),
      mojo::Clone(service_worker_route_id),
      mojo::Clone(devtools_worker_token),
      mojo::Clone(script_url_to_skip_throttling),
      mojo::Clone(wait_for_debugger),
      mojo::Clone(is_installed),
      mojo::Clone(renderer_preferences),
      mojo::Clone(forced_enabled_runtime_features),
      mojo::Clone(service_worker_receiver),
      mojo::Clone(interface_provider),
      mojo::Clone(controller_receiver),
      mojo::Clone(installed_scripts_info),
      mojo::Clone(instance_host),
      mojo::Clone(provider_info),
      mojo::Clone(content_settings_proxy),
      mojo::Clone(preference_watcher_receiver),
      mojo::Clone(subresource_loader_factories),
      mojo::Clone(subresource_loader_updater),
      mojo::Clone(service_worker_token),
      mojo::Clone(ukm_source_id),
      mojo::Clone(main_script_load_params),
      mojo::Clone(policy_container),
      mojo::Clone(storage_key),
      mojo::Clone(cors_exempt_header_list),
      mojo::Clone(coep_reporting_observer),
      mojo::Clone(dip_reporting_observer),
      mojo::Clone(canvas_noise_token),
      mojo::Clone(canvas_noise_token_observer)
  );
}

template <typename T, EmbeddedWorkerStartParams::EnableIfSame<T>*>
bool EmbeddedWorkerStartParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->service_worker_version_id, other_struct.service_worker_version_id))
    return false;
  if (!mojo::Equals(this->scope, other_struct.scope))
    return false;
  if (!mojo::Equals(this->script_url, other_struct.script_url))
    return false;
  if (!mojo::Equals(this->script_type, other_struct.script_type))
    return false;
  if (!mojo::Equals(this->outside_fetch_client_settings_object, other_struct.outside_fetch_client_settings_object))
    return false;
  if (!mojo::Equals(this->user_agent, other_struct.user_agent))
    return false;
  if (!mojo::Equals(this->ua_metadata, other_struct.ua_metadata))
    return false;
  if (!mojo::Equals(this->service_worker_route_id, other_struct.service_worker_route_id))
    return false;
  if (!mojo::Equals(this->devtools_worker_token, other_struct.devtools_worker_token))
    return false;
  if (!mojo::Equals(this->script_url_to_skip_throttling, other_struct.script_url_to_skip_throttling))
    return false;
  if (!mojo::Equals(this->wait_for_debugger, other_struct.wait_for_debugger))
    return false;
  if (!mojo::Equals(this->is_installed, other_struct.is_installed))
    return false;
  if (!mojo::Equals(this->renderer_preferences, other_struct.renderer_preferences))
    return false;
  if (!mojo::Equals(this->forced_enabled_runtime_features, other_struct.forced_enabled_runtime_features))
    return false;
  if (!mojo::Equals(this->service_worker_receiver, other_struct.service_worker_receiver))
    return false;
  if (!mojo::Equals(this->interface_provider, other_struct.interface_provider))
    return false;
  if (!mojo::Equals(this->controller_receiver, other_struct.controller_receiver))
    return false;
  if (!mojo::Equals(this->installed_scripts_info, other_struct.installed_scripts_info))
    return false;
  if (!mojo::Equals(this->instance_host, other_struct.instance_host))
    return false;
  if (!mojo::Equals(this->provider_info, other_struct.provider_info))
    return false;
  if (!mojo::Equals(this->content_settings_proxy, other_struct.content_settings_proxy))
    return false;
  if (!mojo::Equals(this->preference_watcher_receiver, other_struct.preference_watcher_receiver))
    return false;
  if (!mojo::Equals(this->subresource_loader_factories, other_struct.subresource_loader_factories))
    return false;
  if (!mojo::Equals(this->subresource_loader_updater, other_struct.subresource_loader_updater))
    return false;
  if (!mojo::Equals(this->service_worker_token, other_struct.service_worker_token))
    return false;
  if (!mojo::Equals(this->ukm_source_id, other_struct.ukm_source_id))
    return false;
  if (!mojo::Equals(this->main_script_load_params, other_struct.main_script_load_params))
    return false;
  if (!mojo::Equals(this->policy_container, other_struct.policy_container))
    return false;
  if (!mojo::Equals(this->storage_key, other_struct.storage_key))
    return false;
  if (!mojo::Equals(this->cors_exempt_header_list, other_struct.cors_exempt_header_list))
    return false;
  if (!mojo::Equals(this->coep_reporting_observer, other_struct.coep_reporting_observer))
    return false;
  if (!mojo::Equals(this->dip_reporting_observer, other_struct.dip_reporting_observer))
    return false;
  if (!mojo::Equals(this->canvas_noise_token, other_struct.canvas_noise_token))
    return false;
  if (!mojo::Equals(this->canvas_noise_token_observer, other_struct.canvas_noise_token_observer))
    return false;
  return true;
}

template <typename T, EmbeddedWorkerStartParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.service_worker_version_id < rhs.service_worker_version_id)
    return true;
  if (rhs.service_worker_version_id < lhs.service_worker_version_id)
    return false;
  if (lhs.scope < rhs.scope)
    return true;
  if (rhs.scope < lhs.scope)
    return false;
  if (lhs.script_url < rhs.script_url)
    return true;
  if (rhs.script_url < lhs.script_url)
    return false;
  if (lhs.script_type < rhs.script_type)
    return true;
  if (rhs.script_type < lhs.script_type)
    return false;
  if (lhs.outside_fetch_client_settings_object < rhs.outside_fetch_client_settings_object)
    return true;
  if (rhs.outside_fetch_client_settings_object < lhs.outside_fetch_client_settings_object)
    return false;
  if (lhs.user_agent < rhs.user_agent)
    return true;
  if (rhs.user_agent < lhs.user_agent)
    return false;
  if (lhs.ua_metadata < rhs.ua_metadata)
    return true;
  if (rhs.ua_metadata < lhs.ua_metadata)
    return false;
  if (lhs.service_worker_route_id < rhs.service_worker_route_id)
    return true;
  if (rhs.service_worker_route_id < lhs.service_worker_route_id)
    return false;
  if (lhs.devtools_worker_token < rhs.devtools_worker_token)
    return true;
  if (rhs.devtools_worker_token < lhs.devtools_worker_token)
    return false;
  if (lhs.script_url_to_skip_throttling < rhs.script_url_to_skip_throttling)
    return true;
  if (rhs.script_url_to_skip_throttling < lhs.script_url_to_skip_throttling)
    return false;
  if (lhs.wait_for_debugger < rhs.wait_for_debugger)
    return true;
  if (rhs.wait_for_debugger < lhs.wait_for_debugger)
    return false;
  if (lhs.is_installed < rhs.is_installed)
    return true;
  if (rhs.is_installed < lhs.is_installed)
    return false;
  if (lhs.renderer_preferences < rhs.renderer_preferences)
    return true;
  if (rhs.renderer_preferences < lhs.renderer_preferences)
    return false;
  if (lhs.forced_enabled_runtime_features < rhs.forced_enabled_runtime_features)
    return true;
  if (rhs.forced_enabled_runtime_features < lhs.forced_enabled_runtime_features)
    return false;
  if (lhs.service_worker_receiver < rhs.service_worker_receiver)
    return true;
  if (rhs.service_worker_receiver < lhs.service_worker_receiver)
    return false;
  if (lhs.interface_provider < rhs.interface_provider)
    return true;
  if (rhs.interface_provider < lhs.interface_provider)
    return false;
  if (lhs.controller_receiver < rhs.controller_receiver)
    return true;
  if (rhs.controller_receiver < lhs.controller_receiver)
    return false;
  if (lhs.installed_scripts_info < rhs.installed_scripts_info)
    return true;
  if (rhs.installed_scripts_info < lhs.installed_scripts_info)
    return false;
  if (lhs.instance_host < rhs.instance_host)
    return true;
  if (rhs.instance_host < lhs.instance_host)
    return false;
  if (lhs.provider_info < rhs.provider_info)
    return true;
  if (rhs.provider_info < lhs.provider_info)
    return false;
  if (lhs.content_settings_proxy < rhs.content_settings_proxy)
    return true;
  if (rhs.content_settings_proxy < lhs.content_settings_proxy)
    return false;
  if (lhs.preference_watcher_receiver < rhs.preference_watcher_receiver)
    return true;
  if (rhs.preference_watcher_receiver < lhs.preference_watcher_receiver)
    return false;
  if (lhs.subresource_loader_factories < rhs.subresource_loader_factories)
    return true;
  if (rhs.subresource_loader_factories < lhs.subresource_loader_factories)
    return false;
  if (lhs.subresource_loader_updater < rhs.subresource_loader_updater)
    return true;
  if (rhs.subresource_loader_updater < lhs.subresource_loader_updater)
    return false;
  if (lhs.service_worker_token < rhs.service_worker_token)
    return true;
  if (rhs.service_worker_token < lhs.service_worker_token)
    return false;
  if (lhs.ukm_source_id < rhs.ukm_source_id)
    return true;
  if (rhs.ukm_source_id < lhs.ukm_source_id)
    return false;
  if (lhs.main_script_load_params < rhs.main_script_load_params)
    return true;
  if (rhs.main_script_load_params < lhs.main_script_load_params)
    return false;
  if (lhs.policy_container < rhs.policy_container)
    return true;
  if (rhs.policy_container < lhs.policy_container)
    return false;
  if (lhs.storage_key < rhs.storage_key)
    return true;
  if (rhs.storage_key < lhs.storage_key)
    return false;
  if (lhs.cors_exempt_header_list < rhs.cors_exempt_header_list)
    return true;
  if (rhs.cors_exempt_header_list < lhs.cors_exempt_header_list)
    return false;
  if (lhs.coep_reporting_observer < rhs.coep_reporting_observer)
    return true;
  if (rhs.coep_reporting_observer < lhs.coep_reporting_observer)
    return false;
  if (lhs.dip_reporting_observer < rhs.dip_reporting_observer)
    return true;
  if (rhs.dip_reporting_observer < lhs.dip_reporting_observer)
    return false;
  if (lhs.canvas_noise_token < rhs.canvas_noise_token)
    return true;
  if (rhs.canvas_noise_token < lhs.canvas_noise_token)
    return false;
  if (lhs.canvas_noise_token_observer < rhs.canvas_noise_token_observer)
    return true;
  if (rhs.canvas_noise_token_observer < lhs.canvas_noise_token_observer)
    return false;
  return false;
}
template <typename StructPtrType>
EmbeddedWorkerStartTimingPtr EmbeddedWorkerStartTiming::Clone() const {
  return New(
      mojo::Clone(start_worker_received_time),
      mojo::Clone(script_evaluation_start_time),
      mojo::Clone(script_evaluation_end_time)
  );
}

template <typename T, EmbeddedWorkerStartTiming::EnableIfSame<T>*>
bool EmbeddedWorkerStartTiming::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->start_worker_received_time, other_struct.start_worker_received_time))
    return false;
  if (!mojo::Equals(this->script_evaluation_start_time, other_struct.script_evaluation_start_time))
    return false;
  if (!mojo::Equals(this->script_evaluation_end_time, other_struct.script_evaluation_end_time))
    return false;
  return true;
}

template <typename T, EmbeddedWorkerStartTiming::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.start_worker_received_time < rhs.start_worker_received_time)
    return true;
  if (rhs.start_worker_received_time < lhs.start_worker_received_time)
    return false;
  if (lhs.script_evaluation_start_time < rhs.script_evaluation_start_time)
    return true;
  if (rhs.script_evaluation_start_time < lhs.script_evaluation_start_time)
    return false;
  if (lhs.script_evaluation_end_time < rhs.script_evaluation_end_time)
    return true;
  if (rhs.script_evaluation_end_time < lhs.script_evaluation_end_time)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::EmbeddedWorkerStartParams::DataView,
                                         ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr> {
  static bool IsNull(const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::EmbeddedWorkerStartParamsPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::service_worker_version_id) service_worker_version_id(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->service_worker_version_id;
  }

  static const decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::scope)& scope(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->scope;
  }

  static const decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::script_url)& script_url(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->script_url;
  }

  static decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::script_type) script_type(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->script_type;
  }

  static const decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::outside_fetch_client_settings_object)& outside_fetch_client_settings_object(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->outside_fetch_client_settings_object;
  }

  static const decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::user_agent)& user_agent(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->user_agent;
  }

  static const decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::ua_metadata)& ua_metadata(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->ua_metadata;
  }

  static decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::service_worker_route_id) service_worker_route_id(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->service_worker_route_id;
  }

  static const decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::devtools_worker_token)& devtools_worker_token(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->devtools_worker_token;
  }

  static const decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::script_url_to_skip_throttling)& script_url_to_skip_throttling(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->script_url_to_skip_throttling;
  }

  static decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::wait_for_debugger) wait_for_debugger(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->wait_for_debugger;
  }

  static decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::is_installed) is_installed(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->is_installed;
  }

  static const decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::renderer_preferences)& renderer_preferences(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->renderer_preferences;
  }

  static const decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::forced_enabled_runtime_features)& forced_enabled_runtime_features(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->forced_enabled_runtime_features;
  }

  static  decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::service_worker_receiver)& service_worker_receiver(
       ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->service_worker_receiver;
  }

  static  decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::interface_provider)& interface_provider(
       ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->interface_provider;
  }

  static  decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::controller_receiver)& controller_receiver(
       ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->controller_receiver;
  }

  static  decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::installed_scripts_info)& installed_scripts_info(
       ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->installed_scripts_info;
  }

  static  decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::instance_host)& instance_host(
       ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->instance_host;
  }

  static  decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::provider_info)& provider_info(
       ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->provider_info;
  }

  static  decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::content_settings_proxy)& content_settings_proxy(
       ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->content_settings_proxy;
  }

  static  decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::preference_watcher_receiver)& preference_watcher_receiver(
       ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->preference_watcher_receiver;
  }

  static  decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::subresource_loader_factories)& subresource_loader_factories(
       ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->subresource_loader_factories;
  }

  static  decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::subresource_loader_updater)& subresource_loader_updater(
       ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->subresource_loader_updater;
  }

  static const decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::service_worker_token)& service_worker_token(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->service_worker_token;
  }

  static decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::ukm_source_id) ukm_source_id(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->ukm_source_id;
  }

  static  decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::main_script_load_params)& main_script_load_params(
       ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->main_script_load_params;
  }

  static  decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::policy_container)& policy_container(
       ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->policy_container;
  }

  static const decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::storage_key)& storage_key(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->storage_key;
  }

  static const decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::cors_exempt_header_list)& cors_exempt_header_list(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->cors_exempt_header_list;
  }

  static  decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::coep_reporting_observer)& coep_reporting_observer(
       ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->coep_reporting_observer;
  }

  static  decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::dip_reporting_observer)& dip_reporting_observer(
       ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->dip_reporting_observer;
  }

  static const decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::canvas_noise_token)& canvas_noise_token(
      const ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->canvas_noise_token;
  }

  static  decltype(::blink::mojom::blink::EmbeddedWorkerStartParams::canvas_noise_token_observer)& canvas_noise_token_observer(
       ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr& input) {
    return input->canvas_noise_token_observer;
  }

  static bool Read(::blink::mojom::blink::EmbeddedWorkerStartParams::DataView input, ::blink::mojom::blink::EmbeddedWorkerStartParamsPtr* output);
};


template <>
struct CORE_EXPORT StructTraits<::blink::mojom::blink::EmbeddedWorkerStartTiming::DataView,
                                         ::blink::mojom::blink::EmbeddedWorkerStartTimingPtr> {
  static bool IsNull(const ::blink::mojom::blink::EmbeddedWorkerStartTimingPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::EmbeddedWorkerStartTimingPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::EmbeddedWorkerStartTiming::start_worker_received_time)& start_worker_received_time(
      const ::blink::mojom::blink::EmbeddedWorkerStartTimingPtr& input) {
    return input->start_worker_received_time;
  }

  static const decltype(::blink::mojom::blink::EmbeddedWorkerStartTiming::script_evaluation_start_time)& script_evaluation_start_time(
      const ::blink::mojom::blink::EmbeddedWorkerStartTimingPtr& input) {
    return input->script_evaluation_start_time;
  }

  static const decltype(::blink::mojom::blink::EmbeddedWorkerStartTiming::script_evaluation_end_time)& script_evaluation_end_time(
      const ::blink::mojom::blink::EmbeddedWorkerStartTimingPtr& input) {
    return input->script_evaluation_end_time;
  }

  static bool Read(::blink::mojom::blink::EmbeddedWorkerStartTiming::DataView input, ::blink::mojom::blink::EmbeddedWorkerStartTimingPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_SERVICE_WORKER_EMBEDDED_WORKER_MOJOM_BLINK_H_