// third_party/blink/public/mojom/service_worker/controller_service_worker.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  UnguessableToken as mojoBase_mojom_UnguessableToken,
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec
} from '../../../../../mojo/public/mojom/base/unguessable_token.mojom.m.js';

import {
  CrossOriginEmbedderPolicyReporterRemote as network_mojom_CrossOriginEmbedderPolicyReporterRemote,
  CrossOriginEmbedderPolicyReporterPendingReceiver as network_mojom_CrossOriginEmbedderPolicyReporterPendingReceiver,
  CrossOriginEmbedderPolicy as network_mojom_CrossOriginEmbedderPolicy,
  CrossOriginEmbedderPolicySpec as network_mojom_CrossOriginEmbedderPolicySpec
} from '../../../../../services/network/public/mojom/cross_origin_embedder_policy.mojom.m.js';

import {
  DocumentIsolationPolicyReporterRemote as network_mojom_DocumentIsolationPolicyReporterRemote,
  DocumentIsolationPolicyReporterPendingReceiver as network_mojom_DocumentIsolationPolicyReporterPendingReceiver,
  DocumentIsolationPolicy as network_mojom_DocumentIsolationPolicy,
  DocumentIsolationPolicySpec as network_mojom_DocumentIsolationPolicySpec
} from '../../../../../services/network/public/mojom/document_isolation_policy.mojom.m.js';

import {
  CacheStorageRemote as blink_mojom_CacheStorageRemote,
  CacheStoragePendingReceiver as blink_mojom_CacheStoragePendingReceiver
} from '../cache_storage/cache_storage.mojom.m.js';

import {
  WebFeature as blink_mojom_WebFeature,
  WebFeatureSpec as blink_mojom_WebFeatureSpec
} from '../use_counter/metrics/web_feature.mojom.m.js';

import {
  ControllerServiceWorkerMode as blink_mojom_ControllerServiceWorkerMode,
  ControllerServiceWorkerModeSpec as blink_mojom_ControllerServiceWorkerModeSpec
} from './controller_service_worker_mode.mojom.m.js';

import {
  DispatchFetchEventParams as blink_mojom_DispatchFetchEventParams,
  DispatchFetchEventParamsSpec as blink_mojom_DispatchFetchEventParamsSpec
} from './dispatch_fetch_event_params.mojom.m.js';

import {
  ServiceWorkerEmbeddedWorkerStatus as blink_mojom_ServiceWorkerEmbeddedWorkerStatus,
  ServiceWorkerEmbeddedWorkerStatusSpec as blink_mojom_ServiceWorkerEmbeddedWorkerStatusSpec
} from './service_worker_embedded_worker_status.mojom.m.js';

import {
  ServiceWorkerEventStatus as blink_mojom_ServiceWorkerEventStatus,
  ServiceWorkerEventStatusSpec as blink_mojom_ServiceWorkerEventStatusSpec
} from './service_worker_event_status.mojom.m.js';

import {
  ServiceWorkerFetchHandlerBypassOption as blink_mojom_ServiceWorkerFetchHandlerBypassOption,
  ServiceWorkerFetchHandlerBypassOptionSpec as blink_mojom_ServiceWorkerFetchHandlerBypassOptionSpec
} from './service_worker_fetch_handler_bypass_option.mojom.m.js';

import {
  ServiceWorkerFetchHandlerType as blink_mojom_ServiceWorkerFetchHandlerType,
  ServiceWorkerFetchHandlerTypeSpec as blink_mojom_ServiceWorkerFetchHandlerTypeSpec
} from './service_worker_fetch_handler_type.mojom.m.js';

import {
  ServiceWorkerFetchResponseCallbackRemote as blink_mojom_ServiceWorkerFetchResponseCallbackRemote,
  ServiceWorkerFetchResponseCallbackPendingReceiver as blink_mojom_ServiceWorkerFetchResponseCallbackPendingReceiver
} from './service_worker_fetch_response_callback.mojom.m.js';

import {
  ServiceWorkerObjectInfo as blink_mojom_ServiceWorkerObjectInfo,
  ServiceWorkerObjectInfoSpec as blink_mojom_ServiceWorkerObjectInfoSpec
} from './service_worker_object.mojom.m.js';

import {
  ServiceWorkerRouterRules as blink_mojom_ServiceWorkerRouterRules,
  ServiceWorkerRouterRulesSpec as blink_mojom_ServiceWorkerRouterRulesSpec
} from './service_worker_router_rule.mojom.m.js';

import {
  ServiceWorkerRunningStatusCallbackRemote as blink_mojom_ServiceWorkerRunningStatusCallbackRemote,
  ServiceWorkerRunningStatusCallbackPendingReceiver as blink_mojom_ServiceWorkerRunningStatusCallbackPendingReceiver
} from './service_worker_running_status_callback.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ControllerServiceWorkerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ControllerServiceWorker', scope);
  }
}

/** @interface */
export class ControllerServiceWorkerInterface {
  
  /**
   * @param { !blink_mojom_DispatchFetchEventParams } params
   * @param { !blink_mojom_ServiceWorkerFetchResponseCallbackRemote } responseCallback
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchFetchEventForSubresource(params, responseCallback) {}
  
  /**
   * @param { !ControllerServiceWorkerPendingReceiver } receiver
   * @param { !network_mojom_CrossOriginEmbedderPolicy } crossOriginEmbedderPolicy
   * @param { ?network_mojom_CrossOriginEmbedderPolicyReporterRemote } coepReporter
   * @param { !network_mojom_DocumentIsolationPolicy } documentIsolationPolicy
   * @param { ?network_mojom_DocumentIsolationPolicyReporterRemote } dipReporter
   */

  clone(receiver, crossOriginEmbedderPolicy, coepReporter, documentIsolationPolicy, dipReporter) {}
}

/**
 * @implements { ControllerServiceWorkerInterface }
 */
export class ControllerServiceWorkerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ControllerServiceWorkerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ControllerServiceWorkerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ControllerServiceWorkerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink_mojom_DispatchFetchEventParams } params
   * @param { !blink_mojom_ServiceWorkerFetchResponseCallbackRemote } responseCallback
   * @return {!Promise<{
        status: !blink_mojom_ServiceWorkerEventStatus,
   *  }>}
   */

  dispatchFetchEventForSubresource(
      params,
      responseCallback) {
    return this.proxy.sendMessage(
        0,
        ControllerServiceWorker_DispatchFetchEventForSubresource_ParamsSpec.$,
        ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParamsSpec.$,
        [
          params,
          responseCallback
        ],
        false);
  }

  
  /**
   * @param { !ControllerServiceWorkerPendingReceiver } receiver
   * @param { !network_mojom_CrossOriginEmbedderPolicy } crossOriginEmbedderPolicy
   * @param { ?network_mojom_CrossOriginEmbedderPolicyReporterRemote } coepReporter
   * @param { !network_mojom_DocumentIsolationPolicy } documentIsolationPolicy
   * @param { ?network_mojom_DocumentIsolationPolicyReporterRemote } dipReporter
   */

  clone(
      receiver,
      crossOriginEmbedderPolicy,
      coepReporter,
      documentIsolationPolicy,
      dipReporter) {
    this.proxy.sendMessage(
        1,
        ControllerServiceWorker_Clone_ParamsSpec.$,
        null,
        [
          receiver,
          crossOriginEmbedderPolicy,
          coepReporter,
          documentIsolationPolicy,
          dipReporter
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ControllerServiceWorker
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ControllerServiceWorkerReceiver {
  /**
   * @param {!ControllerServiceWorkerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ControllerServiceWorkerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ControllerServiceWorkerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ControllerServiceWorkerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ControllerServiceWorker_DispatchFetchEventForSubresource_ParamsSpec.$,
        ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParamsSpec.$,
        impl.dispatchFetchEventForSubresource.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ControllerServiceWorker_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ControllerServiceWorker {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ControllerServiceWorker";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ControllerServiceWorkerRemote}
   */
  static getRemote() {
    let remote = new ControllerServiceWorkerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ControllerServiceWorker
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ControllerServiceWorkerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ControllerServiceWorkerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ControllerServiceWorkerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.dispatchFetchEventForSubresource =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ControllerServiceWorker_DispatchFetchEventForSubresource_ParamsSpec.$,
        ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParamsSpec.$,
        this.dispatchFetchEventForSubresource.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ControllerServiceWorker_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ControllerServiceWorkerConnectorPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.ControllerServiceWorkerConnector', scope);
  }
}

/** @interface */
export class ControllerServiceWorkerConnectorInterface {
  
  /**
   * @param { ?ControllerServiceWorkerRemote } controller
   */

  updateController(controller) {}
}

/**
 * @implements { ControllerServiceWorkerConnectorInterface }
 */
export class ControllerServiceWorkerConnectorRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ControllerServiceWorkerConnectorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ControllerServiceWorkerConnectorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ControllerServiceWorkerConnectorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?ControllerServiceWorkerRemote } controller
   */

  updateController(
      controller) {
    this.proxy.sendMessage(
        0,
        ControllerServiceWorkerConnector_UpdateController_ParamsSpec.$,
        null,
        [
          controller
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ControllerServiceWorkerConnector
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ControllerServiceWorkerConnectorReceiver {
  /**
   * @param {!ControllerServiceWorkerConnectorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ControllerServiceWorkerConnectorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ControllerServiceWorkerConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ControllerServiceWorkerConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ControllerServiceWorkerConnector_UpdateController_ParamsSpec.$,
        null,
        impl.updateController.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ControllerServiceWorkerConnector {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.ControllerServiceWorkerConnector";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ControllerServiceWorkerConnectorRemote}
   */
  static getRemote() {
    let remote = new ControllerServiceWorkerConnectorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ControllerServiceWorkerConnector
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ControllerServiceWorkerConnectorCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ControllerServiceWorkerConnectorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ControllerServiceWorkerConnectorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateController =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ControllerServiceWorkerConnector_UpdateController_ParamsSpec.$,
        null,
        this.updateController.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ServiceWorkerRouterDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ControllerServiceWorkerInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ControllerServiceWorker_DispatchFetchEventForSubresource_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ControllerServiceWorker_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ControllerServiceWorkerConnector_UpdateController_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    ServiceWorkerRouterDataSpec.$,
    'ServiceWorkerRouterData',
    [
      mojo.internal.StructField(
        'routerRules', 0,
        0,
        blink_mojom_ServiceWorkerRouterRulesSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initial_running_status_$flag', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        {
          isPrimary: true,
          linkedValueFieldName: "initial_running_status_$value",
          originalFieldName: "initialRunningStatus",
        }
      ),
      mojo.internal.StructField(
        'initial_running_status_$value', 12,
        0,
        blink_mojom_ServiceWorkerEmbeddedWorkerStatusSpec.$,
        0,
        false /* nullable */,
        0,
        {
          isPrimary: false,
          originalFieldName: "initialRunningStatus",
        }
      ),
      mojo.internal.StructField(
        'runningStatusReceiver', 16,
        0,
        mojo.internal.InterfaceRequest(blink_mojom_ServiceWorkerRunningStatusCallbackPendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteCacheStorage', 20,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_CacheStorageRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ServiceWorkerRouterData {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerRouterRules } */
    this.routerRules;
    /** @type { (blink_mojom_ServiceWorkerEmbeddedWorkerStatus|undefined) } */
    this.initialRunningStatus;
    /** @type { (blink_mojom_ServiceWorkerRunningStatusCallbackPendingReceiver|undefined) } */
    this.runningStatusReceiver;
    /** @type { !blink_mojom_CacheStorageRemote } */
    this.remoteCacheStorage;
  }
}



mojo.internal.Struct(
    ControllerServiceWorkerInfoSpec.$,
    'ControllerServiceWorkerInfo',
    [
      mojo.internal.StructField(
        'mode', 0,
        0,
        blink_mojom_ControllerServiceWorkerModeSpec.$,
        blink_mojom_ControllerServiceWorkerMode.kNoController,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fetchHandlerType', 4,
        0,
        blink_mojom_ServiceWorkerFetchHandlerTypeSpec.$,
        blink_mojom_ServiceWorkerFetchHandlerType.kNoHandler,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fetchHandlerBypassOption', 8,
        0,
        blink_mojom_ServiceWorkerFetchHandlerBypassOptionSpec.$,
        blink_mojom_ServiceWorkerFetchHandlerBypassOption.kDefault,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sha256ScriptChecksum', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'needRouterEvaluate', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'routerData', 24,
        0,
        ServiceWorkerRouterDataSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'remoteController', 32,
        0,
        mojo.internal.InterfaceProxy(ControllerServiceWorkerRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientId', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fetchRequestWindowId', 48,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'objectInfo', 56,
        0,
        blink_mojom_ServiceWorkerObjectInfoSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'usedFeatures', 64,
        0,
        mojo.internal.Array(blink_mojom_WebFeatureSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 80],]);



/**
 * @record
 */
export class ControllerServiceWorkerInfo {
  constructor() {
    /** @type { !blink_mojom_ControllerServiceWorkerMode } */
    this.mode;
    /** @type { !blink_mojom_ServiceWorkerFetchHandlerType } */
    this.fetchHandlerType;
    /** @type { !blink_mojom_ServiceWorkerFetchHandlerBypassOption } */
    this.fetchHandlerBypassOption;
    /** @type { (string|undefined) } */
    this.sha256ScriptChecksum;
    /** @type { !boolean } */
    this.needRouterEvaluate;
    /** @type { (ServiceWorkerRouterData|undefined) } */
    this.routerData;
    /** @type { (ControllerServiceWorkerRemote|undefined) } */
    this.remoteController;
    /** @type { !string } */
    this.clientId;
    /** @type { (mojoBase_mojom_UnguessableToken|undefined) } */
    this.fetchRequestWindowId;
    /** @type { (blink_mojom_ServiceWorkerObjectInfo|undefined) } */
    this.objectInfo;
    /** @type { !Array<!blink_mojom_WebFeature> } */
    this.usedFeatures;
  }
}



mojo.internal.Struct(
    ControllerServiceWorker_DispatchFetchEventForSubresource_ParamsSpec.$,
    'ControllerServiceWorker_DispatchFetchEventForSubresource_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        blink_mojom_DispatchFetchEventParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseCallback', 8,
        0,
        mojo.internal.InterfaceProxy(blink_mojom_ServiceWorkerFetchResponseCallbackRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class ControllerServiceWorker_DispatchFetchEventForSubresource_Params {
  constructor() {
    /** @type { !blink_mojom_DispatchFetchEventParams } */
    this.params;
    /** @type { !blink_mojom_ServiceWorkerFetchResponseCallbackRemote } */
    this.responseCallback;
  }
}



mojo.internal.Struct(
    ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParamsSpec.$,
    'ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        blink_mojom_ServiceWorkerEventStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ControllerServiceWorker_DispatchFetchEventForSubresource_ResponseParams {
  constructor() {
    /** @type { !blink_mojom_ServiceWorkerEventStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    ControllerServiceWorker_Clone_ParamsSpec.$,
    'ControllerServiceWorker_Clone_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(ControllerServiceWorkerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'crossOriginEmbedderPolicy', 8,
        0,
        network_mojom_CrossOriginEmbedderPolicySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'coepReporter', 16,
        0,
        mojo.internal.InterfaceProxy(network_mojom_CrossOriginEmbedderPolicyReporterRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'documentIsolationPolicy', 24,
        0,
        network_mojom_DocumentIsolationPolicySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dipReporter', 32,
        0,
        mojo.internal.InterfaceProxy(network_mojom_DocumentIsolationPolicyReporterRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class ControllerServiceWorker_Clone_Params {
  constructor() {
    /** @type { !ControllerServiceWorkerPendingReceiver } */
    this.receiver;
    /** @type { !network_mojom_CrossOriginEmbedderPolicy } */
    this.crossOriginEmbedderPolicy;
    /** @type { (network_mojom_CrossOriginEmbedderPolicyReporterRemote|undefined) } */
    this.coepReporter;
    /** @type { !network_mojom_DocumentIsolationPolicy } */
    this.documentIsolationPolicy;
    /** @type { (network_mojom_DocumentIsolationPolicyReporterRemote|undefined) } */
    this.dipReporter;
  }
}



mojo.internal.Struct(
    ControllerServiceWorkerConnector_UpdateController_ParamsSpec.$,
    'ControllerServiceWorkerConnector_UpdateController_Params',
    [
      mojo.internal.StructField(
        'controller', 0,
        0,
        mojo.internal.InterfaceProxy(ControllerServiceWorkerRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ControllerServiceWorkerConnector_UpdateController_Params {
  constructor() {
    /** @type { (ControllerServiceWorkerRemote|undefined) } */
    this.controller;
  }
}

