// third_party/blink/public/mojom/serial/serial.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('device.mojom.SerialPort');
goog.require('device.mojom.SerialPortClient');
goog.require('device.mojom.SerialConnectionOptions');
goog.require('bluetooth.mojom.UUID');
goog.require('mojoBase.mojom.UnguessableToken');






goog.provide('blink.mojom.SerialService');
goog.provide('blink.mojom.SerialServiceReceiver');
goog.provide('blink.mojom.SerialServiceCallbackRouter');
goog.provide('blink.mojom.SerialServiceInterface');
goog.provide('blink.mojom.SerialServiceRemote');
goog.provide('blink.mojom.SerialServicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.SerialServicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.SerialService.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.SerialServiceInterface = class {
  
  /**
   * @param { !blink.mojom.SerialServiceClientRemote } client
   */

  setClient(client) {}
  
  /**
   * @return {!Promise<{
        ports: !Array<!blink.mojom.SerialPortInfo>,
   *  }>}
   */

  getPorts() {}
  
  /**
   * @param { !Array<!blink.mojom.SerialPortFilter> } filters
   * @param { !Array<!bluetooth.mojom.UUID> } allowedBluetoothServiceClassIds
   * @return {!Promise<{
        port: ?blink.mojom.SerialPortInfo,
   *  }>}
   */

  requestPort(filters, allowedBluetoothServiceClassIds) {}
  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } token
   * @param { !device.mojom.SerialConnectionOptions } options
   * @param { !device.mojom.SerialPortClientRemote } client
   * @return {!Promise<{
        port: ?device.mojom.SerialPortRemote,
   *  }>}
   */

  openPort(token, options, client) {}
  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } token
   * @return {!Promise}
   */

  forgetPort(token) {}
};

/**
 * @export
 * @implements { blink.mojom.SerialServiceInterface }
 */
blink.mojom.SerialServiceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.SerialServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.SerialServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.SerialServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.SerialServiceClientRemote } client
   */

  setClient(
      client) {
    this.proxy.sendMessage(
        0,
        blink.mojom.SerialService_SetClient_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        ports: !Array<!blink.mojom.SerialPortInfo>,
   *  }>}
   */

  getPorts() {
    return this.proxy.sendMessage(
        1,
        blink.mojom.SerialService_GetPorts_ParamsSpec.$,
        blink.mojom.SerialService_GetPorts_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !Array<!blink.mojom.SerialPortFilter> } filters
   * @param { !Array<!bluetooth.mojom.UUID> } allowedBluetoothServiceClassIds
   * @return {!Promise<{
        port: ?blink.mojom.SerialPortInfo,
   *  }>}
   */

  requestPort(
      filters,
      allowedBluetoothServiceClassIds) {
    return this.proxy.sendMessage(
        2,
        blink.mojom.SerialService_RequestPort_ParamsSpec.$,
        blink.mojom.SerialService_RequestPort_ResponseParamsSpec.$,
        [
          filters,
          allowedBluetoothServiceClassIds
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } token
   * @param { !device.mojom.SerialConnectionOptions } options
   * @param { !device.mojom.SerialPortClientRemote } client
   * @return {!Promise<{
        port: ?device.mojom.SerialPortRemote,
   *  }>}
   */

  openPort(
      token,
      options,
      client) {
    return this.proxy.sendMessage(
        3,
        blink.mojom.SerialService_OpenPort_ParamsSpec.$,
        blink.mojom.SerialService_OpenPort_ResponseParamsSpec.$,
        [
          token,
          options,
          client
        ],
        false);
  }

  
  /**
   * @param { !mojoBase.mojom.UnguessableToken } token
   * @return {!Promise}
   */

  forgetPort(
      token) {
    return this.proxy.sendMessage(
        4,
        blink.mojom.SerialService_ForgetPort_ParamsSpec.$,
        blink.mojom.SerialService_ForgetPort_ResponseParamsSpec.$,
        [
          token
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SerialService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.SerialServiceReceiver = class {
  /**
   * @param {!blink.mojom.SerialServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.SerialServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.SerialServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SerialServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SerialService_SetClient_ParamsSpec.$,
        null,
        impl.setClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SerialService_GetPorts_ParamsSpec.$,
        blink.mojom.SerialService_GetPorts_ResponseParamsSpec.$,
        impl.getPorts.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SerialService_RequestPort_ParamsSpec.$,
        blink.mojom.SerialService_RequestPort_ResponseParamsSpec.$,
        impl.requestPort.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.SerialService_OpenPort_ParamsSpec.$,
        blink.mojom.SerialService_OpenPort_ResponseParamsSpec.$,
        impl.openPort.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.SerialService_ForgetPort_ParamsSpec.$,
        blink.mojom.SerialService_ForgetPort_ResponseParamsSpec.$,
        impl.forgetPort.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.SerialService = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SerialService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.SerialServiceRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.SerialServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SerialService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.SerialServiceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.SerialServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SerialServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SerialService_SetClient_ParamsSpec.$,
        null,
        this.setClient.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getPorts =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.SerialService_GetPorts_ParamsSpec.$,
        blink.mojom.SerialService_GetPorts_ResponseParamsSpec.$,
        this.getPorts.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestPort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.SerialService_RequestPort_ParamsSpec.$,
        blink.mojom.SerialService_RequestPort_ResponseParamsSpec.$,
        this.requestPort.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.openPort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.SerialService_OpenPort_ParamsSpec.$,
        blink.mojom.SerialService_OpenPort_ResponseParamsSpec.$,
        this.openPort.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.forgetPort =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.SerialService_ForgetPort_ParamsSpec.$,
        blink.mojom.SerialService_ForgetPort_ResponseParamsSpec.$,
        this.forgetPort.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.SerialServiceClient');
goog.provide('blink.mojom.SerialServiceClientReceiver');
goog.provide('blink.mojom.SerialServiceClientCallbackRouter');
goog.provide('blink.mojom.SerialServiceClientInterface');
goog.provide('blink.mojom.SerialServiceClientRemote');
goog.provide('blink.mojom.SerialServiceClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.SerialServiceClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.SerialServiceClient.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.SerialServiceClientInterface = class {
  
  /**
   * @param { !blink.mojom.SerialPortInfo } portInfo
   */

  onPortConnectedStateChanged(portInfo) {}
};

/**
 * @export
 * @implements { blink.mojom.SerialServiceClientInterface }
 */
blink.mojom.SerialServiceClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.SerialServiceClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.SerialServiceClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.SerialServiceClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !blink.mojom.SerialPortInfo } portInfo
   */

  onPortConnectedStateChanged(
      portInfo) {
    this.proxy.sendMessage(
        0,
        blink.mojom.SerialServiceClient_OnPortConnectedStateChanged_ParamsSpec.$,
        null,
        [
          portInfo
        ],
        false);
  }
};

/**
 * An object which receives request messages for the SerialServiceClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.SerialServiceClientReceiver = class {
  /**
   * @param {!blink.mojom.SerialServiceClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.SerialServiceClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.SerialServiceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SerialServiceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SerialServiceClient_OnPortConnectedStateChanged_ParamsSpec.$,
        null,
        impl.onPortConnectedStateChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.SerialServiceClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.SerialServiceClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.SerialServiceClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.SerialServiceClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the SerialServiceClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.SerialServiceClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.SerialServiceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.SerialServiceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPortConnectedStateChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.SerialServiceClient_OnPortConnectedStateChanged_ParamsSpec.$,
        null,
        this.onPortConnectedStateChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.SerialPortInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SerialPortInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SerialPortFilterSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SerialPortFilterSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SerialService_SetClient_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SerialService_SetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SerialService_GetPorts_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SerialService_GetPorts_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SerialService_GetPorts_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SerialService_GetPorts_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SerialService_RequestPort_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SerialService_RequestPort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SerialService_RequestPort_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SerialService_RequestPort_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SerialService_OpenPort_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SerialService_OpenPort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SerialService_OpenPort_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SerialService_OpenPort_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SerialService_ForgetPort_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SerialService_ForgetPort_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SerialService_ForgetPort_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SerialService_ForgetPort_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.SerialServiceClient_OnPortConnectedStateChanged_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.SerialServiceClient_OnPortConnectedStateChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.SerialPortInfoSpec.$,
    'SerialPortInfo',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'usbVendorId', 8,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasUsbVendorId', 10,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'usbProductId', 12,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasUsbProductId', 10,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bluetoothServiceClassId', 16,
        0,
        bluetooth.mojom.UUIDSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'connected', 10,
        2,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.SerialPortInfo');

/** @record */
blink.mojom.SerialPortInfo = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.token;
    /** @export { !number } */
    this.usbVendorId;
    /** @export { !boolean } */
    this.hasUsbVendorId;
    /** @export { !number } */
    this.usbProductId;
    /** @export { !boolean } */
    this.hasUsbProductId;
    /** @export { (bluetooth.mojom.UUID|undefined) } */
    this.bluetoothServiceClassId;
    /** @export { !boolean } */
    this.connected;
  }
};



mojo.internal.Struct(
    blink.mojom.SerialPortFilterSpec.$,
    'SerialPortFilter',
    [
      mojo.internal.StructField(
        'vendorId', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasVendorId', 4,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'productId', 6,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'hasProductId', 4,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'bluetoothServiceClassId', 8,
        0,
        bluetooth.mojom.UUIDSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.SerialPortFilter');

/** @record */
blink.mojom.SerialPortFilter = class {
  constructor() {
    /** @export { !number } */
    this.vendorId;
    /** @export { !boolean } */
    this.hasVendorId;
    /** @export { !number } */
    this.productId;
    /** @export { !boolean } */
    this.hasProductId;
    /** @export { (bluetooth.mojom.UUID|undefined) } */
    this.bluetoothServiceClassId;
  }
};



mojo.internal.Struct(
    blink.mojom.SerialService_SetClient_ParamsSpec.$,
    'SerialService_SetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.SerialServiceClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.SerialService_SetClient_Params');

/** @record */
blink.mojom.SerialService_SetClient_Params = class {
  constructor() {
    /** @export { !blink.mojom.SerialServiceClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    blink.mojom.SerialService_GetPorts_ParamsSpec.$,
    'SerialService_GetPorts_Params',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.SerialService_GetPorts_Params');

/** @record */
blink.mojom.SerialService_GetPorts_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.SerialService_GetPorts_ResponseParamsSpec.$,
    'SerialService_GetPorts_ResponseParams',
    [
      mojo.internal.StructField(
        'ports', 0,
        0,
        mojo.internal.Array(blink.mojom.SerialPortInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.SerialService_GetPorts_ResponseParams');

/** @record */
blink.mojom.SerialService_GetPorts_ResponseParams = class {
  constructor() {
    /** @export { !Array<!blink.mojom.SerialPortInfo> } */
    this.ports;
  }
};



mojo.internal.Struct(
    blink.mojom.SerialService_RequestPort_ParamsSpec.$,
    'SerialService_RequestPort_Params',
    [
      mojo.internal.StructField(
        'filters', 0,
        0,
        mojo.internal.Array(blink.mojom.SerialPortFilterSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'allowedBluetoothServiceClassIds', 8,
        0,
        mojo.internal.Array(bluetooth.mojom.UUIDSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.SerialService_RequestPort_Params');

/** @record */
blink.mojom.SerialService_RequestPort_Params = class {
  constructor() {
    /** @export { !Array<!blink.mojom.SerialPortFilter> } */
    this.filters;
    /** @export { !Array<!bluetooth.mojom.UUID> } */
    this.allowedBluetoothServiceClassIds;
  }
};



mojo.internal.Struct(
    blink.mojom.SerialService_RequestPort_ResponseParamsSpec.$,
    'SerialService_RequestPort_ResponseParams',
    [
      mojo.internal.StructField(
        'port', 0,
        0,
        blink.mojom.SerialPortInfoSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.SerialService_RequestPort_ResponseParams');

/** @record */
blink.mojom.SerialService_RequestPort_ResponseParams = class {
  constructor() {
    /** @export { (blink.mojom.SerialPortInfo|undefined) } */
    this.port;
  }
};



mojo.internal.Struct(
    blink.mojom.SerialService_OpenPort_ParamsSpec.$,
    'SerialService_OpenPort_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'options', 8,
        0,
        device.mojom.SerialConnectionOptionsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'client', 16,
        0,
        mojo.internal.InterfaceProxy(device.mojom.SerialPortClientRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('blink.mojom.SerialService_OpenPort_Params');

/** @record */
blink.mojom.SerialService_OpenPort_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.token;
    /** @export { !device.mojom.SerialConnectionOptions } */
    this.options;
    /** @export { !device.mojom.SerialPortClientRemote } */
    this.client;
  }
};



mojo.internal.Struct(
    blink.mojom.SerialService_OpenPort_ResponseParamsSpec.$,
    'SerialService_OpenPort_ResponseParams',
    [
      mojo.internal.StructField(
        'port', 0,
        0,
        mojo.internal.InterfaceProxy(device.mojom.SerialPortRemote),
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.SerialService_OpenPort_ResponseParams');

/** @record */
blink.mojom.SerialService_OpenPort_ResponseParams = class {
  constructor() {
    /** @export { (device.mojom.SerialPortRemote|undefined) } */
    this.port;
  }
};



mojo.internal.Struct(
    blink.mojom.SerialService_ForgetPort_ParamsSpec.$,
    'SerialService_ForgetPort_Params',
    [
      mojo.internal.StructField(
        'token', 0,
        0,
        mojoBase.mojom.UnguessableTokenSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.SerialService_ForgetPort_Params');

/** @record */
blink.mojom.SerialService_ForgetPort_Params = class {
  constructor() {
    /** @export { !mojoBase.mojom.UnguessableToken } */
    this.token;
  }
};



mojo.internal.Struct(
    blink.mojom.SerialService_ForgetPort_ResponseParamsSpec.$,
    'SerialService_ForgetPort_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('blink.mojom.SerialService_ForgetPort_ResponseParams');

/** @record */
blink.mojom.SerialService_ForgetPort_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.SerialServiceClient_OnPortConnectedStateChanged_ParamsSpec.$,
    'SerialServiceClient_OnPortConnectedStateChanged_Params',
    [
      mojo.internal.StructField(
        'portInfo', 0,
        0,
        blink.mojom.SerialPortInfoSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('blink.mojom.SerialServiceClient_OnPortConnectedStateChanged_Params');

/** @record */
blink.mojom.SerialServiceClient_OnPortConnectedStateChanged_Params = class {
  constructor() {
    /** @export { !blink.mojom.SerialPortInfo } */
    this.portInfo;
  }
};

