// third_party/blink/public/mojom/sensor/web_sensor_provider.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/sensor/web_sensor_provider.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/sensor/web_sensor_provider.mojom-params-data.h"
#include "third_party/blink/public/mojom/sensor/web_sensor_provider.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/sensor/web_sensor_provider.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/sensor/web_sensor_provider.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

WebSensorProvider::IPCStableHashFunction WebSensorProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::WebSensorProvider>(message.name())) {
    case messages::WebSensorProvider::kGetSensor: {
      return &WebSensorProvider::GetSensor_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* WebSensorProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::WebSensorProvider>(message.name())) {
      case messages::WebSensorProvider::kGetSensor:
            return "Receive blink::mojom::WebSensorProvider::GetSensor";
    }
  } else {
    switch (static_cast<messages::WebSensorProvider>(message.name())) {
      case messages::WebSensorProvider::kGetSensor:
            return "Receive reply blink::mojom::WebSensorProvider::GetSensor";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t WebSensorProvider::GetSensor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa5075a28;  // IPCStableHash for blink::mojom::WebSensorProvider::GetSensor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class WebSensorProvider_GetSensor_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WebSensorProvider_GetSensor_ForwardToCallback(
      WebSensorProvider::GetSensorCallback callback
      ) : callback_(std::move(callback)) {
  }

  WebSensorProvider_GetSensor_ForwardToCallback(const WebSensorProvider_GetSensor_ForwardToCallback&) = delete;
  WebSensorProvider_GetSensor_ForwardToCallback& operator=(const WebSensorProvider_GetSensor_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  WebSensorProvider::GetSensorCallback callback_;
};

WebSensorProviderProxy::WebSensorProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WebSensorProviderProxy::GetSensor(
    ::device::mojom::blink::SensorType in_type, GetSensorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::WebSensorProvider::GetSensor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("type"), in_type,
                        "<value of type ::device::mojom::blink::SensorType>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebSensorProvider::kGetSensor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebSensorProvider_GetSensor_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::SensorType>(
    in_type,
    &params->type);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSensorProvider::Name_);
  message.set_method_name("GetSensor");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WebSensorProvider_GetSensor_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class WebSensorProvider_GetSensor_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static WebSensorProvider::GetSensorCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<WebSensorProvider_GetSensor_ProxyToResponder> proxy(
        new WebSensorProvider_GetSensor_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&WebSensorProvider_GetSensor_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WebSensorProvider_GetSensor_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  WebSensorProvider_GetSensor_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "WebSensorProvider::GetSensorCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::device::mojom::blink::SensorCreationResult in_result, ::device::mojom::blink::SensorInitParamsPtr in_init_params);
};

bool WebSensorProvider_GetSensor_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::WebSensorProvider_GetSensor_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WebSensorProvider_GetSensor_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for WebSensorProvider.0
  bool success = true;
  ::device::mojom::blink::SensorCreationResult p_result{};
  ::device::mojom::blink::SensorInitParamsPtr p_init_params{};
  WebSensorProvider_GetSensor_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (success && !input_data_view.ReadInitParams(&p_init_params))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WebSensorProvider::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_init_params));
  }
  return true;
}

void WebSensorProvider_GetSensor_ProxyToResponder::Run(
    ::device::mojom::blink::SensorCreationResult in_result, ::device::mojom::blink::SensorInitParamsPtr in_init_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::WebSensorProvider::GetSensor", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type ::device::mojom::blink::SensorCreationResult>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("init_params"), in_init_params,
                        "<value of type ::device::mojom::blink::SensorInitParamsPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::WebSensorProvider::kGetSensor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::WebSensorProvider_GetSensor_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::SensorCreationResult>(
    in_result,
    &params->result);
  mojo::internal::MessageFragment<
      typename decltype(params->init_params)::BaseType> init_params_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::SensorInitParamsDataView>(
    in_init_params,
    init_params_fragment);

  params->init_params.Set(
      init_params_fragment.is_null() ? nullptr : init_params_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WebSensorProvider::Name_);
  message.set_method_name("GetSensor");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WebSensorProviderStubDispatch::Accept(
    WebSensorProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::WebSensorProvider>(message->header()->name)) {
    case messages::WebSensorProvider::kGetSensor: {
      break;
    }
  }
  return false;
}

// static
bool WebSensorProviderStubDispatch::AcceptWithResponder(
    WebSensorProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::WebSensorProvider>(message->header()->name)) {
    case messages::WebSensorProvider::kGetSensor: {
      internal::WebSensorProvider_GetSensor_Params_Data* params =
          reinterpret_cast<
              internal::WebSensorProvider_GetSensor_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for WebSensorProvider.0
      bool success = true;
      ::device::mojom::blink::SensorType p_type{};
      WebSensorProvider_GetSensor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WebSensorProvider::Name_, 0, false);
        return false;
      }
      auto callback =
          WebSensorProvider_GetSensor_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSensor(        
        std::move(p_type), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kWebSensorProviderValidationInfo[] = {
    { &internal::WebSensorProvider_GetSensor_Params_Data::Validate,
     &internal::WebSensorProvider_GetSensor_ResponseParams_Data::Validate},
};

bool WebSensorProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::WebSensorProvider::Name_,
    kWebSensorProviderValidationInfo);
}

bool WebSensorProviderResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::WebSensorProvider::Name_,
    kWebSensorProviderValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void WebSensorProviderInterceptorForTesting::GetSensor(::device::mojom::blink::SensorType type, GetSensorCallback callback) {
  GetForwardingInterface()->GetSensor(
    std::move(type)
    , std::move(callback));
}
WebSensorProviderAsyncWaiter::WebSensorProviderAsyncWaiter(
    WebSensorProvider* proxy) : proxy_(proxy) {}

WebSensorProviderAsyncWaiter::~WebSensorProviderAsyncWaiter() = default;


void WebSensorProviderAsyncWaiter::GetSensor(
    ::device::mojom::blink::SensorType type, ::device::mojom::blink::SensorCreationResult* out_result, ::device::mojom::blink::SensorInitParamsPtr* out_init_params) {
  base::RunLoop loop;
  proxy_->GetSensor(
      std::move(type),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::device::mojom::blink::SensorCreationResult* out_result
,
             ::device::mojom::blink::SensorInitParamsPtr* out_init_params
,
             ::device::mojom::blink::SensorCreationResult result,
             ::device::mojom::blink::SensorInitParamsPtr init_params) {*out_result = std::move(result);*out_init_params = std::move(init_params);
            loop->Quit();
          },
          &loop,
          out_result,
          out_init_params));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif