// third_party/blink/public/mojom/renderer_preferences.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDERER_PREFERENCES_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDERER_PREFERENCES_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/renderer_preferences.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/renderer_preferences.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/renderer_preferences.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom-blink-forward.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_policy.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/user_agent/user_agent_metadata.mojom-blink.h"
#include "ui/gfx/mojom/font_render_params.mojom-blink-forward.h"
#include "third_party/blink/public/mojom/peerconnection/webrtc_ip_handling_url_entry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/public/common/renderer_preferences/renderer_preferences_mojom_traits.h"
#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {








class PLATFORM_EXPORT RendererPreferences {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<RendererPreferences, T>::value>;
  using DataView = RendererPreferencesDataView;
  using Data_ = internal::RendererPreferences_Data;

  template <typename... Args>
  static RendererPreferencesPtr New(Args&&... args) {
    return RendererPreferencesPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static RendererPreferencesPtr From(const U& u) {
    return mojo::TypeConverter<RendererPreferencesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, RendererPreferences>::Convert(*this);
  }


  RendererPreferences();

  RendererPreferences(
      bool can_accept_load_drops,
      bool should_antialias_text,
      ::gfx::mojom::blink::Hinting hinting,
      bool use_autohinter,
      bool use_bitmaps,
      ::gfx::mojom::blink::SubpixelRendering subpixel_rendering,
      bool use_subpixel_positioning,
      uint32_t focus_ring_color,
      uint32_t active_selection_bg_color,
      uint32_t active_selection_fg_color,
      uint32_t inactive_selection_bg_color,
      uint32_t inactive_selection_fg_color,
      bool browser_handles_all_top_level_requests,
      std::optional<::base::TimeDelta> caret_blink_interval,
      bool use_custom_colors,
      bool enable_referrers,
      bool allow_cross_origin_auth_prompt,
      bool enable_do_not_track,
      bool enable_encrypted_media,
      ::blink::mojom::blink::WebRtcIpHandlingPolicy webrtc_ip_handling_policy,
      ::blink::Vector<::blink::WebRtcIpHandlingUrlEntry> webrtc_ip_handling_urls,
      std::optional<bool> webrtc_post_quantum_key_agreement,
      uint16_t webrtc_udp_min_port,
      uint16_t webrtc_udp_max_port,
      ::blink::Vector<::blink::String> webrtc_local_ips_allowed_urls,
      ::blink::mojom::blink::UserAgentOverridePtr user_agent_override,
      const ::blink::String& accept_languages,
      bool send_subresource_notification,
      bool plugin_fullscreen_allowed,
      bool caret_browsing_enabled,
      ::blink::Vector<uint16_t> explicitly_allowed_network_ports,
      bool view_source_line_wrap_enabled);

RendererPreferences(const RendererPreferences&) = delete;
RendererPreferences& operator=(const RendererPreferences&) = delete;

  ~RendererPreferences();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = RendererPreferencesPtr>
  RendererPreferencesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, RendererPreferences::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, RendererPreferences::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, RendererPreferences::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RendererPreferences::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        RendererPreferences::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        RendererPreferences::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::RendererPreferences_UnserializedMessageContext<
            UserType, RendererPreferences::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<RendererPreferences::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return RendererPreferences::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::RendererPreferences_UnserializedMessageContext<
            UserType, RendererPreferences::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<RendererPreferences::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool can_accept_load_drops;
  
  bool should_antialias_text;
  
  ::gfx::mojom::blink::Hinting hinting;
  
  bool use_autohinter;
  
  bool use_bitmaps;
  
  ::gfx::mojom::blink::SubpixelRendering subpixel_rendering;
  
  bool use_subpixel_positioning;
  
  uint32_t focus_ring_color;
  
  uint32_t active_selection_bg_color;
  
  uint32_t active_selection_fg_color;
  
  uint32_t inactive_selection_bg_color;
  
  uint32_t inactive_selection_fg_color;
  
  bool browser_handles_all_top_level_requests;
  
  std::optional<::base::TimeDelta> caret_blink_interval;
  
  bool use_custom_colors;
  
  bool enable_referrers;
  
  bool allow_cross_origin_auth_prompt;
  
  bool enable_do_not_track;
  
  bool enable_encrypted_media;
  
  ::blink::mojom::blink::WebRtcIpHandlingPolicy webrtc_ip_handling_policy;
  
  ::blink::Vector<::blink::WebRtcIpHandlingUrlEntry> webrtc_ip_handling_urls;
  
  std::optional<bool> webrtc_post_quantum_key_agreement;
  
  uint16_t webrtc_udp_min_port;
  
  uint16_t webrtc_udp_max_port;
  
  ::blink::Vector<::blink::String> webrtc_local_ips_allowed_urls;
  
  ::blink::mojom::blink::UserAgentOverridePtr user_agent_override;
  
  ::blink::String accept_languages;
  
  bool send_subresource_notification;
  
  bool plugin_fullscreen_allowed;
  
  bool caret_browsing_enabled;
  
  ::blink::Vector<uint16_t> explicitly_allowed_network_ports;
  
  bool view_source_line_wrap_enabled;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, RendererPreferences::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, RendererPreferences::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, RendererPreferences::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, RendererPreferences::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
RendererPreferencesPtr RendererPreferences::Clone() const {
  return New(
      mojo::Clone(can_accept_load_drops),
      mojo::Clone(should_antialias_text),
      mojo::Clone(hinting),
      mojo::Clone(use_autohinter),
      mojo::Clone(use_bitmaps),
      mojo::Clone(subpixel_rendering),
      mojo::Clone(use_subpixel_positioning),
      mojo::Clone(focus_ring_color),
      mojo::Clone(active_selection_bg_color),
      mojo::Clone(active_selection_fg_color),
      mojo::Clone(inactive_selection_bg_color),
      mojo::Clone(inactive_selection_fg_color),
      mojo::Clone(browser_handles_all_top_level_requests),
      mojo::Clone(caret_blink_interval),
      mojo::Clone(use_custom_colors),
      mojo::Clone(enable_referrers),
      mojo::Clone(allow_cross_origin_auth_prompt),
      mojo::Clone(enable_do_not_track),
      mojo::Clone(enable_encrypted_media),
      mojo::Clone(webrtc_ip_handling_policy),
      mojo::Clone(webrtc_ip_handling_urls),
      mojo::Clone(webrtc_post_quantum_key_agreement),
      mojo::Clone(webrtc_udp_min_port),
      mojo::Clone(webrtc_udp_max_port),
      mojo::Clone(webrtc_local_ips_allowed_urls),
      mojo::Clone(user_agent_override),
      mojo::Clone(accept_languages),
      mojo::Clone(send_subresource_notification),
      mojo::Clone(plugin_fullscreen_allowed),
      mojo::Clone(caret_browsing_enabled),
      mojo::Clone(explicitly_allowed_network_ports),
      mojo::Clone(view_source_line_wrap_enabled)
  );
}

template <typename T, RendererPreferences::EnableIfSame<T>*>
bool RendererPreferences::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->can_accept_load_drops, other_struct.can_accept_load_drops))
    return false;
  if (!mojo::Equals(this->should_antialias_text, other_struct.should_antialias_text))
    return false;
  if (!mojo::Equals(this->hinting, other_struct.hinting))
    return false;
  if (!mojo::Equals(this->use_autohinter, other_struct.use_autohinter))
    return false;
  if (!mojo::Equals(this->use_bitmaps, other_struct.use_bitmaps))
    return false;
  if (!mojo::Equals(this->subpixel_rendering, other_struct.subpixel_rendering))
    return false;
  if (!mojo::Equals(this->use_subpixel_positioning, other_struct.use_subpixel_positioning))
    return false;
  if (!mojo::Equals(this->focus_ring_color, other_struct.focus_ring_color))
    return false;
  if (!mojo::Equals(this->active_selection_bg_color, other_struct.active_selection_bg_color))
    return false;
  if (!mojo::Equals(this->active_selection_fg_color, other_struct.active_selection_fg_color))
    return false;
  if (!mojo::Equals(this->inactive_selection_bg_color, other_struct.inactive_selection_bg_color))
    return false;
  if (!mojo::Equals(this->inactive_selection_fg_color, other_struct.inactive_selection_fg_color))
    return false;
  if (!mojo::Equals(this->browser_handles_all_top_level_requests, other_struct.browser_handles_all_top_level_requests))
    return false;
  if (!mojo::Equals(this->caret_blink_interval, other_struct.caret_blink_interval))
    return false;
  if (!mojo::Equals(this->use_custom_colors, other_struct.use_custom_colors))
    return false;
  if (!mojo::Equals(this->enable_referrers, other_struct.enable_referrers))
    return false;
  if (!mojo::Equals(this->allow_cross_origin_auth_prompt, other_struct.allow_cross_origin_auth_prompt))
    return false;
  if (!mojo::Equals(this->enable_do_not_track, other_struct.enable_do_not_track))
    return false;
  if (!mojo::Equals(this->enable_encrypted_media, other_struct.enable_encrypted_media))
    return false;
  if (!mojo::Equals(this->webrtc_ip_handling_policy, other_struct.webrtc_ip_handling_policy))
    return false;
  if (!mojo::Equals(this->webrtc_ip_handling_urls, other_struct.webrtc_ip_handling_urls))
    return false;
  if (!mojo::Equals(this->webrtc_post_quantum_key_agreement, other_struct.webrtc_post_quantum_key_agreement))
    return false;
  if (!mojo::Equals(this->webrtc_udp_min_port, other_struct.webrtc_udp_min_port))
    return false;
  if (!mojo::Equals(this->webrtc_udp_max_port, other_struct.webrtc_udp_max_port))
    return false;
  if (!mojo::Equals(this->webrtc_local_ips_allowed_urls, other_struct.webrtc_local_ips_allowed_urls))
    return false;
  if (!mojo::Equals(this->user_agent_override, other_struct.user_agent_override))
    return false;
  if (!mojo::Equals(this->accept_languages, other_struct.accept_languages))
    return false;
  if (!mojo::Equals(this->send_subresource_notification, other_struct.send_subresource_notification))
    return false;
  if (!mojo::Equals(this->plugin_fullscreen_allowed, other_struct.plugin_fullscreen_allowed))
    return false;
  if (!mojo::Equals(this->caret_browsing_enabled, other_struct.caret_browsing_enabled))
    return false;
  if (!mojo::Equals(this->explicitly_allowed_network_ports, other_struct.explicitly_allowed_network_ports))
    return false;
  if (!mojo::Equals(this->view_source_line_wrap_enabled, other_struct.view_source_line_wrap_enabled))
    return false;
  return true;
}

template <typename T, RendererPreferences::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.can_accept_load_drops < rhs.can_accept_load_drops)
    return true;
  if (rhs.can_accept_load_drops < lhs.can_accept_load_drops)
    return false;
  if (lhs.should_antialias_text < rhs.should_antialias_text)
    return true;
  if (rhs.should_antialias_text < lhs.should_antialias_text)
    return false;
  if (lhs.hinting < rhs.hinting)
    return true;
  if (rhs.hinting < lhs.hinting)
    return false;
  if (lhs.use_autohinter < rhs.use_autohinter)
    return true;
  if (rhs.use_autohinter < lhs.use_autohinter)
    return false;
  if (lhs.use_bitmaps < rhs.use_bitmaps)
    return true;
  if (rhs.use_bitmaps < lhs.use_bitmaps)
    return false;
  if (lhs.subpixel_rendering < rhs.subpixel_rendering)
    return true;
  if (rhs.subpixel_rendering < lhs.subpixel_rendering)
    return false;
  if (lhs.use_subpixel_positioning < rhs.use_subpixel_positioning)
    return true;
  if (rhs.use_subpixel_positioning < lhs.use_subpixel_positioning)
    return false;
  if (lhs.focus_ring_color < rhs.focus_ring_color)
    return true;
  if (rhs.focus_ring_color < lhs.focus_ring_color)
    return false;
  if (lhs.active_selection_bg_color < rhs.active_selection_bg_color)
    return true;
  if (rhs.active_selection_bg_color < lhs.active_selection_bg_color)
    return false;
  if (lhs.active_selection_fg_color < rhs.active_selection_fg_color)
    return true;
  if (rhs.active_selection_fg_color < lhs.active_selection_fg_color)
    return false;
  if (lhs.inactive_selection_bg_color < rhs.inactive_selection_bg_color)
    return true;
  if (rhs.inactive_selection_bg_color < lhs.inactive_selection_bg_color)
    return false;
  if (lhs.inactive_selection_fg_color < rhs.inactive_selection_fg_color)
    return true;
  if (rhs.inactive_selection_fg_color < lhs.inactive_selection_fg_color)
    return false;
  if (lhs.browser_handles_all_top_level_requests < rhs.browser_handles_all_top_level_requests)
    return true;
  if (rhs.browser_handles_all_top_level_requests < lhs.browser_handles_all_top_level_requests)
    return false;
  if (lhs.caret_blink_interval < rhs.caret_blink_interval)
    return true;
  if (rhs.caret_blink_interval < lhs.caret_blink_interval)
    return false;
  if (lhs.use_custom_colors < rhs.use_custom_colors)
    return true;
  if (rhs.use_custom_colors < lhs.use_custom_colors)
    return false;
  if (lhs.enable_referrers < rhs.enable_referrers)
    return true;
  if (rhs.enable_referrers < lhs.enable_referrers)
    return false;
  if (lhs.allow_cross_origin_auth_prompt < rhs.allow_cross_origin_auth_prompt)
    return true;
  if (rhs.allow_cross_origin_auth_prompt < lhs.allow_cross_origin_auth_prompt)
    return false;
  if (lhs.enable_do_not_track < rhs.enable_do_not_track)
    return true;
  if (rhs.enable_do_not_track < lhs.enable_do_not_track)
    return false;
  if (lhs.enable_encrypted_media < rhs.enable_encrypted_media)
    return true;
  if (rhs.enable_encrypted_media < lhs.enable_encrypted_media)
    return false;
  if (lhs.webrtc_ip_handling_policy < rhs.webrtc_ip_handling_policy)
    return true;
  if (rhs.webrtc_ip_handling_policy < lhs.webrtc_ip_handling_policy)
    return false;
  if (lhs.webrtc_ip_handling_urls < rhs.webrtc_ip_handling_urls)
    return true;
  if (rhs.webrtc_ip_handling_urls < lhs.webrtc_ip_handling_urls)
    return false;
  if (lhs.webrtc_post_quantum_key_agreement < rhs.webrtc_post_quantum_key_agreement)
    return true;
  if (rhs.webrtc_post_quantum_key_agreement < lhs.webrtc_post_quantum_key_agreement)
    return false;
  if (lhs.webrtc_udp_min_port < rhs.webrtc_udp_min_port)
    return true;
  if (rhs.webrtc_udp_min_port < lhs.webrtc_udp_min_port)
    return false;
  if (lhs.webrtc_udp_max_port < rhs.webrtc_udp_max_port)
    return true;
  if (rhs.webrtc_udp_max_port < lhs.webrtc_udp_max_port)
    return false;
  if (lhs.webrtc_local_ips_allowed_urls < rhs.webrtc_local_ips_allowed_urls)
    return true;
  if (rhs.webrtc_local_ips_allowed_urls < lhs.webrtc_local_ips_allowed_urls)
    return false;
  if (lhs.user_agent_override < rhs.user_agent_override)
    return true;
  if (rhs.user_agent_override < lhs.user_agent_override)
    return false;
  if (lhs.accept_languages < rhs.accept_languages)
    return true;
  if (rhs.accept_languages < lhs.accept_languages)
    return false;
  if (lhs.send_subresource_notification < rhs.send_subresource_notification)
    return true;
  if (rhs.send_subresource_notification < lhs.send_subresource_notification)
    return false;
  if (lhs.plugin_fullscreen_allowed < rhs.plugin_fullscreen_allowed)
    return true;
  if (rhs.plugin_fullscreen_allowed < lhs.plugin_fullscreen_allowed)
    return false;
  if (lhs.caret_browsing_enabled < rhs.caret_browsing_enabled)
    return true;
  if (rhs.caret_browsing_enabled < lhs.caret_browsing_enabled)
    return false;
  if (lhs.explicitly_allowed_network_ports < rhs.explicitly_allowed_network_ports)
    return true;
  if (rhs.explicitly_allowed_network_ports < lhs.explicitly_allowed_network_ports)
    return false;
  if (lhs.view_source_line_wrap_enabled < rhs.view_source_line_wrap_enabled)
    return true;
  if (rhs.view_source_line_wrap_enabled < lhs.view_source_line_wrap_enabled)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::RendererPreferences::DataView,
                                         ::blink::mojom::blink::RendererPreferencesPtr> {
  static bool IsNull(const ::blink::mojom::blink::RendererPreferencesPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::RendererPreferencesPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::RendererPreferences::can_accept_load_drops) can_accept_load_drops(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->can_accept_load_drops;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::should_antialias_text) should_antialias_text(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->should_antialias_text;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::hinting) hinting(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->hinting;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::use_autohinter) use_autohinter(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->use_autohinter;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::use_bitmaps) use_bitmaps(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->use_bitmaps;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::subpixel_rendering) subpixel_rendering(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->subpixel_rendering;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::use_subpixel_positioning) use_subpixel_positioning(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->use_subpixel_positioning;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::focus_ring_color) focus_ring_color(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->focus_ring_color;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::active_selection_bg_color) active_selection_bg_color(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->active_selection_bg_color;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::active_selection_fg_color) active_selection_fg_color(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->active_selection_fg_color;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::inactive_selection_bg_color) inactive_selection_bg_color(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->inactive_selection_bg_color;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::inactive_selection_fg_color) inactive_selection_fg_color(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->inactive_selection_fg_color;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::browser_handles_all_top_level_requests) browser_handles_all_top_level_requests(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->browser_handles_all_top_level_requests;
  }

  static const decltype(::blink::mojom::blink::RendererPreferences::caret_blink_interval)& caret_blink_interval(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->caret_blink_interval;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::use_custom_colors) use_custom_colors(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->use_custom_colors;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::enable_referrers) enable_referrers(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->enable_referrers;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::allow_cross_origin_auth_prompt) allow_cross_origin_auth_prompt(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->allow_cross_origin_auth_prompt;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::enable_do_not_track) enable_do_not_track(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->enable_do_not_track;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::enable_encrypted_media) enable_encrypted_media(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->enable_encrypted_media;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::webrtc_ip_handling_policy) webrtc_ip_handling_policy(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->webrtc_ip_handling_policy;
  }

  static const decltype(::blink::mojom::blink::RendererPreferences::webrtc_ip_handling_urls)& webrtc_ip_handling_urls(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->webrtc_ip_handling_urls;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::webrtc_post_quantum_key_agreement) webrtc_post_quantum_key_agreement(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->webrtc_post_quantum_key_agreement;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::webrtc_udp_min_port) webrtc_udp_min_port(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->webrtc_udp_min_port;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::webrtc_udp_max_port) webrtc_udp_max_port(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->webrtc_udp_max_port;
  }

  static const decltype(::blink::mojom::blink::RendererPreferences::webrtc_local_ips_allowed_urls)& webrtc_local_ips_allowed_urls(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->webrtc_local_ips_allowed_urls;
  }

  static const decltype(::blink::mojom::blink::RendererPreferences::user_agent_override)& user_agent_override(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->user_agent_override;
  }

  static const decltype(::blink::mojom::blink::RendererPreferences::accept_languages)& accept_languages(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->accept_languages;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::send_subresource_notification) send_subresource_notification(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->send_subresource_notification;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::plugin_fullscreen_allowed) plugin_fullscreen_allowed(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->plugin_fullscreen_allowed;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::caret_browsing_enabled) caret_browsing_enabled(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->caret_browsing_enabled;
  }

  static const decltype(::blink::mojom::blink::RendererPreferences::explicitly_allowed_network_ports)& explicitly_allowed_network_ports(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->explicitly_allowed_network_ports;
  }

  static decltype(::blink::mojom::blink::RendererPreferences::view_source_line_wrap_enabled) view_source_line_wrap_enabled(
      const ::blink::mojom::blink::RendererPreferencesPtr& input) {
    return input->view_source_line_wrap_enabled;
  }

  static bool Read(::blink::mojom::blink::RendererPreferences::DataView input, ::blink::mojom::blink::RendererPreferencesPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_RENDERER_PREFERENCES_MOJOM_BLINK_H_