// third_party/blink/public/mojom/render_accessibility.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/render_accessibility.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/render_accessibility.mojom-params-data.h"
#include "third_party/blink/public/mojom/render_accessibility.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/render_accessibility.mojom-import-headers.h"
#include "third_party/blink/public/mojom/render_accessibility.mojom-test-utils.h"


namespace blink::mojom {
HitTestResponse::HitTestResponse()
    : stitched_child_tree_id(),
      hit_frame_token(),
      hit_frame_transformed_point(),
      hit_node_id() {}

HitTestResponse::HitTestResponse(
    const ::ui::AXTreeID& stitched_child_tree_id_in,
    const ::blink::FrameToken& hit_frame_token_in,
    const ::gfx::Point& hit_frame_transformed_point_in,
    int32_t hit_node_id_in)
    : stitched_child_tree_id(std::move(stitched_child_tree_id_in)),
      hit_frame_token(std::move(hit_frame_token_in)),
      hit_frame_transformed_point(std::move(hit_frame_transformed_point_in)),
      hit_node_id(std::move(hit_node_id_in)) {}

HitTestResponse::~HitTestResponse() = default;

void HitTestResponse::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "stitched_child_tree_id"), this->stitched_child_tree_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::ui::AXTreeID&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hit_frame_token"), this->hit_frame_token,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::FrameToken&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hit_frame_transformed_point"), this->hit_frame_transformed_point,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Point&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "hit_node_id"), this->hit_node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HitTestResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

RenderAccessibilityHost::IPCStableHashFunction RenderAccessibilityHost::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RenderAccessibilityHost>(message.name())) {
    case messages::RenderAccessibilityHost::kHandleAXEvents: {
      return &RenderAccessibilityHost::HandleAXEvents_Sym::IPCStableHash;
    }
    case messages::RenderAccessibilityHost::kHandleAXLocationChanges: {
      return &RenderAccessibilityHost::HandleAXLocationChanges_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RenderAccessibilityHost::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RenderAccessibilityHost>(message.name())) {
      case messages::RenderAccessibilityHost::kHandleAXEvents:
            return "Receive blink::mojom::RenderAccessibilityHost::HandleAXEvents";
      case messages::RenderAccessibilityHost::kHandleAXLocationChanges:
            return "Receive blink::mojom::RenderAccessibilityHost::HandleAXLocationChanges";
    }
  } else {
    switch (static_cast<messages::RenderAccessibilityHost>(message.name())) {
      case messages::RenderAccessibilityHost::kHandleAXEvents:
            return "Receive reply blink::mojom::RenderAccessibilityHost::HandleAXEvents";
      case messages::RenderAccessibilityHost::kHandleAXLocationChanges:
            return "Receive reply blink::mojom::RenderAccessibilityHost::HandleAXLocationChanges";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RenderAccessibilityHost::HandleAXEvents_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x9a6a3fb7;  // IPCStableHash for blink::mojom::RenderAccessibilityHost::HandleAXEvents
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderAccessibilityHost::HandleAXLocationChanges_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcf247277;  // IPCStableHash for blink::mojom::RenderAccessibilityHost::HandleAXLocationChanges
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class RenderAccessibilityHost_HandleAXEvents_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RenderAccessibilityHost_HandleAXEvents_ForwardToCallback(
      RenderAccessibilityHost::HandleAXEventsCallback callback
      ) : callback_(std::move(callback)) {
  }

  RenderAccessibilityHost_HandleAXEvents_ForwardToCallback(const RenderAccessibilityHost_HandleAXEvents_ForwardToCallback&) = delete;
  RenderAccessibilityHost_HandleAXEvents_ForwardToCallback& operator=(const RenderAccessibilityHost_HandleAXEvents_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RenderAccessibilityHost::HandleAXEventsCallback callback_;
};

RenderAccessibilityHostProxy::RenderAccessibilityHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RenderAccessibilityHostProxy::HandleAXEvents(
    const ::ui::AXUpdatesAndEvents& in_events_and_updates, const ::ui::AXLocationAndScrollUpdates& in_location_and_scroll_updates, uint32_t in_reset_token, HandleAXEventsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RenderAccessibilityHost::HandleAXEvents", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("events_and_updates"), in_events_and_updates,
                        "<value of type const ::ui::AXUpdatesAndEvents&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("location_and_scroll_updates"), in_location_and_scroll_updates,
                        "<value of type const ::ui::AXLocationAndScrollUpdates&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reset_token"), in_reset_token,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderAccessibilityHost::kHandleAXEvents), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RenderAccessibilityHost_HandleAXEvents_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->events_and_updates)::BaseType> events_and_updates_fragment(
          params.message());
  
  mojo::internal::Serialize<::ax::mojom::AXUpdatesAndEventsDataView>(
    in_events_and_updates,
    events_and_updates_fragment);

  params->events_and_updates.Set(
      events_and_updates_fragment.is_null() ? nullptr : events_and_updates_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->events_and_updates.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null events_and_updates in RenderAccessibilityHost.HandleAXEvents request");
  mojo::internal::MessageFragment<
      typename decltype(params->location_and_scroll_updates)::BaseType> location_and_scroll_updates_fragment(
          params.message());
  
  mojo::internal::Serialize<::ax::mojom::AXLocationAndScrollUpdatesDataView>(
    in_location_and_scroll_updates,
    location_and_scroll_updates_fragment);

  params->location_and_scroll_updates.Set(
      location_and_scroll_updates_fragment.is_null() ? nullptr : location_and_scroll_updates_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->location_and_scroll_updates.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null location_and_scroll_updates in RenderAccessibilityHost.HandleAXEvents request");

  params->reset_token = in_reset_token;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderAccessibilityHost::Name_);
  message.set_method_name("HandleAXEvents");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderAccessibilityHost_HandleAXEvents_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RenderAccessibilityHostProxy::HandleAXLocationChanges(
    const ::ui::AXLocationAndScrollUpdates& in_changes, uint32_t in_reset_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RenderAccessibilityHost::HandleAXLocationChanges", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("changes"), in_changes,
                        "<value of type const ::ui::AXLocationAndScrollUpdates&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reset_token"), in_reset_token,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderAccessibilityHost::kHandleAXLocationChanges), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RenderAccessibilityHost_HandleAXLocationChanges_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->changes)::BaseType> changes_fragment(
          params.message());
  
  mojo::internal::Serialize<::ax::mojom::AXLocationAndScrollUpdatesDataView>(
    in_changes,
    changes_fragment);

  params->changes.Set(
      changes_fragment.is_null() ? nullptr : changes_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->changes.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null changes in RenderAccessibilityHost.HandleAXLocationChanges request");

  params->reset_token = in_reset_token;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderAccessibilityHost::Name_);
  message.set_method_name("HandleAXLocationChanges");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class RenderAccessibilityHost_HandleAXEvents_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RenderAccessibilityHost::HandleAXEventsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RenderAccessibilityHost_HandleAXEvents_ProxyToResponder> proxy(
        new RenderAccessibilityHost_HandleAXEvents_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RenderAccessibilityHost_HandleAXEvents_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RenderAccessibilityHost_HandleAXEvents_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RenderAccessibilityHost_HandleAXEvents_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RenderAccessibilityHost::HandleAXEventsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      );
};

bool RenderAccessibilityHost_HandleAXEvents_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RenderAccessibilityHost.0
  bool success = true;
  RenderAccessibilityHost_HandleAXEvents_ResponseParamsDataView input_data_view(params, message);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderAccessibilityHost::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run();
  }
  return true;
}

void RenderAccessibilityHost_HandleAXEvents_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send reply blink::mojom::RenderAccessibilityHost::HandleAXEvents");
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderAccessibilityHost::kHandleAXEvents), kFlags,
      MOJO_CREATE_MESSAGE_FLAG_UNLIMITED_SIZE,
      estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderAccessibilityHost::Name_);
  message.set_method_name("HandleAXEvents");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RenderAccessibilityHostStubDispatch::Accept(
    RenderAccessibilityHost* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RenderAccessibilityHost>(message->header()->name)) {
    case messages::RenderAccessibilityHost::kHandleAXEvents: {
      break;
    }
    case messages::RenderAccessibilityHost::kHandleAXLocationChanges: {
      DCHECK(message->is_serialized());
      internal::RenderAccessibilityHost_HandleAXLocationChanges_Params_Data* params =
          reinterpret_cast<internal::RenderAccessibilityHost_HandleAXLocationChanges_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderAccessibilityHost.1
      bool success = true;
      ::ui::AXLocationAndScrollUpdates p_changes{};
      uint32_t p_reset_token{};
      RenderAccessibilityHost_HandleAXLocationChanges_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadChanges(&p_changes))
        success = false;
      if (success)
        p_reset_token = input_data_view.reset_token();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderAccessibilityHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleAXLocationChanges(        
        p_changes, 
        std::move(p_reset_token));
      return true;
    }
  }
  return false;
}

// static
bool RenderAccessibilityHostStubDispatch::AcceptWithResponder(
    RenderAccessibilityHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RenderAccessibilityHost>(message->header()->name)) {
    case messages::RenderAccessibilityHost::kHandleAXEvents: {
      internal::RenderAccessibilityHost_HandleAXEvents_Params_Data* params =
          reinterpret_cast<
              internal::RenderAccessibilityHost_HandleAXEvents_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RenderAccessibilityHost.0
      bool success = true;
      ::ui::AXUpdatesAndEvents p_events_and_updates{};
      ::ui::AXLocationAndScrollUpdates p_location_and_scroll_updates{};
      uint32_t p_reset_token{};
      RenderAccessibilityHost_HandleAXEvents_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadEventsAndUpdates(&p_events_and_updates))
        success = false;
      if (success && !input_data_view.ReadLocationAndScrollUpdates(&p_location_and_scroll_updates))
        success = false;
      if (success)
        p_reset_token = input_data_view.reset_token();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderAccessibilityHost::Name_, 0, false);
        return false;
      }
      auto callback =
          RenderAccessibilityHost_HandleAXEvents_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HandleAXEvents(        
        p_events_and_updates, 
        p_location_and_scroll_updates, 
        std::move(p_reset_token), std::move(callback));
      return true;
    }
    case messages::RenderAccessibilityHost::kHandleAXLocationChanges: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRenderAccessibilityHostValidationInfo[] = {
    { &internal::RenderAccessibilityHost_HandleAXEvents_Params_Data::Validate,
     &internal::RenderAccessibilityHost_HandleAXEvents_ResponseParams_Data::Validate},
    { &internal::RenderAccessibilityHost_HandleAXLocationChanges_Params_Data::Validate,
     nullptr /* no response */},
};

bool RenderAccessibilityHostRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::RenderAccessibilityHost::Name_,
    kRenderAccessibilityHostValidationInfo);
}

bool RenderAccessibilityHostResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::RenderAccessibilityHost::Name_,
    kRenderAccessibilityHostValidationInfo);
}
// The declaration includes the definition on other builds.

RenderAccessibility::IPCStableHashFunction RenderAccessibility::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::RenderAccessibility>(message.name())) {
    case messages::RenderAccessibility::kSetMode: {
      return &RenderAccessibility::SetMode_Sym::IPCStableHash;
    }
    case messages::RenderAccessibility::kFatalError: {
      return &RenderAccessibility::FatalError_Sym::IPCStableHash;
    }
    case messages::RenderAccessibility::kHitTest: {
      return &RenderAccessibility::HitTest_Sym::IPCStableHash;
    }
    case messages::RenderAccessibility::kPerformAction: {
      return &RenderAccessibility::PerformAction_Sym::IPCStableHash;
    }
    case messages::RenderAccessibility::kReset: {
      return &RenderAccessibility::Reset_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* RenderAccessibility::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::RenderAccessibility>(message.name())) {
      case messages::RenderAccessibility::kSetMode:
            return "Receive blink::mojom::RenderAccessibility::SetMode";
      case messages::RenderAccessibility::kFatalError:
            return "Receive blink::mojom::RenderAccessibility::FatalError";
      case messages::RenderAccessibility::kHitTest:
            return "Receive blink::mojom::RenderAccessibility::HitTest";
      case messages::RenderAccessibility::kPerformAction:
            return "Receive blink::mojom::RenderAccessibility::PerformAction";
      case messages::RenderAccessibility::kReset:
            return "Receive blink::mojom::RenderAccessibility::Reset";
    }
  } else {
    switch (static_cast<messages::RenderAccessibility>(message.name())) {
      case messages::RenderAccessibility::kSetMode:
            return "Receive reply blink::mojom::RenderAccessibility::SetMode";
      case messages::RenderAccessibility::kFatalError:
            return "Receive reply blink::mojom::RenderAccessibility::FatalError";
      case messages::RenderAccessibility::kHitTest:
            return "Receive reply blink::mojom::RenderAccessibility::HitTest";
      case messages::RenderAccessibility::kPerformAction:
            return "Receive reply blink::mojom::RenderAccessibility::PerformAction";
      case messages::RenderAccessibility::kReset:
            return "Receive reply blink::mojom::RenderAccessibility::Reset";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t RenderAccessibility::SetMode_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4bb7c64f;  // IPCStableHash for blink::mojom::RenderAccessibility::SetMode
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderAccessibility::FatalError_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8695f2c2;  // IPCStableHash for blink::mojom::RenderAccessibility::FatalError
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderAccessibility::HitTest_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x41c8b116;  // IPCStableHash for blink::mojom::RenderAccessibility::HitTest
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderAccessibility::PerformAction_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7e30b7a2;  // IPCStableHash for blink::mojom::RenderAccessibility::PerformAction
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t RenderAccessibility::Reset_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4e3ab69d;  // IPCStableHash for blink::mojom::RenderAccessibility::Reset
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class RenderAccessibility_HitTest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  RenderAccessibility_HitTest_ForwardToCallback(
      RenderAccessibility::HitTestCallback callback
      ) : callback_(std::move(callback)) {
  }

  RenderAccessibility_HitTest_ForwardToCallback(const RenderAccessibility_HitTest_ForwardToCallback&) = delete;
  RenderAccessibility_HitTest_ForwardToCallback& operator=(const RenderAccessibility_HitTest_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  RenderAccessibility::HitTestCallback callback_;
};

RenderAccessibilityProxy::RenderAccessibilityProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void RenderAccessibilityProxy::SetMode(
    const ::ui::AXMode& in_ax_mode, uint32_t in_reset_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RenderAccessibility::SetMode", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("ax_mode"), in_ax_mode,
                        "<value of type const ::ui::AXMode&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reset_token"), in_reset_token,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderAccessibility::kSetMode), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RenderAccessibility_SetMode_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->ax_mode)::BaseType> ax_mode_fragment(
          params.message());
  
  mojo::internal::Serialize<::ax::mojom::AXModeDataView>(
    in_ax_mode,
    ax_mode_fragment);

  params->ax_mode.Set(
      ax_mode_fragment.is_null() ? nullptr : ax_mode_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->ax_mode.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null ax_mode in RenderAccessibility.SetMode request");

  params->reset_token = in_reset_token;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderAccessibility::Name_);
  message.set_method_name("SetMode");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderAccessibilityProxy::FatalError(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send blink::mojom::RenderAccessibility::FatalError");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderAccessibility::kFatalError), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RenderAccessibility_FatalError_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderAccessibility::Name_);
  message.set_method_name("FatalError");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderAccessibilityProxy::HitTest(
    const ::gfx::Point& in_point, ::ax::mojom::Event in_event_to_fire, int32_t in_request_id, HitTestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RenderAccessibility::HitTest", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("point"), in_point,
                        "<value of type const ::gfx::Point&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("event_to_fire"), in_event_to_fire,
                        "<value of type ::ax::mojom::Event>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("request_id"), in_request_id,
                        "<value of type int32_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderAccessibility::kHitTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RenderAccessibility_HitTest_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->point)::BaseType> point_fragment(
          params.message());
  
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
    in_point,
    point_fragment);

  params->point.Set(
      point_fragment.is_null() ? nullptr : point_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->point.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null point in RenderAccessibility.HitTest request");

  
  mojo::internal::Serialize<::ax::mojom::Event>(
    in_event_to_fire,
    &params->event_to_fire);

  params->request_id = in_request_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderAccessibility::Name_);
  message.set_method_name("HitTest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new RenderAccessibility_HitTest_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void RenderAccessibilityProxy::PerformAction(
    const ::ui::AXActionData& in_action_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RenderAccessibility::PerformAction", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("action_data"), in_action_data,
                        "<value of type const ::ui::AXActionData&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderAccessibility::kPerformAction), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RenderAccessibility_PerformAction_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->action_data)::BaseType> action_data_fragment(
          params.message());
  
  mojo::internal::Serialize<::ax::mojom::AXActionDataDataView>(
    in_action_data,
    action_data_fragment);

  params->action_data.Set(
      action_data_fragment.is_null() ? nullptr : action_data_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->action_data.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null action_data in RenderAccessibility.PerformAction request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderAccessibility::Name_);
  message.set_method_name("PerformAction");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void RenderAccessibilityProxy::Reset(
    uint32_t in_reset_token) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::RenderAccessibility::Reset", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("reset_token"), in_reset_token,
                        "<value of type uint32_t>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderAccessibility::kReset), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RenderAccessibility_Reset_Params_Data> params(
          message);
  params.Allocate();

  params->reset_token = in_reset_token;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderAccessibility::Name_);
  message.set_method_name("Reset");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class RenderAccessibility_HitTest_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static RenderAccessibility::HitTestCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<RenderAccessibility_HitTest_ProxyToResponder> proxy(
        new RenderAccessibility_HitTest_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&RenderAccessibility_HitTest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~RenderAccessibility_HitTest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  RenderAccessibility_HitTest_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "RenderAccessibility::HitTestCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      HitTestResponsePtr in_hit_test_response);
};

bool RenderAccessibility_HitTest_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::RenderAccessibility_HitTest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::RenderAccessibility_HitTest_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for RenderAccessibility.2
  bool success = true;
  HitTestResponsePtr p_hit_test_response{};
  RenderAccessibility_HitTest_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadHitTestResponse(&p_hit_test_response))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        RenderAccessibility::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_hit_test_response));
  }
  return true;
}

void RenderAccessibility_HitTest_ProxyToResponder::Run(
    HitTestResponsePtr in_hit_test_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::RenderAccessibility::HitTest", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hit_test_response"), in_hit_test_response,
                        "<value of type HitTestResponsePtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::RenderAccessibility::kHitTest), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::RenderAccessibility_HitTest_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->hit_test_response)::BaseType> hit_test_response_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::HitTestResponseDataView>(
    in_hit_test_response,
    hit_test_response_fragment);

  params->hit_test_response.Set(
      hit_test_response_fragment.is_null() ? nullptr : hit_test_response_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(RenderAccessibility::Name_);
  message.set_method_name("HitTest");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool RenderAccessibilityStubDispatch::Accept(
    RenderAccessibility* impl,
    mojo::Message* message) {
  switch (static_cast<messages::RenderAccessibility>(message->header()->name)) {
    case messages::RenderAccessibility::kSetMode: {
      DCHECK(message->is_serialized());
      internal::RenderAccessibility_SetMode_Params_Data* params =
          reinterpret_cast<internal::RenderAccessibility_SetMode_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderAccessibility.0
      bool success = true;
      ::ui::AXMode p_ax_mode{};
      uint32_t p_reset_token{};
      RenderAccessibility_SetMode_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadAxMode(&p_ax_mode))
        success = false;
      if (success)
        p_reset_token = input_data_view.reset_token();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderAccessibility::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetMode(        
        std::move(p_ax_mode), 
        std::move(p_reset_token));
      return true;
    }
    case messages::RenderAccessibility::kFatalError: {
      DCHECK(message->is_serialized());
      internal::RenderAccessibility_FatalError_Params_Data* params =
          reinterpret_cast<internal::RenderAccessibility_FatalError_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderAccessibility.1
      bool success = true;
      RenderAccessibility_FatalError_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderAccessibility::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->FatalError(        );
      return true;
    }
    case messages::RenderAccessibility::kHitTest: {
      break;
    }
    case messages::RenderAccessibility::kPerformAction: {
      DCHECK(message->is_serialized());
      internal::RenderAccessibility_PerformAction_Params_Data* params =
          reinterpret_cast<internal::RenderAccessibility_PerformAction_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderAccessibility.3
      bool success = true;
      ::ui::AXActionData p_action_data{};
      RenderAccessibility_PerformAction_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadActionData(&p_action_data))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderAccessibility::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PerformAction(        
        std::move(p_action_data));
      return true;
    }
    case messages::RenderAccessibility::kReset: {
      DCHECK(message->is_serialized());
      internal::RenderAccessibility_Reset_Params_Data* params =
          reinterpret_cast<internal::RenderAccessibility_Reset_Params_Data*>(
              message->mutable_payload());
      

      // Validation for RenderAccessibility.4
      bool success = true;
      uint32_t p_reset_token{};
      RenderAccessibility_Reset_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_reset_token = input_data_view.reset_token();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderAccessibility::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Reset(        
        std::move(p_reset_token));
      return true;
    }
  }
  return false;
}

// static
bool RenderAccessibilityStubDispatch::AcceptWithResponder(
    RenderAccessibility* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::RenderAccessibility>(message->header()->name)) {
    case messages::RenderAccessibility::kSetMode: {
      break;
    }
    case messages::RenderAccessibility::kFatalError: {
      break;
    }
    case messages::RenderAccessibility::kHitTest: {
      internal::RenderAccessibility_HitTest_Params_Data* params =
          reinterpret_cast<
              internal::RenderAccessibility_HitTest_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for RenderAccessibility.2
      bool success = true;
      ::gfx::Point p_point{};
      ::ax::mojom::Event p_event_to_fire{};
      int32_t p_request_id{};
      RenderAccessibility_HitTest_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadPoint(&p_point))
        success = false;
      if (success && !input_data_view.ReadEventToFire(&p_event_to_fire))
        success = false;
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            RenderAccessibility::Name_, 2, false);
        return false;
      }
      auto callback =
          RenderAccessibility_HitTest_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->HitTest(        
        std::move(p_point), 
        std::move(p_event_to_fire), 
        std::move(p_request_id), std::move(callback));
      return true;
    }
    case messages::RenderAccessibility::kPerformAction: {
      break;
    }
    case messages::RenderAccessibility::kReset: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kRenderAccessibilityValidationInfo[] = {
    { &internal::RenderAccessibility_SetMode_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderAccessibility_FatalError_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderAccessibility_HitTest_Params_Data::Validate,
     &internal::RenderAccessibility_HitTest_ResponseParams_Data::Validate},
    { &internal::RenderAccessibility_PerformAction_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::RenderAccessibility_Reset_Params_Data::Validate,
     nullptr /* no response */},
};

bool RenderAccessibilityRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::RenderAccessibility::Name_,
    kRenderAccessibilityValidationInfo);
}

bool RenderAccessibilityResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::RenderAccessibility::Name_,
    kRenderAccessibilityValidationInfo);
}


}  // blink::mojom


namespace mojo {


// static
bool StructTraits<::blink::mojom::HitTestResponse::DataView, ::blink::mojom::HitTestResponsePtr>::Read(
    ::blink::mojom::HitTestResponse::DataView input,
    ::blink::mojom::HitTestResponsePtr* output) {
  bool success = true;
  ::blink::mojom::HitTestResponsePtr result(::blink::mojom::HitTestResponse::New());
  
      if (success && !input.ReadStitchedChildTreeId(&result->stitched_child_tree_id))
        success = false;
      if (success && !input.ReadHitFrameToken(&result->hit_frame_token))
        success = false;
      if (success && !input.ReadHitFrameTransformedPoint(&result->hit_frame_transformed_point))
        success = false;
      if (success)
        result->hit_node_id = input.hit_node_id();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom {


void RenderAccessibilityHostInterceptorForTesting::HandleAXEvents(const ::ui::AXUpdatesAndEvents& events_and_updates, const ::ui::AXLocationAndScrollUpdates& location_and_scroll_updates, uint32_t reset_token, HandleAXEventsCallback callback) {
  GetForwardingInterface()->HandleAXEvents(
    events_and_updates, 
    location_and_scroll_updates, 
    std::move(reset_token)
    , std::move(callback));
}
void RenderAccessibilityHostInterceptorForTesting::HandleAXLocationChanges(const ::ui::AXLocationAndScrollUpdates& changes, uint32_t reset_token) {
  GetForwardingInterface()->HandleAXLocationChanges(
    changes, 
    std::move(reset_token)
    );
}
RenderAccessibilityHostAsyncWaiter::RenderAccessibilityHostAsyncWaiter(
    RenderAccessibilityHost* proxy) : proxy_(proxy) {}

RenderAccessibilityHostAsyncWaiter::~RenderAccessibilityHostAsyncWaiter() = default;


void RenderAccessibilityHostAsyncWaiter::HandleAXEvents(
    const ::ui::AXUpdatesAndEvents& events_and_updates, const ::ui::AXLocationAndScrollUpdates& location_and_scroll_updates, uint32_t reset_token) {
  base::RunLoop loop;
  proxy_->HandleAXEvents(
      events_and_updates,
      location_and_scroll_updates,
      std::move(reset_token),
      base::BindOnce(
          [](base::RunLoop* loop) {
            loop->Quit();
          },
          &loop));
  loop.Run();
}






void RenderAccessibilityInterceptorForTesting::SetMode(const ::ui::AXMode& ax_mode, uint32_t reset_token) {
  GetForwardingInterface()->SetMode(
    std::move(ax_mode)
    , 
    std::move(reset_token)
    );
}
void RenderAccessibilityInterceptorForTesting::FatalError() {
  GetForwardingInterface()->FatalError();
}
void RenderAccessibilityInterceptorForTesting::HitTest(const ::gfx::Point& point, ::ax::mojom::Event event_to_fire, int32_t request_id, HitTestCallback callback) {
  GetForwardingInterface()->HitTest(
    std::move(point)
    , 
    std::move(event_to_fire)
    , 
    std::move(request_id)
    , std::move(callback));
}
void RenderAccessibilityInterceptorForTesting::PerformAction(const ::ui::AXActionData& action_data) {
  GetForwardingInterface()->PerformAction(
    std::move(action_data)
    );
}
void RenderAccessibilityInterceptorForTesting::Reset(uint32_t reset_token) {
  GetForwardingInterface()->Reset(
    std::move(reset_token)
    );
}
RenderAccessibilityAsyncWaiter::RenderAccessibilityAsyncWaiter(
    RenderAccessibility* proxy) : proxy_(proxy) {}

RenderAccessibilityAsyncWaiter::~RenderAccessibilityAsyncWaiter() = default;


void RenderAccessibilityAsyncWaiter::HitTest(
    const ::gfx::Point& point, ::ax::mojom::Event event_to_fire, int32_t request_id, HitTestResponsePtr* out_hit_test_response) {
  base::RunLoop loop;
  proxy_->HitTest(
      std::move(point),
      std::move(event_to_fire),
      std::move(request_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             HitTestResponsePtr* out_hit_test_response
,
             HitTestResponsePtr hit_test_response) {*out_hit_test_response = std::move(hit_test_response);
            loop->Quit();
          },
          &loop,
          out_hit_test_response));
  loop.Run();
}

HitTestResponsePtr RenderAccessibilityAsyncWaiter::HitTest(
    const ::gfx::Point& point, ::ax::mojom::Event event_to_fire, int32_t request_id) {
  HitTestResponsePtr async_wait_result;
  HitTest(std::move(point),std::move(event_to_fire),std::move(request_id),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif