// third_party/blink/public/mojom/quota/quota_manager_host.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.QuotaManagerHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.QuotaManagerHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.QuotaManagerHostInterface }
 */
blink.mojom.QuotaManagerHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.QuotaManagerHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.QuotaManagerHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.QuotaManagerHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        error: !blink.mojom.QuotaStatusCode,
        currentUsage: !bigint,
        currentQuota: !bigint,
        usageBreakdown: !blink.mojom.UsageBreakdown,
   *  }>}
   */

  queryStorageUsageAndQuota() {
    return this.proxy.sendMessage(
        0,
        blink.mojom.QuotaManagerHost_QueryStorageUsageAndQuota_ParamsSpec.$,
        blink.mojom.QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the QuotaManagerHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.QuotaManagerHostReceiver = class {
  /**
   * @param {!blink.mojom.QuotaManagerHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.QuotaManagerHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.QuotaManagerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.QuotaManagerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.QuotaManagerHost_QueryStorageUsageAndQuota_ParamsSpec.$,
        blink.mojom.QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsSpec.$,
        impl.queryStorageUsageAndQuota.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.QuotaManagerHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.QuotaManagerHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.QuotaManagerHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.QuotaManagerHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the QuotaManagerHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.QuotaManagerHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.QuotaManagerHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.QuotaManagerHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queryStorageUsageAndQuota =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.QuotaManagerHost_QueryStorageUsageAndQuota_ParamsSpec.$,
        blink.mojom.QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsSpec.$,
        this.queryStorageUsageAndQuota.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.QuotaManagerHost_QueryStorageUsageAndQuota_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.QuotaManagerHost_QueryStorageUsageAndQuota_ParamsSpec.$,
    'QuotaManagerHost_QueryStorageUsageAndQuota_Params',
    [
    ],
    [[0, 8],]);





/** @record */
blink.mojom.QuotaManagerHost_QueryStorageUsageAndQuota_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    blink.mojom.QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParamsSpec.$,
    'QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams',
    [
      mojo.internal.StructField(
        'error', 0,
        0,
        blink.mojom.QuotaStatusCodeSpec.$,
        -1,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'currentUsage', 8,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'currentQuota', 16,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'usageBreakdown', 24,
        0,
        blink.mojom.UsageBreakdownSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);





/** @record */
blink.mojom.QuotaManagerHost_QueryStorageUsageAndQuota_ResponseParams = class {
  constructor() {
    /** @export { !blink.mojom.QuotaStatusCode } */
    this.error;
    /** @export { !bigint } */
    this.currentUsage;
    /** @export { !bigint } */
    this.currentQuota;
    /** @export { !blink.mojom.UsageBreakdown } */
    this.usageBreakdown;
  }
};

