// third_party/blink/public/mojom/push_messaging/push_messaging.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-params-data.h"
#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/push_messaging/push_messaging.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
PushSubscriptionOptions::PushSubscriptionOptions()
    : user_visible_only(),
      application_server_key() {}

PushSubscriptionOptions::PushSubscriptionOptions(
    bool user_visible_only_in,
    ::blink::Vector<uint8_t> application_server_key_in)
    : user_visible_only(std::move(user_visible_only_in)),
      application_server_key(std::move(application_server_key_in)) {}

PushSubscriptionOptions::~PushSubscriptionOptions() = default;

void PushSubscriptionOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "user_visible_only"), this->user_visible_only,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "application_server_key"), this->application_server_key,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PushSubscriptionOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
PushSubscription::PushSubscription()
    : endpoint(),
      expirationTime(),
      options(),
      p256dh(),
      auth() {}

PushSubscription::PushSubscription(
    const ::blink::KURL& endpoint_in,
    std::optional<::base::Time> expirationTime_in,
    PushSubscriptionOptionsPtr options_in,
    ::blink::Vector<uint8_t> p256dh_in,
    ::blink::Vector<uint8_t> auth_in)
    : endpoint(std::move(endpoint_in)),
      expirationTime(std::move(expirationTime_in)),
      options(std::move(options_in)),
      p256dh(std::move(p256dh_in)),
      auth(std::move(auth_in)) {}

PushSubscription::~PushSubscription() = default;

void PushSubscription::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "endpoint"), this->endpoint,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::KURL&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "expirationTime"), this->expirationTime,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::base::Time>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "options"), this->options,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type PushSubscriptionOptionsPtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "p256dh"), this->p256dh,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "auth"), this->auth,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool PushSubscription::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

PushMessaging::IPCStableHashFunction PushMessaging::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::PushMessaging>(message.name())) {
    case messages::PushMessaging::kSubscribe: {
      return &PushMessaging::Subscribe_Sym::IPCStableHash;
    }
    case messages::PushMessaging::kUnsubscribe: {
      return &PushMessaging::Unsubscribe_Sym::IPCStableHash;
    }
    case messages::PushMessaging::kGetSubscription: {
      return &PushMessaging::GetSubscription_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* PushMessaging::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::PushMessaging>(message.name())) {
      case messages::PushMessaging::kSubscribe:
            return "Receive blink::mojom::PushMessaging::Subscribe";
      case messages::PushMessaging::kUnsubscribe:
            return "Receive blink::mojom::PushMessaging::Unsubscribe";
      case messages::PushMessaging::kGetSubscription:
            return "Receive blink::mojom::PushMessaging::GetSubscription";
    }
  } else {
    switch (static_cast<messages::PushMessaging>(message.name())) {
      case messages::PushMessaging::kSubscribe:
            return "Receive reply blink::mojom::PushMessaging::Subscribe";
      case messages::PushMessaging::kUnsubscribe:
            return "Receive reply blink::mojom::PushMessaging::Unsubscribe";
      case messages::PushMessaging::kGetSubscription:
            return "Receive reply blink::mojom::PushMessaging::GetSubscription";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t PushMessaging::Subscribe_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x1df0df9d;  // IPCStableHash for blink::mojom::PushMessaging::Subscribe
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PushMessaging::Unsubscribe_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf0aa63dc;  // IPCStableHash for blink::mojom::PushMessaging::Unsubscribe
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t PushMessaging::GetSubscription_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x04811bf6;  // IPCStableHash for blink::mojom::PushMessaging::GetSubscription
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class PushMessaging_Subscribe_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PushMessaging_Subscribe_ForwardToCallback(
      PushMessaging::SubscribeCallback callback
      ) : callback_(std::move(callback)) {
  }

  PushMessaging_Subscribe_ForwardToCallback(const PushMessaging_Subscribe_ForwardToCallback&) = delete;
  PushMessaging_Subscribe_ForwardToCallback& operator=(const PushMessaging_Subscribe_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PushMessaging::SubscribeCallback callback_;
};

class PushMessaging_Unsubscribe_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PushMessaging_Unsubscribe_ForwardToCallback(
      PushMessaging::UnsubscribeCallback callback
      ) : callback_(std::move(callback)) {
  }

  PushMessaging_Unsubscribe_ForwardToCallback(const PushMessaging_Unsubscribe_ForwardToCallback&) = delete;
  PushMessaging_Unsubscribe_ForwardToCallback& operator=(const PushMessaging_Unsubscribe_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PushMessaging::UnsubscribeCallback callback_;
};

class PushMessaging_GetSubscription_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  PushMessaging_GetSubscription_ForwardToCallback(
      PushMessaging::GetSubscriptionCallback callback
      ) : callback_(std::move(callback)) {
  }

  PushMessaging_GetSubscription_ForwardToCallback(const PushMessaging_GetSubscription_ForwardToCallback&) = delete;
  PushMessaging_GetSubscription_ForwardToCallback& operator=(const PushMessaging_GetSubscription_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  PushMessaging::GetSubscriptionCallback callback_;
};

PushMessagingProxy::PushMessagingProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void PushMessagingProxy::Subscribe(
    int64_t in_service_worker_registration_id, PushSubscriptionOptionsPtr in_options, bool in_user_gesture, SubscribeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PushMessaging::Subscribe", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id,
                        "<value of type int64_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type PushSubscriptionOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("user_gesture"), in_user_gesture,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushMessaging::kSubscribe), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PushMessaging_Subscribe_Params_Data> params(
          message);
  params.Allocate();

  params->service_worker_registration_id = in_service_worker_registration_id;
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PushSubscriptionOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in PushMessaging.Subscribe request");

  params->user_gesture = in_user_gesture;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushMessaging::Name_);
  message.set_method_name("Subscribe");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PushMessaging_Subscribe_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PushMessagingProxy::Unsubscribe(
    int64_t in_service_worker_registration_id, UnsubscribeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PushMessaging::Unsubscribe", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushMessaging::kUnsubscribe), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PushMessaging_Unsubscribe_Params_Data> params(
          message);
  params.Allocate();

  params->service_worker_registration_id = in_service_worker_registration_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushMessaging::Name_);
  message.set_method_name("Unsubscribe");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PushMessaging_Unsubscribe_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void PushMessagingProxy::GetSubscription(
    int64_t in_service_worker_registration_id, GetSubscriptionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::PushMessaging::GetSubscription", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("service_worker_registration_id"), in_service_worker_registration_id,
                        "<value of type int64_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushMessaging::kGetSubscription), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PushMessaging_GetSubscription_Params_Data> params(
          message);
  params.Allocate();

  params->service_worker_registration_id = in_service_worker_registration_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushMessaging::Name_);
  message.set_method_name("GetSubscription");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new PushMessaging_GetSubscription_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class PushMessaging_Subscribe_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PushMessaging::SubscribeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PushMessaging_Subscribe_ProxyToResponder> proxy(
        new PushMessaging_Subscribe_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PushMessaging_Subscribe_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PushMessaging_Subscribe_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PushMessaging_Subscribe_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PushMessaging::SubscribeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::PushRegistrationStatus in_status, PushSubscriptionPtr in_subscription);
};

bool PushMessaging_Subscribe_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PushMessaging_Subscribe_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PushMessaging_Subscribe_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PushMessaging.0
  bool success = true;
  ::blink::mojom::blink::PushRegistrationStatus p_status{};
  PushSubscriptionPtr p_subscription{};
  PushMessaging_Subscribe_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadSubscription(&p_subscription))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PushMessaging::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_subscription));
  }
  return true;
}

void PushMessaging_Subscribe_ProxyToResponder::Run(
    ::blink::mojom::blink::PushRegistrationStatus in_status, PushSubscriptionPtr in_subscription) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::PushMessaging::Subscribe", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::PushRegistrationStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscription"), in_subscription,
                        "<value of type PushSubscriptionPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushMessaging::kSubscribe), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PushMessaging_Subscribe_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PushRegistrationStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->subscription)::BaseType> subscription_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PushSubscriptionDataView>(
    in_subscription,
    subscription_fragment);

  params->subscription.Set(
      subscription_fragment.is_null() ? nullptr : subscription_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushMessaging::Name_);
  message.set_method_name("Subscribe");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PushMessaging_Unsubscribe_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PushMessaging::UnsubscribeCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PushMessaging_Unsubscribe_ProxyToResponder> proxy(
        new PushMessaging_Unsubscribe_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PushMessaging_Unsubscribe_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PushMessaging_Unsubscribe_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PushMessaging_Unsubscribe_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PushMessaging::UnsubscribeCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      PushErrorType in_error_type, bool in_did_unsubscribe, const ::blink::String& in_error_message);
};

bool PushMessaging_Unsubscribe_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PushMessaging_Unsubscribe_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PushMessaging_Unsubscribe_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PushMessaging.1
  bool success = true;
  PushErrorType p_error_type{};
  bool p_did_unsubscribe{};
  ::blink::String p_error_message{};
  PushMessaging_Unsubscribe_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadErrorType(&p_error_type))
    success = false;
  if (success)
    p_did_unsubscribe = input_data_view.did_unsubscribe();
  if (success && !input_data_view.ReadErrorMessage(&p_error_message))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PushMessaging::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_error_type), 
std::move(p_did_unsubscribe), 
std::move(p_error_message));
  }
  return true;
}

void PushMessaging_Unsubscribe_ProxyToResponder::Run(
    PushErrorType in_error_type, bool in_did_unsubscribe, const ::blink::String& in_error_message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::PushMessaging::Unsubscribe", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_type"), in_error_type,
                        "<value of type PushErrorType>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("did_unsubscribe"), in_did_unsubscribe,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("error_message"), in_error_message,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushMessaging::kUnsubscribe), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PushMessaging_Unsubscribe_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PushErrorType>(
    in_error_type,
    &params->error_type);

  params->did_unsubscribe = in_did_unsubscribe;
  mojo::internal::MessageFragment<
      typename decltype(params->error_message)::BaseType> error_message_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_error_message,
    error_message_fragment);

  params->error_message.Set(
      error_message_fragment.is_null() ? nullptr : error_message_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushMessaging::Name_);
  message.set_method_name("Unsubscribe");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class PushMessaging_GetSubscription_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static PushMessaging::GetSubscriptionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<PushMessaging_GetSubscription_ProxyToResponder> proxy(
        new PushMessaging_GetSubscription_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&PushMessaging_GetSubscription_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~PushMessaging_GetSubscription_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  PushMessaging_GetSubscription_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "PushMessaging::GetSubscriptionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::mojom::blink::PushGetRegistrationStatus in_status, PushSubscriptionPtr in_subscription);
};

bool PushMessaging_GetSubscription_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::PushMessaging_GetSubscription_ResponseParams_Data* params =
      reinterpret_cast<
          internal::PushMessaging_GetSubscription_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for PushMessaging.2
  bool success = true;
  ::blink::mojom::blink::PushGetRegistrationStatus p_status{};
  PushSubscriptionPtr p_subscription{};
  PushMessaging_GetSubscription_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (success && !input_data_view.ReadSubscription(&p_subscription))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        PushMessaging::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status), 
std::move(p_subscription));
  }
  return true;
}

void PushMessaging_GetSubscription_ProxyToResponder::Run(
    ::blink::mojom::blink::PushGetRegistrationStatus in_status, PushSubscriptionPtr in_subscription) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::PushMessaging::GetSubscription", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::blink::mojom::blink::PushGetRegistrationStatus>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("subscription"), in_subscription,
                        "<value of type PushSubscriptionPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::PushMessaging::kGetSubscription), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::PushMessaging_GetSubscription_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::PushGetRegistrationStatus>(
    in_status,
    &params->status);
  mojo::internal::MessageFragment<
      typename decltype(params->subscription)::BaseType> subscription_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::PushSubscriptionDataView>(
    in_subscription,
    subscription_fragment);

  params->subscription.Set(
      subscription_fragment.is_null() ? nullptr : subscription_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(PushMessaging::Name_);
  message.set_method_name("GetSubscription");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool PushMessagingStubDispatch::Accept(
    PushMessaging* impl,
    mojo::Message* message) {
  switch (static_cast<messages::PushMessaging>(message->header()->name)) {
    case messages::PushMessaging::kSubscribe: {
      break;
    }
    case messages::PushMessaging::kUnsubscribe: {
      break;
    }
    case messages::PushMessaging::kGetSubscription: {
      break;
    }
  }
  return false;
}

// static
bool PushMessagingStubDispatch::AcceptWithResponder(
    PushMessaging* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::PushMessaging>(message->header()->name)) {
    case messages::PushMessaging::kSubscribe: {
      internal::PushMessaging_Subscribe_Params_Data* params =
          reinterpret_cast<
              internal::PushMessaging_Subscribe_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PushMessaging.0
      bool success = true;
      int64_t p_service_worker_registration_id{};
      PushSubscriptionOptionsPtr p_options{};
      bool p_user_gesture{};
      PushMessaging_Subscribe_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success)
        p_user_gesture = input_data_view.user_gesture();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushMessaging::Name_, 0, false);
        return false;
      }
      auto callback =
          PushMessaging_Subscribe_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Subscribe(        
        std::move(p_service_worker_registration_id), 
        std::move(p_options), 
        std::move(p_user_gesture), std::move(callback));
      return true;
    }
    case messages::PushMessaging::kUnsubscribe: {
      internal::PushMessaging_Unsubscribe_Params_Data* params =
          reinterpret_cast<
              internal::PushMessaging_Unsubscribe_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PushMessaging.1
      bool success = true;
      int64_t p_service_worker_registration_id{};
      PushMessaging_Unsubscribe_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushMessaging::Name_, 1, false);
        return false;
      }
      auto callback =
          PushMessaging_Unsubscribe_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Unsubscribe(        
        std::move(p_service_worker_registration_id), std::move(callback));
      return true;
    }
    case messages::PushMessaging::kGetSubscription: {
      internal::PushMessaging_GetSubscription_Params_Data* params =
          reinterpret_cast<
              internal::PushMessaging_GetSubscription_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for PushMessaging.2
      bool success = true;
      int64_t p_service_worker_registration_id{};
      PushMessaging_GetSubscription_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_service_worker_registration_id = input_data_view.service_worker_registration_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            PushMessaging::Name_, 2, false);
        return false;
      }
      auto callback =
          PushMessaging_GetSubscription_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetSubscription(        
        std::move(p_service_worker_registration_id), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kPushMessagingValidationInfo[] = {
    { &internal::PushMessaging_Subscribe_Params_Data::Validate,
     &internal::PushMessaging_Subscribe_ResponseParams_Data::Validate},
    { &internal::PushMessaging_Unsubscribe_Params_Data::Validate,
     &internal::PushMessaging_Unsubscribe_ResponseParams_Data::Validate},
    { &internal::PushMessaging_GetSubscription_Params_Data::Validate,
     &internal::PushMessaging_GetSubscription_ResponseParams_Data::Validate},
};

bool PushMessagingRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::PushMessaging::Name_,
    kPushMessagingValidationInfo);
}

bool PushMessagingResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::PushMessaging::Name_,
    kPushMessagingValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::PushSubscriptionOptions::DataView, ::blink::mojom::blink::PushSubscriptionOptionsPtr>::Read(
    ::blink::mojom::blink::PushSubscriptionOptions::DataView input,
    ::blink::mojom::blink::PushSubscriptionOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PushSubscriptionOptionsPtr result(::blink::mojom::blink::PushSubscriptionOptions::New());
  
      if (success)
        result->user_visible_only = input.user_visible_only();
      if (success && !input.ReadApplicationServerKey(&result->application_server_key))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::PushSubscription::DataView, ::blink::mojom::blink::PushSubscriptionPtr>::Read(
    ::blink::mojom::blink::PushSubscription::DataView input,
    ::blink::mojom::blink::PushSubscriptionPtr* output) {
  bool success = true;
  ::blink::mojom::blink::PushSubscriptionPtr result(::blink::mojom::blink::PushSubscription::New());
  
      if (success && !input.ReadEndpoint(&result->endpoint))
        success = false;
      if (success && !input.ReadExpirationTime(&result->expirationTime))
        success = false;
      if (success && !input.ReadOptions(&result->options))
        success = false;
      if (success && !input.ReadP256dh(&result->p256dh))
        success = false;
      if (success && !input.ReadAuth(&result->auth))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void PushMessagingInterceptorForTesting::Subscribe(int64_t service_worker_registration_id, PushSubscriptionOptionsPtr options, bool user_gesture, SubscribeCallback callback) {
  GetForwardingInterface()->Subscribe(
    std::move(service_worker_registration_id)
    , 
    std::move(options)
    , 
    std::move(user_gesture)
    , std::move(callback));
}
void PushMessagingInterceptorForTesting::Unsubscribe(int64_t service_worker_registration_id, UnsubscribeCallback callback) {
  GetForwardingInterface()->Unsubscribe(
    std::move(service_worker_registration_id)
    , std::move(callback));
}
void PushMessagingInterceptorForTesting::GetSubscription(int64_t service_worker_registration_id, GetSubscriptionCallback callback) {
  GetForwardingInterface()->GetSubscription(
    std::move(service_worker_registration_id)
    , std::move(callback));
}
PushMessagingAsyncWaiter::PushMessagingAsyncWaiter(
    PushMessaging* proxy) : proxy_(proxy) {}

PushMessagingAsyncWaiter::~PushMessagingAsyncWaiter() = default;


void PushMessagingAsyncWaiter::Subscribe(
    int64_t service_worker_registration_id, PushSubscriptionOptionsPtr options, bool user_gesture, ::blink::mojom::blink::PushRegistrationStatus* out_status, PushSubscriptionPtr* out_subscription) {
  base::RunLoop loop;
  proxy_->Subscribe(
      std::move(service_worker_registration_id),
      std::move(options),
      std::move(user_gesture),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::PushRegistrationStatus* out_status
,
             PushSubscriptionPtr* out_subscription
,
             ::blink::mojom::blink::PushRegistrationStatus status,
             PushSubscriptionPtr subscription) {*out_status = std::move(status);*out_subscription = std::move(subscription);
            loop->Quit();
          },
          &loop,
          out_status,
          out_subscription));
  loop.Run();
}



void PushMessagingAsyncWaiter::Unsubscribe(
    int64_t service_worker_registration_id, PushErrorType* out_error_type, bool* out_did_unsubscribe, ::blink::String* out_error_message) {
  base::RunLoop loop;
  proxy_->Unsubscribe(
      std::move(service_worker_registration_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             PushErrorType* out_error_type
,
             bool* out_did_unsubscribe
,
             ::blink::String* out_error_message
,
             PushErrorType error_type,
             bool did_unsubscribe,
             const ::blink::String& error_message) {*out_error_type = std::move(error_type);*out_did_unsubscribe = std::move(did_unsubscribe);*out_error_message = std::move(error_message);
            loop->Quit();
          },
          &loop,
          out_error_type,
          out_did_unsubscribe,
          out_error_message));
  loop.Run();
}



void PushMessagingAsyncWaiter::GetSubscription(
    int64_t service_worker_registration_id, ::blink::mojom::blink::PushGetRegistrationStatus* out_status, PushSubscriptionPtr* out_subscription) {
  base::RunLoop loop;
  proxy_->GetSubscription(
      std::move(service_worker_registration_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::mojom::blink::PushGetRegistrationStatus* out_status
,
             PushSubscriptionPtr* out_subscription
,
             ::blink::mojom::blink::PushGetRegistrationStatus status,
             PushSubscriptionPtr subscription) {*out_status = std::move(status);*out_subscription = std::move(subscription);
            loop->Quit();
          },
          &loop,
          out_status,
          out_subscription));
  loop.Run();
}








}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif