// third_party/blink/public/mojom/preloading/anchor_element_interaction_host.mojom-lite.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';


mojo.internal.exportModule('blink.mojom');








/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.AnchorElementInteractionHostPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.AnchorElementInteractionHost.$interfaceName,
        scope);
  }
};



/**
 * @export
 * @implements { blink.mojom.AnchorElementInteractionHostInterface }
 */
blink.mojom.AnchorElementInteractionHostRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.AnchorElementInteractionHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.AnchorElementInteractionHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.AnchorElementInteractionHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url.mojom.Url } target
   */

  onPointerDown(
      target) {
    this.proxy.sendMessage(
        0,
        blink.mojom.AnchorElementInteractionHost_OnPointerDown_ParamsSpec.$,
        null,
        [
          target
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } target
   * @param { !blink.mojom.AnchorElementPointerData } mouseData
   */

  onPointerHoverEager(
      target,
      mouseData) {
    this.proxy.sendMessage(
        1,
        blink.mojom.AnchorElementInteractionHost_OnPointerHoverEager_ParamsSpec.$,
        null,
        [
          target,
          mouseData
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } target
   * @param { !blink.mojom.AnchorElementPointerData } mouseData
   */

  onPointerHoverModerate(
      target,
      mouseData) {
    this.proxy.sendMessage(
        2,
        blink.mojom.AnchorElementInteractionHost_OnPointerHoverModerate_ParamsSpec.$,
        null,
        [
          target,
          mouseData
        ],
        false);
  }

  
  /**
   * @param { !url.mojom.Url } target
   */

  onModerateViewportHeuristicTriggered(
      target) {
    this.proxy.sendMessage(
        3,
        blink.mojom.AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_ParamsSpec.$,
        null,
        [
          target
        ],
        false);
  }

  
  /**
   * @param { !Array<!url.mojom.Url> } targets
   */

  onEagerViewportHeuristicTriggered(
      targets) {
    this.proxy.sendMessage(
        4,
        blink.mojom.AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_ParamsSpec.$,
        null,
        [
          targets
        ],
        false);
  }
};

/**
 * An object which receives request messages for the AnchorElementInteractionHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.AnchorElementInteractionHostReceiver = class {
  /**
   * @param {!blink.mojom.AnchorElementInteractionHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.AnchorElementInteractionHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.AnchorElementInteractionHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AnchorElementInteractionHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AnchorElementInteractionHost_OnPointerDown_ParamsSpec.$,
        null,
        impl.onPointerDown.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AnchorElementInteractionHost_OnPointerHoverEager_ParamsSpec.$,
        null,
        impl.onPointerHoverEager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AnchorElementInteractionHost_OnPointerHoverModerate_ParamsSpec.$,
        null,
        impl.onPointerHoverModerate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        blink.mojom.AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_ParamsSpec.$,
        null,
        impl.onModerateViewportHeuristicTriggered.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        blink.mojom.AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_ParamsSpec.$,
        null,
        impl.onEagerViewportHeuristicTriggered.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.AnchorElementInteractionHost = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.AnchorElementInteractionHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.AnchorElementInteractionHostRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.AnchorElementInteractionHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the AnchorElementInteractionHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.AnchorElementInteractionHostCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.AnchorElementInteractionHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.AnchorElementInteractionHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPointerDown =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.AnchorElementInteractionHost_OnPointerDown_ParamsSpec.$,
        null,
        this.onPointerDown.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPointerHoverEager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.AnchorElementInteractionHost_OnPointerHoverEager_ParamsSpec.$,
        null,
        this.onPointerHoverEager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPointerHoverModerate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        blink.mojom.AnchorElementInteractionHost_OnPointerHoverModerate_ParamsSpec.$,
        null,
        this.onPointerHoverModerate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onModerateViewportHeuristicTriggered =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        blink.mojom.AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_ParamsSpec.$,
        null,
        this.onModerateViewportHeuristicTriggered.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEagerViewportHeuristicTriggered =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        blink.mojom.AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_ParamsSpec.$,
        null,
        this.onEagerViewportHeuristicTriggered.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};



/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementPointerDataSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementInteractionHost_OnPointerDown_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementInteractionHost_OnPointerHoverEager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementInteractionHost_OnPointerHoverModerate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };


/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.AnchorElementPointerDataSpec.$,
    'AnchorElementPointerData',
    [
      mojo.internal.StructField(
        'isMousePointer', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mouseVelocity', 8,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mouseAcceleration', 16,
        0,
        mojo.internal.Double,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);





/** @record */
blink.mojom.AnchorElementPointerData = class {
  constructor() {
    /** @export { !boolean } */
    this.isMousePointer;
    /** @export { !number } */
    this.mouseVelocity;
    /** @export { !number } */
    this.mouseAcceleration;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementInteractionHost_OnPointerDown_ParamsSpec.$,
    'AnchorElementInteractionHost_OnPointerDown_Params',
    [
      mojo.internal.StructField(
        'target', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.AnchorElementInteractionHost_OnPointerDown_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.target;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementInteractionHost_OnPointerHoverEager_ParamsSpec.$,
    'AnchorElementInteractionHost_OnPointerHoverEager_Params',
    [
      mojo.internal.StructField(
        'target', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mouseData', 8,
        0,
        blink.mojom.AnchorElementPointerDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.AnchorElementInteractionHost_OnPointerHoverEager_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.target;
    /** @export { !blink.mojom.AnchorElementPointerData } */
    this.mouseData;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementInteractionHost_OnPointerHoverModerate_ParamsSpec.$,
    'AnchorElementInteractionHost_OnPointerHoverModerate_Params',
    [
      mojo.internal.StructField(
        'target', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'mouseData', 8,
        0,
        blink.mojom.AnchorElementPointerDataSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);





/** @record */
blink.mojom.AnchorElementInteractionHost_OnPointerHoverModerate_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.target;
    /** @export { !blink.mojom.AnchorElementPointerData } */
    this.mouseData;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_ParamsSpec.$,
    'AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Params',
    [
      mojo.internal.StructField(
        'target', 0,
        0,
        url.mojom.UrlSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.AnchorElementInteractionHost_OnModerateViewportHeuristicTriggered_Params = class {
  constructor() {
    /** @export { !url.mojom.Url } */
    this.target;
  }
};



mojo.internal.Struct(
    blink.mojom.AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_ParamsSpec.$,
    'AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Params',
    [
      mojo.internal.StructField(
        'targets', 0,
        0,
        mojo.internal.Array(url.mojom.UrlSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);





/** @record */
blink.mojom.AnchorElementInteractionHost_OnEagerViewportHeuristicTriggered_Params = class {
  constructor() {
    /** @export { !Array<!url.mojom.Url> } */
    this.targets;
  }
};

