// third_party/blink/public/mojom/preloading/anchor_element_interaction_host.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRELOADING_ANCHOR_ELEMENT_INTERACTION_HOST_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRELOADING_ANCHOR_ELEMENT_INTERACTION_HOST_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/preloading/anchor_element_interaction_host.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/preloading/anchor_element_interaction_host.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/preloading/anchor_element_interaction_host.mojom-blink-forward.h"  // IWYU pragma: export
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {

class AnchorElementInteractionHostProxy;

template <typename ImplRefTraits>
class AnchorElementInteractionHostStub;

class AnchorElementInteractionHostRequestValidator;


class PLATFORM_EXPORT AnchorElementInteractionHost
    : public AnchorElementInteractionHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.AnchorElementInteractionHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = AnchorElementInteractionHostInterfaceBase;
  using Proxy_ = AnchorElementInteractionHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = AnchorElementInteractionHostStub<ImplRefTraits>;

  using RequestValidator_ = AnchorElementInteractionHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnPointerDownMinVersion = 0,
    kOnPointerHoverEagerMinVersion = 0,
    kOnPointerHoverModerateMinVersion = 0,
    kOnModerateViewportHeuristicTriggeredMinVersion = 0,
    kOnEagerViewportHeuristicTriggeredMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnPointerDown_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPointerHoverEager_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnPointerHoverModerate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnModerateViewportHeuristicTriggered_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnEagerViewportHeuristicTriggered_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~AnchorElementInteractionHost() = default;

  virtual void OnPointerDown(const ::blink::KURL& target) = 0;

  virtual void OnPointerHoverEager(const ::blink::KURL& target, AnchorElementPointerDataPtr mouse_data) = 0;

  virtual void OnPointerHoverModerate(const ::blink::KURL& target, AnchorElementPointerDataPtr mouse_data) = 0;

  virtual void OnModerateViewportHeuristicTriggered(const ::blink::KURL& target) = 0;

  virtual void OnEagerViewportHeuristicTriggered(const ::blink::Vector<::blink::KURL>& targets) = 0;
};



class PLATFORM_EXPORT AnchorElementInteractionHostProxy
    : public AnchorElementInteractionHost {
 public:
  using InterfaceType = AnchorElementInteractionHost;

  explicit AnchorElementInteractionHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnPointerDown(const ::blink::KURL& target) final;
  
  void OnPointerHoverEager(const ::blink::KURL& target, AnchorElementPointerDataPtr mouse_data) final;
  
  void OnPointerHoverModerate(const ::blink::KURL& target, AnchorElementPointerDataPtr mouse_data) final;
  
  void OnModerateViewportHeuristicTriggered(const ::blink::KURL& target) final;
  
  void OnEagerViewportHeuristicTriggered(const ::blink::Vector<::blink::KURL>& targets) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class PLATFORM_EXPORT AnchorElementInteractionHostStubDispatch {
 public:
  static bool Accept(AnchorElementInteractionHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AnchorElementInteractionHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AnchorElementInteractionHost>>
class AnchorElementInteractionHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AnchorElementInteractionHostStub() = default;
  ~AnchorElementInteractionHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AnchorElementInteractionHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AnchorElementInteractionHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class PLATFORM_EXPORT AnchorElementInteractionHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class PLATFORM_EXPORT AnchorElementPointerData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AnchorElementPointerData, T>::value>;
  using DataView = AnchorElementPointerDataDataView;
  using Data_ = internal::AnchorElementPointerData_Data;

  template <typename... Args>
  static AnchorElementPointerDataPtr New(Args&&... args) {
    return AnchorElementPointerDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AnchorElementPointerDataPtr From(const U& u) {
    return mojo::TypeConverter<AnchorElementPointerDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AnchorElementPointerData>::Convert(*this);
  }


  AnchorElementPointerData();

  AnchorElementPointerData(
      bool is_mouse_pointer,
      double mouse_velocity,
      double mouse_acceleration);


  ~AnchorElementPointerData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AnchorElementPointerDataPtr>
  AnchorElementPointerDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AnchorElementPointerData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AnchorElementPointerData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AnchorElementPointerData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }
  size_t Hash(size_t seed) const;

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementPointerData::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnchorElementPointerData::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AnchorElementPointerData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AnchorElementPointerData_UnserializedMessageContext<
            UserType, AnchorElementPointerData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AnchorElementPointerData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AnchorElementPointerData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AnchorElementPointerData_UnserializedMessageContext<
            UserType, AnchorElementPointerData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AnchorElementPointerData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool is_mouse_pointer;
  
  double mouse_velocity;
  
  double mouse_acceleration;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AnchorElementPointerData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AnchorElementPointerData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AnchorElementPointerData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AnchorElementPointerData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
AnchorElementPointerDataPtr AnchorElementPointerData::Clone() const {
  return New(
      mojo::Clone(is_mouse_pointer),
      mojo::Clone(mouse_velocity),
      mojo::Clone(mouse_acceleration)
  );
}

template <typename T, AnchorElementPointerData::EnableIfSame<T>*>
bool AnchorElementPointerData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->is_mouse_pointer, other_struct.is_mouse_pointer))
    return false;
  if (!mojo::Equals(this->mouse_velocity, other_struct.mouse_velocity))
    return false;
  if (!mojo::Equals(this->mouse_acceleration, other_struct.mouse_acceleration))
    return false;
  return true;
}

template <typename T, AnchorElementPointerData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.is_mouse_pointer < rhs.is_mouse_pointer)
    return true;
  if (rhs.is_mouse_pointer < lhs.is_mouse_pointer)
    return false;
  if (lhs.mouse_velocity < rhs.mouse_velocity)
    return true;
  if (rhs.mouse_velocity < lhs.mouse_velocity)
    return false;
  if (lhs.mouse_acceleration < rhs.mouse_acceleration)
    return true;
  if (rhs.mouse_acceleration < lhs.mouse_acceleration)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::AnchorElementPointerData::DataView,
                                         ::blink::mojom::blink::AnchorElementPointerDataPtr> {
  static bool IsNull(const ::blink::mojom::blink::AnchorElementPointerDataPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::AnchorElementPointerDataPtr* output) { output->reset(); }

  static decltype(::blink::mojom::blink::AnchorElementPointerData::is_mouse_pointer) is_mouse_pointer(
      const ::blink::mojom::blink::AnchorElementPointerDataPtr& input) {
    return input->is_mouse_pointer;
  }

  static decltype(::blink::mojom::blink::AnchorElementPointerData::mouse_velocity) mouse_velocity(
      const ::blink::mojom::blink::AnchorElementPointerDataPtr& input) {
    return input->mouse_velocity;
  }

  static decltype(::blink::mojom::blink::AnchorElementPointerData::mouse_acceleration) mouse_acceleration(
      const ::blink::mojom::blink::AnchorElementPointerDataPtr& input) {
    return input->mouse_acceleration;
  }

  static bool Read(::blink::mojom::blink::AnchorElementPointerData::DataView input, ::blink::mojom::blink::AnchorElementPointerDataPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PRELOADING_ANCHOR_ELEMENT_INTERACTION_HOST_MOJOM_BLINK_H_