// third_party/blink/public/mojom/permissions/permission.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/permissions/permission.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/permissions/permission_status.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "third_party/blink/public/mojom/permissions/permission.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::PermissionName, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::EmbeddedPermissionControlResult, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::MidiPermissionDescriptorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::MidiPermissionDescriptorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::MidiPermissionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->sysex = Traits::sysex(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ClipboardPermissionDescriptorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ClipboardPermissionDescriptorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ClipboardPermissionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->has_user_gesture = Traits::has_user_gesture(input);

      fragment->will_be_sanitized = Traits::will_be_sanitized(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::CameraDevicePermissionDescriptorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::CameraDevicePermissionDescriptorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::CameraDevicePermissionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->panTiltZoom = Traits::panTiltZoom(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::TopLevelStorageAccessPermissionDescriptorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::TopLevelStorageAccessPermissionDescriptorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::TopLevelStorageAccessPermissionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::requestedOrigin(input)) in_requestedOrigin = Traits::requestedOrigin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->requestedOrigin)::BaseType> requestedOrigin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_requestedOrigin,
        requestedOrigin_fragment);

      fragment->requestedOrigin.Set(
          requestedOrigin_fragment.is_null() ? nullptr : requestedOrigin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->requestedOrigin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null requestedOrigin in TopLevelStorageAccessPermissionDescriptor struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::FullscreenPermissionDescriptorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FullscreenPermissionDescriptorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::FullscreenPermissionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->allow_without_user_gesture = Traits::allow_without_user_gesture(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::PermissionDescriptorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PermissionDescriptorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PermissionDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::blink::mojom::PermissionName>(
        Traits::name(input),
        &fragment->name);

      decltype(Traits::extension(input)) in_extension = Traits::extension(input);
      mojo::internal::MessageFragment<decltype(fragment->extension)>
          extension_fragment(fragment.message());
      extension_fragment.Claim(&fragment->extension);
      
      mojo::internal::Serialize<::blink::mojom::PermissionDescriptorExtensionDataView, send_validation>(
        in_extension,
        extension_fragment,
        true);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::GeolocationEmbeddedPermissionRequestDescriptorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::GeolocationEmbeddedPermissionRequestDescriptorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::GeolocationEmbeddedPermissionRequestDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->autolocate = Traits::autolocate(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::EmbeddedPermissionRequestDescriptorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::EmbeddedPermissionRequestDescriptorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::EmbeddedPermissionRequestDescriptor_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::element_position(input)) in_element_position = Traits::element_position(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->element_position)::BaseType> element_position_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_element_position,
        element_position_fragment);

      fragment->element_position.Set(
          element_position_fragment.is_null() ? nullptr : element_position_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->element_position.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null element_position in EmbeddedPermissionRequestDescriptor struct");

      decltype(Traits::geolocation(input)) in_geolocation = Traits::geolocation(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->geolocation)::BaseType> geolocation_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::GeolocationEmbeddedPermissionRequestDescriptorDataView, send_validation>(
        in_geolocation,
        geolocation_fragment);

      fragment->geolocation.Set(
          geolocation_fragment.is_null() ? nullptr : geolocation_fragment.data());
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::PermissionDescriptorExtensionDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::blink::mojom::PermissionDescriptorExtensionDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::blink::mojom::internal::PermissionDescriptorExtension_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::blink::mojom::PermissionDescriptorExtensionDataView::Tag::kMidi: {
    decltype(Traits::midi(input))
    in_midi = Traits::midi(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_midi)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::MidiPermissionDescriptorDataView, send_validation>(
  in_midi,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null midi in PermissionDescriptorExtension union");
    fragment->data.f_midi.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::PermissionDescriptorExtensionDataView::Tag::kClipboard: {
    decltype(Traits::clipboard(input))
    in_clipboard = Traits::clipboard(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_clipboard)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::ClipboardPermissionDescriptorDataView, send_validation>(
  in_clipboard,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null clipboard in PermissionDescriptorExtension union");
    fragment->data.f_clipboard.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::PermissionDescriptorExtensionDataView::Tag::kCameraDevice: {
    decltype(Traits::camera_device(input))
    in_camera_device = Traits::camera_device(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_camera_device)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::CameraDevicePermissionDescriptorDataView, send_validation>(
  in_camera_device,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null camera_device in PermissionDescriptorExtension union");
    fragment->data.f_camera_device.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::PermissionDescriptorExtensionDataView::Tag::kTopLevelStorageAccess: {
    decltype(Traits::top_level_storage_access(input))
    in_top_level_storage_access = Traits::top_level_storage_access(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_top_level_storage_access)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::TopLevelStorageAccessPermissionDescriptorDataView, send_validation>(
  in_top_level_storage_access,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null top_level_storage_access in PermissionDescriptorExtension union");
    fragment->data.f_top_level_storage_access.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::blink::mojom::PermissionDescriptorExtensionDataView::Tag::kFullscreen: {
    decltype(Traits::fullscreen(input))
    in_fullscreen = Traits::fullscreen(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_fullscreen)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::blink::mojom::FullscreenPermissionDescriptorDataView, send_validation>(
  in_fullscreen,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null fullscreen in PermissionDescriptorExtension union");
    fragment->data.f_fullscreen.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PERMISSIONS_PERMISSION_MOJOM_SEND_VALIDATION_H_