// third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PEERCONNECTION_PEER_CONNECTION_TRACKER_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PEERCONNECTION_PEER_CONNECTION_TRACKER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/peerconnection/peer_connection_tracker.mojom-shared-internal.h"
#include "mojo/public/mojom/base/values.mojom-shared.h"


namespace blink::mojom {
class PeerConnectionInfoDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::PeerConnectionInfoDataView> {
  using Data = ::blink::mojom::internal::PeerConnectionInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class DeviceThermalState : int32_t {
  
  kUnknown = 0,
  
  kNominal = 1,
  
  kFair = 2,
  
  kSerious = 3,
  
  kCritical = 4,
  kMinValue = 0,
  kMaxValue = 4,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, DeviceThermalState value);
inline bool IsKnownEnumValue(DeviceThermalState value) {
  return internal::DeviceThermalState_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class PeerConnectionManagerInterfaceBase {};

using PeerConnectionManagerPtrDataView =
    mojo::InterfacePtrDataView<PeerConnectionManagerInterfaceBase>;
using PeerConnectionManagerRequestDataView =
    mojo::InterfaceRequestDataView<PeerConnectionManagerInterfaceBase>;
using PeerConnectionManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PeerConnectionManagerInterfaceBase>;
using PeerConnectionManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PeerConnectionManagerInterfaceBase>;
class PeerConnectionTrackerHostInterfaceBase {};

using PeerConnectionTrackerHostPtrDataView =
    mojo::InterfacePtrDataView<PeerConnectionTrackerHostInterfaceBase>;
using PeerConnectionTrackerHostRequestDataView =
    mojo::InterfaceRequestDataView<PeerConnectionTrackerHostInterfaceBase>;
using PeerConnectionTrackerHostAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<PeerConnectionTrackerHostInterfaceBase>;
using PeerConnectionTrackerHostAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<PeerConnectionTrackerHostInterfaceBase>;


class PeerConnectionInfoDataView {
 public:
  PeerConnectionInfoDataView() = default;

  PeerConnectionInfoDataView(
      internal::PeerConnectionInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  int32_t lid() const {
    return data_->lid;
  }
  inline void GetRtcConfigurationDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRtcConfiguration(UserType* output) {
    
    auto* pointer = data_->rtc_configuration.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetUrlDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `url` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUrl` instead "
    "of `ReadUrl if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::PeerConnectionInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PEERCONNECTION_PEER_CONNECTION_TRACKER_MOJOM_DATA_VIEW_H_