// third_party/blink/public/mojom/page/widget.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_WIDGET_MOJOM_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_WIDGET_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/page/widget.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/page/widget.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/page/widget.mojom-forward.h"  // IWYU pragma: export
#include "cc/mojom/touch_action.mojom.h"
#include "mojo/public/mojom/base/text_direction.mojom.h"
#include "services/viz/public/mojom/compositing/local_surface_id.mojom-forward.h"
#include "skia/public/mojom/bitmap.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/intrinsic_sizing_info.mojom-forward.h"
#include "third_party/blink/public/mojom/frame/viewport_intersection_state.mojom-forward.h"
#include "third_party/blink/public/mojom/input/ime_host.mojom-forward.h"
#include "third_party/blink/public/mojom/input/touch_event.mojom-forward.h"
#include "third_party/blink/public/mojom/drag/drag.mojom.h"
#include "third_party/blink/public/mojom/widget/platform_widget.mojom-forward.h"
#include "third_party/blink/public/mojom/widget/device_emulation_params.mojom.h"
#include "third_party/blink/public/mojom/widget/visual_properties.mojom.h"
#include "ui/base/dragdrop/mojom/drag_drop_types.mojom-forward.h"
#include "ui/base/mojom/ui_base_types.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "ui/gfx/range/mojom/range.mojom-forward.h"
#include "ui/base/mojom/attributed_string.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"


#include "third_party/blink/public/common/common_export.h"




namespace blink::mojom {

class FrameWidgetProxy;

template <typename ImplRefTraits>
class FrameWidgetStub;

class FrameWidgetRequestValidator;
class FrameWidgetResponseValidator;


class BLINK_COMMON_EXPORT FrameWidget
    : public FrameWidgetInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.FrameWidget";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FrameWidgetInterfaceBase;
  using Proxy_ = FrameWidgetProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameWidgetStub<ImplRefTraits>;

  using RequestValidator_ = FrameWidgetRequestValidator;
  using ResponseValidator_ = FrameWidgetResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDragTargetDragEnterMinVersion = 0,
    kDragTargetDragOverMinVersion = 0,
    kDragTargetDragLeaveMinVersion = 0,
    kDragTargetDropMinVersion = 0,
    kDragSourceEndedAtMinVersion = 0,
    kDragSourceSystemDragEndedMinVersion = 0,
    kOnStartStylusWritingMinVersion = 0,
    kSetBackgroundOpaqueMinVersion = 0,
    kSetTextDirectionMinVersion = 0,
    kSetActiveMinVersion = 0,
    kSetInheritedEffectiveTouchActionForSubFrameMinVersion = 0,
    kUpdateRenderThrottlingStatusForSubFrameMinVersion = 0,
    kSetIsInertForSubFrameMinVersion = 0,
    kGetStringAtPointMinVersion = 0,
    kEnableDeviceEmulationMinVersion = 0,
    kDisableDeviceEmulationMinVersion = 0,
    kBindWidgetCompositorMinVersion = 0,
    kSetViewportIntersectionMinVersion = 0,
    kNotifyClearedDisplayedGraphicsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct DragTargetDragEnter_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DragTargetDragOver_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DragTargetDragLeave_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DragTargetDrop_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DragSourceEndedAt_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DragSourceSystemDragEnded_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnStartStylusWriting_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetBackgroundOpaque_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetTextDirection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetActive_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetInheritedEffectiveTouchActionForSubFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateRenderThrottlingStatusForSubFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetIsInertForSubFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetStringAtPoint_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct EnableDeviceEmulation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DisableDeviceEmulation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct BindWidgetCompositor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetViewportIntersection_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct NotifyClearedDisplayedGraphics_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FrameWidget() = default;

  using DragTargetDragEnterCallback = base::OnceCallback<void(::ui::mojom::DragOperation, bool)>;
  using DragTargetDragEnterMojoCallback = base::OnceCallback<void(::ui::mojom::DragOperation, bool)>;

  virtual void DragTargetDragEnter(::blink::mojom::DragDataPtr drag_data, const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, ::blink::DragOperationsMask operations_allowed, uint32_t key_modifiers, DragTargetDragEnterCallback callback) = 0;

  using DragTargetDragOverCallback = base::OnceCallback<void(::ui::mojom::DragOperation, bool)>;
  using DragTargetDragOverMojoCallback = base::OnceCallback<void(::ui::mojom::DragOperation, bool)>;

  virtual void DragTargetDragOver(const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, ::blink::DragOperationsMask operations_allowed, uint32_t key_modifiers, DragTargetDragOverCallback callback) = 0;

  virtual void DragTargetDragLeave(const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point) = 0;

  using DragTargetDropCallback = base::OnceCallback<void()>;
  using DragTargetDropMojoCallback = base::OnceCallback<void()>;

  virtual void DragTargetDrop(::blink::mojom::DragDataPtr drag_data, const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, uint32_t key_modifiers, DragTargetDropCallback callback) = 0;

  using DragSourceEndedAtCallback = base::OnceCallback<void()>;
  using DragSourceEndedAtMojoCallback = base::OnceCallback<void()>;

  virtual void DragSourceEndedAt(const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, ::ui::mojom::DragOperation drag_operation, DragSourceEndedAtCallback callback) = 0;

  virtual void DragSourceSystemDragEnded() = 0;

  using OnStartStylusWritingCallback = base::OnceCallback<void(StylusWritingFocusResultPtr)>;
  using OnStartStylusWritingMojoCallback = base::OnceCallback<void(StylusWritingFocusResultPtr)>;

  virtual void OnStartStylusWriting(OnStartStylusWritingCallback callback) = 0;

  virtual void SetBackgroundOpaque(bool opaque) = 0;

  virtual void SetTextDirection(::base::i18n::TextDirection direction) = 0;

  virtual void SetActive(bool active) = 0;

  virtual void SetInheritedEffectiveTouchActionForSubFrame(::cc::TouchAction touch_action) = 0;

  virtual void UpdateRenderThrottlingStatusForSubFrame(bool is_throttled, bool subtree_throttled, bool display_locked) = 0;

  virtual void SetIsInertForSubFrame(bool inert) = 0;

  using GetStringAtPointCallback = base::OnceCallback<void(::ui::mojom::AttributedStringPtr, const ::gfx::Point&)>;
  using GetStringAtPointMojoCallback = base::OnceCallback<void(::ui::mojom::AttributedStringPtr, const ::gfx::Point&)>;

  virtual void GetStringAtPoint(const ::gfx::Point& point_in_local_root, GetStringAtPointCallback callback) = 0;

  virtual void EnableDeviceEmulation(const ::blink::DeviceEmulationParams& parameters, DeviceEmulationCacheBehavior cache_behavior) = 0;

  virtual void DisableDeviceEmulation() = 0;

  virtual void BindWidgetCompositor(::mojo::PendingReceiver<::blink::mojom::WidgetCompositor> host) = 0;

  virtual void SetViewportIntersection(::blink::mojom::ViewportIntersectionStatePtr intersection_state, const std::optional<::blink::VisualProperties>& visual_properties) = 0;

  virtual void NotifyClearedDisplayedGraphics() = 0;
};

class FrameWidgetHostProxy;

template <typename ImplRefTraits>
class FrameWidgetHostStub;

class FrameWidgetHostRequestValidator;


class BLINK_COMMON_EXPORT FrameWidgetHost
    : public FrameWidgetHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.FrameWidgetHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = FrameWidgetHostInterfaceBase;
  using Proxy_ = FrameWidgetHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = FrameWidgetHostStub<ImplRefTraits>;

  using RequestValidator_ = FrameWidgetHostRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kAnimateDoubleTapZoomInMainFrameMinVersion = 0,
    kZoomToFindInPageRectInMainFrameMinVersion = 0,
    kSetHasTouchEventConsumersMinVersion = 0,
    kIntrinsicSizingInfoChangedMinVersion = 0,
    kAutoscrollStartMinVersion = 0,
    kAutoscrollFlingMinVersion = 0,
    kAutoscrollEndMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AnimateDoubleTapZoomInMainFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ZoomToFindInPageRectInMainFrame_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetHasTouchEventConsumers_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct IntrinsicSizingInfoChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AutoscrollStart_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AutoscrollFling_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct AutoscrollEnd_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~FrameWidgetHost() = default;

  virtual void AnimateDoubleTapZoomInMainFrame(const ::gfx::Point& tap_point, const ::gfx::Rect& rect_to_zoom) = 0;

  virtual void ZoomToFindInPageRectInMainFrame(const ::gfx::Rect& rect_to_zoom) = 0;

  virtual void SetHasTouchEventConsumers(::blink::mojom::TouchEventConsumersPtr touch_event_consumers) = 0;

  virtual void IntrinsicSizingInfoChanged(::blink::mojom::IntrinsicSizingInfoPtr sizing_info) = 0;

  virtual void AutoscrollStart(const ::gfx::PointF& position) = 0;

  virtual void AutoscrollFling(const ::gfx::Vector2dF& velocity) = 0;

  virtual void AutoscrollEnd() = 0;
};

class PopupWidgetHostProxy;

template <typename ImplRefTraits>
class PopupWidgetHostStub;

class PopupWidgetHostRequestValidator;
class PopupWidgetHostResponseValidator;


class BLINK_COMMON_EXPORT PopupWidgetHost
    : public PopupWidgetHostInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "blink.mojom.PopupWidgetHost";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PopupWidgetHostInterfaceBase;
  using Proxy_ = PopupWidgetHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = PopupWidgetHostStub<ImplRefTraits>;

  using RequestValidator_ = PopupWidgetHostRequestValidator;
  using ResponseValidator_ = PopupWidgetHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kRequestClosePopupMinVersion = 0,
    kShowPopupMinVersion = 0,
    kSetPopupBoundsMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct RequestClosePopup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowPopup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPopupBounds_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PopupWidgetHost() = default;

  virtual void RequestClosePopup() = 0;

  using ShowPopupCallback = base::OnceCallback<void()>;
  using ShowPopupMojoCallback = base::OnceCallback<void()>;

  virtual void ShowPopup(const ::gfx::Rect& initial_rect, const ::gfx::Rect& anchor_rect, ShowPopupCallback callback) = 0;

  using SetPopupBoundsCallback = base::OnceCallback<void()>;
  using SetPopupBoundsMojoCallback = base::OnceCallback<void()>;

  virtual void SetPopupBounds(const ::gfx::Rect& bounds, SetPopupBoundsCallback callback) = 0;
};



class BLINK_COMMON_EXPORT FrameWidgetProxy
    : public FrameWidget {
 public:
  using InterfaceType = FrameWidget;

  explicit FrameWidgetProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void DragTargetDragEnter(::blink::mojom::DragDataPtr drag_data, const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, ::blink::DragOperationsMask operations_allowed, uint32_t key_modifiers, DragTargetDragEnterCallback callback) final;
  
  void DragTargetDragOver(const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, ::blink::DragOperationsMask operations_allowed, uint32_t key_modifiers, DragTargetDragOverCallback callback) final;
  
  void DragTargetDragLeave(const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point) final;
  
  void DragTargetDrop(::blink::mojom::DragDataPtr drag_data, const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, uint32_t key_modifiers, DragTargetDropCallback callback) final;
  
  void DragSourceEndedAt(const ::gfx::PointF& point_in_viewport, const ::gfx::PointF& screen_point, ::ui::mojom::DragOperation drag_operation, DragSourceEndedAtCallback callback) final;
  
  void DragSourceSystemDragEnded() final;
  
  void OnStartStylusWriting(OnStartStylusWritingCallback callback) final;
  
  void SetBackgroundOpaque(bool opaque) final;
  
  void SetTextDirection(::base::i18n::TextDirection direction) final;
  
  void SetActive(bool active) final;
  
  void SetInheritedEffectiveTouchActionForSubFrame(::cc::TouchAction touch_action) final;
  
  void UpdateRenderThrottlingStatusForSubFrame(bool is_throttled, bool subtree_throttled, bool display_locked) final;
  
  void SetIsInertForSubFrame(bool inert) final;
  
  void GetStringAtPoint(const ::gfx::Point& point_in_local_root, GetStringAtPointCallback callback) final;
  
  void EnableDeviceEmulation(const ::blink::DeviceEmulationParams& parameters, DeviceEmulationCacheBehavior cache_behavior) final;
  
  void DisableDeviceEmulation() final;
  
  void BindWidgetCompositor(::mojo::PendingReceiver<::blink::mojom::WidgetCompositor> host) final;
  
  void SetViewportIntersection(::blink::mojom::ViewportIntersectionStatePtr intersection_state, const std::optional<::blink::VisualProperties>& visual_properties) final;
  
  void NotifyClearedDisplayedGraphics() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT FrameWidgetHostProxy
    : public FrameWidgetHost {
 public:
  using InterfaceType = FrameWidgetHost;

  explicit FrameWidgetHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AnimateDoubleTapZoomInMainFrame(const ::gfx::Point& tap_point, const ::gfx::Rect& rect_to_zoom) final;
  
  void ZoomToFindInPageRectInMainFrame(const ::gfx::Rect& rect_to_zoom) final;
  
  void SetHasTouchEventConsumers(::blink::mojom::TouchEventConsumersPtr touch_event_consumers) final;
  
  void IntrinsicSizingInfoChanged(::blink::mojom::IntrinsicSizingInfoPtr sizing_info) final;
  
  void AutoscrollStart(const ::gfx::PointF& position) final;
  
  void AutoscrollFling(const ::gfx::Vector2dF& velocity) final;
  
  void AutoscrollEnd() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class BLINK_COMMON_EXPORT PopupWidgetHostProxy
    : public PopupWidgetHost {
 public:
  using InterfaceType = PopupWidgetHost;

  explicit PopupWidgetHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void RequestClosePopup() final;
  
  void ShowPopup(const ::gfx::Rect& initial_rect, const ::gfx::Rect& anchor_rect, ShowPopupCallback callback) final;
  
  void SetPopupBounds(const ::gfx::Rect& bounds, SetPopupBoundsCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_COMMON_EXPORT FrameWidgetStubDispatch {
 public:
  static bool Accept(FrameWidget* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameWidget* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameWidget>>
class FrameWidgetStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameWidgetStub() = default;
  ~FrameWidgetStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameWidgetStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameWidgetStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT FrameWidgetHostStubDispatch {
 public:
  static bool Accept(FrameWidgetHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FrameWidgetHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FrameWidgetHost>>
class FrameWidgetHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FrameWidgetHostStub() = default;
  ~FrameWidgetHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameWidgetHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FrameWidgetHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT PopupWidgetHostStubDispatch {
 public:
  static bool Accept(PopupWidgetHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PopupWidgetHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PopupWidgetHost>>
class PopupWidgetHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PopupWidgetHostStub() = default;
  ~PopupWidgetHostStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PopupWidgetHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PopupWidgetHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_COMMON_EXPORT FrameWidgetRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT FrameWidgetHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT PopupWidgetHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT FrameWidgetResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_COMMON_EXPORT PopupWidgetHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_COMMON_EXPORT StylusWritingFocusResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StylusWritingFocusResult, T>::value>;
  using DataView = StylusWritingFocusResultDataView;
  using Data_ = internal::StylusWritingFocusResult_Data;

  template <typename... Args>
  static StylusWritingFocusResultPtr New(Args&&... args) {
    return StylusWritingFocusResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StylusWritingFocusResultPtr From(const U& u) {
    return mojo::TypeConverter<StylusWritingFocusResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StylusWritingFocusResult>::Convert(*this);
  }


  StylusWritingFocusResult();

  StylusWritingFocusResult(
      const ::gfx::Rect& focused_edit_bounds,
      const ::gfx::Rect& caret_bounds);


  ~StylusWritingFocusResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StylusWritingFocusResultPtr>
  StylusWritingFocusResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StylusWritingFocusResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StylusWritingFocusResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StylusWritingFocusResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StylusWritingFocusResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StylusWritingFocusResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StylusWritingFocusResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StylusWritingFocusResult_UnserializedMessageContext<
            UserType, StylusWritingFocusResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StylusWritingFocusResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StylusWritingFocusResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StylusWritingFocusResult_UnserializedMessageContext<
            UserType, StylusWritingFocusResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StylusWritingFocusResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Rect focused_edit_bounds;
  
  ::gfx::Rect caret_bounds;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StylusWritingFocusResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StylusWritingFocusResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StylusWritingFocusResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StylusWritingFocusResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
StylusWritingFocusResultPtr StylusWritingFocusResult::Clone() const {
  return New(
      mojo::Clone(focused_edit_bounds),
      mojo::Clone(caret_bounds)
  );
}

template <typename T, StylusWritingFocusResult::EnableIfSame<T>*>
bool StylusWritingFocusResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->focused_edit_bounds, other_struct.focused_edit_bounds))
    return false;
  if (!mojo::Equals(this->caret_bounds, other_struct.caret_bounds))
    return false;
  return true;
}

template <typename T, StylusWritingFocusResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.focused_edit_bounds < rhs.focused_edit_bounds)
    return true;
  if (rhs.focused_edit_bounds < lhs.focused_edit_bounds)
    return false;
  if (lhs.caret_bounds < rhs.caret_bounds)
    return true;
  if (rhs.caret_bounds < lhs.caret_bounds)
    return false;
  return false;
}


}  // blink::mojom

namespace mojo {


template <>
struct BLINK_COMMON_EXPORT StructTraits<::blink::mojom::StylusWritingFocusResult::DataView,
                                         ::blink::mojom::StylusWritingFocusResultPtr> {
  static bool IsNull(const ::blink::mojom::StylusWritingFocusResultPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::StylusWritingFocusResultPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::StylusWritingFocusResult::focused_edit_bounds)& focused_edit_bounds(
      const ::blink::mojom::StylusWritingFocusResultPtr& input) {
    return input->focused_edit_bounds;
  }

  static const decltype(::blink::mojom::StylusWritingFocusResult::caret_bounds)& caret_bounds(
      const ::blink::mojom::StylusWritingFocusResultPtr& input) {
    return input->caret_bounds;
  }

  static bool Read(::blink::mojom::StylusWritingFocusResult::DataView input, ::blink::mojom::StylusWritingFocusResultPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_WIDGET_MOJOM_H_