// third_party/blink/public/mojom/page/page.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/page/page.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var attribution$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/attribution.mojom', '../../../../../services/network/public/mojom/attribution.mojom.js');
  }
  var skcolor$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/skcolor.mojom', '../../../../../skia/public/mojom/skcolor.mojom.js');
  }
  var noise_token$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/fingerprinting_protection/noise_token.mojom', '../fingerprinting_protection/noise_token.mojom.js');
  }
  var frame_replication_state$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/frame_replication_state.mojom', '../frame/frame_replication_state.mojom.js');
  }
  var remote_frame$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/remote_frame.mojom', '../frame/remote_frame.mojom.js');
  }
  var view_transition_state$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/view_transition_state.mojom', '../frame/view_transition_state.mojom.js');
  }
  var was_activated_option$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/navigation/was_activated_option.mojom', '../navigation/was_activated_option.mojom.js');
  }
  var page_visibility_state$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/page/page_visibility_state.mojom', 'page_visibility_state.mojom.js');
  }
  var renderer_preferences$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/renderer_preferences.mojom', '../renderer_preferences.mojom.js');
  }
  var tokens$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/tokens/tokens.mojom', '../tokens/tokens.mojom.js');
  }
  var web_preferences$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/webpreferences/web_preferences.mojom', '../webpreferences/web_preferences.mojom.js');
  }
  var color_id$ =
      mojo.internal.exposeNamespace('color.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/color/color_id.mojom', '../../../../../ui/color/color_id.mojom.js');
  }


  var PagehideDispatch = {};
  PagehideDispatch.kNotDispatched = 0;
  PagehideDispatch.kDispatchedNotPersisted = 1;
  PagehideDispatch.kDispatchedPersisted = 2;
  PagehideDispatch.MIN_VALUE = 0;
  PagehideDispatch.MAX_VALUE = 2;

  PagehideDispatch.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  PagehideDispatch.toKnownEnumValue = function(value) {
    return value;
  };

  PagehideDispatch.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function PageLifecycleState(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageLifecycleState.prototype.initDefaults_ = function() {
    this.isFrozen = false;
    this.isInBackForwardCache = false;
    this.evictionEnabled = false;
    this.visibility = 0;
    this.pagehideDispatch = 0;
  };
  PageLifecycleState.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageLifecycleState.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PageLifecycleState.visibility
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 4, page_visibility_state$.PageVisibilityState);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PageLifecycleState.pagehideDispatch
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, PagehideDispatch);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PageLifecycleState.encodedSize = codec.kStructHeaderSize + 16;

  PageLifecycleState.decode = function(decoder) {
    var packed;
    var val = new PageLifecycleState();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isFrozen = (packed >> 0) & 1 ? true : false;
    val.isInBackForwardCache = (packed >> 1) & 1 ? true : false;
    val.evictionEnabled = (packed >> 2) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.visibility =
        decoder.decodeStruct(new codec.Enum(page_visibility_state$.PageVisibilityState));
    val.pagehideDispatch =
        decoder.decodeStruct(new codec.Enum(PagehideDispatch));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PageLifecycleState.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageLifecycleState.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isFrozen & 1) << 0
    packed |= (val.isInBackForwardCache & 1) << 1
    packed |= (val.evictionEnabled & 1) << 2
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.visibility);
    encoder.encodeStruct(codec.Int32, val.pagehideDispatch);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PageRestoreParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageRestoreParams.prototype.initDefaults_ = function() {
    this.navigationStart = null;
    this.pendingHistoryListIndex = 0;
    this.currentHistoryListLength = 0;
    this.viewTransitionState = null;
  };
  PageRestoreParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageRestoreParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageRestoreParams.navigationStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate PageRestoreParams.viewTransitionState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, view_transition_state$.ViewTransitionState, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageRestoreParams.encodedSize = codec.kStructHeaderSize + 24;

  PageRestoreParams.decode = function(decoder) {
    var packed;
    var val = new PageRestoreParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.navigationStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.pendingHistoryListIndex =
        decoder.decodeStruct(codec.Int32);
    val.currentHistoryListLength =
        decoder.decodeStruct(codec.Int32);
    val.viewTransitionState =
        decoder.decodeStructPointer(view_transition_state$.ViewTransitionState);
    return val;
  };

  PageRestoreParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageRestoreParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeTicks, val.navigationStart);
    encoder.encodeStruct(codec.Int32, val.pendingHistoryListIndex);
    encoder.encodeStruct(codec.Int32, val.currentHistoryListLength);
    encoder.encodeStructPointer(view_transition_state$.ViewTransitionState, val.viewTransitionState);
  };
  function ColorProviderColorMaps(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ColorProviderColorMaps.prototype.initDefaults_ = function() {
    this.lightColorsMap = null;
    this.darkColorsMap = null;
    this.forcedColorsMap = null;
  };
  ColorProviderColorMaps.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ColorProviderColorMaps.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ColorProviderColorMaps.lightColorsMap
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, new codec.Enum(color_id$.RendererColorId), new codec.PointerTo(skcolor$.SkColor), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ColorProviderColorMaps.darkColorsMap
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 8, false, new codec.Enum(color_id$.RendererColorId), new codec.PointerTo(skcolor$.SkColor), false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ColorProviderColorMaps.forcedColorsMap
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 16, false, new codec.Enum(color_id$.RendererColorId), new codec.PointerTo(skcolor$.SkColor), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ColorProviderColorMaps.encodedSize = codec.kStructHeaderSize + 24;

  ColorProviderColorMaps.decode = function(decoder) {
    var packed;
    var val = new ColorProviderColorMaps();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.lightColorsMap =
        decoder.decodeMapPointer(new codec.Enum(color_id$.RendererColorId), new codec.PointerTo(skcolor$.SkColor));
    val.darkColorsMap =
        decoder.decodeMapPointer(new codec.Enum(color_id$.RendererColorId), new codec.PointerTo(skcolor$.SkColor));
    val.forcedColorsMap =
        decoder.decodeMapPointer(new codec.Enum(color_id$.RendererColorId), new codec.PointerTo(skcolor$.SkColor));
    return val;
  };

  ColorProviderColorMaps.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ColorProviderColorMaps.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(new codec.Enum(color_id$.RendererColorId), new codec.PointerTo(skcolor$.SkColor), val.lightColorsMap);
    encoder.encodeMapPointer(new codec.Enum(color_id$.RendererColorId), new codec.PointerTo(skcolor$.SkColor), val.darkColorsMap);
    encoder.encodeMapPointer(new codec.Enum(color_id$.RendererColorId), new codec.PointerTo(skcolor$.SkColor), val.forcedColorsMap);
  };
  function PrerenderPageActivationParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PrerenderPageActivationParams.prototype.initDefaults_ = function() {
    this.wasUserActivated = 0;
    this.activationStart = null;
    this.viewTransitionState = null;
  };
  PrerenderPageActivationParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PrerenderPageActivationParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrerenderPageActivationParams.wasUserActivated
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, was_activated_option$.WasActivatedOption);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrerenderPageActivationParams.activationStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeTicks, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PrerenderPageActivationParams.viewTransitionState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, view_transition_state$.ViewTransitionState, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PrerenderPageActivationParams.encodedSize = codec.kStructHeaderSize + 24;

  PrerenderPageActivationParams.decode = function(decoder) {
    var packed;
    var val = new PrerenderPageActivationParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.wasUserActivated =
        decoder.decodeStruct(new codec.Enum(was_activated_option$.WasActivatedOption));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.activationStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.viewTransitionState =
        decoder.decodeStructPointer(view_transition_state$.ViewTransitionState);
    return val;
  };

  PrerenderPageActivationParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PrerenderPageActivationParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.wasUserActivated);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(time$.TimeTicks, val.activationStart);
    encoder.encodeStructPointer(view_transition_state$.ViewTransitionState, val.viewTransitionState);
  };
  function PageBroadcast_SetPageLifecycleState_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageBroadcast_SetPageLifecycleState_Params.prototype.initDefaults_ = function() {
    this.state = null;
    this.pageRestoreParams = null;
  };
  PageBroadcast_SetPageLifecycleState_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageBroadcast_SetPageLifecycleState_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageBroadcast_SetPageLifecycleState_Params.state
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, PageLifecycleState, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageBroadcast_SetPageLifecycleState_Params.pageRestoreParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, PageRestoreParams, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageBroadcast_SetPageLifecycleState_Params.encodedSize = codec.kStructHeaderSize + 16;

  PageBroadcast_SetPageLifecycleState_Params.decode = function(decoder) {
    var packed;
    var val = new PageBroadcast_SetPageLifecycleState_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.state =
        decoder.decodeStructPointer(PageLifecycleState);
    val.pageRestoreParams =
        decoder.decodeStructPointer(PageRestoreParams);
    return val;
  };

  PageBroadcast_SetPageLifecycleState_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageBroadcast_SetPageLifecycleState_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(PageLifecycleState, val.state);
    encoder.encodeStructPointer(PageRestoreParams, val.pageRestoreParams);
  };
  function PageBroadcast_SetPageLifecycleState_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageBroadcast_SetPageLifecycleState_ResponseParams.prototype.initDefaults_ = function() {
  };
  PageBroadcast_SetPageLifecycleState_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageBroadcast_SetPageLifecycleState_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageBroadcast_SetPageLifecycleState_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  PageBroadcast_SetPageLifecycleState_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PageBroadcast_SetPageLifecycleState_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PageBroadcast_SetPageLifecycleState_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageBroadcast_SetPageLifecycleState_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function PageBroadcast_AudioStateChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageBroadcast_AudioStateChanged_Params.prototype.initDefaults_ = function() {
    this.isAudioPlaying = false;
  };
  PageBroadcast_AudioStateChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageBroadcast_AudioStateChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PageBroadcast_AudioStateChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  PageBroadcast_AudioStateChanged_Params.decode = function(decoder) {
    var packed;
    var val = new PageBroadcast_AudioStateChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isAudioPlaying = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PageBroadcast_AudioStateChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageBroadcast_AudioStateChanged_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isAudioPlaying & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PageBroadcast_ActivatePrerenderedPage_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageBroadcast_ActivatePrerenderedPage_Params.prototype.initDefaults_ = function() {
    this.prerenderPageActivationParams = null;
  };
  PageBroadcast_ActivatePrerenderedPage_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageBroadcast_ActivatePrerenderedPage_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageBroadcast_ActivatePrerenderedPage_Params.prerenderPageActivationParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, PrerenderPageActivationParams, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageBroadcast_ActivatePrerenderedPage_Params.encodedSize = codec.kStructHeaderSize + 8;

  PageBroadcast_ActivatePrerenderedPage_Params.decode = function(decoder) {
    var packed;
    var val = new PageBroadcast_ActivatePrerenderedPage_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.prerenderPageActivationParams =
        decoder.decodeStructPointer(PrerenderPageActivationParams);
    return val;
  };

  PageBroadcast_ActivatePrerenderedPage_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageBroadcast_ActivatePrerenderedPage_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(PrerenderPageActivationParams, val.prerenderPageActivationParams);
  };
  function PageBroadcast_ActivatePrerenderedPage_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageBroadcast_ActivatePrerenderedPage_ResponseParams.prototype.initDefaults_ = function() {
  };
  PageBroadcast_ActivatePrerenderedPage_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageBroadcast_ActivatePrerenderedPage_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageBroadcast_ActivatePrerenderedPage_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  PageBroadcast_ActivatePrerenderedPage_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new PageBroadcast_ActivatePrerenderedPage_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  PageBroadcast_ActivatePrerenderedPage_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageBroadcast_ActivatePrerenderedPage_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function PageBroadcast_UpdateWebPreferences_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageBroadcast_UpdateWebPreferences_Params.prototype.initDefaults_ = function() {
    this.preferences = null;
  };
  PageBroadcast_UpdateWebPreferences_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageBroadcast_UpdateWebPreferences_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageBroadcast_UpdateWebPreferences_Params.preferences
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, web_preferences$.WebPreferences, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageBroadcast_UpdateWebPreferences_Params.encodedSize = codec.kStructHeaderSize + 8;

  PageBroadcast_UpdateWebPreferences_Params.decode = function(decoder) {
    var packed;
    var val = new PageBroadcast_UpdateWebPreferences_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.preferences =
        decoder.decodeStructPointer(web_preferences$.WebPreferences);
    return val;
  };

  PageBroadcast_UpdateWebPreferences_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageBroadcast_UpdateWebPreferences_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(web_preferences$.WebPreferences, val.preferences);
  };
  function PageBroadcast_UpdateRendererPreferences_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageBroadcast_UpdateRendererPreferences_Params.prototype.initDefaults_ = function() {
    this.preferences = null;
  };
  PageBroadcast_UpdateRendererPreferences_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageBroadcast_UpdateRendererPreferences_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageBroadcast_UpdateRendererPreferences_Params.preferences
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, renderer_preferences$.RendererPreferences, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageBroadcast_UpdateRendererPreferences_Params.encodedSize = codec.kStructHeaderSize + 8;

  PageBroadcast_UpdateRendererPreferences_Params.decode = function(decoder) {
    var packed;
    var val = new PageBroadcast_UpdateRendererPreferences_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.preferences =
        decoder.decodeStructPointer(renderer_preferences$.RendererPreferences);
    return val;
  };

  PageBroadcast_UpdateRendererPreferences_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageBroadcast_UpdateRendererPreferences_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(renderer_preferences$.RendererPreferences, val.preferences);
  };
  function PageBroadcast_SetHistoryIndexAndLength_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageBroadcast_SetHistoryIndexAndLength_Params.prototype.initDefaults_ = function() {
    this.index = 0;
    this.length = 0;
  };
  PageBroadcast_SetHistoryIndexAndLength_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageBroadcast_SetHistoryIndexAndLength_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  PageBroadcast_SetHistoryIndexAndLength_Params.encodedSize = codec.kStructHeaderSize + 8;

  PageBroadcast_SetHistoryIndexAndLength_Params.decode = function(decoder) {
    var packed;
    var val = new PageBroadcast_SetHistoryIndexAndLength_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.index =
        decoder.decodeStruct(codec.Int32);
    val.length =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  PageBroadcast_SetHistoryIndexAndLength_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageBroadcast_SetHistoryIndexAndLength_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.index);
    encoder.encodeStruct(codec.Int32, val.length);
  };
  function PageBroadcast_SetPageBaseBackgroundColor_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageBroadcast_SetPageBaseBackgroundColor_Params.prototype.initDefaults_ = function() {
    this.color = null;
  };
  PageBroadcast_SetPageBaseBackgroundColor_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageBroadcast_SetPageBaseBackgroundColor_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageBroadcast_SetPageBaseBackgroundColor_Params.color
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, skcolor$.SkColor, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageBroadcast_SetPageBaseBackgroundColor_Params.encodedSize = codec.kStructHeaderSize + 8;

  PageBroadcast_SetPageBaseBackgroundColor_Params.decode = function(decoder) {
    var packed;
    var val = new PageBroadcast_SetPageBaseBackgroundColor_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.color =
        decoder.decodeStructPointer(skcolor$.SkColor);
    return val;
  };

  PageBroadcast_SetPageBaseBackgroundColor_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageBroadcast_SetPageBaseBackgroundColor_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(skcolor$.SkColor, val.color);
  };
  function PageBroadcast_CreateRemoteMainFrame_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageBroadcast_CreateRemoteMainFrame_Params.prototype.initDefaults_ = function() {
    this.token = null;
    this.openerFrameToken = null;
    this.replicationState = null;
    this.isLoading = false;
    this.devtoolsFrameToken = null;
    this.navigationMetricsToken = null;
    this.remoteFrameInterfaces = null;
    this.remoteMainFrameInterfaces = null;
  };
  PageBroadcast_CreateRemoteMainFrame_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageBroadcast_CreateRemoteMainFrame_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 80}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageBroadcast_CreateRemoteMainFrame_Params.token
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, tokens$.RemoteFrameToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageBroadcast_CreateRemoteMainFrame_Params.openerFrameToken
    err = messageValidator.validateUnion(offset + codec.kStructHeaderSize + 8, tokens$.FrameToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageBroadcast_CreateRemoteMainFrame_Params.replicationState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, frame_replication_state$.FrameReplicationState, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PageBroadcast_CreateRemoteMainFrame_Params.devtoolsFrameToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageBroadcast_CreateRemoteMainFrame_Params.navigationMetricsToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageBroadcast_CreateRemoteMainFrame_Params.remoteFrameInterfaces
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, remote_frame$.RemoteFrameInterfacesFromBrowser, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageBroadcast_CreateRemoteMainFrame_Params.remoteMainFrameInterfaces
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, remote_frame$.RemoteMainFrameInterfaces, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageBroadcast_CreateRemoteMainFrame_Params.encodedSize = codec.kStructHeaderSize + 72;

  PageBroadcast_CreateRemoteMainFrame_Params.decode = function(decoder) {
    var packed;
    var val = new PageBroadcast_CreateRemoteMainFrame_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStructPointer(tokens$.RemoteFrameToken);
    val.openerFrameToken =
        decoder.decodeStruct(tokens$.FrameToken);
    val.replicationState =
        decoder.decodeStructPointer(frame_replication_state$.FrameReplicationState);
    packed = decoder.readUint8();
    val.isLoading = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.devtoolsFrameToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.navigationMetricsToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.remoteFrameInterfaces =
        decoder.decodeStructPointer(remote_frame$.RemoteFrameInterfacesFromBrowser);
    val.remoteMainFrameInterfaces =
        decoder.decodeStructPointer(remote_frame$.RemoteMainFrameInterfaces);
    return val;
  };

  PageBroadcast_CreateRemoteMainFrame_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageBroadcast_CreateRemoteMainFrame_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(tokens$.RemoteFrameToken, val.token);
    encoder.encodeStruct(tokens$.FrameToken, val.openerFrameToken);
    encoder.encodeStructPointer(frame_replication_state$.FrameReplicationState, val.replicationState);
    packed = 0;
    packed |= (val.isLoading & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.devtoolsFrameToken);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.navigationMetricsToken);
    encoder.encodeStructPointer(remote_frame$.RemoteFrameInterfacesFromBrowser, val.remoteFrameInterfaces);
    encoder.encodeStructPointer(remote_frame$.RemoteMainFrameInterfaces, val.remoteMainFrameInterfaces);
  };
  function PageBroadcast_UpdatePageBrowsingContextGroup_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageBroadcast_UpdatePageBrowsingContextGroup_Params.prototype.initDefaults_ = function() {
    this.browsingContextGroupToken = null;
  };
  PageBroadcast_UpdatePageBrowsingContextGroup_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageBroadcast_UpdatePageBrowsingContextGroup_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageBroadcast_UpdatePageBrowsingContextGroup_Params.browsingContextGroupToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageBroadcast_UpdatePageBrowsingContextGroup_Params.encodedSize = codec.kStructHeaderSize + 8;

  PageBroadcast_UpdatePageBrowsingContextGroup_Params.decode = function(decoder) {
    var packed;
    var val = new PageBroadcast_UpdatePageBrowsingContextGroup_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.browsingContextGroupToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  PageBroadcast_UpdatePageBrowsingContextGroup_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageBroadcast_UpdatePageBrowsingContextGroup_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.browsingContextGroupToken);
  };
  function PageBroadcast_SetPageAttributionSupport_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageBroadcast_SetPageAttributionSupport_Params.prototype.initDefaults_ = function() {
    this.support = 0;
  };
  PageBroadcast_SetPageAttributionSupport_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageBroadcast_SetPageAttributionSupport_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageBroadcast_SetPageAttributionSupport_Params.support
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, attribution$.AttributionSupport);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageBroadcast_SetPageAttributionSupport_Params.encodedSize = codec.kStructHeaderSize + 8;

  PageBroadcast_SetPageAttributionSupport_Params.decode = function(decoder) {
    var packed;
    var val = new PageBroadcast_SetPageAttributionSupport_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.support =
        decoder.decodeStruct(new codec.Enum(attribution$.AttributionSupport));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PageBroadcast_SetPageAttributionSupport_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageBroadcast_SetPageAttributionSupport_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.support);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function PageBroadcast_UpdateColorProviders_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageBroadcast_UpdateColorProviders_Params.prototype.initDefaults_ = function() {
    this.colorProviderColors = null;
  };
  PageBroadcast_UpdateColorProviders_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageBroadcast_UpdateColorProviders_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageBroadcast_UpdateColorProviders_Params.colorProviderColors
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, ColorProviderColorMaps, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageBroadcast_UpdateColorProviders_Params.encodedSize = codec.kStructHeaderSize + 8;

  PageBroadcast_UpdateColorProviders_Params.decode = function(decoder) {
    var packed;
    var val = new PageBroadcast_UpdateColorProviders_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.colorProviderColors =
        decoder.decodeStructPointer(ColorProviderColorMaps);
    return val;
  };

  PageBroadcast_UpdateColorProviders_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageBroadcast_UpdateColorProviders_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(ColorProviderColorMaps, val.colorProviderColors);
  };
  function PageBroadcast_UpdateCanvasNoiseToken_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageBroadcast_UpdateCanvasNoiseToken_Params.prototype.initDefaults_ = function() {
    this.canvasNoiseToken = null;
  };
  PageBroadcast_UpdateCanvasNoiseToken_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageBroadcast_UpdateCanvasNoiseToken_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageBroadcast_UpdateCanvasNoiseToken_Params.canvasNoiseToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, noise_token$.NoiseToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageBroadcast_UpdateCanvasNoiseToken_Params.encodedSize = codec.kStructHeaderSize + 8;

  PageBroadcast_UpdateCanvasNoiseToken_Params.decode = function(decoder) {
    var packed;
    var val = new PageBroadcast_UpdateCanvasNoiseToken_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.canvasNoiseToken =
        decoder.decodeStructPointer(noise_token$.NoiseToken);
    return val;
  };

  PageBroadcast_UpdateCanvasNoiseToken_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageBroadcast_UpdateCanvasNoiseToken_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(noise_token$.NoiseToken, val.canvasNoiseToken);
  };
  function PageBroadcast_SetSupportsDraggableRegions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageBroadcast_SetSupportsDraggableRegions_Params.prototype.initDefaults_ = function() {
    this.supportsDraggableRegions = false;
  };
  PageBroadcast_SetSupportsDraggableRegions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageBroadcast_SetSupportsDraggableRegions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  PageBroadcast_SetSupportsDraggableRegions_Params.encodedSize = codec.kStructHeaderSize + 8;

  PageBroadcast_SetSupportsDraggableRegions_Params.decode = function(decoder) {
    var packed;
    var val = new PageBroadcast_SetSupportsDraggableRegions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.supportsDraggableRegions = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PageBroadcast_SetSupportsDraggableRegions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageBroadcast_SetSupportsDraggableRegions_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.supportsDraggableRegions & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kPageBroadcast_SetPageLifecycleState_Name = 0;
  var kPageBroadcast_AudioStateChanged_Name = 1;
  var kPageBroadcast_ActivatePrerenderedPage_Name = 2;
  var kPageBroadcast_UpdateWebPreferences_Name = 3;
  var kPageBroadcast_UpdateRendererPreferences_Name = 4;
  var kPageBroadcast_SetHistoryIndexAndLength_Name = 5;
  var kPageBroadcast_SetPageBaseBackgroundColor_Name = 6;
  var kPageBroadcast_CreateRemoteMainFrame_Name = 7;
  var kPageBroadcast_UpdatePageBrowsingContextGroup_Name = 8;
  var kPageBroadcast_SetPageAttributionSupport_Name = 9;
  var kPageBroadcast_UpdateColorProviders_Name = 10;
  var kPageBroadcast_UpdateCanvasNoiseToken_Name = 11;
  var kPageBroadcast_SetSupportsDraggableRegions_Name = 12;

  function PageBroadcastPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(PageBroadcast,
                                                   handleOrPtrInfo);
  }

  function PageBroadcastAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        PageBroadcast, associatedInterfacePtrInfo);
  }

  PageBroadcastAssociatedPtr.prototype =
      Object.create(PageBroadcastPtr.prototype);
  PageBroadcastAssociatedPtr.prototype.constructor =
      PageBroadcastAssociatedPtr;

  function PageBroadcastProxy(receiver) {
    this.receiver_ = receiver;
  }
  PageBroadcastPtr.prototype.setPageLifecycleState = function() {
    return PageBroadcastProxy.prototype.setPageLifecycleState
        .apply(this.ptr.getProxy(), arguments);
  };

  PageBroadcastProxy.prototype.setPageLifecycleState = function(state, pageRestoreParams) {
    var params_ = new PageBroadcast_SetPageLifecycleState_Params();
    params_.state = state;
    params_.pageRestoreParams = pageRestoreParams;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPageBroadcast_SetPageLifecycleState_Name,
          codec.align(PageBroadcast_SetPageLifecycleState_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PageBroadcast_SetPageLifecycleState_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PageBroadcast_SetPageLifecycleState_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PageBroadcastPtr.prototype.audioStateChanged = function() {
    return PageBroadcastProxy.prototype.audioStateChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  PageBroadcastProxy.prototype.audioStateChanged = function(isAudioPlaying) {
    var params_ = new PageBroadcast_AudioStateChanged_Params();
    params_.isAudioPlaying = isAudioPlaying;
    var builder = new codec.MessageV0Builder(
        kPageBroadcast_AudioStateChanged_Name,
        codec.align(PageBroadcast_AudioStateChanged_Params.encodedSize));
    builder.encodeStruct(PageBroadcast_AudioStateChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PageBroadcastPtr.prototype.activatePrerenderedPage = function() {
    return PageBroadcastProxy.prototype.activatePrerenderedPage
        .apply(this.ptr.getProxy(), arguments);
  };

  PageBroadcastProxy.prototype.activatePrerenderedPage = function(prerenderPageActivationParams) {
    var params_ = new PageBroadcast_ActivatePrerenderedPage_Params();
    params_.prerenderPageActivationParams = prerenderPageActivationParams;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kPageBroadcast_ActivatePrerenderedPage_Name,
          codec.align(PageBroadcast_ActivatePrerenderedPage_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(PageBroadcast_ActivatePrerenderedPage_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(PageBroadcast_ActivatePrerenderedPage_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  PageBroadcastPtr.prototype.updateWebPreferences = function() {
    return PageBroadcastProxy.prototype.updateWebPreferences
        .apply(this.ptr.getProxy(), arguments);
  };

  PageBroadcastProxy.prototype.updateWebPreferences = function(preferences) {
    var params_ = new PageBroadcast_UpdateWebPreferences_Params();
    params_.preferences = preferences;
    var builder = new codec.MessageV0Builder(
        kPageBroadcast_UpdateWebPreferences_Name,
        codec.align(PageBroadcast_UpdateWebPreferences_Params.encodedSize));
    builder.encodeStruct(PageBroadcast_UpdateWebPreferences_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PageBroadcastPtr.prototype.updateRendererPreferences = function() {
    return PageBroadcastProxy.prototype.updateRendererPreferences
        .apply(this.ptr.getProxy(), arguments);
  };

  PageBroadcastProxy.prototype.updateRendererPreferences = function(preferences) {
    var params_ = new PageBroadcast_UpdateRendererPreferences_Params();
    params_.preferences = preferences;
    var builder = new codec.MessageV0Builder(
        kPageBroadcast_UpdateRendererPreferences_Name,
        codec.align(PageBroadcast_UpdateRendererPreferences_Params.encodedSize));
    builder.encodeStruct(PageBroadcast_UpdateRendererPreferences_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PageBroadcastPtr.prototype.setHistoryIndexAndLength = function() {
    return PageBroadcastProxy.prototype.setHistoryIndexAndLength
        .apply(this.ptr.getProxy(), arguments);
  };

  PageBroadcastProxy.prototype.setHistoryIndexAndLength = function(index, length) {
    var params_ = new PageBroadcast_SetHistoryIndexAndLength_Params();
    params_.index = index;
    params_.length = length;
    var builder = new codec.MessageV0Builder(
        kPageBroadcast_SetHistoryIndexAndLength_Name,
        codec.align(PageBroadcast_SetHistoryIndexAndLength_Params.encodedSize));
    builder.encodeStruct(PageBroadcast_SetHistoryIndexAndLength_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PageBroadcastPtr.prototype.setPageBaseBackgroundColor = function() {
    return PageBroadcastProxy.prototype.setPageBaseBackgroundColor
        .apply(this.ptr.getProxy(), arguments);
  };

  PageBroadcastProxy.prototype.setPageBaseBackgroundColor = function(color) {
    var params_ = new PageBroadcast_SetPageBaseBackgroundColor_Params();
    params_.color = color;
    var builder = new codec.MessageV0Builder(
        kPageBroadcast_SetPageBaseBackgroundColor_Name,
        codec.align(PageBroadcast_SetPageBaseBackgroundColor_Params.encodedSize));
    builder.encodeStruct(PageBroadcast_SetPageBaseBackgroundColor_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PageBroadcastPtr.prototype.createRemoteMainFrame = function() {
    return PageBroadcastProxy.prototype.createRemoteMainFrame
        .apply(this.ptr.getProxy(), arguments);
  };

  PageBroadcastProxy.prototype.createRemoteMainFrame = function(token, openerFrameToken, replicationState, isLoading, devtoolsFrameToken, navigationMetricsToken, remoteFrameInterfaces, remoteMainFrameInterfaces) {
    var params_ = new PageBroadcast_CreateRemoteMainFrame_Params();
    params_.token = token;
    params_.openerFrameToken = openerFrameToken;
    params_.replicationState = replicationState;
    params_.isLoading = isLoading;
    params_.devtoolsFrameToken = devtoolsFrameToken;
    params_.navigationMetricsToken = navigationMetricsToken;
    params_.remoteFrameInterfaces = remoteFrameInterfaces;
    params_.remoteMainFrameInterfaces = remoteMainFrameInterfaces;
    var builder = new codec.MessageV2Builder(
        kPageBroadcast_CreateRemoteMainFrame_Name,
        codec.align(PageBroadcast_CreateRemoteMainFrame_Params.encodedSize));
    builder.setPayload(PageBroadcast_CreateRemoteMainFrame_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PageBroadcastPtr.prototype.updatePageBrowsingContextGroup = function() {
    return PageBroadcastProxy.prototype.updatePageBrowsingContextGroup
        .apply(this.ptr.getProxy(), arguments);
  };

  PageBroadcastProxy.prototype.updatePageBrowsingContextGroup = function(browsingContextGroupToken) {
    var params_ = new PageBroadcast_UpdatePageBrowsingContextGroup_Params();
    params_.browsingContextGroupToken = browsingContextGroupToken;
    var builder = new codec.MessageV0Builder(
        kPageBroadcast_UpdatePageBrowsingContextGroup_Name,
        codec.align(PageBroadcast_UpdatePageBrowsingContextGroup_Params.encodedSize));
    builder.encodeStruct(PageBroadcast_UpdatePageBrowsingContextGroup_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PageBroadcastPtr.prototype.setPageAttributionSupport = function() {
    return PageBroadcastProxy.prototype.setPageAttributionSupport
        .apply(this.ptr.getProxy(), arguments);
  };

  PageBroadcastProxy.prototype.setPageAttributionSupport = function(support) {
    var params_ = new PageBroadcast_SetPageAttributionSupport_Params();
    params_.support = support;
    var builder = new codec.MessageV0Builder(
        kPageBroadcast_SetPageAttributionSupport_Name,
        codec.align(PageBroadcast_SetPageAttributionSupport_Params.encodedSize));
    builder.encodeStruct(PageBroadcast_SetPageAttributionSupport_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PageBroadcastPtr.prototype.updateColorProviders = function() {
    return PageBroadcastProxy.prototype.updateColorProviders
        .apply(this.ptr.getProxy(), arguments);
  };

  PageBroadcastProxy.prototype.updateColorProviders = function(colorProviderColors) {
    var params_ = new PageBroadcast_UpdateColorProviders_Params();
    params_.colorProviderColors = colorProviderColors;
    var builder = new codec.MessageV0Builder(
        kPageBroadcast_UpdateColorProviders_Name,
        codec.align(PageBroadcast_UpdateColorProviders_Params.encodedSize));
    builder.encodeStruct(PageBroadcast_UpdateColorProviders_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PageBroadcastPtr.prototype.updateCanvasNoiseToken = function() {
    return PageBroadcastProxy.prototype.updateCanvasNoiseToken
        .apply(this.ptr.getProxy(), arguments);
  };

  PageBroadcastProxy.prototype.updateCanvasNoiseToken = function(canvasNoiseToken) {
    var params_ = new PageBroadcast_UpdateCanvasNoiseToken_Params();
    params_.canvasNoiseToken = canvasNoiseToken;
    var builder = new codec.MessageV0Builder(
        kPageBroadcast_UpdateCanvasNoiseToken_Name,
        codec.align(PageBroadcast_UpdateCanvasNoiseToken_Params.encodedSize));
    builder.encodeStruct(PageBroadcast_UpdateCanvasNoiseToken_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  PageBroadcastPtr.prototype.setSupportsDraggableRegions = function() {
    return PageBroadcastProxy.prototype.setSupportsDraggableRegions
        .apply(this.ptr.getProxy(), arguments);
  };

  PageBroadcastProxy.prototype.setSupportsDraggableRegions = function(supportsDraggableRegions) {
    var params_ = new PageBroadcast_SetSupportsDraggableRegions_Params();
    params_.supportsDraggableRegions = supportsDraggableRegions;
    var builder = new codec.MessageV0Builder(
        kPageBroadcast_SetSupportsDraggableRegions_Name,
        codec.align(PageBroadcast_SetSupportsDraggableRegions_Params.encodedSize));
    builder.encodeStruct(PageBroadcast_SetSupportsDraggableRegions_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function PageBroadcastStub(delegate) {
    this.delegate_ = delegate;
  }
  PageBroadcastStub.prototype.setPageLifecycleState = function(state, pageRestoreParams) {
    return this.delegate_ && this.delegate_.setPageLifecycleState && this.delegate_.setPageLifecycleState(state, pageRestoreParams);
  }
  PageBroadcastStub.prototype.audioStateChanged = function(isAudioPlaying) {
    return this.delegate_ && this.delegate_.audioStateChanged && this.delegate_.audioStateChanged(isAudioPlaying);
  }
  PageBroadcastStub.prototype.activatePrerenderedPage = function(prerenderPageActivationParams) {
    return this.delegate_ && this.delegate_.activatePrerenderedPage && this.delegate_.activatePrerenderedPage(prerenderPageActivationParams);
  }
  PageBroadcastStub.prototype.updateWebPreferences = function(preferences) {
    return this.delegate_ && this.delegate_.updateWebPreferences && this.delegate_.updateWebPreferences(preferences);
  }
  PageBroadcastStub.prototype.updateRendererPreferences = function(preferences) {
    return this.delegate_ && this.delegate_.updateRendererPreferences && this.delegate_.updateRendererPreferences(preferences);
  }
  PageBroadcastStub.prototype.setHistoryIndexAndLength = function(index, length) {
    return this.delegate_ && this.delegate_.setHistoryIndexAndLength && this.delegate_.setHistoryIndexAndLength(index, length);
  }
  PageBroadcastStub.prototype.setPageBaseBackgroundColor = function(color) {
    return this.delegate_ && this.delegate_.setPageBaseBackgroundColor && this.delegate_.setPageBaseBackgroundColor(color);
  }
  PageBroadcastStub.prototype.createRemoteMainFrame = function(token, openerFrameToken, replicationState, isLoading, devtoolsFrameToken, navigationMetricsToken, remoteFrameInterfaces, remoteMainFrameInterfaces) {
    return this.delegate_ && this.delegate_.createRemoteMainFrame && this.delegate_.createRemoteMainFrame(token, openerFrameToken, replicationState, isLoading, devtoolsFrameToken, navigationMetricsToken, remoteFrameInterfaces, remoteMainFrameInterfaces);
  }
  PageBroadcastStub.prototype.updatePageBrowsingContextGroup = function(browsingContextGroupToken) {
    return this.delegate_ && this.delegate_.updatePageBrowsingContextGroup && this.delegate_.updatePageBrowsingContextGroup(browsingContextGroupToken);
  }
  PageBroadcastStub.prototype.setPageAttributionSupport = function(support) {
    return this.delegate_ && this.delegate_.setPageAttributionSupport && this.delegate_.setPageAttributionSupport(support);
  }
  PageBroadcastStub.prototype.updateColorProviders = function(colorProviderColors) {
    return this.delegate_ && this.delegate_.updateColorProviders && this.delegate_.updateColorProviders(colorProviderColors);
  }
  PageBroadcastStub.prototype.updateCanvasNoiseToken = function(canvasNoiseToken) {
    return this.delegate_ && this.delegate_.updateCanvasNoiseToken && this.delegate_.updateCanvasNoiseToken(canvasNoiseToken);
  }
  PageBroadcastStub.prototype.setSupportsDraggableRegions = function(supportsDraggableRegions) {
    return this.delegate_ && this.delegate_.setSupportsDraggableRegions && this.delegate_.setSupportsDraggableRegions(supportsDraggableRegions);
  }

  PageBroadcastStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPageBroadcast_AudioStateChanged_Name:
      var params = reader.decodeStruct(PageBroadcast_AudioStateChanged_Params);
      this.audioStateChanged(params.isAudioPlaying);
      return true;
    case kPageBroadcast_UpdateWebPreferences_Name:
      var params = reader.decodeStruct(PageBroadcast_UpdateWebPreferences_Params);
      this.updateWebPreferences(params.preferences);
      return true;
    case kPageBroadcast_UpdateRendererPreferences_Name:
      var params = reader.decodeStruct(PageBroadcast_UpdateRendererPreferences_Params);
      this.updateRendererPreferences(params.preferences);
      return true;
    case kPageBroadcast_SetHistoryIndexAndLength_Name:
      var params = reader.decodeStruct(PageBroadcast_SetHistoryIndexAndLength_Params);
      this.setHistoryIndexAndLength(params.index, params.length);
      return true;
    case kPageBroadcast_SetPageBaseBackgroundColor_Name:
      var params = reader.decodeStruct(PageBroadcast_SetPageBaseBackgroundColor_Params);
      this.setPageBaseBackgroundColor(params.color);
      return true;
    case kPageBroadcast_CreateRemoteMainFrame_Name:
      var params = reader.decodeStruct(PageBroadcast_CreateRemoteMainFrame_Params);
      this.createRemoteMainFrame(params.token, params.openerFrameToken, params.replicationState, params.isLoading, params.devtoolsFrameToken, params.navigationMetricsToken, params.remoteFrameInterfaces, params.remoteMainFrameInterfaces);
      return true;
    case kPageBroadcast_UpdatePageBrowsingContextGroup_Name:
      var params = reader.decodeStruct(PageBroadcast_UpdatePageBrowsingContextGroup_Params);
      this.updatePageBrowsingContextGroup(params.browsingContextGroupToken);
      return true;
    case kPageBroadcast_SetPageAttributionSupport_Name:
      var params = reader.decodeStruct(PageBroadcast_SetPageAttributionSupport_Params);
      this.setPageAttributionSupport(params.support);
      return true;
    case kPageBroadcast_UpdateColorProviders_Name:
      var params = reader.decodeStruct(PageBroadcast_UpdateColorProviders_Params);
      this.updateColorProviders(params.colorProviderColors);
      return true;
    case kPageBroadcast_UpdateCanvasNoiseToken_Name:
      var params = reader.decodeStruct(PageBroadcast_UpdateCanvasNoiseToken_Params);
      this.updateCanvasNoiseToken(params.canvasNoiseToken);
      return true;
    case kPageBroadcast_SetSupportsDraggableRegions_Name:
      var params = reader.decodeStruct(PageBroadcast_SetSupportsDraggableRegions_Params);
      this.setSupportsDraggableRegions(params.supportsDraggableRegions);
      return true;
    default:
      return false;
    }
  };

  PageBroadcastStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kPageBroadcast_SetPageLifecycleState_Name:
      var params = reader.decodeStruct(PageBroadcast_SetPageLifecycleState_Params);
      this.setPageLifecycleState(params.state, params.pageRestoreParams).then(function(response) {
        var responseParams =
            new PageBroadcast_SetPageLifecycleState_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kPageBroadcast_SetPageLifecycleState_Name,
            codec.align(PageBroadcast_SetPageLifecycleState_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PageBroadcast_SetPageLifecycleState_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kPageBroadcast_ActivatePrerenderedPage_Name:
      var params = reader.decodeStruct(PageBroadcast_ActivatePrerenderedPage_Params);
      this.activatePrerenderedPage(params.prerenderPageActivationParams).then(function(response) {
        var responseParams =
            new PageBroadcast_ActivatePrerenderedPage_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kPageBroadcast_ActivatePrerenderedPage_Name,
            codec.align(PageBroadcast_ActivatePrerenderedPage_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(PageBroadcast_ActivatePrerenderedPage_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validatePageBroadcastRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kPageBroadcast_SetPageLifecycleState_Name:
        if (message.expectsResponse())
          paramsClass = PageBroadcast_SetPageLifecycleState_Params;
      break;
      case kPageBroadcast_AudioStateChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PageBroadcast_AudioStateChanged_Params;
      break;
      case kPageBroadcast_ActivatePrerenderedPage_Name:
        if (message.expectsResponse())
          paramsClass = PageBroadcast_ActivatePrerenderedPage_Params;
      break;
      case kPageBroadcast_UpdateWebPreferences_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PageBroadcast_UpdateWebPreferences_Params;
      break;
      case kPageBroadcast_UpdateRendererPreferences_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PageBroadcast_UpdateRendererPreferences_Params;
      break;
      case kPageBroadcast_SetHistoryIndexAndLength_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PageBroadcast_SetHistoryIndexAndLength_Params;
      break;
      case kPageBroadcast_SetPageBaseBackgroundColor_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PageBroadcast_SetPageBaseBackgroundColor_Params;
      break;
      case kPageBroadcast_CreateRemoteMainFrame_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PageBroadcast_CreateRemoteMainFrame_Params;
      break;
      case kPageBroadcast_UpdatePageBrowsingContextGroup_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PageBroadcast_UpdatePageBrowsingContextGroup_Params;
      break;
      case kPageBroadcast_SetPageAttributionSupport_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PageBroadcast_SetPageAttributionSupport_Params;
      break;
      case kPageBroadcast_UpdateColorProviders_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PageBroadcast_UpdateColorProviders_Params;
      break;
      case kPageBroadcast_UpdateCanvasNoiseToken_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PageBroadcast_UpdateCanvasNoiseToken_Params;
      break;
      case kPageBroadcast_SetSupportsDraggableRegions_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = PageBroadcast_SetSupportsDraggableRegions_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validatePageBroadcastResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kPageBroadcast_SetPageLifecycleState_Name:
        if (message.isResponse())
          paramsClass = PageBroadcast_SetPageLifecycleState_ResponseParams;
        break;
      case kPageBroadcast_ActivatePrerenderedPage_Name:
        if (message.isResponse())
          paramsClass = PageBroadcast_ActivatePrerenderedPage_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var PageBroadcast = {
    name: 'blink.mojom.PageBroadcast',
    kVersion: 0,
    ptrClass: PageBroadcastPtr,
    proxyClass: PageBroadcastProxy,
    stubClass: PageBroadcastStub,
    validateRequest: validatePageBroadcastRequest,
    validateResponse: validatePageBroadcastResponse,
  };
  PageBroadcastStub.prototype.validator = validatePageBroadcastRequest;
  PageBroadcastProxy.prototype.validator = validatePageBroadcastResponse;
  exports.PagehideDispatch = PagehideDispatch;
  exports.PageLifecycleState = PageLifecycleState;
  exports.PageRestoreParams = PageRestoreParams;
  exports.ColorProviderColorMaps = ColorProviderColorMaps;
  exports.PrerenderPageActivationParams = PrerenderPageActivationParams;
  exports.PageBroadcast = PageBroadcast;
  exports.PageBroadcastPtr = PageBroadcastPtr;
  exports.PageBroadcastAssociatedPtr = PageBroadcastAssociatedPtr;
})();