// third_party/blink/public/mojom/page/page.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_SEND_VALIDATION_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_SEND_VALIDATION_H_

#include "third_party/blink/public/mojom/page/page.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/attribution.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "third_party/blink/public/mojom/fingerprinting_protection/noise_token.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/frame_replication_state.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/remote_frame.mojom-shared.h"
#include "third_party/blink/public/mojom/frame/view_transition_state.mojom-shared.h"
#include "third_party/blink/public/mojom/navigation/was_activated_option.mojom-shared.h"
#include "third_party/blink/public/mojom/page/page_visibility_state.mojom-shared.h"
#include "third_party/blink/public/mojom/renderer_preferences.mojom-shared.h"
#include "third_party/blink/public/mojom/tokens/tokens.mojom-shared.h"
#include "third_party/blink/public/mojom/webpreferences/web_preferences.mojom-shared.h"
#include "ui/color/color_id.mojom-shared.h"

#include "third_party/blink/public/mojom/page/page.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::blink::mojom::PagehideDispatch, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::PageLifecycleStateDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PageLifecycleStateDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PageLifecycleState_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->is_frozen = Traits::is_frozen(input);

      
      mojo::internal::Serialize<::blink::mojom::PageVisibilityState>(
        Traits::visibility(input),
        &fragment->visibility);

      fragment->is_in_back_forward_cache = Traits::is_in_back_forward_cache(input);

      
      mojo::internal::Serialize<::blink::mojom::PagehideDispatch>(
        Traits::pagehide_dispatch(input),
        &fragment->pagehide_dispatch);

      fragment->eviction_enabled = Traits::eviction_enabled(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::PageRestoreParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PageRestoreParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PageRestoreParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::navigation_start(input)) in_navigation_start = Traits::navigation_start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->navigation_start)::BaseType> navigation_start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_navigation_start,
        navigation_start_fragment);

      fragment->navigation_start.Set(
          navigation_start_fragment.is_null() ? nullptr : navigation_start_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->navigation_start.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null navigation_start in PageRestoreParams struct");

      fragment->pending_history_list_index = Traits::pending_history_list_index(input);

      fragment->current_history_list_length = Traits::current_history_list_length(input);

      decltype(Traits::view_transition_state(input)) in_view_transition_state = Traits::view_transition_state(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->view_transition_state)::BaseType> view_transition_state_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::ViewTransitionStateDataView, send_validation>(
        in_view_transition_state,
        view_transition_state_fragment);

      fragment->view_transition_state.Set(
          view_transition_state_fragment.is_null() ? nullptr : view_transition_state_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::ColorProviderColorMapsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::ColorProviderColorMapsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::ColorProviderColorMaps_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::light_colors_map(input)) in_light_colors_map = Traits::light_colors_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->light_colors_map)::BaseType>
          light_colors_map_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& light_colors_map_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::color::mojom::internal::RendererColorId_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::color::mojom::RendererColorId, ::skia::mojom::SkColorDataView>, send_validation>(
        in_light_colors_map,
        light_colors_map_fragment,
        &light_colors_map_validate_params);

      fragment->light_colors_map.Set(
          light_colors_map_fragment.is_null() ? nullptr : light_colors_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->light_colors_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null light_colors_map in ColorProviderColorMaps struct");

      decltype(Traits::dark_colors_map(input)) in_dark_colors_map = Traits::dark_colors_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->dark_colors_map)::BaseType>
          dark_colors_map_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& dark_colors_map_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::color::mojom::internal::RendererColorId_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::color::mojom::RendererColorId, ::skia::mojom::SkColorDataView>, send_validation>(
        in_dark_colors_map,
        dark_colors_map_fragment,
        &dark_colors_map_validate_params);

      fragment->dark_colors_map.Set(
          dark_colors_map_fragment.is_null() ? nullptr : dark_colors_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->dark_colors_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null dark_colors_map in ColorProviderColorMaps struct");

      decltype(Traits::forced_colors_map(input)) in_forced_colors_map = Traits::forced_colors_map(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->forced_colors_map)::BaseType>
          forced_colors_map_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& forced_colors_map_validate_params =
          mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::color::mojom::internal::RendererColorId_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
      
      mojo::internal::Serialize<mojo::MapDataView<::color::mojom::RendererColorId, ::skia::mojom::SkColorDataView>, send_validation>(
        in_forced_colors_map,
        forced_colors_map_fragment,
        &forced_colors_map_validate_params);

      fragment->forced_colors_map.Set(
          forced_colors_map_fragment.is_null() ? nullptr : forced_colors_map_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->forced_colors_map.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null forced_colors_map in ColorProviderColorMaps struct");
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::blink::mojom::PrerenderPageActivationParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::PrerenderPageActivationParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::blink::mojom::internal::PrerenderPageActivationParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::blink::mojom::WasActivatedOption>(
        Traits::was_user_activated(input),
        &fragment->was_user_activated);

      decltype(Traits::activation_start(input)) in_activation_start = Traits::activation_start(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->activation_start)::BaseType> activation_start_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_activation_start,
        activation_start_fragment);

      fragment->activation_start.Set(
          activation_start_fragment.is_null() ? nullptr : activation_start_fragment.data());

      decltype(Traits::view_transition_state(input)) in_view_transition_state = Traits::view_transition_state(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->view_transition_state)::BaseType> view_transition_state_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::blink::mojom::ViewTransitionStateDataView, send_validation>(
        in_view_transition_state,
        view_transition_state_fragment);

      fragment->view_transition_state.Set(
          view_transition_state_fragment.is_null() ? nullptr : view_transition_state_fragment.data());
  }
};

}  // namespace mojo::internal

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_PAGE_MOJOM_SEND_VALIDATION_H_