// third_party/blink/public/mojom/page/display_cutout.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../../mojo/public/js/bindings.js';

import {
  Insets as gfx_mojom_Insets,
  InsetsSpec as gfx_mojom_InsetsSpec
} from '../../../../../ui/gfx/geometry/mojom/geometry.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ViewportFitSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ViewportFit = {
  
  kAuto: 0,
  kContain: 1,
  kCover: 2,
  kCoverForcedByUserAgent: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DisplayCutoutHostPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.DisplayCutoutHost', scope);
  }
}

/** @interface */
export class DisplayCutoutHostInterface {
  
  /**
   * @param { !ViewportFit } value
   */

  notifyViewportFitChanged(value) {}
  
  /**
   * @param { !boolean } value
   */

  notifyComplexSafeAreaConstraintChanged(value) {}
}

/**
 * @implements { DisplayCutoutHostInterface }
 */
export class DisplayCutoutHostRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DisplayCutoutHostPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DisplayCutoutHostPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DisplayCutoutHostPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !ViewportFit } value
   */

  notifyViewportFitChanged(
      value) {
    this.proxy.sendMessage(
        0,
        DisplayCutoutHost_NotifyViewportFitChanged_ParamsSpec.$,
        null,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !boolean } value
   */

  notifyComplexSafeAreaConstraintChanged(
      value) {
    this.proxy.sendMessage(
        1,
        DisplayCutoutHost_NotifyComplexSafeAreaConstraintChanged_ParamsSpec.$,
        null,
        [
          value
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DisplayCutoutHost
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DisplayCutoutHostReceiver {
  /**
   * @param {!DisplayCutoutHostInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DisplayCutoutHostRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DisplayCutoutHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DisplayCutoutHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DisplayCutoutHost_NotifyViewportFitChanged_ParamsSpec.$,
        null,
        impl.notifyViewportFitChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        DisplayCutoutHost_NotifyComplexSafeAreaConstraintChanged_ParamsSpec.$,
        null,
        impl.notifyComplexSafeAreaConstraintChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DisplayCutoutHost {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DisplayCutoutHost";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DisplayCutoutHostRemote}
   */
  static getRemote() {
    let remote = new DisplayCutoutHostRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DisplayCutoutHost
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DisplayCutoutHostCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DisplayCutoutHostRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DisplayCutoutHostRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyViewportFitChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DisplayCutoutHost_NotifyViewportFitChanged_ParamsSpec.$,
        null,
        this.notifyViewportFitChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyComplexSafeAreaConstraintChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        DisplayCutoutHost_NotifyComplexSafeAreaConstraintChanged_ParamsSpec.$,
        null,
        this.notifyComplexSafeAreaConstraintChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DisplayCutoutClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'blink.mojom.DisplayCutoutClient', scope);
  }
}

/** @interface */
export class DisplayCutoutClientInterface {
  
  /**
   * @param { !gfx_mojom_Insets } safeArea
   */

  setSafeArea(safeArea) {}
}

/**
 * @implements { DisplayCutoutClientInterface }
 */
export class DisplayCutoutClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DisplayCutoutClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DisplayCutoutClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DisplayCutoutClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !gfx_mojom_Insets } safeArea
   */

  setSafeArea(
      safeArea) {
    this.proxy.sendMessage(
        0,
        DisplayCutoutClient_SetSafeArea_ParamsSpec.$,
        null,
        [
          safeArea
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DisplayCutoutClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DisplayCutoutClientReceiver {
  /**
   * @param {!DisplayCutoutClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DisplayCutoutClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DisplayCutoutClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DisplayCutoutClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DisplayCutoutClient_SetSafeArea_ParamsSpec.$,
        null,
        impl.setSafeArea.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DisplayCutoutClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.DisplayCutoutClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DisplayCutoutClientRemote}
   */
  static getRemote() {
    let remote = new DisplayCutoutClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DisplayCutoutClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DisplayCutoutClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DisplayCutoutClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DisplayCutoutClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSafeArea =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DisplayCutoutClient_SetSafeArea_ParamsSpec.$,
        null,
        this.setSafeArea.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DisplayCutoutHost_NotifyViewportFitChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DisplayCutoutHost_NotifyComplexSafeAreaConstraintChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DisplayCutoutClient_SetSafeArea_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DisplayCutoutHost_NotifyViewportFitChanged_ParamsSpec.$,
    'DisplayCutoutHost_NotifyViewportFitChanged_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        ViewportFitSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DisplayCutoutHost_NotifyViewportFitChanged_Params {
  constructor() {
    /** @type { !ViewportFit } */
    this.value;
  }
}



mojo.internal.Struct(
    DisplayCutoutHost_NotifyComplexSafeAreaConstraintChanged_ParamsSpec.$,
    'DisplayCutoutHost_NotifyComplexSafeAreaConstraintChanged_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DisplayCutoutHost_NotifyComplexSafeAreaConstraintChanged_Params {
  constructor() {
    /** @type { !boolean } */
    this.value;
  }
}



mojo.internal.Struct(
    DisplayCutoutClient_SetSafeArea_ParamsSpec.$,
    'DisplayCutoutClient_SetSafeArea_Params',
    [
      mojo.internal.StructField(
        'safeArea', 0,
        0,
        gfx_mojom_InsetsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DisplayCutoutClient_SetSafeArea_Params {
  constructor() {
    /** @type { !gfx_mojom_Insets } */
    this.safeArea;
  }
}

