// third_party/blink/public/mojom/origin_trials/origin_trial_state_host.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/origin_trials/origin_trial_state_host.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var runtime_feature$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/runtime_feature_state/runtime_feature.mojom', '../runtime_feature_state/runtime_feature.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }



  function OriginTrialFeatureState(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OriginTrialFeatureState.prototype.initDefaults_ = function() {
    this.isEnabled = false;
    this.tokens = null;
  };
  OriginTrialFeatureState.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OriginTrialFeatureState.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate OriginTrialFeatureState.tokens
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OriginTrialFeatureState.encodedSize = codec.kStructHeaderSize + 16;

  OriginTrialFeatureState.decode = function(decoder) {
    var packed;
    var val = new OriginTrialFeatureState();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.isEnabled = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.tokens =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  OriginTrialFeatureState.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OriginTrialFeatureState.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.isEnabled & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(codec.String, val.tokens);
  };
  function OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params.prototype.initDefaults_ = function() {
    this.originTrialFeatures = null;
  };
  OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params.originTrialFeatures
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 0, false, new codec.Enum(runtime_feature$.RuntimeFeature), new codec.PointerTo(OriginTrialFeatureState), false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params.encodedSize = codec.kStructHeaderSize + 8;

  OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params.decode = function(decoder) {
    var packed;
    var val = new OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.originTrialFeatures =
        decoder.decodeMapPointer(new codec.Enum(runtime_feature$.RuntimeFeature), new codec.PointerTo(OriginTrialFeatureState));
    return val;
  };

  OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeMapPointer(new codec.Enum(runtime_feature$.RuntimeFeature), new codec.PointerTo(OriginTrialFeatureState), val.originTrialFeatures);
  };
  function OriginTrialStateHost_EnablePersistentTrial_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OriginTrialStateHost_EnablePersistentTrial_Params.prototype.initDefaults_ = function() {
    this.token = null;
    this.scriptOrigins = null;
  };
  OriginTrialStateHost_EnablePersistentTrial_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OriginTrialStateHost_EnablePersistentTrial_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OriginTrialStateHost_EnablePersistentTrial_Params.token
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate OriginTrialStateHost_EnablePersistentTrial_Params.scriptOrigins
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(origin$.Origin), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OriginTrialStateHost_EnablePersistentTrial_Params.encodedSize = codec.kStructHeaderSize + 16;

  OriginTrialStateHost_EnablePersistentTrial_Params.decode = function(decoder) {
    var packed;
    var val = new OriginTrialStateHost_EnablePersistentTrial_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.token =
        decoder.decodeStruct(codec.String);
    val.scriptOrigins =
        decoder.decodeArrayPointer(new codec.PointerTo(origin$.Origin));
    return val;
  };

  OriginTrialStateHost_EnablePersistentTrial_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OriginTrialStateHost_EnablePersistentTrial_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.token);
    encoder.encodeArrayPointer(new codec.PointerTo(origin$.Origin), val.scriptOrigins);
  };
  var kOriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Name = 0;
  var kOriginTrialStateHost_EnablePersistentTrial_Name = 1;

  function OriginTrialStateHostPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(OriginTrialStateHost,
                                                   handleOrPtrInfo);
  }

  function OriginTrialStateHostAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        OriginTrialStateHost, associatedInterfacePtrInfo);
  }

  OriginTrialStateHostAssociatedPtr.prototype =
      Object.create(OriginTrialStateHostPtr.prototype);
  OriginTrialStateHostAssociatedPtr.prototype.constructor =
      OriginTrialStateHostAssociatedPtr;

  function OriginTrialStateHostProxy(receiver) {
    this.receiver_ = receiver;
  }
  OriginTrialStateHostPtr.prototype.applyFeatureDiffForOriginTrial = function() {
    return OriginTrialStateHostProxy.prototype.applyFeatureDiffForOriginTrial
        .apply(this.ptr.getProxy(), arguments);
  };

  OriginTrialStateHostProxy.prototype.applyFeatureDiffForOriginTrial = function(originTrialFeatures) {
    var params_ = new OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params();
    params_.originTrialFeatures = originTrialFeatures;
    var builder = new codec.MessageV0Builder(
        kOriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Name,
        codec.align(OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params.encodedSize));
    builder.encodeStruct(OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  OriginTrialStateHostPtr.prototype.enablePersistentTrial = function() {
    return OriginTrialStateHostProxy.prototype.enablePersistentTrial
        .apply(this.ptr.getProxy(), arguments);
  };

  OriginTrialStateHostProxy.prototype.enablePersistentTrial = function(token, scriptOrigins) {
    var params_ = new OriginTrialStateHost_EnablePersistentTrial_Params();
    params_.token = token;
    params_.scriptOrigins = scriptOrigins;
    var builder = new codec.MessageV0Builder(
        kOriginTrialStateHost_EnablePersistentTrial_Name,
        codec.align(OriginTrialStateHost_EnablePersistentTrial_Params.encodedSize));
    builder.encodeStruct(OriginTrialStateHost_EnablePersistentTrial_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function OriginTrialStateHostStub(delegate) {
    this.delegate_ = delegate;
  }
  OriginTrialStateHostStub.prototype.applyFeatureDiffForOriginTrial = function(originTrialFeatures) {
    return this.delegate_ && this.delegate_.applyFeatureDiffForOriginTrial && this.delegate_.applyFeatureDiffForOriginTrial(originTrialFeatures);
  }
  OriginTrialStateHostStub.prototype.enablePersistentTrial = function(token, scriptOrigins) {
    return this.delegate_ && this.delegate_.enablePersistentTrial && this.delegate_.enablePersistentTrial(token, scriptOrigins);
  }

  OriginTrialStateHostStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kOriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Name:
      var params = reader.decodeStruct(OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params);
      this.applyFeatureDiffForOriginTrial(params.originTrialFeatures);
      return true;
    case kOriginTrialStateHost_EnablePersistentTrial_Name:
      var params = reader.decodeStruct(OriginTrialStateHost_EnablePersistentTrial_Params);
      this.enablePersistentTrial(params.token, params.scriptOrigins);
      return true;
    default:
      return false;
    }
  };

  OriginTrialStateHostStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateOriginTrialStateHostRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kOriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = OriginTrialStateHost_ApplyFeatureDiffForOriginTrial_Params;
      break;
      case kOriginTrialStateHost_EnablePersistentTrial_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = OriginTrialStateHost_EnablePersistentTrial_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateOriginTrialStateHostResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var OriginTrialStateHost = {
    name: 'blink.mojom.OriginTrialStateHost',
    kVersion: 0,
    ptrClass: OriginTrialStateHostPtr,
    proxyClass: OriginTrialStateHostProxy,
    stubClass: OriginTrialStateHostStub,
    validateRequest: validateOriginTrialStateHostRequest,
    validateResponse: null,
  };
  OriginTrialStateHostStub.prototype.validator = validateOriginTrialStateHostRequest;
  OriginTrialStateHostProxy.prototype.validator = null;
  exports.OriginTrialFeatureState = OriginTrialFeatureState;
  exports.OriginTrialStateHost = OriginTrialStateHost;
  exports.OriginTrialStateHostPtr = OriginTrialStateHostPtr;
  exports.OriginTrialStateHostAssociatedPtr = OriginTrialStateHostAssociatedPtr;
})();