// third_party/blink/public/mojom/on_device_translation/translator.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('blink.mojom.ModelStreamingResponder');






goog.provide('blink.mojom.Translator');
goog.provide('blink.mojom.TranslatorReceiver');
goog.provide('blink.mojom.TranslatorCallbackRouter');
goog.provide('blink.mojom.TranslatorInterface');
goog.provide('blink.mojom.TranslatorRemote');
goog.provide('blink.mojom.TranslatorPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
blink.mojom.TranslatorPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        blink.mojom.Translator.$interfaceName,
        scope);
  }
};

/** @interface */
blink.mojom.TranslatorInterface = class {
  
  /**
   * @param { !string } input
   * @param { !blink.mojom.ModelStreamingResponderRemote } pendingResponder
   */

  translate(input, pendingResponder) {}
  
  /**
   * @param { !string } input
   * @param { !blink.mojom.ModelStreamingResponderRemote } pendingResponder
   */

  translateStreaming(input, pendingResponder) {}
};

/**
 * @export
 * @implements { blink.mojom.TranslatorInterface }
 */
blink.mojom.TranslatorRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!blink.mojom.TranslatorPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          blink.mojom.TranslatorPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!blink.mojom.TranslatorPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } input
   * @param { !blink.mojom.ModelStreamingResponderRemote } pendingResponder
   */

  translate(
      input,
      pendingResponder) {
    this.proxy.sendMessage(
        0,
        blink.mojom.Translator_Translate_ParamsSpec.$,
        null,
        [
          input,
          pendingResponder
        ],
        false);
  }

  
  /**
   * @param { !string } input
   * @param { !blink.mojom.ModelStreamingResponderRemote } pendingResponder
   */

  translateStreaming(
      input,
      pendingResponder) {
    this.proxy.sendMessage(
        1,
        blink.mojom.Translator_TranslateStreaming_ParamsSpec.$,
        null,
        [
          input,
          pendingResponder
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Translator
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
blink.mojom.TranslatorReceiver = class {
  /**
   * @param {!blink.mojom.TranslatorInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!blink.mojom.TranslatorRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        blink.mojom.TranslatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.TranslatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        blink.mojom.Translator_Translate_ParamsSpec.$,
        null,
        impl.translate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        blink.mojom.Translator_TranslateStreaming_ParamsSpec.$,
        null,
        impl.translateStreaming.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
blink.mojom.Translator = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "blink.mojom.Translator";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!blink.mojom.TranslatorRemote}
   * @export
   */
  static getRemote() {
    let remote = new blink.mojom.TranslatorRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the Translator
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
blink.mojom.TranslatorCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      blink.mojom.TranslatorRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!blink.mojom.TranslatorRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.translate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        blink.mojom.Translator_Translate_ParamsSpec.$,
        null,
        this.translate.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.translateStreaming =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        blink.mojom.Translator_TranslateStreaming_ParamsSpec.$,
        null,
        this.translateStreaming.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('blink.mojom.Translator_Translate_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Translator_Translate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('blink.mojom.Translator_TranslateStreaming_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
blink.mojom.Translator_TranslateStreaming_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    blink.mojom.Translator_Translate_ParamsSpec.$,
    'Translator_Translate_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pendingResponder', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.ModelStreamingResponderRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.Translator_Translate_Params');

/** @record */
blink.mojom.Translator_Translate_Params = class {
  constructor() {
    /** @export { !string } */
    this.input;
    /** @export { !blink.mojom.ModelStreamingResponderRemote } */
    this.pendingResponder;
  }
};



mojo.internal.Struct(
    blink.mojom.Translator_TranslateStreaming_ParamsSpec.$,
    'Translator_TranslateStreaming_Params',
    [
      mojo.internal.StructField(
        'input', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pendingResponder', 8,
        0,
        mojo.internal.InterfaceProxy(blink.mojom.ModelStreamingResponderRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('blink.mojom.Translator_TranslateStreaming_Params');

/** @record */
blink.mojom.Translator_TranslateStreaming_Params = class {
  constructor() {
    /** @export { !string } */
    this.input;
    /** @export { !blink.mojom.ModelStreamingResponderRemote } */
    this.pendingResponder;
  }
};

