// third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_TRANSLATION_MANAGER_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_TRANSLATION_MANAGER_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/ai/model_download_progress_observer.mojom-shared.h"
#include "third_party/blink/public/mojom/on_device_translation/translator.mojom-shared.h"


namespace blink::mojom {
class TranslatorLanguageCodeDataView;

class TranslatorCreateOptionsDataView;

class CreateTranslatorResultDataView;


}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::TranslatorLanguageCodeDataView> {
  using Data = ::blink::mojom::internal::TranslatorLanguageCode_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::TranslatorCreateOptionsDataView> {
  using Data = ::blink::mojom::internal::TranslatorCreateOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::blink::mojom::CreateTranslatorResultDataView> {
  using Data = ::blink::mojom::internal::CreateTranslatorResult_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


enum class CanCreateTranslatorResult : int32_t {
  
  kReadily = 0,
  
  kAfterDownloadLibraryNotReady = 1,
  
  kAfterDownloadLanguagePackNotReady = 2,
  
  kAfterDownloadLibraryAndLanguagePackNotReady = 3,
  
  kAfterDownloadTranslatorCreationRequired = 4,
  
  kNoNotSupportedLanguage = 5,
  
  kNoServiceCrashed = 6,
  
  kNoDisallowedByPolicy = 7,
  
  kNoExceedsServiceCountLimitation = 8,
  
  kNoInvalidStoragePartition = 9,
  kMinValue = 0,
  kMaxValue = 9,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CanCreateTranslatorResult value);
inline bool IsKnownEnumValue(CanCreateTranslatorResult value) {
  return internal::CanCreateTranslatorResult_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class CreateTranslatorError : int32_t {
  
  kInvalidBinary = 1,
  
  kInvalidFunctionPointer = 2,
  
  kFailedToInitialize = 3,
  
  kFailedToCreateTranslator = 4,
  
  kServiceCrashed = 5,
  
  kDisallowedByPolicy = 6,
  
  kExceedsServiceCountLimitation = 7,
  
  kExceedsPendingTaskCountLimitation = 8,
  
  kInvalidVersion = 9,
  
  kInvalidStoragePartition = 10,
  kMinValue = 1,
  kMaxValue = 10,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, CreateTranslatorError value);
inline bool IsKnownEnumValue(CreateTranslatorError value) {
  return internal::CreateTranslatorError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class TranslationManagerCreateTranslatorClientInterfaceBase {};

using TranslationManagerCreateTranslatorClientPtrDataView =
    mojo::InterfacePtrDataView<TranslationManagerCreateTranslatorClientInterfaceBase>;
using TranslationManagerCreateTranslatorClientRequestDataView =
    mojo::InterfaceRequestDataView<TranslationManagerCreateTranslatorClientInterfaceBase>;
using TranslationManagerCreateTranslatorClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TranslationManagerCreateTranslatorClientInterfaceBase>;
using TranslationManagerCreateTranslatorClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TranslationManagerCreateTranslatorClientInterfaceBase>;
class TranslationManagerInterfaceBase {};

using TranslationManagerPtrDataView =
    mojo::InterfacePtrDataView<TranslationManagerInterfaceBase>;
using TranslationManagerRequestDataView =
    mojo::InterfaceRequestDataView<TranslationManagerInterfaceBase>;
using TranslationManagerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<TranslationManagerInterfaceBase>;
using TranslationManagerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<TranslationManagerInterfaceBase>;


class TranslatorLanguageCodeDataView {
 public:
  TranslatorLanguageCodeDataView() = default;

  TranslatorLanguageCodeDataView(
      internal::TranslatorLanguageCode_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCodeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCode(UserType* output) {
    
    auto* pointer = data_->code.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::TranslatorLanguageCode_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class TranslatorCreateOptionsDataView {
 public:
  TranslatorCreateOptionsDataView() = default;

  TranslatorCreateOptionsDataView(
      internal::TranslatorCreateOptions_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSourceLangDataView(
      TranslatorLanguageCodeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceLang(UserType* output) {
    
    auto* pointer = data_->source_lang.Get();
    return mojo::internal::Deserialize<::blink::mojom::TranslatorLanguageCodeDataView>(
        pointer, output, message_);
  }
  inline void GetTargetLangDataView(
      TranslatorLanguageCodeDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTargetLang(UserType* output) {
    
    auto* pointer = data_->target_lang.Get();
    return mojo::internal::Deserialize<::blink::mojom::TranslatorLanguageCodeDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeObserverRemote() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::ModelDownloadProgressObserverInterfaceBase>>(
            &data_->observer_remote, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::TranslatorCreateOptions_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CreateTranslatorResultDataView {
 public:
  using Tag = internal::CreateTranslatorResult_Data::CreateTranslatorResult_Tag;

  CreateTranslatorResultDataView() = default;

  CreateTranslatorResultDataView(
      internal::CreateTranslatorResult_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_translator() const { return data_->tag == Tag::kTranslator; }
  template <typename UserType>
  UserType TakeTranslator() {
    CHECK(is_translator());
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::blink::mojom::TranslatorInterfaceBase>>(
            &data_->data.f_translator, &result, message_);
    CHECK(ret);
    return result;
  }
  bool is_error() const { return data_->tag == Tag::kError; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    CHECK(is_error());
    return mojo::internal::Deserialize<::blink::mojom::CreateTranslatorError>(
        data_->data.f_error, output);
  }
  CreateTranslatorError error() const {
    CHECK(is_error());
    // TODO(dcheng): This seems incorrect, as it bypasses enum traits.
    return ::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::blink::mojom::CreateTranslatorError>(data_->data.f_error));
  }

 private:
  internal::CreateTranslatorResult_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};



}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_ON_DEVICE_TRANSLATION_TRANSLATION_MANAGER_MOJOM_DATA_VIEW_H_