// third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-params-data.h"
#include "third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/on_device_translation/translation_manager.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
TranslatorLanguageCode::TranslatorLanguageCode()
    : code() {}

TranslatorLanguageCode::TranslatorLanguageCode(
    const ::blink::String& code_in)
    : code(std::move(code_in)) {}

TranslatorLanguageCode::~TranslatorLanguageCode() = default;
size_t TranslatorLanguageCode::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->code);
  return seed;
}

void TranslatorLanguageCode::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "code"), this->code,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TranslatorLanguageCode::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TranslatorCreateOptions::TranslatorCreateOptions()
    : source_lang(),
      target_lang(),
      observer_remote() {}

TranslatorCreateOptions::TranslatorCreateOptions(
    TranslatorLanguageCodePtr source_lang_in,
    TranslatorLanguageCodePtr target_lang_in,
    ::mojo::PendingRemote<::blink::mojom::blink::ModelDownloadProgressObserver> observer_remote_in)
    : source_lang(std::move(source_lang_in)),
      target_lang(std::move(target_lang_in)),
      observer_remote(std::move(observer_remote_in)) {}

TranslatorCreateOptions::~TranslatorCreateOptions() = default;

void TranslatorCreateOptions::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_lang"), this->source_lang,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TranslatorLanguageCodePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "target_lang"), this->target_lang,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type TranslatorLanguageCodePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "observer_remote"), this->observer_remote,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::mojo::PendingRemote<::blink::mojom::blink::ModelDownloadProgressObserver>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TranslatorCreateOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CreateTranslatorResultPtr
CreateTranslatorResult::NewTranslator(
    ::mojo::PendingRemote<::blink::mojom::blink::Translator> value) {
  return CreateTranslatorResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kTranslator)>,
      std::move(value));
}

CreateTranslatorResultPtr
CreateTranslatorResult::NewError(
    CreateTranslatorError value) {
  return CreateTranslatorResultPtr(
      std::in_place,
      std::in_place_index<static_cast<size_t>(Tag::kError)>,
      std::move(value));
}

CreateTranslatorResult::CreateTranslatorResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kTranslator)>,
    ::mojo::PendingRemote<::blink::mojom::blink::Translator> value)
    : tag_(Tag::kTranslator),
      data_(std::in_place_index<static_cast<size_t>(Tag::kTranslator)>,
            std::move(value)) {}

CreateTranslatorResult::CreateTranslatorResult(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    CreateTranslatorError value)
    : tag_(Tag::kError),
      data_(std::in_place_index<static_cast<size_t>(Tag::kError)>,
            std::move(value)) {}
CreateTranslatorResult::~CreateTranslatorResult() {
  DestroyActive();
}

void CreateTranslatorResult::set_translator(::mojo::PendingRemote<::blink::mojom::blink::Translator> translator) {
  if (tag_ == Tag::kTranslator) {
    data_.translator = std::move(translator);
  } else {
    DestroyActive();
    tag_ = Tag::kTranslator;
    new (&data_.translator) ::mojo::PendingRemote<::blink::mojom::blink::Translator>(
        std::move(translator));
  }
}

void CreateTranslatorResult::set_error(CreateTranslatorError error) {
  if (tag_ != Tag::kError) {
    DestroyActive();
    tag_ = Tag::kError;
  }
  data_.error = error;
}


CreateTranslatorResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kTranslator)>,
    ::mojo::PendingRemote<::blink::mojom::blink::Translator> value)
    : translator(std::move(value)) {}

CreateTranslatorResult::Union_::Union_(
    std::in_place_index_t<static_cast<size_t>(Tag::kError)>,
    CreateTranslatorError value)
    : error(std::move(value)) {}

void CreateTranslatorResult::DestroyActive() {
  switch (tag_) {

    case Tag::kTranslator:
      std::destroy_at(&data_.translator);
      break;
    case Tag::kError:
      std::destroy_at(&data_.error);
      break;
  }
}

bool CreateTranslatorResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
// The declaration includes the definition on other builds.

TranslationManagerCreateTranslatorClient::IPCStableHashFunction TranslationManagerCreateTranslatorClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TranslationManagerCreateTranslatorClient>(message.name())) {
    case messages::TranslationManagerCreateTranslatorClient::kOnResult: {
      return &TranslationManagerCreateTranslatorClient::OnResult_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TranslationManagerCreateTranslatorClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TranslationManagerCreateTranslatorClient>(message.name())) {
      case messages::TranslationManagerCreateTranslatorClient::kOnResult:
            return "Receive blink::mojom::TranslationManagerCreateTranslatorClient::OnResult";
    }
  } else {
    switch (static_cast<messages::TranslationManagerCreateTranslatorClient>(message.name())) {
      case messages::TranslationManagerCreateTranslatorClient::kOnResult:
            return "Receive reply blink::mojom::TranslationManagerCreateTranslatorClient::OnResult";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TranslationManagerCreateTranslatorClient::OnResult_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2bc5ffe5;  // IPCStableHash for blink::mojom::TranslationManagerCreateTranslatorClient::OnResult
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

TranslationManagerCreateTranslatorClientProxy::TranslationManagerCreateTranslatorClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TranslationManagerCreateTranslatorClientProxy::OnResult(
    CreateTranslatorResultPtr in_result, TranslatorLanguageCodePtr in_source_lang, TranslatorLanguageCodePtr in_target_lang) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::TranslationManagerCreateTranslatorClient::OnResult", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CreateTranslatorResultPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_lang"), in_source_lang,
                        "<value of type TranslatorLanguageCodePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_lang"), in_target_lang,
                        "<value of type TranslatorLanguageCodePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TranslationManagerCreateTranslatorClient::kOnResult), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TranslationManagerCreateTranslatorClient_OnResult_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<decltype(params->result)>
      result_fragment(params.message());
  result_fragment.Claim(&params->result);
  
  mojo::internal::Serialize<::blink::mojom::CreateTranslatorResultDataView>(
    in_result,
    result_fragment,
    true);

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->result.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null result in TranslationManagerCreateTranslatorClient.OnResult request");
  mojo::internal::MessageFragment<
      typename decltype(params->source_lang)::BaseType> source_lang_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::TranslatorLanguageCodeDataView>(
    in_source_lang,
    source_lang_fragment);

  params->source_lang.Set(
      source_lang_fragment.is_null() ? nullptr : source_lang_fragment.data());
  mojo::internal::MessageFragment<
      typename decltype(params->target_lang)::BaseType> target_lang_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::TranslatorLanguageCodeDataView>(
    in_target_lang,
    target_lang_fragment);

  params->target_lang.Set(
      target_lang_fragment.is_null() ? nullptr : target_lang_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TranslationManagerCreateTranslatorClient::Name_);
  message.set_method_name("OnResult");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool TranslationManagerCreateTranslatorClientStubDispatch::Accept(
    TranslationManagerCreateTranslatorClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TranslationManagerCreateTranslatorClient>(message->header()->name)) {
    case messages::TranslationManagerCreateTranslatorClient::kOnResult: {
      DCHECK(message->is_serialized());
      internal::TranslationManagerCreateTranslatorClient_OnResult_Params_Data* params =
          reinterpret_cast<internal::TranslationManagerCreateTranslatorClient_OnResult_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TranslationManagerCreateTranslatorClient.0
      bool success = true;
      CreateTranslatorResultPtr p_result{};
      TranslatorLanguageCodePtr p_source_lang{};
      TranslatorLanguageCodePtr p_target_lang{};
      TranslationManagerCreateTranslatorClient_OnResult_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadResult(&p_result))
        success = false;
      if (success && !input_data_view.ReadSourceLang(&p_source_lang))
        success = false;
      if (success && !input_data_view.ReadTargetLang(&p_target_lang))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TranslationManagerCreateTranslatorClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnResult(        
        std::move(p_result), 
        std::move(p_source_lang), 
        std::move(p_target_lang));
      return true;
    }
  }
  return false;
}

// static
bool TranslationManagerCreateTranslatorClientStubDispatch::AcceptWithResponder(
    TranslationManagerCreateTranslatorClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TranslationManagerCreateTranslatorClient>(message->header()->name)) {
    case messages::TranslationManagerCreateTranslatorClient::kOnResult: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTranslationManagerCreateTranslatorClientValidationInfo[] = {
    { &internal::TranslationManagerCreateTranslatorClient_OnResult_Params_Data::Validate,
     nullptr /* no response */},
};

bool TranslationManagerCreateTranslatorClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::TranslationManagerCreateTranslatorClient::Name_,
    kTranslationManagerCreateTranslatorClientValidationInfo);
}

// The declaration includes the definition on other builds.

TranslationManager::IPCStableHashFunction TranslationManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::TranslationManager>(message.name())) {
    case messages::TranslationManager::kCreateTranslator: {
      return &TranslationManager::CreateTranslator_Sym::IPCStableHash;
    }
    case messages::TranslationManager::kTranslationAvailable: {
      return &TranslationManager::TranslationAvailable_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* TranslationManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::TranslationManager>(message.name())) {
      case messages::TranslationManager::kCreateTranslator:
            return "Receive blink::mojom::TranslationManager::CreateTranslator";
      case messages::TranslationManager::kTranslationAvailable:
            return "Receive blink::mojom::TranslationManager::TranslationAvailable";
    }
  } else {
    switch (static_cast<messages::TranslationManager>(message.name())) {
      case messages::TranslationManager::kCreateTranslator:
            return "Receive reply blink::mojom::TranslationManager::CreateTranslator";
      case messages::TranslationManager::kTranslationAvailable:
            return "Receive reply blink::mojom::TranslationManager::TranslationAvailable";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t TranslationManager::CreateTranslator_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x95b4aa9b;  // IPCStableHash for blink::mojom::TranslationManager::CreateTranslator
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t TranslationManager::TranslationAvailable_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8d83a273;  // IPCStableHash for blink::mojom::TranslationManager::TranslationAvailable
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class TranslationManager_TranslationAvailable_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TranslationManager_TranslationAvailable_ForwardToCallback(
      TranslationManager::TranslationAvailableCallback callback
      ) : callback_(std::move(callback)) {
  }

  TranslationManager_TranslationAvailable_ForwardToCallback(const TranslationManager_TranslationAvailable_ForwardToCallback&) = delete;
  TranslationManager_TranslationAvailable_ForwardToCallback& operator=(const TranslationManager_TranslationAvailable_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  TranslationManager::TranslationAvailableCallback callback_;
};

TranslationManagerProxy::TranslationManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TranslationManagerProxy::CreateTranslator(
    ::mojo::PendingRemote<TranslationManagerCreateTranslatorClient> in_client, TranslatorCreateOptionsPtr in_options, bool in_add_fake_download_delay) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::TranslationManager::CreateTranslator", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<TranslationManagerCreateTranslatorClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("options"), in_options,
                        "<value of type TranslatorCreateOptionsPtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("add_fake_download_delay"), in_add_fake_download_delay,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TranslationManager::kCreateTranslator), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TranslationManager_CreateTranslator_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::TranslationManagerCreateTranslatorClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in TranslationManager.CreateTranslator request");
  mojo::internal::MessageFragment<
      typename decltype(params->options)::BaseType> options_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::TranslatorCreateOptionsDataView>(
    in_options,
    options_fragment);

  params->options.Set(
      options_fragment.is_null() ? nullptr : options_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->options.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null options in TranslationManager.CreateTranslator request");

  params->add_fake_download_delay = in_add_fake_download_delay;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TranslationManager::Name_);
  message.set_method_name("CreateTranslator");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void TranslationManagerProxy::TranslationAvailable(
    TranslatorLanguageCodePtr in_source_lang, TranslatorLanguageCodePtr in_target_lang, TranslationAvailableCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::TranslationManager::TranslationAvailable", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("source_lang"), in_source_lang,
                        "<value of type TranslatorLanguageCodePtr>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("target_lang"), in_target_lang,
                        "<value of type TranslatorLanguageCodePtr>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TranslationManager::kTranslationAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TranslationManager_TranslationAvailable_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->source_lang)::BaseType> source_lang_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::TranslatorLanguageCodeDataView>(
    in_source_lang,
    source_lang_fragment);

  params->source_lang.Set(
      source_lang_fragment.is_null() ? nullptr : source_lang_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->source_lang.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null source_lang in TranslationManager.TranslationAvailable request");
  mojo::internal::MessageFragment<
      typename decltype(params->target_lang)::BaseType> target_lang_fragment(
          params.message());
  
  mojo::internal::Serialize<::blink::mojom::TranslatorLanguageCodeDataView>(
    in_target_lang,
    target_lang_fragment);

  params->target_lang.Set(
      target_lang_fragment.is_null() ? nullptr : target_lang_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->target_lang.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null target_lang in TranslationManager.TranslationAvailable request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TranslationManager::Name_);
  message.set_method_name("TranslationAvailable");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TranslationManager_TranslationAvailable_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class TranslationManager_TranslationAvailable_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static TranslationManager::TranslationAvailableCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<TranslationManager_TranslationAvailable_ProxyToResponder> proxy(
        new TranslationManager_TranslationAvailable_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&TranslationManager_TranslationAvailable_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TranslationManager_TranslationAvailable_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  TranslationManager_TranslationAvailable_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "TranslationManager::TranslationAvailableCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      CanCreateTranslatorResult in_result);
};

bool TranslationManager_TranslationAvailable_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::TranslationManager_TranslationAvailable_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TranslationManager_TranslationAvailable_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for TranslationManager.1
  bool success = true;
  CanCreateTranslatorResult p_result{};
  TranslationManager_TranslationAvailable_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TranslationManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_result));
  }
  return true;
}

void TranslationManager_TranslationAvailable_ProxyToResponder::Run(
    CanCreateTranslatorResult in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::TranslationManager::TranslationAvailable", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("result"), in_result,
                        "<value of type CanCreateTranslatorResult>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::TranslationManager::kTranslationAvailable), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::TranslationManager_TranslationAvailable_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::blink::mojom::CanCreateTranslatorResult>(
    in_result,
    &params->result);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TranslationManager::Name_);
  message.set_method_name("TranslationAvailable");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TranslationManagerStubDispatch::Accept(
    TranslationManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::TranslationManager>(message->header()->name)) {
    case messages::TranslationManager::kCreateTranslator: {
      DCHECK(message->is_serialized());
      internal::TranslationManager_CreateTranslator_Params_Data* params =
          reinterpret_cast<internal::TranslationManager_CreateTranslator_Params_Data*>(
              message->mutable_payload());
      

      // Validation for TranslationManager.0
      bool success = true;
      ::mojo::PendingRemote<TranslationManagerCreateTranslatorClient> p_client{};
      TranslatorCreateOptionsPtr p_options{};
      bool p_add_fake_download_delay{};
      TranslationManager_CreateTranslator_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success && !input_data_view.ReadOptions(&p_options))
        success = false;
      if (success)
        p_add_fake_download_delay = input_data_view.add_fake_download_delay();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TranslationManager::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateTranslator(        
        std::move(p_client), 
        std::move(p_options), 
        std::move(p_add_fake_download_delay));
      return true;
    }
    case messages::TranslationManager::kTranslationAvailable: {
      break;
    }
  }
  return false;
}

// static
bool TranslationManagerStubDispatch::AcceptWithResponder(
    TranslationManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::TranslationManager>(message->header()->name)) {
    case messages::TranslationManager::kCreateTranslator: {
      break;
    }
    case messages::TranslationManager::kTranslationAvailable: {
      internal::TranslationManager_TranslationAvailable_Params_Data* params =
          reinterpret_cast<
              internal::TranslationManager_TranslationAvailable_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for TranslationManager.1
      bool success = true;
      TranslatorLanguageCodePtr p_source_lang{};
      TranslatorLanguageCodePtr p_target_lang{};
      TranslationManager_TranslationAvailable_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSourceLang(&p_source_lang))
        success = false;
      if (success && !input_data_view.ReadTargetLang(&p_target_lang))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TranslationManager::Name_, 1, false);
        return false;
      }
      auto callback =
          TranslationManager_TranslationAvailable_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TranslationAvailable(        
        std::move(p_source_lang), 
        std::move(p_target_lang), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kTranslationManagerValidationInfo[] = {
    { &internal::TranslationManager_CreateTranslator_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::TranslationManager_TranslationAvailable_Params_Data::Validate,
     &internal::TranslationManager_TranslationAvailable_ResponseParams_Data::Validate},
};

bool TranslationManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::TranslationManager::Name_,
    kTranslationManagerValidationInfo);
}

bool TranslationManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::TranslationManager::Name_,
    kTranslationManagerValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::TranslatorLanguageCode::DataView, ::blink::mojom::blink::TranslatorLanguageCodePtr>::Read(
    ::blink::mojom::blink::TranslatorLanguageCode::DataView input,
    ::blink::mojom::blink::TranslatorLanguageCodePtr* output) {
  bool success = true;
  ::blink::mojom::blink::TranslatorLanguageCodePtr result(::blink::mojom::blink::TranslatorLanguageCode::New());
  
      if (success && !input.ReadCode(&result->code))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::TranslatorCreateOptions::DataView, ::blink::mojom::blink::TranslatorCreateOptionsPtr>::Read(
    ::blink::mojom::blink::TranslatorCreateOptions::DataView input,
    ::blink::mojom::blink::TranslatorCreateOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::TranslatorCreateOptionsPtr result(::blink::mojom::blink::TranslatorCreateOptions::New());
  
      if (success && !input.ReadSourceLang(&result->source_lang))
        success = false;
      if (success && !input.ReadTargetLang(&result->target_lang))
        success = false;
      if (success) {
        result->observer_remote =
            input.TakeObserverRemote<decltype(result->observer_remote)>();
      }
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::CreateTranslatorResult::DataView, ::blink::mojom::blink::CreateTranslatorResultPtr>::Read(
    ::blink::mojom::blink::CreateTranslatorResult::DataView input,
    ::blink::mojom::blink::CreateTranslatorResultPtr* output) {
  using UnionType = ::blink::mojom::blink::CreateTranslatorResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::kTranslator: {
      *output = UnionType::NewTranslator(
          input.TakeTranslator<::mojo::PendingRemote<::blink::mojom::blink::Translator>>());
      break;
    }
    case Tag::kError: {
      ::blink::mojom::blink::CreateTranslatorError result_error;
      if (!input.ReadError(&result_error))
        return false;

      *output = UnionType::NewError(result_error);
      break;
    }
    default:

      return false;
  }
  return true;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void TranslationManagerCreateTranslatorClientInterceptorForTesting::OnResult(CreateTranslatorResultPtr result, TranslatorLanguageCodePtr source_lang, TranslatorLanguageCodePtr target_lang) {
  GetForwardingInterface()->OnResult(
    std::move(result)
    , 
    std::move(source_lang)
    , 
    std::move(target_lang)
    );
}
TranslationManagerCreateTranslatorClientAsyncWaiter::TranslationManagerCreateTranslatorClientAsyncWaiter(
    TranslationManagerCreateTranslatorClient* proxy) : proxy_(proxy) {}

TranslationManagerCreateTranslatorClientAsyncWaiter::~TranslationManagerCreateTranslatorClientAsyncWaiter() = default;





void TranslationManagerInterceptorForTesting::CreateTranslator(::mojo::PendingRemote<TranslationManagerCreateTranslatorClient> client, TranslatorCreateOptionsPtr options, bool add_fake_download_delay) {
  GetForwardingInterface()->CreateTranslator(
    std::move(client)
    , 
    std::move(options)
    , 
    std::move(add_fake_download_delay)
    );
}
void TranslationManagerInterceptorForTesting::TranslationAvailable(TranslatorLanguageCodePtr source_lang, TranslatorLanguageCodePtr target_lang, TranslationAvailableCallback callback) {
  GetForwardingInterface()->TranslationAvailable(
    std::move(source_lang)
    , 
    std::move(target_lang)
    , std::move(callback));
}
TranslationManagerAsyncWaiter::TranslationManagerAsyncWaiter(
    TranslationManager* proxy) : proxy_(proxy) {}

TranslationManagerAsyncWaiter::~TranslationManagerAsyncWaiter() = default;


void TranslationManagerAsyncWaiter::TranslationAvailable(
    TranslatorLanguageCodePtr source_lang, TranslatorLanguageCodePtr target_lang, CanCreateTranslatorResult* out_result) {
  base::RunLoop loop;
  proxy_->TranslationAvailable(
      std::move(source_lang),
      std::move(target_lang),
      base::BindOnce(
          [](base::RunLoop* loop,
             CanCreateTranslatorResult* out_result
,
             CanCreateTranslatorResult result) {*out_result = std::move(result);
            loop->Quit();
          },
          &loop,
          out_result));
  loop.Run();
}

CanCreateTranslatorResult TranslationManagerAsyncWaiter::TranslationAvailable(
    TranslatorLanguageCodePtr source_lang, TranslatorLanguageCodePtr target_lang) {
  CanCreateTranslatorResult async_wait_result;
  TranslationAvailable(std::move(source_lang),std::move(target_lang),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif