// third_party/blink/public/mojom/navigation/navigation_params.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'third_party/blink/public/mojom/navigation/navigation_params.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('blink.mojom');
  var byte_string$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/byte_string.mojom', '../../../../../mojo/public/mojom/base/byte_string.mojom.js');
  }
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var values$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/values.mojom', '../../../../../mojo/public/mojom/base/values.mojom.js');
  }
  var content_security_policy$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/content_security_policy.mojom', '../../../../../services/network/public/mojom/content_security_policy.mojom.js');
  }
  var fetch_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/fetch_api.mojom', '../../../../../services/network/public/mojom/fetch_api.mojom.js');
  }
  var source_location$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/source_location.mojom', '../../../../../services/network/public/mojom/source_location.mojom.js');
  }
  var storage_access_api$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/storage_access_api.mojom', '../../../../../services/network/public/mojom/storage_access_api.mojom.js');
  }
  var trust_tokens$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/trust_tokens.mojom', '../../../../../services/network/public/mojom/trust_tokens.mojom.js');
  }
  var url_loader$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_loader.mojom', '../../../../../services/network/public/mojom/url_loader.mojom.js');
  }
  var url_request$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_request.mojom', '../../../../../services/network/public/mojom/url_request.mojom.js');
  }
  var url_response_head$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/url_response_head.mojom', '../../../../../services/network/public/mojom/url_response_head.mojom.js');
  }
  var web_client_hints_types$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/web_client_hints_types.mojom', '../../../../../services/network/public/mojom/web_client_hints_types.mojom.js');
  }
  var web_sandbox_flags$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/web_sandbox_flags.mojom', '../../../../../services/network/public/mojom/web_sandbox_flags.mojom.js');
  }
  var local_surface_id$ =
      mojo.internal.exposeNamespace('viz.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/viz/public/mojom/compositing/local_surface_id.mojom', '../../../../../services/viz/public/mojom/compositing/local_surface_id.mojom.js');
  }
  var back_forward_cache_not_restored_reasons$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/back_forward_cache_not_restored_reasons.mojom', '../back_forward_cache_not_restored_reasons.mojom.js');
  }
  var conversions$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/conversions/conversions.mojom', '../conversions/conversions.mojom.js');
  }
  var fenced_frame_config$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/fenced_frame/fenced_frame_config.mojom', '../fenced_frame/fenced_frame_config.mojom.js');
  }
  var fetch_api_request$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/fetch/fetch_api_request.mojom', '../fetch/fetch_api_request.mojom.js');
  }
  var frame_policy$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/frame_policy.mojom', '../frame/frame_policy.mojom.js');
  }
  var view_transition_state$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/frame/view_transition_state.mojom', '../frame/view_transition_state.mojom.js');
  }
  var lcp_critical_path_predictor$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/lcp_critical_path_predictor/lcp_critical_path_predictor.mojom', '../lcp_critical_path_predictor/lcp_critical_path_predictor.mojom.js');
  }
  var mixed_content$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/loader/mixed_content.mojom', '../loader/mixed_content.mojom.js');
  }
  var referrer$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/loader/referrer.mojom', '../loader/referrer.mojom.js');
  }
  var task_attribution_id$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/messaging/task_attribution_id.mojom', '../messaging/task_attribution_id.mojom.js');
  }
  var navigation_api_history_entry_arrays$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/navigation/navigation_api_history_entry_arrays.mojom', 'navigation_api_history_entry_arrays.mojom.js');
  }
  var navigation_initiator_activation_and_ad_status$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/navigation/navigation_initiator_activation_and_ad_status.mojom', 'navigation_initiator_activation_and_ad_status.mojom.js');
  }
  var navigation_policy$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/navigation/navigation_policy.mojom', 'navigation_policy.mojom.js');
  }
  var prefetched_signed_exchange_info$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/navigation/prefetched_signed_exchange_info.mojom', 'prefetched_signed_exchange_info.mojom.js');
  }
  var renderer_content_settings$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/navigation/renderer_content_settings.mojom', 'renderer_content_settings.mojom.js');
  }
  var system_entropy$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/navigation/system_entropy.mojom', 'system_entropy.mojom.js');
  }
  var was_activated_option$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/navigation/was_activated_option.mojom', 'was_activated_option.mojom.js');
  }
  var page$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/page/page.mojom', '../page/page.mojom.js');
  }
  var permission$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/permissions/permission.mojom', '../permissions/permission.mojom.js');
  }
  var permission_status$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/permissions/permission_status.mojom', '../permissions/permission_status.mojom.js');
  }
  var permissions_policy$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/permissions_policy/permissions_policy.mojom', '../../../../../services/network/public/mojom/permissions_policy/permissions_policy.mojom.js');
  }
  var runtime_feature$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/runtime_feature_state/runtime_feature.mojom', '../runtime_feature_state/runtime_feature.mojom.js');
  }
  var storage_key$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/storage_key/storage_key.mojom', '../storage_key/storage_key.mojom.js');
  }
  var tokens$ =
      mojo.internal.exposeNamespace('blink.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'third_party/blink/public/mojom/tokens/tokens.mojom', '../tokens/tokens.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../../url/mojom/url.mojom.js');
  }


  var NavigationType = {};
  NavigationType.RELOAD = 0;
  NavigationType.RELOAD_BYPASSING_CACHE = 1;
  NavigationType.RESTORE = 2;
  NavigationType.RESTORE_WITH_POST = 3;
  NavigationType.HISTORY_SAME_DOCUMENT = 4;
  NavigationType.HISTORY_DIFFERENT_DOCUMENT = 5;
  NavigationType.SAME_DOCUMENT = 6;
  NavigationType.DIFFERENT_DOCUMENT = 7;
  NavigationType.MIN_VALUE = 0;
  NavigationType.MAX_VALUE = 7;

  NavigationType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  NavigationType.toKnownEnumValue = function(value) {
    return value;
  };

  NavigationType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var NavigationTypeForNavigationApi = {};
  NavigationTypeForNavigationApi.kPush = 0;
  NavigationTypeForNavigationApi.kTraverse = 1;
  NavigationTypeForNavigationApi.kReplace = 2;
  NavigationTypeForNavigationApi.kReload = 3;
  NavigationTypeForNavigationApi.MIN_VALUE = 0;
  NavigationTypeForNavigationApi.MAX_VALUE = 3;

  NavigationTypeForNavigationApi.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  NavigationTypeForNavigationApi.toKnownEnumValue = function(value) {
    return value;
  };

  NavigationTypeForNavigationApi.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ForceHistoryPush = {};
  ForceHistoryPush.kYes = 0;
  ForceHistoryPush.kNo = 1;
  ForceHistoryPush.MIN_VALUE = 0;
  ForceHistoryPush.MAX_VALUE = 1;

  ForceHistoryPush.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  ForceHistoryPush.toKnownEnumValue = function(value) {
    return value;
  };

  ForceHistoryPush.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var ParentResourceTimingAccess = {};
  ParentResourceTimingAccess.kDoNotReport = 0;
  ParentResourceTimingAccess.kReportWithoutResponseDetails = 1;
  ParentResourceTimingAccess.kReportWithResponseDetails = 2;
  ParentResourceTimingAccess.MIN_VALUE = 0;
  ParentResourceTimingAccess.MAX_VALUE = 2;

  ParentResourceTimingAccess.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  ParentResourceTimingAccess.toKnownEnumValue = function(value) {
    return value;
  };

  ParentResourceTimingAccess.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function BeginNavigationParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  BeginNavigationParams.prototype.initDefaults_ = function() {
    this.initiatorFrameToken = null;
    this.headers = null;
    this.loadFlags = 0;
    this.skipServiceWorker = false;
    this.isFormSubmission = false;
    this.wasInitiatedByLinkClick = false;
    this.isContainerInitiated = false;
    this.hasRelOpener = false;
    this.requestContextType = fetch_api_request$.RequestContextType.UNSPECIFIED;
    this.mixedContentContextType = mixed_content$.MixedContentContextType.kNotMixedContent;
    this.forceHistoryPush = ForceHistoryPush.kNo;
    this.initiatorActivationAndAdStatus = 0;
    this.searchableFormUrl = null;
    this.searchableFormEncoding = null;
    this.clientSideRedirectUrl = null;
    this.devtoolsInitiator = null;
    this.trustTokenParams = null;
    this.impression = null;
    this.beforeUnloadStart = null;
    this.beforeUnloadEnd = null;
    this.storageAccessApiStatus = storage_access_api$.StorageAccessApiStatus.kNone;
  };
  BeginNavigationParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  BeginNavigationParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 120}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BeginNavigationParams.initiatorFrameToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, tokens$.LocalFrameToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BeginNavigationParams.headers
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;




    // validate BeginNavigationParams.requestContextType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, fetch_api_request$.RequestContextType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BeginNavigationParams.mixedContentContextType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 28, mixed_content$.MixedContentContextType);
    if (err !== validator.validationError.NONE)
        return err;




    // validate BeginNavigationParams.forceHistoryPush
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 32, ForceHistoryPush);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BeginNavigationParams.searchableFormUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BeginNavigationParams.searchableFormEncoding
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 48, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate BeginNavigationParams.clientSideRedirectUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BeginNavigationParams.devtoolsInitiator
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, values$.DictionaryValue, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BeginNavigationParams.trustTokenParams
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, trust_tokens$.TrustTokenParams, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BeginNavigationParams.impression
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, conversions$.Impression, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BeginNavigationParams.beforeUnloadStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BeginNavigationParams.beforeUnloadEnd
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 96, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate BeginNavigationParams.initiatorActivationAndAdStatus
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, navigation_initiator_activation_and_ad_status$.NavigationInitiatorActivationAndAdStatus);
    if (err !== validator.validationError.NONE)
        return err;



    // validate BeginNavigationParams.storageAccessApiStatus
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 104, storage_access_api$.StorageAccessApiStatus);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  BeginNavigationParams.encodedSize = codec.kStructHeaderSize + 112;

  BeginNavigationParams.decode = function(decoder) {
    var packed;
    var val = new BeginNavigationParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.initiatorFrameToken =
        decoder.decodeStructPointer(tokens$.LocalFrameToken);
    val.headers =
        decoder.decodeStruct(codec.String);
    val.loadFlags =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.skipServiceWorker = (packed >> 0) & 1 ? true : false;
    val.isFormSubmission = (packed >> 1) & 1 ? true : false;
    val.wasInitiatedByLinkClick = (packed >> 2) & 1 ? true : false;
    val.isContainerInitiated = (packed >> 3) & 1 ? true : false;
    val.hasRelOpener = (packed >> 4) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.requestContextType =
        decoder.decodeStruct(new codec.Enum(fetch_api_request$.RequestContextType));
    val.mixedContentContextType =
        decoder.decodeStruct(new codec.Enum(mixed_content$.MixedContentContextType));
    val.forceHistoryPush =
        decoder.decodeStruct(new codec.Enum(ForceHistoryPush));
    val.initiatorActivationAndAdStatus =
        decoder.decodeStruct(new codec.Enum(navigation_initiator_activation_and_ad_status$.NavigationInitiatorActivationAndAdStatus));
    val.searchableFormUrl =
        decoder.decodeStructPointer(url$.Url);
    val.searchableFormEncoding =
        decoder.decodeStruct(codec.String);
    val.clientSideRedirectUrl =
        decoder.decodeStructPointer(url$.Url);
    val.devtoolsInitiator =
        decoder.decodeStructPointer(values$.DictionaryValue);
    val.trustTokenParams =
        decoder.decodeStructPointer(trust_tokens$.TrustTokenParams);
    val.impression =
        decoder.decodeStructPointer(conversions$.Impression);
    val.beforeUnloadStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.beforeUnloadEnd =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.storageAccessApiStatus =
        decoder.decodeStruct(new codec.Enum(storage_access_api$.StorageAccessApiStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  BeginNavigationParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(BeginNavigationParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(tokens$.LocalFrameToken, val.initiatorFrameToken);
    encoder.encodeStruct(codec.String, val.headers);
    encoder.encodeStruct(codec.Int32, val.loadFlags);
    packed = 0;
    packed |= (val.skipServiceWorker & 1) << 0
    packed |= (val.isFormSubmission & 1) << 1
    packed |= (val.wasInitiatedByLinkClick & 1) << 2
    packed |= (val.isContainerInitiated & 1) << 3
    packed |= (val.hasRelOpener & 1) << 4
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.requestContextType);
    encoder.encodeStruct(codec.Int32, val.mixedContentContextType);
    encoder.encodeStruct(codec.Int32, val.forceHistoryPush);
    encoder.encodeStruct(codec.Int32, val.initiatorActivationAndAdStatus);
    encoder.encodeStructPointer(url$.Url, val.searchableFormUrl);
    encoder.encodeStruct(codec.String, val.searchableFormEncoding);
    encoder.encodeStructPointer(url$.Url, val.clientSideRedirectUrl);
    encoder.encodeStructPointer(values$.DictionaryValue, val.devtoolsInitiator);
    encoder.encodeStructPointer(trust_tokens$.TrustTokenParams, val.trustTokenParams);
    encoder.encodeStructPointer(conversions$.Impression, val.impression);
    encoder.encodeStructPointer(time$.TimeTicks, val.beforeUnloadStart);
    encoder.encodeStructPointer(time$.TimeTicks, val.beforeUnloadEnd);
    encoder.encodeStruct(codec.Int32, val.storageAccessApiStatus);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function CommonNavigationParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CommonNavigationParams.prototype.initDefaults_ = function() {
    this.url = null;
    this.initiatorOrigin = null;
    this.initiatorBaseUrl = null;
    this.referrer = null;
    this.transition = 0;
    this.navigationType = NavigationType.DIFFERENT_DOCUMENT;
    this.downloadPolicy = null;
    this.shouldReplaceCurrentEntry = false;
    this.startedFromContextMenu = false;
    this.hasUserGesture = false;
    this.textFragmentToken = false;
    this.isHistoryNavigationInNewChildFrame = false;
    this.shouldCheckMainWorldCsp = content_security_policy$.CSPDisposition.CHECK;
    this.baseUrlForDataUrl = null;
    this.actualNavigationStart = null;
    this.navigationStart = null;
    this.method = "GET";
    this.postData = null;
    this.sourceLocation = null;
    this.initiatorOriginTrialFeatures = null;
    this.hrefTranslate = null;
    this.inputStart = null;
    this.requestDestination = fetch_api$.RequestDestination.kEmpty;
  };
  CommonNavigationParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CommonNavigationParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 144}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommonNavigationParams.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommonNavigationParams.initiatorOrigin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommonNavigationParams.initiatorBaseUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, url$.Url, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommonNavigationParams.referrer
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, referrer$.Referrer, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CommonNavigationParams.navigationType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 36, NavigationType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommonNavigationParams.downloadPolicy
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, navigation_policy$.NavigationDownloadPolicy, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CommonNavigationParams.baseUrlForDataUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommonNavigationParams.actualNavigationStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommonNavigationParams.navigationStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommonNavigationParams.method
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 80, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommonNavigationParams.postData
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, url_request$.URLRequestBody, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommonNavigationParams.sourceLocation
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 96, source_location$.SourceLocation, false);
    if (err !== validator.validationError.NONE)
        return err;





    // validate CommonNavigationParams.shouldCheckMainWorldCsp
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 52, content_security_policy$.CSPDisposition);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommonNavigationParams.initiatorOriginTrialFeatures
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 104, 4, codec.Int32, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommonNavigationParams.hrefTranslate
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 112, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate CommonNavigationParams.inputStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 120, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommonNavigationParams.requestDestination
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 128, fetch_api$.RequestDestination);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CommonNavigationParams.encodedSize = codec.kStructHeaderSize + 136;

  CommonNavigationParams.decode = function(decoder) {
    var packed;
    var val = new CommonNavigationParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.initiatorOrigin =
        decoder.decodeStructPointer(origin$.Origin);
    val.initiatorBaseUrl =
        decoder.decodeStructPointer(url$.Url);
    val.referrer =
        decoder.decodeStructPointer(referrer$.Referrer);
    val.transition =
        decoder.decodeStruct(codec.Int32);
    val.navigationType =
        decoder.decodeStruct(new codec.Enum(NavigationType));
    val.downloadPolicy =
        decoder.decodeStructPointer(navigation_policy$.NavigationDownloadPolicy);
    packed = decoder.readUint8();
    val.shouldReplaceCurrentEntry = (packed >> 0) & 1 ? true : false;
    val.startedFromContextMenu = (packed >> 1) & 1 ? true : false;
    val.hasUserGesture = (packed >> 2) & 1 ? true : false;
    val.textFragmentToken = (packed >> 3) & 1 ? true : false;
    val.isHistoryNavigationInNewChildFrame = (packed >> 4) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.shouldCheckMainWorldCsp =
        decoder.decodeStruct(new codec.Enum(content_security_policy$.CSPDisposition));
    val.baseUrlForDataUrl =
        decoder.decodeStructPointer(url$.Url);
    val.actualNavigationStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.navigationStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.method =
        decoder.decodeStruct(codec.String);
    val.postData =
        decoder.decodeStructPointer(url_request$.URLRequestBody);
    val.sourceLocation =
        decoder.decodeStructPointer(source_location$.SourceLocation);
    val.initiatorOriginTrialFeatures =
        decoder.decodeArrayPointer(codec.Int32);
    val.hrefTranslate =
        decoder.decodeStruct(codec.String);
    val.inputStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.requestDestination =
        decoder.decodeStruct(new codec.Enum(fetch_api$.RequestDestination));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  CommonNavigationParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CommonNavigationParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(origin$.Origin, val.initiatorOrigin);
    encoder.encodeStructPointer(url$.Url, val.initiatorBaseUrl);
    encoder.encodeStructPointer(referrer$.Referrer, val.referrer);
    encoder.encodeStruct(codec.Int32, val.transition);
    encoder.encodeStruct(codec.Int32, val.navigationType);
    encoder.encodeStructPointer(navigation_policy$.NavigationDownloadPolicy, val.downloadPolicy);
    packed = 0;
    packed |= (val.shouldReplaceCurrentEntry & 1) << 0
    packed |= (val.startedFromContextMenu & 1) << 1
    packed |= (val.hasUserGesture & 1) << 2
    packed |= (val.textFragmentToken & 1) << 3
    packed |= (val.isHistoryNavigationInNewChildFrame & 1) << 4
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.shouldCheckMainWorldCsp);
    encoder.encodeStructPointer(url$.Url, val.baseUrlForDataUrl);
    encoder.encodeStructPointer(time$.TimeTicks, val.actualNavigationStart);
    encoder.encodeStructPointer(time$.TimeTicks, val.navigationStart);
    encoder.encodeStruct(codec.String, val.method);
    encoder.encodeStructPointer(url_request$.URLRequestBody, val.postData);
    encoder.encodeStructPointer(source_location$.SourceLocation, val.sourceLocation);
    encoder.encodeArrayPointer(codec.Int32, val.initiatorOriginTrialFeatures);
    encoder.encodeStruct(codec.String, val.hrefTranslate);
    encoder.encodeStructPointer(time$.TimeTicks, val.inputStart);
    encoder.encodeStruct(codec.Int32, val.requestDestination);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function NavigationTiming(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  NavigationTiming.prototype.initDefaults_ = function() {
    this.redirectStart = null;
    this.redirectEnd = null;
    this.fetchStart = null;
    this.systemEntropyAtNavigationStart = system_entropy$.SystemEntropy.kEmpty;
    this.parentResourceTimingAccess = ParentResourceTimingAccess.kDoNotReport;
  };
  NavigationTiming.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  NavigationTiming.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NavigationTiming.redirectStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NavigationTiming.redirectEnd
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NavigationTiming.fetchStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NavigationTiming.systemEntropyAtNavigationStart
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 24, system_entropy$.SystemEntropy);
    if (err !== validator.validationError.NONE)
        return err;


    // validate NavigationTiming.parentResourceTimingAccess
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 28, ParentResourceTimingAccess);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  NavigationTiming.encodedSize = codec.kStructHeaderSize + 32;

  NavigationTiming.decode = function(decoder) {
    var packed;
    var val = new NavigationTiming();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.redirectStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.redirectEnd =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.fetchStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.systemEntropyAtNavigationStart =
        decoder.decodeStruct(new codec.Enum(system_entropy$.SystemEntropy));
    val.parentResourceTimingAccess =
        decoder.decodeStruct(new codec.Enum(ParentResourceTimingAccess));
    return val;
  };

  NavigationTiming.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(NavigationTiming.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeTicks, val.redirectStart);
    encoder.encodeStructPointer(time$.TimeTicks, val.redirectEnd);
    encoder.encodeStructPointer(time$.TimeTicks, val.fetchStart);
    encoder.encodeStruct(codec.Int32, val.systemEntropyAtNavigationStart);
    encoder.encodeStruct(codec.Int32, val.parentResourceTimingAccess);
  };
  function OldPageInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OldPageInfo.prototype.initDefaults_ = function() {
    this.frameTokenForOldMainFrame = null;
    this.newLifecycleStateForOldPage = null;
  };
  OldPageInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OldPageInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OldPageInfo.frameTokenForOldMainFrame
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, tokens$.LocalFrameToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OldPageInfo.newLifecycleStateForOldPage
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, page$.PageLifecycleState, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  OldPageInfo.encodedSize = codec.kStructHeaderSize + 16;

  OldPageInfo.decode = function(decoder) {
    var packed;
    var val = new OldPageInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.frameTokenForOldMainFrame =
        decoder.decodeStructPointer(tokens$.LocalFrameToken);
    val.newLifecycleStateForOldPage =
        decoder.decodeStructPointer(page$.PageLifecycleState);
    return val;
  };

  OldPageInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OldPageInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(tokens$.LocalFrameToken, val.frameTokenForOldMainFrame);
    encoder.encodeStructPointer(page$.PageLifecycleState, val.newLifecycleStateForOldPage);
  };
  function CommitNavigationParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  CommitNavigationParams.prototype.initDefaults_ = function() {
    this.originToCommit = null;
    this.storageKey = null;
    this.isOverridingUserAgent = false;
    this.canLoadLocalResources = false;
    this.intendedAsNewEntry = false;
    this.wasDiscarded = false;
    this.isViewSource = false;
    this.shouldClearHistoryList = false;
    this.isBrowserInitiated = false;
    this.hasUaVisualTransition = false;
    this.originAgentCluster = false;
    this.originAgentClusterLeftAsDefault = true;
    this.isCrossSiteCrossBrowsingContextGroup = false;
    this.shouldHaveStickyUserActivation = false;
    this.isLoadDataWithBaseUrl = false;
    this.ancestorOrSelfHasCspee = false;
    this.visited_link_salt_$flag = false;
    this.shouldSkipScreenshot = false;
    this.forceNewDocumentSequenceNumber = false;
    this.navEntryId = 0;
    this.redirects = null;
    this.redirectResponse = null;
    this.redirectInfos = null;
    this.postContentType = null;
    this.originalUrl = null;
    this.originalMethod = null;
    this.pageState = null;
    this.subframeUniqueNames = null;
    this.pendingHistoryListIndex = -1;
    this.currentHistoryListIndex = -1;
    this.currentHistoryListLength = 0;
    this.wasActivated = was_activated_option$.WasActivatedOption.kUnknown;
    this.navigationTiming = null;
    this.navigationToken = null;
    this.prefetchedSignedExchanges = null;
    this.documentUkmSourceId = 0;
    this.framePolicy = null;
    this.forceEnabledOriginTrials = null;
    this.enabledClientHints = null;
    this.oldPageInfo = null;
    this.httpResponseCode = -1;
    this.navigationDeliveryType = url_response_head$.NavigationDeliveryType.kDefault;
    this.navigationApiHistoryEntryArrays = null;
    this.earlyHintsPreloadedResources = null;
    this.commitSent = null;
    this.srcdocValue = null;
    this.reducedAcceptLanguage = null;
    this.viewTransitionState = null;
    this.softNavigationHeuristicsTaskId = null;
    this.modifiedRuntimeFeatures = null;
    this.fencedFrameProperties = null;
    this.notRestoredReasons = null;
    this.loadWithStorageAccess = storage_access_api$.StorageAccessApiStatus.kNone;
    this.browsingContextGroupToken = null;
    this.lcppHint = null;
    this.contentSettings = null;
    this.cookieDeprecationLabel = null;
    this.visited_link_salt_$value = 0;
    this.localSurfaceId = null;
    this.initialPermissionStatuses = null;
    this.navigationMetricsToken = null;
    this.commitTargetFrameToken = null;
  };
  CommitNavigationParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  CommitNavigationParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 344}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.originToCommit
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.storageKey
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, storage_key$.StorageKey, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CommitNavigationParams.redirects
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 24, 8, new codec.PointerTo(url$.Url), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.redirectResponse
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(url_response_head$.URLResponseHead), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.redirectInfos
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 8, new codec.PointerTo(url_loader$.URLRequestRedirectInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.postContentType
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 48, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.originalUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.originalMethod
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 64, false)
    if (err !== validator.validationError.NONE)
        return err;



    // validate CommitNavigationParams.pageState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, byte_string$.ByteString, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CommitNavigationParams.subframeUniqueNames
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 80, false, codec.String, codec.PackedBool, false);
    if (err !== validator.validationError.NONE)
        return err;









    // validate CommitNavigationParams.navigationTiming
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, NavigationTiming, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.wasActivated
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 100, was_activated_option$.WasActivatedOption);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.navigationToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 112, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.prefetchedSignedExchanges
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 120, 8, new codec.PointerTo(prefetched_signed_exchange_info$.PrefetchedSignedExchangeInfo), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;





    // validate CommitNavigationParams.framePolicy
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 136, frame_policy$.FramePolicy, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.forceEnabledOriginTrials
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 144, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;




    // validate CommitNavigationParams.enabledClientHints
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 152, 4, new codec.Enum(web_client_hints_types$.WebClientHintsType), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;




    // validate CommitNavigationParams.oldPageInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 160, OldPageInfo, true);
    if (err !== validator.validationError.NONE)
        return err;



    // validate CommitNavigationParams.navigationApiHistoryEntryArrays
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 176, navigation_api_history_entry_arrays$.NavigationApiHistoryEntryArrays, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.earlyHintsPreloadedResources
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 184, 8, new codec.PointerTo(url$.Url), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.commitSent
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 192, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.srcdocValue
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 200, false)
    if (err !== validator.validationError.NONE)
        return err;




    // validate CommitNavigationParams.reducedAcceptLanguage
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 208, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.navigationDeliveryType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 172, url_response_head$.NavigationDeliveryType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.viewTransitionState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 216, view_transition_state$.ViewTransitionState, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.softNavigationHeuristicsTaskId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 224, task_attribution_id$.TaskAttributionId, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.modifiedRuntimeFeatures
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 232, false, new codec.Enum(runtime_feature$.RuntimeFeature), codec.PackedBool, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.fencedFrameProperties
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 240, fenced_frame_config$.FencedFrameProperties, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.notRestoredReasons
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 248, back_forward_cache_not_restored_reasons$.BackForwardCacheNotRestoredReasons, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.loadWithStorageAccess
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 256, storage_access_api$.StorageAccessApiStatus);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.browsingContextGroupToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 264, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.lcppHint
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 272, lcp_critical_path_predictor$.LCPCriticalPathPredictorNavigationTimeHint, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.contentSettings
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 280, renderer_content_settings$.RendererContentSettings, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.cookieDeprecationLabel
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 288, true)
    if (err !== validator.validationError.NONE)
        return err;




    // validate CommitNavigationParams.localSurfaceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 304, local_surface_id$.LocalSurfaceId, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.initialPermissionStatuses
    err = messageValidator.validateMapPointer(offset + codec.kStructHeaderSize + 312, true, new codec.Enum(permission$.PermissionName), new codec.Enum(permission_status$.PermissionStatus), false);
    if (err !== validator.validationError.NONE)
        return err;




    // validate CommitNavigationParams.navigationMetricsToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 320, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate CommitNavigationParams.commitTargetFrameToken
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 328, tokens$.LocalFrameToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  CommitNavigationParams.encodedSize = codec.kStructHeaderSize + 336;

  CommitNavigationParams.decode = function(decoder) {
    var packed;
    var val = new CommitNavigationParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.originToCommit =
        decoder.decodeStructPointer(origin$.Origin);
    val.storageKey =
        decoder.decodeStructPointer(storage_key$.StorageKey);
    packed = decoder.readUint8();
    val.isOverridingUserAgent = (packed >> 0) & 1 ? true : false;
    val.canLoadLocalResources = (packed >> 1) & 1 ? true : false;
    val.intendedAsNewEntry = (packed >> 2) & 1 ? true : false;
    val.wasDiscarded = (packed >> 3) & 1 ? true : false;
    val.isViewSource = (packed >> 4) & 1 ? true : false;
    val.shouldClearHistoryList = (packed >> 5) & 1 ? true : false;
    val.isBrowserInitiated = (packed >> 6) & 1 ? true : false;
    val.hasUaVisualTransition = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.originAgentCluster = (packed >> 0) & 1 ? true : false;
    val.originAgentClusterLeftAsDefault = (packed >> 1) & 1 ? true : false;
    val.isCrossSiteCrossBrowsingContextGroup = (packed >> 2) & 1 ? true : false;
    val.shouldHaveStickyUserActivation = (packed >> 3) & 1 ? true : false;
    val.isLoadDataWithBaseUrl = (packed >> 4) & 1 ? true : false;
    val.ancestorOrSelfHasCspee = (packed >> 5) & 1 ? true : false;
    val.visited_link_salt_$flag = (packed >> 6) & 1 ? true : false;
    val.shouldSkipScreenshot = (packed >> 7) & 1 ? true : false;
    packed = decoder.readUint8();
    val.forceNewDocumentSequenceNumber = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    val.navEntryId =
        decoder.decodeStruct(codec.Int32);
    val.redirects =
        decoder.decodeArrayPointer(new codec.PointerTo(url$.Url));
    val.redirectResponse =
        decoder.decodeArrayPointer(new codec.PointerTo(url_response_head$.URLResponseHead));
    val.redirectInfos =
        decoder.decodeArrayPointer(new codec.PointerTo(url_loader$.URLRequestRedirectInfo));
    val.postContentType =
        decoder.decodeStruct(codec.String);
    val.originalUrl =
        decoder.decodeStructPointer(url$.Url);
    val.originalMethod =
        decoder.decodeStruct(codec.String);
    val.pageState =
        decoder.decodeStructPointer(byte_string$.ByteString);
    val.subframeUniqueNames =
        decoder.decodeMapPointer(codec.String, codec.PackedBool);
    val.pendingHistoryListIndex =
        decoder.decodeStruct(codec.Int32);
    val.currentHistoryListIndex =
        decoder.decodeStruct(codec.Int32);
    val.currentHistoryListLength =
        decoder.decodeStruct(codec.Int32);
    val.wasActivated =
        decoder.decodeStruct(new codec.Enum(was_activated_option$.WasActivatedOption));
    val.navigationTiming =
        decoder.decodeStructPointer(NavigationTiming);
    val.navigationToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.prefetchedSignedExchanges =
        decoder.decodeArrayPointer(new codec.PointerTo(prefetched_signed_exchange_info$.PrefetchedSignedExchangeInfo));
    val.documentUkmSourceId =
        decoder.decodeStruct(codec.Int64);
    val.framePolicy =
        decoder.decodeStructPointer(frame_policy$.FramePolicy);
    val.forceEnabledOriginTrials =
        decoder.decodeArrayPointer(codec.String);
    val.enabledClientHints =
        decoder.decodeArrayPointer(new codec.Enum(web_client_hints_types$.WebClientHintsType));
    val.oldPageInfo =
        decoder.decodeStructPointer(OldPageInfo);
    val.httpResponseCode =
        decoder.decodeStruct(codec.Int32);
    val.navigationDeliveryType =
        decoder.decodeStruct(new codec.Enum(url_response_head$.NavigationDeliveryType));
    val.navigationApiHistoryEntryArrays =
        decoder.decodeStructPointer(navigation_api_history_entry_arrays$.NavigationApiHistoryEntryArrays);
    val.earlyHintsPreloadedResources =
        decoder.decodeArrayPointer(new codec.PointerTo(url$.Url));
    val.commitSent =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.srcdocValue =
        decoder.decodeStruct(codec.String);
    val.reducedAcceptLanguage =
        decoder.decodeStruct(codec.String);
    val.viewTransitionState =
        decoder.decodeStructPointer(view_transition_state$.ViewTransitionState);
    val.softNavigationHeuristicsTaskId =
        decoder.decodeStructPointer(task_attribution_id$.TaskAttributionId);
    val.modifiedRuntimeFeatures =
        decoder.decodeMapPointer(new codec.Enum(runtime_feature$.RuntimeFeature), codec.PackedBool);
    val.fencedFrameProperties =
        decoder.decodeStructPointer(fenced_frame_config$.FencedFrameProperties);
    val.notRestoredReasons =
        decoder.decodeStructPointer(back_forward_cache_not_restored_reasons$.BackForwardCacheNotRestoredReasons);
    val.loadWithStorageAccess =
        decoder.decodeStruct(new codec.Enum(storage_access_api$.StorageAccessApiStatus));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.browsingContextGroupToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.lcppHint =
        decoder.decodeStructPointer(lcp_critical_path_predictor$.LCPCriticalPathPredictorNavigationTimeHint);
    val.contentSettings =
        decoder.decodeStructPointer(renderer_content_settings$.RendererContentSettings);
    val.cookieDeprecationLabel =
        decoder.decodeStruct(codec.String);
    val.visited_link_salt_$value =
        decoder.decodeStruct(codec.Uint64);
    val.localSurfaceId =
        decoder.decodeStructPointer(local_surface_id$.LocalSurfaceId);
    val.initialPermissionStatuses =
        decoder.decodeMapPointer(new codec.Enum(permission$.PermissionName), new codec.Enum(permission_status$.PermissionStatus));
    val.navigationMetricsToken =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.commitTargetFrameToken =
        decoder.decodeStructPointer(tokens$.LocalFrameToken);
    return val;
  };

  CommitNavigationParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(CommitNavigationParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.originToCommit);
    encoder.encodeStructPointer(storage_key$.StorageKey, val.storageKey);
    packed = 0;
    packed |= (val.isOverridingUserAgent & 1) << 0
    packed |= (val.canLoadLocalResources & 1) << 1
    packed |= (val.intendedAsNewEntry & 1) << 2
    packed |= (val.wasDiscarded & 1) << 3
    packed |= (val.isViewSource & 1) << 4
    packed |= (val.shouldClearHistoryList & 1) << 5
    packed |= (val.isBrowserInitiated & 1) << 6
    packed |= (val.hasUaVisualTransition & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.originAgentCluster & 1) << 0
    packed |= (val.originAgentClusterLeftAsDefault & 1) << 1
    packed |= (val.isCrossSiteCrossBrowsingContextGroup & 1) << 2
    packed |= (val.shouldHaveStickyUserActivation & 1) << 3
    packed |= (val.isLoadDataWithBaseUrl & 1) << 4
    packed |= (val.ancestorOrSelfHasCspee & 1) << 5
    packed |= (val.visited_link_salt_$flag & 1) << 6
    packed |= (val.shouldSkipScreenshot & 1) << 7
    encoder.writeUint8(packed);
    packed = 0;
    packed |= (val.forceNewDocumentSequenceNumber & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.navEntryId);
    encoder.encodeArrayPointer(new codec.PointerTo(url$.Url), val.redirects);
    encoder.encodeArrayPointer(new codec.PointerTo(url_response_head$.URLResponseHead), val.redirectResponse);
    encoder.encodeArrayPointer(new codec.PointerTo(url_loader$.URLRequestRedirectInfo), val.redirectInfos);
    encoder.encodeStruct(codec.String, val.postContentType);
    encoder.encodeStructPointer(url$.Url, val.originalUrl);
    encoder.encodeStruct(codec.String, val.originalMethod);
    encoder.encodeStructPointer(byte_string$.ByteString, val.pageState);
    encoder.encodeMapPointer(codec.String, codec.PackedBool, val.subframeUniqueNames);
    encoder.encodeStruct(codec.Int32, val.pendingHistoryListIndex);
    encoder.encodeStruct(codec.Int32, val.currentHistoryListIndex);
    encoder.encodeStruct(codec.Int32, val.currentHistoryListLength);
    encoder.encodeStruct(codec.Int32, val.wasActivated);
    encoder.encodeStructPointer(NavigationTiming, val.navigationTiming);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.navigationToken);
    encoder.encodeArrayPointer(new codec.PointerTo(prefetched_signed_exchange_info$.PrefetchedSignedExchangeInfo), val.prefetchedSignedExchanges);
    encoder.encodeStruct(codec.Int64, val.documentUkmSourceId);
    encoder.encodeStructPointer(frame_policy$.FramePolicy, val.framePolicy);
    encoder.encodeArrayPointer(codec.String, val.forceEnabledOriginTrials);
    encoder.encodeArrayPointer(new codec.Enum(web_client_hints_types$.WebClientHintsType), val.enabledClientHints);
    encoder.encodeStructPointer(OldPageInfo, val.oldPageInfo);
    encoder.encodeStruct(codec.Int32, val.httpResponseCode);
    encoder.encodeStruct(codec.Int32, val.navigationDeliveryType);
    encoder.encodeStructPointer(navigation_api_history_entry_arrays$.NavigationApiHistoryEntryArrays, val.navigationApiHistoryEntryArrays);
    encoder.encodeArrayPointer(new codec.PointerTo(url$.Url), val.earlyHintsPreloadedResources);
    encoder.encodeStructPointer(time$.TimeTicks, val.commitSent);
    encoder.encodeStruct(codec.String, val.srcdocValue);
    encoder.encodeStruct(codec.String, val.reducedAcceptLanguage);
    encoder.encodeStructPointer(view_transition_state$.ViewTransitionState, val.viewTransitionState);
    encoder.encodeStructPointer(task_attribution_id$.TaskAttributionId, val.softNavigationHeuristicsTaskId);
    encoder.encodeMapPointer(new codec.Enum(runtime_feature$.RuntimeFeature), codec.PackedBool, val.modifiedRuntimeFeatures);
    encoder.encodeStructPointer(fenced_frame_config$.FencedFrameProperties, val.fencedFrameProperties);
    encoder.encodeStructPointer(back_forward_cache_not_restored_reasons$.BackForwardCacheNotRestoredReasons, val.notRestoredReasons);
    encoder.encodeStruct(codec.Int32, val.loadWithStorageAccess);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.browsingContextGroupToken);
    encoder.encodeStructPointer(lcp_critical_path_predictor$.LCPCriticalPathPredictorNavigationTimeHint, val.lcppHint);
    encoder.encodeStructPointer(renderer_content_settings$.RendererContentSettings, val.contentSettings);
    encoder.encodeStruct(codec.String, val.cookieDeprecationLabel);
    encoder.encodeStruct(codec.Uint64, val.visited_link_salt_$value);
    encoder.encodeStructPointer(local_surface_id$.LocalSurfaceId, val.localSurfaceId);
    encoder.encodeMapPointer(new codec.Enum(permission$.PermissionName), new codec.Enum(permission_status$.PermissionStatus), val.initialPermissionStatuses);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.navigationMetricsToken);
    encoder.encodeStructPointer(tokens$.LocalFrameToken, val.commitTargetFrameToken);
  };
  function PageSwapEventParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PageSwapEventParams.prototype.initDefaults_ = function() {
    this.url = null;
    this.pageState = null;
    this.navigationType = 0;
  };
  PageSwapEventParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PageSwapEventParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageSwapEventParams.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageSwapEventParams.pageState
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, byte_string$.ByteString, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PageSwapEventParams.navigationType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 16, NavigationTypeForNavigationApi);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PageSwapEventParams.encodedSize = codec.kStructHeaderSize + 24;

  PageSwapEventParams.decode = function(decoder) {
    var packed;
    var val = new PageSwapEventParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.pageState =
        decoder.decodeStructPointer(byte_string$.ByteString);
    val.navigationType =
        decoder.decodeStruct(new codec.Enum(NavigationTypeForNavigationApi));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  PageSwapEventParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PageSwapEventParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStructPointer(byte_string$.ByteString, val.pageState);
    encoder.encodeStruct(codec.Int32, val.navigationType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  exports.NavigationType = NavigationType;
  exports.NavigationTypeForNavigationApi = NavigationTypeForNavigationApi;
  exports.ForceHistoryPush = ForceHistoryPush;
  exports.ParentResourceTimingAccess = ParentResourceTimingAccess;
  exports.BeginNavigationParams = BeginNavigationParams;
  exports.CommonNavigationParams = CommonNavigationParams;
  exports.NavigationTiming = NavigationTiming;
  exports.OldPageInfo = OldPageInfo;
  exports.CommitNavigationParams = CommitNavigationParams;
  exports.PageSwapEventParams = PageSwapEventParams;
})();