// third_party/blink/public/mojom/navigation/navigation_params.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/navigation/navigation_params.mojom-params-data.h"
namespace blink {
namespace mojom {

NOINLINE static const char* NavigationTypeToStringHelper(NavigationType value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NavigationType::RELOAD:
      return "RELOAD";
    case NavigationType::RELOAD_BYPASSING_CACHE:
      return "RELOAD_BYPASSING_CACHE";
    case NavigationType::RESTORE:
      return "RESTORE";
    case NavigationType::RESTORE_WITH_POST:
      return "RESTORE_WITH_POST";
    case NavigationType::HISTORY_SAME_DOCUMENT:
      return "HISTORY_SAME_DOCUMENT";
    case NavigationType::HISTORY_DIFFERENT_DOCUMENT:
      return "HISTORY_DIFFERENT_DOCUMENT";
    case NavigationType::SAME_DOCUMENT:
      return "SAME_DOCUMENT";
    case NavigationType::DIFFERENT_DOCUMENT:
      return "DIFFERENT_DOCUMENT";
    default:
      return nullptr;
  }
}

std::string NavigationTypeToString(NavigationType value) {
  const char *str = NavigationTypeToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NavigationType value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NavigationType value) {
  return os << NavigationTypeToString(value);
}

NOINLINE static const char* NavigationTypeForNavigationApiToStringHelper(NavigationTypeForNavigationApi value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case NavigationTypeForNavigationApi::kPush:
      return "kPush";
    case NavigationTypeForNavigationApi::kTraverse:
      return "kTraverse";
    case NavigationTypeForNavigationApi::kReplace:
      return "kReplace";
    case NavigationTypeForNavigationApi::kReload:
      return "kReload";
    default:
      return nullptr;
  }
}

std::string NavigationTypeForNavigationApiToString(NavigationTypeForNavigationApi value) {
  const char *str = NavigationTypeForNavigationApiToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown NavigationTypeForNavigationApi value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, NavigationTypeForNavigationApi value) {
  return os << NavigationTypeForNavigationApiToString(value);
}

NOINLINE static const char* ForceHistoryPushToStringHelper(ForceHistoryPush value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ForceHistoryPush::kYes:
      return "kYes";
    case ForceHistoryPush::kNo:
      return "kNo";
    default:
      return nullptr;
  }
}

std::string ForceHistoryPushToString(ForceHistoryPush value) {
  const char *str = ForceHistoryPushToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ForceHistoryPush value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ForceHistoryPush value) {
  return os << ForceHistoryPushToString(value);
}

NOINLINE static const char* ParentResourceTimingAccessToStringHelper(ParentResourceTimingAccess value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case ParentResourceTimingAccess::kDoNotReport:
      return "kDoNotReport";
    case ParentResourceTimingAccess::kReportWithoutResponseDetails:
      return "kReportWithoutResponseDetails";
    case ParentResourceTimingAccess::kReportWithResponseDetails:
      return "kReportWithResponseDetails";
    default:
      return nullptr;
  }
}

std::string ParentResourceTimingAccessToString(ParentResourceTimingAccess value) {
  const char *str = ParentResourceTimingAccessToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown ParentResourceTimingAccess value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, ParentResourceTimingAccess value) {
  return os << ParentResourceTimingAccessToString(value);
}

namespace internal {


// static
bool BeginNavigationParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 120, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const BeginNavigationParams_Data* object =
      static_cast<const BeginNavigationParams_Data*>(data);

  if (!mojo::internal::ValidateStruct(object->initiator_frame_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->headers, validation_context,
                                         &headers_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::RequestContextType_Data
        ::Validate(object->request_context_type, validation_context))
    return false;


  if (!::blink::mojom::internal::MixedContentContextType_Data
        ::Validate(object->mixed_content_context_type, validation_context))
    return false;


  if (!::blink::mojom::internal::ForceHistoryPush_Data
        ::Validate(object->force_history_push, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->searchable_form_url, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->searchable_form_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->searchable_form_encoding, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& searchable_form_encoding_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->searchable_form_encoding, validation_context,
                                         &searchable_form_encoding_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_side_redirect_url, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->client_side_redirect_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->devtools_initiator, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->trust_token_params, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->impression, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->before_unload_start, 16, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->before_unload_start, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->before_unload_end, 17, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->before_unload_end, validation_context))
    return false;


  if (!::blink::mojom::internal::NavigationInitiatorActivationAndAdStatus_Data
        ::Validate(object->initiator_activation_and_ad_status, validation_context))
    return false;


  if (!::network::mojom::internal::StorageAccessApiStatus_Data
        ::Validate(object->storage_access_api_status, validation_context))
    return false;

  return true;
}

BeginNavigationParams_Data::BeginNavigationParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommonNavigationParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 144, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommonNavigationParams_Data* object =
      static_cast<const CommonNavigationParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->initiator_origin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->initiator_base_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referrer, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;


  if (!::blink::mojom::internal::NavigationType_Data
        ::Validate(object->navigation_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->download_policy, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->download_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->base_url_for_data_url, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->base_url_for_data_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->actual_navigation_start, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->actual_navigation_start, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->navigation_start, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->navigation_start, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method, 12, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& method_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->method, validation_context,
                                         &method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->post_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_location, 14, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_location, validation_context))
    return false;


  if (!::network::mojom::internal::CSPDisposition_Data
        ::Validate(object->should_check_main_world_csp, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initiator_origin_trial_features, 19, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& initiator_origin_trial_features_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->initiator_origin_trial_features, validation_context,
                                         &initiator_origin_trial_features_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->href_translate, 20, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& href_translate_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->href_translate, validation_context,
                                         &href_translate_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_start, 22, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_start, validation_context))
    return false;


  if (!::network::mojom::internal::RequestDestination_Data
        ::Validate(object->request_destination, validation_context))
    return false;

  return true;
}

CommonNavigationParams_Data::CommonNavigationParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NavigationTiming_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NavigationTiming_Data* object =
      static_cast<const NavigationTiming_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->redirect_start, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->redirect_start, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->redirect_end, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->redirect_end, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fetch_start, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->fetch_start, validation_context))
    return false;


  if (!::blink::mojom::internal::SystemEntropy_Data
        ::Validate(object->system_entropy_at_navigation_start, validation_context))
    return false;


  if (!::blink::mojom::internal::ParentResourceTimingAccess_Data
        ::Validate(object->parent_resource_timing_access, validation_context))
    return false;

  return true;
}

NavigationTiming_Data::NavigationTiming_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OldPageInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OldPageInfo_Data* object =
      static_cast<const OldPageInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_token_for_old_main_frame, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_token_for_old_main_frame, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_lifecycle_state_for_old_page, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_lifecycle_state_for_old_page, validation_context))
    return false;

  return true;
}

OldPageInfo_Data::OldPageInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommitNavigationParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 344, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const CommitNavigationParams_Data* object =
      static_cast<const CommitNavigationParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin_to_commit, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin_to_commit, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->storage_key, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->storage_key, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->redirects, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& redirects_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->redirects, validation_context,
                                         &redirects_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->redirect_response, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& redirect_response_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->redirect_response, validation_context,
                                         &redirect_response_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->redirect_infos, 6, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& redirect_infos_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->redirect_infos, validation_context,
                                         &redirect_infos_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->post_content_type, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& post_content_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->post_content_type, validation_context,
                                         &post_content_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->original_url, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->original_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->original_method, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& original_method_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->original_method, validation_context,
                                         &original_method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_state, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->page_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subframe_unique_names, 13, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& subframe_unique_names_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->subframe_unique_names, validation_context,
                                         &subframe_unique_names_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->navigation_timing, 21, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->navigation_timing, validation_context))
    return false;


  if (!::blink::mojom::internal::WasActivatedOption_Data
        ::Validate(object->was_activated, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->navigation_token, 23, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->navigation_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prefetched_signed_exchanges, 24, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& prefetched_signed_exchanges_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->prefetched_signed_exchanges, validation_context,
                                         &prefetched_signed_exchanges_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->frame_policy, 28, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->frame_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->force_enabled_origin_trials, 29, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& force_enabled_origin_trials_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->force_enabled_origin_trials, validation_context,
                                         &force_enabled_origin_trials_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->enabled_client_hints, 32, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& enabled_client_hints_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::WebClientHintsType_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->enabled_client_hints, validation_context,
                                         &enabled_client_hints_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->old_page_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->navigation_api_history_entry_arrays, 37, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->navigation_api_history_entry_arrays, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->early_hints_preloaded_resources, 38, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& early_hints_preloaded_resources_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->early_hints_preloaded_resources, validation_context,
                                         &early_hints_preloaded_resources_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->commit_sent, 39, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->commit_sent, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->srcdoc_value, 40, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& srcdoc_value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->srcdoc_value, validation_context,
                                         &srcdoc_value_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->reduced_accept_language, 43, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& reduced_accept_language_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->reduced_accept_language, validation_context,
                                         &reduced_accept_language_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::NavigationDeliveryType_Data
        ::Validate(object->navigation_delivery_type, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->view_transition_state, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->soft_navigation_heuristics_task_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->modified_runtime_features, 47, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& modified_runtime_features_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::RuntimeFeature_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->modified_runtime_features, validation_context,
                                         &modified_runtime_features_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->fenced_frame_properties, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->not_restored_reasons, validation_context))
    return false;


  if (!::network::mojom::internal::StorageAccessApiStatus_Data
        ::Validate(object->load_with_storage_access, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->browsing_context_group_token, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->lcpp_hint, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_settings, 53, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->content_settings, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& cookie_deprecation_label_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cookie_deprecation_label, validation_context,
                                         &cookie_deprecation_label_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->local_surface_id, validation_context))
    return false;

  constexpr const mojo::internal::ContainerValidateParams& initial_permission_statuses_validate_params =
      mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::PermissionName_Data::Validate>(), *&mojo::internal::GetArrayOfEnumsValidator<0, false, ::blink::mojom::internal::PermissionStatus_Data::Validate>()>();
  if (!mojo::internal::ValidateContainer(object->initial_permission_statuses, validation_context,
                                         &initial_permission_statuses_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->navigation_metrics_token, 61, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->navigation_metrics_token, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->commit_target_frame_token, validation_context))
    return false;

  return true;
}

CommitNavigationParams_Data::CommitNavigationParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageSwapEventParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageSwapEventParams_Data* object =
      static_cast<const PageSwapEventParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_state, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->page_state, validation_context))
    return false;


  if (!::blink::mojom::internal::NavigationTypeForNavigationApi_Data
        ::Validate(object->navigation_type, validation_context))
    return false;

  return true;
}

PageSwapEventParams_Data::PageSwapEventParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace blink

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::NavigationType>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::NavigationType value) {
  return std::move(context).WriteString(::blink::mojom::NavigationTypeToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::NavigationTypeForNavigationApi>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::NavigationTypeForNavigationApi value) {
  return std::move(context).WriteString(::blink::mojom::NavigationTypeForNavigationApiToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ForceHistoryPush>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ForceHistoryPush value) {
  return std::move(context).WriteString(::blink::mojom::ForceHistoryPushToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::blink::mojom::ParentResourceTimingAccess>::WriteIntoTrace(
   perfetto::TracedValue context, ::blink::mojom::ParentResourceTimingAccess value) {
  return std::move(context).WriteString(::blink::mojom::ParentResourceTimingAccessToString(value));
}

} // namespace perfetto