// third_party/blink/public/mojom/navigation/navigation_api_history_entry_arrays.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_API_HISTORY_ENTRY_ARRAYS_MOJOM_BLINK_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_API_HISTORY_ENTRY_ARRAYS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "third_party/blink/public/mojom/navigation/navigation_api_history_entry_arrays.mojom-features.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/navigation/navigation_api_history_entry_arrays.mojom-shared.h"  // IWYU pragma: export
#include "third_party/blink/public/mojom/navigation/navigation_api_history_entry_arrays.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/string16.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "third_party/blink/renderer/platform/platform_export.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace blink::mojom::blink {









class PLATFORM_EXPORT NavigationApiHistoryEntry {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NavigationApiHistoryEntry, T>::value>;
  using DataView = NavigationApiHistoryEntryDataView;
  using Data_ = internal::NavigationApiHistoryEntry_Data;

  template <typename... Args>
  static NavigationApiHistoryEntryPtr New(Args&&... args) {
    return NavigationApiHistoryEntryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NavigationApiHistoryEntryPtr From(const U& u) {
    return mojo::TypeConverter<NavigationApiHistoryEntryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NavigationApiHistoryEntry>::Convert(*this);
  }


  NavigationApiHistoryEntry();

  NavigationApiHistoryEntry(
      const ::blink::String& key,
      const ::blink::String& id,
      const ::blink::String& url,
      int64_t item_sequence_number,
      int64_t document_sequence_number,
      const ::blink::String& state);


  ~NavigationApiHistoryEntry();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NavigationApiHistoryEntryPtr>
  NavigationApiHistoryEntryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NavigationApiHistoryEntry::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NavigationApiHistoryEntry::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NavigationApiHistoryEntry::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationApiHistoryEntry::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationApiHistoryEntry::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NavigationApiHistoryEntry::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NavigationApiHistoryEntry_UnserializedMessageContext<
            UserType, NavigationApiHistoryEntry::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NavigationApiHistoryEntry::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NavigationApiHistoryEntry::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NavigationApiHistoryEntry_UnserializedMessageContext<
            UserType, NavigationApiHistoryEntry::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NavigationApiHistoryEntry::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String key;
  
  ::blink::String id;
  
  ::blink::String url;
  
  int64_t item_sequence_number;
  
  int64_t document_sequence_number;
  
  ::blink::String state;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NavigationApiHistoryEntry::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NavigationApiHistoryEntry::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NavigationApiHistoryEntry::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NavigationApiHistoryEntry::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class PLATFORM_EXPORT NavigationApiHistoryEntryArrays {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NavigationApiHistoryEntryArrays, T>::value>;
  using DataView = NavigationApiHistoryEntryArraysDataView;
  using Data_ = internal::NavigationApiHistoryEntryArrays_Data;

  template <typename... Args>
  static NavigationApiHistoryEntryArraysPtr New(Args&&... args) {
    return NavigationApiHistoryEntryArraysPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NavigationApiHistoryEntryArraysPtr From(const U& u) {
    return mojo::TypeConverter<NavigationApiHistoryEntryArraysPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NavigationApiHistoryEntryArrays>::Convert(*this);
  }


  NavigationApiHistoryEntryArrays();

  NavigationApiHistoryEntryArrays(
      ::blink::Vector<NavigationApiHistoryEntryPtr> back_entries,
      ::blink::Vector<NavigationApiHistoryEntryPtr> forward_entries,
      NavigationApiHistoryEntryPtr previous_entry);

NavigationApiHistoryEntryArrays(const NavigationApiHistoryEntryArrays&) = delete;
NavigationApiHistoryEntryArrays& operator=(const NavigationApiHistoryEntryArrays&) = delete;

  ~NavigationApiHistoryEntryArrays();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NavigationApiHistoryEntryArraysPtr>
  NavigationApiHistoryEntryArraysPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NavigationApiHistoryEntryArrays::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, NavigationApiHistoryEntryArrays::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, NavigationApiHistoryEntryArrays::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationApiHistoryEntryArrays::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NavigationApiHistoryEntryArrays::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NavigationApiHistoryEntryArrays::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NavigationApiHistoryEntryArrays_UnserializedMessageContext<
            UserType, NavigationApiHistoryEntryArrays::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<NavigationApiHistoryEntryArrays::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return NavigationApiHistoryEntryArrays::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NavigationApiHistoryEntryArrays_UnserializedMessageContext<
            UserType, NavigationApiHistoryEntryArrays::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NavigationApiHistoryEntryArrays::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<NavigationApiHistoryEntryPtr> back_entries;
  
  ::blink::Vector<NavigationApiHistoryEntryPtr> forward_entries;
  
  NavigationApiHistoryEntryPtr previous_entry;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NavigationApiHistoryEntryArrays::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NavigationApiHistoryEntryArrays::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NavigationApiHistoryEntryArrays::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NavigationApiHistoryEntryArrays::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
NavigationApiHistoryEntryPtr NavigationApiHistoryEntry::Clone() const {
  return New(
      mojo::Clone(key),
      mojo::Clone(id),
      mojo::Clone(url),
      mojo::Clone(item_sequence_number),
      mojo::Clone(document_sequence_number),
      mojo::Clone(state)
  );
}

template <typename T, NavigationApiHistoryEntry::EnableIfSame<T>*>
bool NavigationApiHistoryEntry::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->item_sequence_number, other_struct.item_sequence_number))
    return false;
  if (!mojo::Equals(this->document_sequence_number, other_struct.document_sequence_number))
    return false;
  if (!mojo::Equals(this->state, other_struct.state))
    return false;
  return true;
}

template <typename T, NavigationApiHistoryEntry::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  if (lhs.id < rhs.id)
    return true;
  if (rhs.id < lhs.id)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.item_sequence_number < rhs.item_sequence_number)
    return true;
  if (rhs.item_sequence_number < lhs.item_sequence_number)
    return false;
  if (lhs.document_sequence_number < rhs.document_sequence_number)
    return true;
  if (rhs.document_sequence_number < lhs.document_sequence_number)
    return false;
  if (lhs.state < rhs.state)
    return true;
  if (rhs.state < lhs.state)
    return false;
  return false;
}
template <typename StructPtrType>
NavigationApiHistoryEntryArraysPtr NavigationApiHistoryEntryArrays::Clone() const {
  return New(
      mojo::Clone(back_entries),
      mojo::Clone(forward_entries),
      mojo::Clone(previous_entry)
  );
}

template <typename T, NavigationApiHistoryEntryArrays::EnableIfSame<T>*>
bool NavigationApiHistoryEntryArrays::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->back_entries, other_struct.back_entries))
    return false;
  if (!mojo::Equals(this->forward_entries, other_struct.forward_entries))
    return false;
  if (!mojo::Equals(this->previous_entry, other_struct.previous_entry))
    return false;
  return true;
}

template <typename T, NavigationApiHistoryEntryArrays::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.back_entries < rhs.back_entries)
    return true;
  if (rhs.back_entries < lhs.back_entries)
    return false;
  if (lhs.forward_entries < rhs.forward_entries)
    return true;
  if (rhs.forward_entries < lhs.forward_entries)
    return false;
  if (lhs.previous_entry < rhs.previous_entry)
    return true;
  if (rhs.previous_entry < lhs.previous_entry)
    return false;
  return false;
}


}  // blink::mojom::blink

namespace mojo {


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::NavigationApiHistoryEntry::DataView,
                                         ::blink::mojom::blink::NavigationApiHistoryEntryPtr> {
  static bool IsNull(const ::blink::mojom::blink::NavigationApiHistoryEntryPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::NavigationApiHistoryEntryPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::NavigationApiHistoryEntry::key)& key(
      const ::blink::mojom::blink::NavigationApiHistoryEntryPtr& input) {
    return input->key;
  }

  static const decltype(::blink::mojom::blink::NavigationApiHistoryEntry::id)& id(
      const ::blink::mojom::blink::NavigationApiHistoryEntryPtr& input) {
    return input->id;
  }

  static const decltype(::blink::mojom::blink::NavigationApiHistoryEntry::url)& url(
      const ::blink::mojom::blink::NavigationApiHistoryEntryPtr& input) {
    return input->url;
  }

  static decltype(::blink::mojom::blink::NavigationApiHistoryEntry::item_sequence_number) item_sequence_number(
      const ::blink::mojom::blink::NavigationApiHistoryEntryPtr& input) {
    return input->item_sequence_number;
  }

  static decltype(::blink::mojom::blink::NavigationApiHistoryEntry::document_sequence_number) document_sequence_number(
      const ::blink::mojom::blink::NavigationApiHistoryEntryPtr& input) {
    return input->document_sequence_number;
  }

  static const decltype(::blink::mojom::blink::NavigationApiHistoryEntry::state)& state(
      const ::blink::mojom::blink::NavigationApiHistoryEntryPtr& input) {
    return input->state;
  }

  static bool Read(::blink::mojom::blink::NavigationApiHistoryEntry::DataView input, ::blink::mojom::blink::NavigationApiHistoryEntryPtr* output);
};


template <>
struct PLATFORM_EXPORT StructTraits<::blink::mojom::blink::NavigationApiHistoryEntryArrays::DataView,
                                         ::blink::mojom::blink::NavigationApiHistoryEntryArraysPtr> {
  static bool IsNull(const ::blink::mojom::blink::NavigationApiHistoryEntryArraysPtr& input) { return !input; }
  static void SetToNull(::blink::mojom::blink::NavigationApiHistoryEntryArraysPtr* output) { output->reset(); }

  static const decltype(::blink::mojom::blink::NavigationApiHistoryEntryArrays::back_entries)& back_entries(
      const ::blink::mojom::blink::NavigationApiHistoryEntryArraysPtr& input) {
    return input->back_entries;
  }

  static const decltype(::blink::mojom::blink::NavigationApiHistoryEntryArrays::forward_entries)& forward_entries(
      const ::blink::mojom::blink::NavigationApiHistoryEntryArraysPtr& input) {
    return input->forward_entries;
  }

  static const decltype(::blink::mojom::blink::NavigationApiHistoryEntryArrays::previous_entry)& previous_entry(
      const ::blink::mojom::blink::NavigationApiHistoryEntryArraysPtr& input) {
    return input->previous_entry;
  }

  static bool Read(::blink::mojom::blink::NavigationApiHistoryEntryArrays::DataView input, ::blink::mojom::blink::NavigationApiHistoryEntryArraysPtr* output);
};

}  // namespace mojo

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_NAVIGATION_NAVIGATION_API_HISTORY_ENTRY_ARRAYS_MOJOM_BLINK_H_