// third_party/blink/public/mojom/mime/mime_registry.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/mime/mime_registry.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "third_party/blink/public/mojom/mime/mime_registry.mojom-params-data.h"
#include "third_party/blink/public/mojom/mime/mime_registry.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/mime/mime_registry.mojom-blink-import-headers.h"
#include "third_party/blink/public/mojom/mime/mime_registry.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace blink::mojom::blink {
// The declaration includes the definition on other builds.

MimeRegistry::IPCStableHashFunction MimeRegistry::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::MimeRegistry>(message.name())) {
    case messages::MimeRegistry::kGetMimeTypeFromExtension: {
      return &MimeRegistry::GetMimeTypeFromExtension_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* MimeRegistry::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::MimeRegistry>(message.name())) {
      case messages::MimeRegistry::kGetMimeTypeFromExtension:
            return "Receive blink::mojom::MimeRegistry::GetMimeTypeFromExtension";
    }
  } else {
    switch (static_cast<messages::MimeRegistry>(message.name())) {
      case messages::MimeRegistry::kGetMimeTypeFromExtension:
            return "Receive reply blink::mojom::MimeRegistry::GetMimeTypeFromExtension";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t MimeRegistry::GetMimeTypeFromExtension_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xec9235dc;  // IPCStableHash for blink::mojom::MimeRegistry::GetMimeTypeFromExtension
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)
bool MimeRegistry::GetMimeTypeFromExtension(const ::blink::String& extension, ::blink::String* out_mime_type) {
  NOTREACHED();
}
class MimeRegistry_GetMimeTypeFromExtension_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  MimeRegistry_GetMimeTypeFromExtension_HandleSyncResponse(
      bool* result, ::blink::String* out_mime_type)
      : result_(result), out_mime_type_(out_mime_type) {
    DCHECK(!*result_);
  }

  MimeRegistry_GetMimeTypeFromExtension_HandleSyncResponse(const MimeRegistry_GetMimeTypeFromExtension_HandleSyncResponse&) = delete;
  MimeRegistry_GetMimeTypeFromExtension_HandleSyncResponse& operator=(const MimeRegistry_GetMimeTypeFromExtension_HandleSyncResponse&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::blink::String* out_mime_type_;};

class MimeRegistry_GetMimeTypeFromExtension_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  MimeRegistry_GetMimeTypeFromExtension_ForwardToCallback(
      MimeRegistry::GetMimeTypeFromExtensionCallback callback
      ) : callback_(std::move(callback)) {
  }

  MimeRegistry_GetMimeTypeFromExtension_ForwardToCallback(const MimeRegistry_GetMimeTypeFromExtension_ForwardToCallback&) = delete;
  MimeRegistry_GetMimeTypeFromExtension_ForwardToCallback& operator=(const MimeRegistry_GetMimeTypeFromExtension_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  MimeRegistry::GetMimeTypeFromExtensionCallback callback_;
};

MimeRegistryProxy::MimeRegistryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}
bool MimeRegistryProxy::GetMimeTypeFromExtension(
    const ::blink::String& param_extension, ::blink::String* out_param_mime_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "Call blink::mojom::MimeRegistry::GetMimeTypeFromExtension (sync)", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension"), param_extension,
                        "<value of type const ::blink::String&>");
   });
#else
  TRACE_EVENT0("mojom", "MimeRegistry::GetMimeTypeFromExtension");
#endif
  
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  const bool kAllowInterrupt =
      true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MimeRegistry::kGetMimeTypeFromExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MimeRegistry_GetMimeTypeFromExtension_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension)::BaseType> extension_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    param_extension,
    extension_fragment);

  params->extension.Set(
      extension_fragment.is_null() ? nullptr : extension_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension in MimeRegistry.GetMimeTypeFromExtension request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MimeRegistry::Name_);
  message.set_method_name("GetMimeTypeFromExtension");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MimeRegistry_GetMimeTypeFromExtension_HandleSyncResponse(
          &result, out_param_mime_type));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "MimeRegistry::GetMimeTypeFromExtension", "sync_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mime_type"), out_param_mime_type,
                        "<value of type const ::blink::String&>");
   });
#endif
  return result;
}

void MimeRegistryProxy::GetMimeTypeFromExtension(
    const ::blink::String& in_extension, GetMimeTypeFromExtensionCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send blink::mojom::MimeRegistry::GetMimeTypeFromExtension", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("extension"), in_extension,
                        "<value of type const ::blink::String&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MimeRegistry::kGetMimeTypeFromExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MimeRegistry_GetMimeTypeFromExtension_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->extension)::BaseType> extension_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_extension,
    extension_fragment);

  params->extension.Set(
      extension_fragment.is_null() ? nullptr : extension_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->extension.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null extension in MimeRegistry.GetMimeTypeFromExtension request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MimeRegistry::Name_);
  message.set_method_name("GetMimeTypeFromExtension");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new MimeRegistry_GetMimeTypeFromExtension_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class MimeRegistry_GetMimeTypeFromExtension_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static MimeRegistry::GetMimeTypeFromExtensionCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<MimeRegistry_GetMimeTypeFromExtension_ProxyToResponder> proxy(
        new MimeRegistry_GetMimeTypeFromExtension_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&MimeRegistry_GetMimeTypeFromExtension_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~MimeRegistry_GetMimeTypeFromExtension_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  MimeRegistry_GetMimeTypeFromExtension_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "MimeRegistry::GetMimeTypeFromExtensionCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::blink::String& in_mime_type);
};

bool MimeRegistry_GetMimeTypeFromExtension_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MimeRegistry_GetMimeTypeFromExtension_ResponseParams_Data* params =
      reinterpret_cast<
          internal::MimeRegistry_GetMimeTypeFromExtension_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for MimeRegistry.0
  bool success = true;
  ::blink::String p_mime_type{};
  MimeRegistry_GetMimeTypeFromExtension_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMimeType(&p_mime_type))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MimeRegistry::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_mime_type));
  }
  return true;
}

void MimeRegistry_GetMimeTypeFromExtension_ProxyToResponder::Run(
    const ::blink::String& in_mime_type) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply blink::mojom::MimeRegistry::GetMimeTypeFromExtension", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("mime_type"), in_mime_type,
                        "<value of type const ::blink::String&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::MimeRegistry::kGetMimeTypeFromExtension), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::blink::mojom::internal::MimeRegistry_GetMimeTypeFromExtension_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->mime_type)::BaseType> mime_type_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_mime_type,
    mime_type_fragment);

  params->mime_type.Set(
      mime_type_fragment.is_null() ? nullptr : mime_type_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->mime_type.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null mime_type in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(MimeRegistry::Name_);
  message.set_method_name("GetMimeTypeFromExtension");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool MimeRegistry_GetMimeTypeFromExtension_HandleSyncResponse::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::MimeRegistry_GetMimeTypeFromExtension_ResponseParams_Data* params =
      reinterpret_cast<internal::MimeRegistry_GetMimeTypeFromExtension_ResponseParams_Data*>(
          message->mutable_payload());
  

  // Validation for MimeRegistry.0
  bool success = true;
  ::blink::String p_mime_type{};
  MimeRegistry_GetMimeTypeFromExtension_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadMimeType(&p_mime_type))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        MimeRegistry::Name_, 0, true);
    return false;
  }
  *out_mime_type_ = std::move(p_mime_type);
  *result_ = true;
  return true;
}

// static
bool MimeRegistryStubDispatch::Accept(
    MimeRegistry* impl,
    mojo::Message* message) {
  switch (static_cast<messages::MimeRegistry>(message->header()->name)) {
    case messages::MimeRegistry::kGetMimeTypeFromExtension: {
      break;
    }
  }
  return false;
}

// static
bool MimeRegistryStubDispatch::AcceptWithResponder(
    MimeRegistry* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::MimeRegistry>(message->header()->name)) {
    case messages::MimeRegistry::kGetMimeTypeFromExtension: {
      internal::MimeRegistry_GetMimeTypeFromExtension_Params_Data* params =
          reinterpret_cast<
              internal::MimeRegistry_GetMimeTypeFromExtension_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for MimeRegistry.0
      bool success = true;
      ::blink::String p_extension{};
      MimeRegistry_GetMimeTypeFromExtension_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadExtension(&p_extension))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            MimeRegistry::Name_, 0, false);
        return false;
      }
      auto callback =
          MimeRegistry_GetMimeTypeFromExtension_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetMimeTypeFromExtension(        
        std::move(p_extension), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kMimeRegistryValidationInfo[] = {
    { &internal::MimeRegistry_GetMimeTypeFromExtension_Params_Data::Validate,
     &internal::MimeRegistry_GetMimeTypeFromExtension_ResponseParams_Data::Validate},
};

bool MimeRegistryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::blink::mojom::blink::MimeRegistry::Name_,
    kMimeRegistryValidationInfo);
}

bool MimeRegistryResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::blink::mojom::blink::MimeRegistry::Name_,
    kMimeRegistryValidationInfo);
}


}  // blink::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace blink::mojom::blink {


void MimeRegistryInterceptorForTesting::GetMimeTypeFromExtension(const ::blink::String& extension, GetMimeTypeFromExtensionCallback callback) {
  GetForwardingInterface()->GetMimeTypeFromExtension(
    std::move(extension)
    , std::move(callback));
}
MimeRegistryAsyncWaiter::MimeRegistryAsyncWaiter(
    MimeRegistry* proxy) : proxy_(proxy) {}

MimeRegistryAsyncWaiter::~MimeRegistryAsyncWaiter() = default;


void MimeRegistryAsyncWaiter::GetMimeTypeFromExtension(
    const ::blink::String& extension, ::blink::String* out_mime_type) {
  base::RunLoop loop;
  proxy_->GetMimeTypeFromExtension(
      std::move(extension),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::String* out_mime_type
,
             const ::blink::String& mime_type) {*out_mime_type = std::move(mime_type);
            loop->Quit();
          },
          &loop,
          out_mime_type));
  loop.Run();
}

::blink::String MimeRegistryAsyncWaiter::GetMimeTypeFromExtension(
    const ::blink::String& extension) {
  ::blink::String async_wait_result;
  GetMimeTypeFromExtension(std::move(extension),&async_wait_result);
  return async_wait_result;
}






}  // blink::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif