// third_party/blink/public/mojom/messaging/transferable_message.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_TRANSFERABLE_MESSAGE_MOJOM_DATA_VIEW_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_TRANSFERABLE_MESSAGE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/blink/public/mojom/messaging/transferable_message.mojom-shared-internal.h"
#include "third_party/blink/public/mojom/array_buffer/array_buffer_contents.mojom-shared.h"
#include "third_party/blink/public/mojom/blob/serialized_blob.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/cloneable_message.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/delegated_capability.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/message_port_descriptor.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/user_activation_snapshot.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/task_attribution_id.mojom-shared.h"
#include "third_party/blink/public/mojom/messaging/static_bitmap_image.mojom-shared.h"


namespace blink::mojom {
class TransferableMessageDataView;



}  // blink::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::TransferableMessageDataView> {
  using Data = ::blink::mojom::internal::TransferableMessage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink::mojom {


class TransferableMessageDataView {
 public:
  TransferableMessageDataView() = default;

  TransferableMessageDataView(
      internal::TransferableMessage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetMessageDataView(
      ::blink::mojom::CloneableMessageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMessage(UserType* output) {
    
    auto* pointer = data_->message.Get();
    return mojo::internal::Deserialize<::blink::mojom::CloneableMessageDataView>(
        pointer, output, message_);
  }
  inline void GetPortsDataView(
      mojo::ArrayDataView<::blink::mojom::MessagePortDescriptorDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPorts(UserType* output) {
    
    auto* pointer = data_->ports.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::MessagePortDescriptorDataView>>(
        pointer, output, message_);
  }
  inline void GetStreamChannelsDataView(
      mojo::ArrayDataView<::blink::mojom::MessagePortDescriptorDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadStreamChannels(UserType* output) {
    
    auto* pointer = data_->stream_channels.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::MessagePortDescriptorDataView>>(
        pointer, output, message_);
  }
  inline void GetArrayBufferContentsArrayDataView(
      mojo::ArrayDataView<::blink::mojom::SerializedArrayBufferContentsDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadArrayBufferContentsArray(UserType* output) {
    
    auto* pointer = data_->array_buffer_contents_array.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SerializedArrayBufferContentsDataView>>(
        pointer, output, message_);
  }
  inline void GetImageBitmapContentsArrayDataView(
      mojo::ArrayDataView<::blink::mojom::SerializedStaticBitmapImageDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadImageBitmapContentsArray(UserType* output) {
    
    auto* pointer = data_->image_bitmap_contents_array.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::blink::mojom::SerializedStaticBitmapImageDataView>>(
        pointer, output, message_);
  }
  inline void GetUserActivationDataView(
      ::blink::mojom::UserActivationSnapshotDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUserActivation(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::UserActivationSnapshotDataView, UserType>(),
    "Attempting to read the optional `user_activation` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadUserActivation` instead "
    "of `ReadUserActivation if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->user_activation.Get();
    return mojo::internal::Deserialize<::blink::mojom::UserActivationSnapshotDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadDelegatedCapability(UserType* output) const {
    auto data_value = data_->delegated_capability;
    return mojo::internal::Deserialize<::blink::mojom::DelegatedCapability>(
        data_value, output);
  }
  ::blink::mojom::DelegatedCapability delegated_capability() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::blink::mojom::DelegatedCapability>(data_->delegated_capability));
  }
  inline void GetTaskStateIdDataView(
      ::blink::mojom::TaskAttributionIdDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTaskStateId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::blink::mojom::TaskAttributionIdDataView, UserType>(),
    "Attempting to read the optional `task_state_id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTaskStateId` instead "
    "of `ReadTaskStateId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->task_state_id.Get();
    return mojo::internal::Deserialize<::blink::mojom::TaskAttributionIdDataView>(
        pointer, output, message_);
  }
 private:
  internal::TransferableMessage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // blink::mojom

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_MESSAGING_TRANSFERABLE_MESSAGE_MOJOM_DATA_VIEW_H_